//*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtDfSi534X_ConfigData.h *#*#*#*#*#*#*#*# (C) 2018 DekTec
//
// Device function - SI-5342/5344/5345 - Configuration Data
//

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2017 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.


#define  SI534X_EXP12  (1000LL*1000LL*1000LL*1000LL)
#define  SI534X_EXP9   (1000LL*1000LL*1000LL)
#define  SI534X_EXP6   (1000LL*1000LL)
#define  SI534X_EXP5   (100LL*1000LL)

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Types -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- SI534X Configuration Data -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// SI534X  Hard reset
static const DtDfSi534XRegister SI534X_CONFIG_HARDRST[] =
{
    {0x001E,0x02},
};

// SI534X  Preamble
static const DtDfSi534XRegister SI534X_CONFIG_PREAMBLE[] =
{
    {0x0B24,0xC0},
    {0x0B25,0x00},
    {0x0540,0x01},
};

// SI534X  Postamble
static const DtDfSi534XRegister SI534X_CONFIG_POSTAMBLE[] =
{
    {0x0514,0x01},
    {0x001C,0x01},
    {0x0540,0x00},
    {0x0B24,0xC3},
    {0x0B25,0x02},
};

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ SI5342 Dual SDI clock +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// SI5342 dual SDI clock (non-fractional and fractional) configuration. 
// Used for the DTA-2172, DTA-2174B, DTA-2178ASI and DTA-2178.
// 54MHz XTAL input, DCO-mode; In1: 27MHz; Out0: 148.35MHz and Out1: 148.5MHz
//

// Properties
static const DtDfSi534XClockProps SI5342_CONFIG_SDI_CLOCK_PROPS_DTA2172_LIKE[2] =
{
    { 0,                                                // Clock output port index 0
      DT_DF_SI534X_CLK_FRACTIONAL,                      // Fractional clock
      (SI534X_EXP12+50046435328LL-1)/50046435328LL,     // Steps: 1e12/N0_NUM ppt
      200*SI534X_EXP6,                                  // Range: +/- 200ppm
      148*SI534X_EXP12 + 32*SI534X_EXP12/91             // Freq: 148.5/1.001 MHz
    },
    { 1,                                                // Clock output port index 1
      DT_DF_SI534X_CLK_NON_FRACTIONAL,                  // Non-fractional clock
      (SI534X_EXP12+93837066240LL-1)/93837066240LL,     // Steps: 1e12/N1_NUM
      200*SI534X_EXP6,                                  // Range: +/- 200ppm
      148*SI534X_EXP12 + 500LL*SI534X_EXP9              // Freq: 148.5MHz
    },
};


//  Design
//  ======
//  Host Interface:
//     I/O Power Supply: VDD (Core)
//     SPI Mode: 4-Wire
//     I2C Address Range: 104d to 107d / 0x68 to 0x6B (selected via A0/A1 pins)
//  
//  XA/XB:
//     54 MHz (XTAL - Crystal)
//  
//  Inputs:
//      IN0: Unused
//      IN1: 27 MHz
//           Standard
//      IN2: Unused
//      IN3: Unused
//  
//  Outputs:
//     OUT0: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
//           [ 148.5MHz*1000/1001 ]
//           Enabled, LVDS 1.8 V
//     OUT1: 148.5 MHz
//           Enabled, LVDS 1.8 V
//  
//  Frequency Plan
//  ==============
//  Fvco = 13.2759890109890109... GHz [ 13 + 5023/18200 GHz ]
//  Fpfd = 296.7032967032967032... kHz [ 296 + 64/91 kHz ]
//  Fms0 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
//  Fms1 = 594 MHz
//  
//  P dividers:
//     P0  = Unused
//     P1  = 91
//     P2  = Unused
//     P3  = Unused
//     Pxaxb = 1
//  
//  MXAXB = 245.8516483516483516... [ 245 + 155/182 ]
//  M = 8949
//  N dividers:
//     N0:
//        Value: 14.915
//        OUT0: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
//     N1:
//        Value: 22.3501498501498501... [ 22 + 701/2002 ]
//        OUT1: 148.5 MHz [ 148 + 1/2 MHz ]
//  
//  R dividers:
//     R0 = 6
//     R1 = 4
//  
//  Nominal Bandwidth:
//    Desired: 100.000 Hz
//    Actual:  134.601 Hz
//    Coefficients:
//       BW0:  20
//       BW1:  35
//       BW2:  12
//       BW3:  11
//       BW4:  31
//       BW5:  63
//  Fastlock Bandwidth:
//    Desired: 4.000 kHz
//    Actual:  4.456 kHz
//    Coefficients:
//       BW0:  25
//       BW1:  47
//       BW2:  7
//       BW3:  6
//       BW4:  31
//       BW5:  63
//  Holdover Bandwidth:
//     N/A (Ramped Exit from Holdover)
//  
//  Digitally Controlled Oscillator (DCO)
//  =====================================
//  Mode: Register Direct Write
//  
//         Fvco * Nx_DEN
//  Fout = -------------
//          Nx_NUM * R
//  
//  N0: DCO Enabled
//  
//     Fvco:               13.2759890109890109... GHz [ 13 + 5023/18200 GHz ]
//     N0_NUM:             50046435328
//     N0_DEN:             3355443200
//     Step Word:          1
//  
//     Desired Step Size:  1 ppt
//     Actual Step Size:   19.981443103111... ppt
//     Range:              200 ppm
//  
//     OUT0
//          R0:            6
//          Initial Freq:  148.351648351648... MHz
//          Step Size:     0.00296428002... Hz
//          Min Freq:      148.321989887167... MHz
//          Max Freq:      148.381318679514... MHz
//  
//  N1: DCO Enabled
//  
//     Fvco:               13.2759890109890109... GHz [ 13 + 5023/18200 GHz ]
//     N1_NUM:             93837066240
//     N1_DEN:             4198498304
//     Step Word:          1
//  
//     Desired Step Size:  1 ppt
//     Actual Step Size:   10.656769654893... ppt
//     Range:              200 ppm
//  
//     OUT1
//          R1:            4
//          Initial Freq:  148.5 MHz
//          Step Size:     0.001582530293... Hz
//          Min Freq:      148.470311876065... MHz
//          Max Freq:      148.529699999183... MHz

// Register settings
static const DtDfSi534XRegister  SI5342_CONFIG_DUAL_SDI_CLOCK_DTA2172_LIKE[] =
{
    { 0x0006, 0x00 },
    { 0x0007, 0x00 },
    { 0x0008, 0x00 },
    { 0x000B, 0x68 },
    { 0x0016, 0x02 },
    { 0x0017, 0xDC },
    { 0x0018, 0xDD },
    { 0x0019, 0xDD },
    { 0x001A, 0xDF },
    { 0x002B, 0x02 },
    { 0x002C, 0x02 },
    { 0x002D, 0x04 },
    { 0x002E, 0x00 },
    { 0x002F, 0x00 },
    { 0x0030, 0xEA },
    { 0x0031, 0x00 },
    { 0x0032, 0x00 },
    { 0x0033, 0x00 },
    { 0x0034, 0x00 },
    { 0x0035, 0x00 },
    { 0x0036, 0x00 },
    { 0x0037, 0x00 },
    { 0x0038, 0xEA },
    { 0x0039, 0x00 },
    { 0x003A, 0x00 },
    { 0x003B, 0x00 },
    { 0x003C, 0x00 },
    { 0x003D, 0x00 },
    { 0x003F, 0x22 },
    { 0x0040, 0x01 },
    { 0x0041, 0x00 },
    { 0x0042, 0x0B },
    { 0x0043, 0x00 },
    { 0x0044, 0x00 },
    { 0x0045, 0x0C },
    { 0x0046, 0x00 },
    { 0x0047, 0x32 },
    { 0x0048, 0x00 },
    { 0x0049, 0x00 },
    { 0x004A, 0x00 },
    { 0x004B, 0x32 },
    { 0x004C, 0x00 },
    { 0x004D, 0x00 },
    { 0x004E, 0x50 },
    { 0x004F, 0x00 },
    { 0x0050, 0x0F },
    { 0x0051, 0x00 },
    { 0x0052, 0x03 },
    { 0x0053, 0x00 },
    { 0x0054, 0x00 },
    { 0x0055, 0x00 },
    { 0x0056, 0x03 },
    { 0x0057, 0x00 },
    { 0x0058, 0x00 },
    { 0x0059, 0x04 },
    { 0x005A, 0x00 },
    { 0x005B, 0x00 },
    { 0x005C, 0x00 },
    { 0x005D, 0x00 },
    { 0x005E, 0x00 },
    { 0x005F, 0x00 },
    { 0x0060, 0x00 },
    { 0x0061, 0x01 },
    { 0x0062, 0x00 },
    { 0x0063, 0x00 },
    { 0x0064, 0x00 },
    { 0x0065, 0x00 },
    { 0x0066, 0x00 },
    { 0x0067, 0x00 },
    { 0x0068, 0x00 },
    { 0x0069, 0x00 },
    { 0x0092, 0x02 },
    { 0x0093, 0xA0 },
    { 0x0095, 0x00 },
    { 0x0096, 0x90 },
    { 0x0098, 0x70 },
    { 0x009A, 0x02 },
    { 0x009B, 0x70 },
    { 0x009D, 0x08 },
    { 0x009E, 0x50 },
    { 0x00A0, 0x30 },
    { 0x00A2, 0x00 },
    { 0x00A9, 0x83 },
    { 0x00AA, 0x1E },
    { 0x00AB, 0x00 },
    { 0x00AC, 0x00 },
    { 0x00E5, 0x21 },
    { 0x00EA, 0x8E },
    { 0x00EB, 0x1D },
    { 0x00EC, 0x00 },
    { 0x00ED, 0x00 },
    { 0x0102, 0x01 },
    { 0x0112, 0x02 },
    { 0x0113, 0x09 },
    { 0x0114, 0x3E },
    { 0x0115, 0x18 },
    { 0x0117, 0x02 },
    { 0x0118, 0x09 },
    { 0x0119, 0x3E },
    { 0x011A, 0x19 },
    { 0x013F, 0x00 },
    { 0x0140, 0x00 },
    { 0x0141, 0x40 },
    { 0x0142, 0xFF },
    { 0x0206, 0x00 },
    { 0x0208, 0x00 },
    { 0x0209, 0x00 },
    { 0x020A, 0x00 },
    { 0x020B, 0x00 },
    { 0x020C, 0x00 },
    { 0x020D, 0x00 },
    { 0x020E, 0x00 },
    { 0x020F, 0x00 },
    { 0x0210, 0x00 },
    { 0x0211, 0x00 },
    { 0x0212, 0x5B },
    { 0x0213, 0x00 },
    { 0x0214, 0x00 },
    { 0x0215, 0x00 },
    { 0x0216, 0x00 },
    { 0x0217, 0x00 },
    { 0x0218, 0x01 },
    { 0x0219, 0x00 },
    { 0x021A, 0x00 },
    { 0x021B, 0x00 },
    { 0x021C, 0x00 },
    { 0x021D, 0x00 },
    { 0x021E, 0x00 },
    { 0x021F, 0x00 },
    { 0x0220, 0x00 },
    { 0x0221, 0x00 },
    { 0x0222, 0x00 },
    { 0x0223, 0x00 },
    { 0x0224, 0x00 },
    { 0x0225, 0x00 },
    { 0x0226, 0x00 },
    { 0x0227, 0x00 },
    { 0x0228, 0x00 },
    { 0x0229, 0x00 },
    { 0x022A, 0x00 },
    { 0x022B, 0x00 },
    { 0x022C, 0x00 },
    { 0x022D, 0x00 },
    { 0x022E, 0x00 },
    { 0x022F, 0x00 },
    { 0x0231, 0x0B },
    { 0x0232, 0x0B },
    { 0x0233, 0x0B },
    { 0x0234, 0x0B },
    { 0x0235, 0x00 },
    { 0x0236, 0x00 },
    { 0x0237, 0x00 },
    { 0x0238, 0xC9 },
    { 0x0239, 0xAE },
    { 0x023A, 0x00 },
    { 0x023B, 0x00 },
    { 0x023C, 0x00 },
    { 0x023D, 0x00 },
    { 0x023E, 0xB6 },
    { 0x0250, 0x02 },
    { 0x0251, 0x00 },
    { 0x0252, 0x00 },
    { 0x0253, 0x01 },
    { 0x0254, 0x00 },
    { 0x0255, 0x00 },
    { 0x026B, 0x44 },
    { 0x026C, 0x54 },
    { 0x026D, 0x41 },
    { 0x026E, 0x2D },
    { 0x026F, 0x32 },
    { 0x0270, 0x31 },
    { 0x0271, 0x37 },
    { 0x0272, 0x32 },
    { 0x028A, 0x00 },
    { 0x028B, 0x00 },
    { 0x028C, 0x00 },
    { 0x028D, 0x00 },
    { 0x028E, 0x00 },
    { 0x028F, 0x00 },
    { 0x0290, 0x00 },
    { 0x0291, 0x00 },
    { 0x0294, 0xD0 },
    { 0x0296, 0x02 },
    { 0x0297, 0x02 },
    { 0x0299, 0x02 },
    { 0x029D, 0x7E },
    { 0x029E, 0x00 },
    { 0x029F, 0x00 },
    { 0x02A9, 0x33 },
    { 0x02AA, 0x01 },
    { 0x02AB, 0x00 },
    { 0x02B7, 0xFF },
    { 0x0302, 0x00 },
    { 0x0303, 0x00 },
    { 0x0304, 0x00 },
    { 0x0305, 0xA7 },
    { 0x0306, 0x0B },
    { 0x0307, 0x00 },
    { 0x0308, 0x00 },
    { 0x0309, 0x00 },
    { 0x030A, 0x00 },
    { 0x030B, 0xC8 },
    { 0x030C, 0x00 },
    { 0x030D, 0x00 },
    { 0x030E, 0x00 },
    { 0x030F, 0x20 },
    { 0x0310, 0xD9 },
    { 0x0311, 0x15 },
    { 0x0312, 0x00 },
    { 0x0313, 0x00 },
    { 0x0314, 0x00 },
    { 0x0315, 0x40 },
    { 0x0316, 0xFA },
    { 0x0317, 0x00 },
    { 0x0338, 0x00 },
    { 0x0339, 0x1F },
    { 0x033B, 0x01 },
    { 0x033C, 0x00 },
    { 0x033D, 0x00 },
    { 0x033E, 0x00 },
    { 0x033F, 0x00 },
    { 0x0340, 0x00 },
    { 0x0341, 0x01 },
    { 0x0342, 0x00 },
    { 0x0343, 0x00 },
    { 0x0344, 0x00 },
    { 0x0345, 0x00 },
    { 0x0346, 0x00 },
    { 0x0359, 0x00 },
    { 0x035A, 0x00 },
    { 0x035B, 0x00 },
    { 0x035C, 0x00 },
    { 0x0487, 0x00 },
    { 0x0508, 0x14 },
    { 0x0509, 0x23 },
    { 0x050A, 0x0C },
    { 0x050B, 0x0B },
    { 0x050C, 0x1F },
    { 0x050D, 0x3F },
    { 0x050E, 0x19 },
    { 0x050F, 0x2F },
    { 0x0510, 0x07 },
    { 0x0511, 0x06 },
    { 0x0512, 0x1F },
    { 0x0513, 0x3F },
    { 0x0515, 0x00 },
    { 0x0516, 0x00 },
    { 0x0517, 0x00 },
    { 0x0518, 0x80 },
    { 0x0519, 0x7A },
    { 0x051A, 0x11 },
    { 0x051B, 0x00 },
    { 0x051C, 0x00 },
    { 0x051D, 0x00 },
    { 0x051E, 0x00 },
    { 0x051F, 0x80 },
    { 0x0521, 0x2B },
    { 0x052A, 0x03 },
    { 0x052B, 0x01 },
    { 0x052C, 0x87 },
    { 0x052D, 0x03 },
    { 0x052E, 0x19 },
    { 0x052F, 0x19 },
    { 0x0531, 0x00 },
    { 0x0532, 0xF2 },
    { 0x0533, 0x15 },
    { 0x0534, 0x00 },
    { 0x0535, 0x00 },
    { 0x0536, 0x04 },
    { 0x0537, 0x00 },
    { 0x0538, 0x00 },
    { 0x0539, 0x00 },
    { 0x053A, 0x02 },
    { 0x053B, 0x03 },
    { 0x053C, 0x00 },
    { 0x053D, 0x0E },
    { 0x053E, 0x06 },
    { 0x0589, 0x56 },
    { 0x058A, 0x00 },
    { 0x059B, 0xF8 },   // Set INIT_LO_CLOSE_HO to "0" so that  loop bandwidth or fastlock
                        // bandwidth will primarily determine the settling behavior.
                        // Silabs technical support e-mail 2019.10.25
    { 0x059D, 0x14 },
    { 0x059E, 0x25 },
    { 0x059F, 0x0C },
    { 0x05A0, 0x0B },
    { 0x05A1, 0x1F },
    { 0x05A2, 0x3F },
    { 0x05A6, 0x03 },
    { 0x0802, 0x35 },
    { 0x0803, 0x05 },
    { 0x0804, 0x00 },
    { 0x0805, 0x00 },
    { 0x0806, 0x00 },
    { 0x0807, 0x00 },
    { 0x0808, 0x00 },
    { 0x0809, 0x00 },
    { 0x080A, 0x00 },
    { 0x080B, 0x00 },
    { 0x080C, 0x00 },
    { 0x080D, 0x00 },
    { 0x080E, 0x00 },
    { 0x080F, 0x00 },
    { 0x0810, 0x00 },
    { 0x0811, 0x00 },
    { 0x0812, 0x00 },
    { 0x0813, 0x00 },
    { 0x0814, 0x00 },
    { 0x0815, 0x00 },
    { 0x0816, 0x00 },
    { 0x0817, 0x00 },
    { 0x0818, 0x00 },
    { 0x0819, 0x00 },
    { 0x081A, 0x00 },
    { 0x081B, 0x00 },
    { 0x081C, 0x00 },
    { 0x081D, 0x00 },
    { 0x081E, 0x00 },
    { 0x081F, 0x00 },
    { 0x0820, 0x00 },
    { 0x0821, 0x00 },
    { 0x0822, 0x00 },
    { 0x0823, 0x00 },
    { 0x0824, 0x00 },
    { 0x0825, 0x00 },
    { 0x0826, 0x00 },
    { 0x0827, 0x00 },
    { 0x0828, 0x00 },
    { 0x0829, 0x00 },
    { 0x082A, 0x00 },
    { 0x082B, 0x00 },
    { 0x082C, 0x00 },
    { 0x082D, 0x00 },
    { 0x082E, 0x00 },
    { 0x082F, 0x00 },
    { 0x0830, 0x00 },
    { 0x0831, 0x00 },
    { 0x0832, 0x00 },
    { 0x0833, 0x00 },
    { 0x0834, 0x00 },
    { 0x0835, 0x00 },
    { 0x0836, 0x00 },
    { 0x0837, 0x00 },
    { 0x0838, 0x00 },
    { 0x0839, 0x00 },
    { 0x083A, 0x00 },
    { 0x083B, 0x00 },
    { 0x083C, 0x00 },
    { 0x083D, 0x00 },
    { 0x083E, 0x00 },
    { 0x083F, 0x00 },
    { 0x0840, 0x00 },
    { 0x0841, 0x00 },
    { 0x0842, 0x00 },
    { 0x0843, 0x00 },
    { 0x0844, 0x00 },
    { 0x0845, 0x00 },
    { 0x0846, 0x00 },
    { 0x0847, 0x00 },
    { 0x0848, 0x00 },
    { 0x0849, 0x00 },
    { 0x084A, 0x00 },
    { 0x084B, 0x00 },
    { 0x084C, 0x00 },
    { 0x084D, 0x00 },
    { 0x084E, 0x00 },
    { 0x084F, 0x00 },
    { 0x0850, 0x00 },
    { 0x0851, 0x00 },
    { 0x0852, 0x00 },
    { 0x0853, 0x00 },
    { 0x0854, 0x00 },
    { 0x0855, 0x00 },
    { 0x0856, 0x00 },
    { 0x0857, 0x00 },
    { 0x0858, 0x00 },
    { 0x0859, 0x00 },
    { 0x085A, 0x00 },
    { 0x085B, 0x00 },
    { 0x085C, 0x00 },
    { 0x085D, 0x00 },
    { 0x085E, 0x00 },
    { 0x085F, 0x00 },
    { 0x0860, 0x00 },
    { 0x0861, 0x00 },
    { 0x090E, 0x02 },
    { 0x0943, 0x00 },
    { 0x0949, 0x12 },
    { 0x094A, 0x02 },
    { 0x094E, 0x49 },
    { 0x094F, 0x02 },
    { 0x095E, 0x00 },
    { 0x0A02, 0x00 },
    { 0x0A03, 0x03 },
    { 0x0A04, 0x00 },
    { 0x0A05, 0x03 },
    { 0x0A14, 0x00 },
    { 0x0A1A, 0x00 },
    { 0x0B44, 0x2F },
    { 0x0B46, 0x00 },
    { 0x0B47, 0x0D },
    { 0x0B48, 0x0D },
    { 0x0B4A, 0x00 },
    { 0x0B57, 0xF0 },
    { 0x0B58, 0x00 },
};

// =+=+=+=+=+=+=+=+=+=+=+=+ DTA2175-Like Configuration Properties +=+=+=+=+=+=+=+=+=+=+=+=
//
static const DtDfSi534XClockProps SI5342_CONFIG_NON_FRAC_SDI_CLOCK_PROPS_DTA2175_LIKE[1] =
{
    { 0,                                                // Clock output port index 0
      DT_DF_SI534X_CLK_NON_FRACTIONAL,                   // Non-fractional clock
      (SI534X_EXP12+96636764160LL-1)/96636764160LL,     // 1e12/N0_NUM
      200*SI534X_EXP6,                                  // +/- 200ppm
      148*SI534X_EXP12 + 500LL*SI534X_EXP9              // 148.5MHz
    },
};

static const DtDfSi534XClockProps SI5342_CONFIG_FRAC_SDI_CLOCK_PROPS_DTA2175_LIKE[1] =
{
    { 0,                                                // Clock output port index 0
      DT_DF_SI534X_CLK_FRACTIONAL,                      // Fractional clock
      (SI534X_EXP12+96636764160LL-1)/96636764160LL,     // 1e12/N0_NUM
      200*SI534X_EXP6,                                  // +/- 200ppm
      1483516484LL*SI534X_EXP5                          // 148.35MHz
    }
};


// +=+=+=+=+=+=+=+=+=+=+=+=+=+ SI5342 Non-Fractional SDI clock +=+=+=+=+=+=+=+=+=+=+=+=+=+
//
// SI5342 non-fractional SDI clock configuration. 
// Used for the DTA-2175.
// 54MHz XTAL input, DCO-mode; In1: 27MHz; Out0: 148.5MHz.
//
static const DtDfSi534XRegister SI5342_CONFIG_NON_FRAC_SDI_CLOCK_DTA2175_LIKE[] =
{
    { 0x0006, 0x00 },
    { 0x0007, 0x00 },
    { 0x0008, 0x00 },
    { 0x000B, 0x68 },
    { 0x0016, 0x02 },
    { 0x0017, 0xDC },
    { 0x0018, 0xCC },
    { 0x0019, 0xDD },
    { 0x001A, 0xDF },
    { 0x002B, 0x02 },
    { 0x002C, 0x03 },
    { 0x002D, 0x05 },
    { 0x002E, 0xDB },
    { 0x002F, 0x04 },
    { 0x0030, 0xDB },
    { 0x0031, 0x04 },
    { 0x0032, 0x00 },
    { 0x0033, 0x00 },
    { 0x0034, 0x00 },
    { 0x0035, 0x00 },
    { 0x0036, 0xDB },
    { 0x0037, 0x04 },
    { 0x0038, 0xDB },
    { 0x0039, 0x04 },
    { 0x003A, 0x00 },
    { 0x003B, 0x00 },
    { 0x003C, 0x00 },
    { 0x003D, 0x00 },
    { 0x003F, 0x33 },
    { 0x0040, 0x01 },
    { 0x0041, 0x02 },
    { 0x0042, 0x0B },
    { 0x0043, 0x00 },
    { 0x0044, 0x00 },
    { 0x0045, 0x0C },
    { 0x0046, 0x32 },
    { 0x0047, 0x32 },
    { 0x0048, 0x00 },
    { 0x0049, 0x00 },
    { 0x004A, 0x32 },
    { 0x004B, 0x32 },
    { 0x004C, 0x00 },
    { 0x004D, 0x00 },
    { 0x004E, 0x55 },
    { 0x004F, 0x00 },
    { 0x0050, 0x0F },
    { 0x0051, 0x03 },
    { 0x0052, 0x03 },
    { 0x0053, 0x00 },
    { 0x0054, 0x00 },
    { 0x0055, 0x03 },
    { 0x0056, 0x03 },
    { 0x0057, 0x00 },
    { 0x0058, 0x00 },
    { 0x0059, 0x05 },
    { 0x005A, 0x0D },
    { 0x005B, 0x74 },
    { 0x005C, 0xDA },
    { 0x005D, 0x00 },
    { 0x005E, 0x00 },
    { 0x005F, 0x00 },
    { 0x0060, 0x00 },
    { 0x0061, 0x01 },
    { 0x0062, 0x00 },
    { 0x0063, 0x00 },
    { 0x0064, 0x00 },
    { 0x0065, 0x00 },
    { 0x0066, 0x00 },
    { 0x0067, 0x00 },
    { 0x0068, 0x00 },
    { 0x0069, 0x00 },
    { 0x0092, 0x02 },
    { 0x0093, 0xA0 },
    { 0x0095, 0x00 },
    { 0x0096, 0x90 },
    { 0x0098, 0x70 },
    { 0x009A, 0x02 },
    { 0x009B, 0x70 },
    { 0x009D, 0x04 },
    { 0x009E, 0x60 },
    { 0x00A0, 0x30 },
    { 0x00A2, 0x00 },
    { 0x00A9, 0xF8 },
    { 0x00AA, 0x3C },
    { 0x00AB, 0x00 },
    { 0x00AC, 0x00 },
    { 0x00E5, 0x21 },
    { 0x00EA, 0x1D },
    { 0x00EB, 0x3B },
    { 0x00EC, 0x00 },
    { 0x00ED, 0x00 },
    { 0x0102, 0x01 },
    { 0x0112, 0x06 },
    { 0x0113, 0x09 },
    { 0x0114, 0x3E },
    { 0x0115, 0x18 },
    { 0x0117, 0x01 },
    { 0x0118, 0x09 },
    { 0x0119, 0x3B },
    { 0x011A, 0x28 },
    { 0x013F, 0x00 },
    { 0x0140, 0x00 },
    { 0x0141, 0x40 },
    { 0x0142, 0xFF },
    { 0x0206, 0x00 },
    { 0x0208, 0x01 },
    { 0x0209, 0x00 },
    { 0x020A, 0x00 },
    { 0x020B, 0x00 },
    { 0x020C, 0x00 },
    { 0x020D, 0x00 },
    { 0x020E, 0x01 },
    { 0x020F, 0x00 },
    { 0x0210, 0x00 },
    { 0x0211, 0x00 },
    { 0x0212, 0x58 },
    { 0x0213, 0x02 },
    { 0x0214, 0x00 },
    { 0x0215, 0x00 },
    { 0x0216, 0x00 },
    { 0x0217, 0x00 },
    { 0x0218, 0x01 },
    { 0x0219, 0x00 },
    { 0x021A, 0x00 },
    { 0x021B, 0x00 },
    { 0x021C, 0x00 },
    { 0x021D, 0x00 },
    { 0x021E, 0x00 },
    { 0x021F, 0x00 },
    { 0x0220, 0x00 },
    { 0x0221, 0x00 },
    { 0x0222, 0x00 },
    { 0x0223, 0x00 },
    { 0x0224, 0x00 },
    { 0x0225, 0x00 },
    { 0x0226, 0x00 },
    { 0x0227, 0x00 },
    { 0x0228, 0x00 },
    { 0x0229, 0x00 },
    { 0x022A, 0x00 },
    { 0x022B, 0x00 },
    { 0x022C, 0x00 },
    { 0x022D, 0x00 },
    { 0x022E, 0x00 },
    { 0x022F, 0x00 },
    { 0x0231, 0x0B },
    { 0x0232, 0x0B },
    { 0x0233, 0x0B },
    { 0x0234, 0x0B },
    { 0x0235, 0x00 },
    { 0x0236, 0x00 },
    { 0x0237, 0x00 },
    { 0x0238, 0xC0 },
    { 0x0239, 0x7B },
    { 0x023A, 0x00 },
    { 0x023B, 0x00 },
    { 0x023C, 0x00 },
    { 0x023D, 0x00 },
    { 0x023E, 0x80 },
    { 0x0250, 0x00 },
    { 0x0251, 0x00 },
    { 0x0252, 0x00 },
    { 0x0253, 0x00 },
    { 0x0254, 0x00 },
    { 0x0255, 0x00 },
    { 0x026B, 0x44 },
    { 0x026C, 0x54 },
    { 0x026D, 0x41 },
    { 0x026E, 0x2D },
    { 0x026F, 0x32 },
    { 0x0270, 0x31 },
    { 0x0271, 0x37 },
    { 0x0272, 0x35 },
    { 0x028A, 0x00 },
    { 0x028B, 0x00 },
    { 0x028C, 0x00 },
    { 0x028D, 0x00 },
    { 0x028E, 0x00 },
    { 0x028F, 0x00 },
    { 0x0290, 0x00 },
    { 0x0291, 0x00 },
    { 0x0294, 0xC0 },
    { 0x0296, 0x00 },
    { 0x0297, 0x02 },
    { 0x0299, 0x02 },
    { 0x029D, 0xEF },
    { 0x029E, 0x00 },
    { 0x029F, 0x00 },
    { 0x02A9, 0x66 },
    { 0x02AA, 0x02 },
    { 0x02AB, 0x00 },
    { 0x02B7, 0xFF },
    { 0x0302, 0x00 },
    { 0x0303, 0x00 },
    { 0x0304, 0x00 },
    { 0x0305, 0x80 },
    { 0x0306, 0x16 },
    { 0x0307, 0x00 },
    { 0x0308, 0x00 },
    { 0x0309, 0x00 },
    { 0x030A, 0x00 },
    { 0x030B, 0x80 },
    { 0x030C, 0x00 },
    { 0x030D, 0x00 },
    { 0x030E, 0x00 },
    { 0x030F, 0x00 },
    { 0x0310, 0x00 },
    { 0x0311, 0x00 },
    { 0x0312, 0x00 },
    { 0x0313, 0x00 },
    { 0x0314, 0x00 },
    { 0x0315, 0x00 },
    { 0x0316, 0x00 },
    { 0x0317, 0x00 },
    { 0x0338, 0x00 },
    { 0x0339, 0x1F },
    { 0x033B, 0x00 },
    { 0x033C, 0x00 },
    { 0x033D, 0x00 },
    { 0x033E, 0x00 },
    { 0x033F, 0x00 },
    { 0x0340, 0x00 },
    { 0x0341, 0x00 },
    { 0x0342, 0x00 },
    { 0x0343, 0x00 },
    { 0x0344, 0x00 },
    { 0x0345, 0x00 },
    { 0x0346, 0x00 },
    { 0x0359, 0x00 },
    { 0x035A, 0x00 },
    { 0x035B, 0x00 },
    { 0x035C, 0x00 },
    { 0x0487, 0x00 },
    { 0x0508, 0x13 },
    { 0x0509, 0x22 },
    { 0x050A, 0x0C },
    { 0x050B, 0x0B },
    { 0x050C, 0x07 },
    { 0x050D, 0x01 },
    { 0x050E, 0x17 },
    { 0x050F, 0x2C },
    { 0x0510, 0x08 },
    { 0x0511, 0x07 },
    { 0x0512, 0x07 },
    { 0x0513, 0x01 },
    { 0x0515, 0x00 },
    { 0x0516, 0x00 },
    { 0x0517, 0x00 },
    { 0x0518, 0x00 },
    { 0x0519, 0x04 },
    { 0x051A, 0x74 },
    { 0x051B, 0x00 },
    { 0x051C, 0x00 },
    { 0x051D, 0x00 },
    { 0x051E, 0x00 },
    { 0x051F, 0x80 },
    { 0x0521, 0x2B },
    { 0x052A, 0x03 },
    { 0x052B, 0x01 },
    { 0x052C, 0x87 },
    { 0x052D, 0x03 },
    { 0x052E, 0x19 },
    { 0x052F, 0x19 },
    { 0x0531, 0x00 },
    { 0x0532, 0xAE },
    { 0x0533, 0x90 },
    { 0x0534, 0x00 },
    { 0x0535, 0x00 },
    { 0x0536, 0x04 },
    { 0x0537, 0x00 },
    { 0x0538, 0x00 },
    { 0x0539, 0x00 },
    { 0x053A, 0x02 },
    { 0x053B, 0x03 },
    { 0x053C, 0x00 },
    { 0x053D, 0x0C },
    { 0x053E, 0x06 },
    { 0x0589, 0x4F },
    { 0x058A, 0x02 },
    { 0x059B, 0xF8 },   // Set INIT_LO_CLOSE_HO to "0" so that  loop bandwidth or fastlock
                        // bandwidth will primarily determine the settling behavior.
                        // Silabs technical support e-mail 2019.10.25
    { 0x059D, 0x13 },
    { 0x059E, 0x24 },
    { 0x059F, 0x0C },
    { 0x05A0, 0x0B },
    { 0x05A1, 0x07 },
    { 0x05A2, 0x01 },
    { 0x05A6, 0x03 },
    { 0x0802, 0x35 },
    { 0x0803, 0x05 },
    { 0x0804, 0x00 },
    { 0x0805, 0x00 },
    { 0x0806, 0x00 },
    { 0x0807, 0x00 },
    { 0x0808, 0x00 },
    { 0x0809, 0x00 },
    { 0x080A, 0x00 },
    { 0x080B, 0x00 },
    { 0x080C, 0x00 },
    { 0x080D, 0x00 },
    { 0x080E, 0x00 },
    { 0x080F, 0x00 },
    { 0x0810, 0x00 },
    { 0x0811, 0x00 },
    { 0x0812, 0x00 },
    { 0x0813, 0x00 },
    { 0x0814, 0x00 },
    { 0x0815, 0x00 },
    { 0x0816, 0x00 },
    { 0x0817, 0x00 },
    { 0x0818, 0x00 },
    { 0x0819, 0x00 },
    { 0x081A, 0x00 },
    { 0x081B, 0x00 },
    { 0x081C, 0x00 },
    { 0x081D, 0x00 },
    { 0x081E, 0x00 },
    { 0x081F, 0x00 },
    { 0x0820, 0x00 },
    { 0x0821, 0x00 },
    { 0x0822, 0x00 },
    { 0x0823, 0x00 },
    { 0x0824, 0x00 },
    { 0x0825, 0x00 },
    { 0x0826, 0x00 },
    { 0x0827, 0x00 },
    { 0x0828, 0x00 },
    { 0x0829, 0x00 },
    { 0x082A, 0x00 },
    { 0x082B, 0x00 },
    { 0x082C, 0x00 },
    { 0x082D, 0x00 },
    { 0x082E, 0x00 },
    { 0x082F, 0x00 },
    { 0x0830, 0x00 },
    { 0x0831, 0x00 },
    { 0x0832, 0x00 },
    { 0x0833, 0x00 },
    { 0x0834, 0x00 },
    { 0x0835, 0x00 },
    { 0x0836, 0x00 },
    { 0x0837, 0x00 },
    { 0x0838, 0x00 },
    { 0x0839, 0x00 },
    { 0x083A, 0x00 },
    { 0x083B, 0x00 },
    { 0x083C, 0x00 },
    { 0x083D, 0x00 },
    { 0x083E, 0x00 },
    { 0x083F, 0x00 },
    { 0x0840, 0x00 },
    { 0x0841, 0x00 },
    { 0x0842, 0x00 },
    { 0x0843, 0x00 },
    { 0x0844, 0x00 },
    { 0x0845, 0x00 },
    { 0x0846, 0x00 },
    { 0x0847, 0x00 },
    { 0x0848, 0x00 },
    { 0x0849, 0x00 },
    { 0x084A, 0x00 },
    { 0x084B, 0x00 },
    { 0x084C, 0x00 },
    { 0x084D, 0x00 },
    { 0x084E, 0x00 },
    { 0x084F, 0x00 },
    { 0x0850, 0x00 },
    { 0x0851, 0x00 },
    { 0x0852, 0x00 },
    { 0x0853, 0x00 },
    { 0x0854, 0x00 },
    { 0x0855, 0x00 },
    { 0x0856, 0x00 },
    { 0x0857, 0x00 },
    { 0x0858, 0x00 },
    { 0x0859, 0x00 },
    { 0x085A, 0x00 },
    { 0x085B, 0x00 },
    { 0x085C, 0x00 },
    { 0x085D, 0x00 },
    { 0x085E, 0x00 },
    { 0x085F, 0x00 },
    { 0x0860, 0x00 },
    { 0x0861, 0x00 },
    { 0x090E, 0x02 },
    { 0x0943, 0x00 },
    { 0x0949, 0x13 },
    { 0x094A, 0x03 },
    { 0x094E, 0x49 },
    { 0x094F, 0x02 },
    { 0x095E, 0x00 },
    { 0x0A02, 0x00 },
    { 0x0A03, 0x01 },
    { 0x0A04, 0x01 },
    { 0x0A05, 0x01 },
    { 0x0A14, 0x00 },
    { 0x0A1A, 0x00 },
    { 0x0B44, 0x2F },
    { 0x0B46, 0x00 },
    { 0x0B47, 0x0C },
    { 0x0B48, 0x0C },
    { 0x0B4A, 0x02 },
    { 0x0B57, 0xF0 },
    { 0x0B58, 0x00 },
};

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+ SI5342 Fractional SDI clock +=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//
// SI5342 fractional SDI clock configuration. 
// Used for the DTA-2175.
// 54MHz XTAL input, DCO-mode; In1: 27MHz; Out0: 148.35MHz.
//
// Register settings
static const DtDfSi534XRegister SI5342_CONFIG_FRAC_SDI_CLOCK_DTA2175_LIKE[] =
{
    { 0x0006, 0x00 },
    { 0x0007, 0x00 },
    { 0x0008, 0x00 },
    { 0x000B, 0x68 },
    { 0x0016, 0x02 },
    { 0x0017, 0xDC },
    { 0x0018, 0xCC },
    { 0x0019, 0xDD },
    { 0x001A, 0xDF },
    { 0x002B, 0x02 },
    { 0x002C, 0x03 },
    { 0x002D, 0x05 },
    { 0x002E, 0xDA },
    { 0x002F, 0x04 },
    { 0x0030, 0xDA },
    { 0x0031, 0x04 },
    { 0x0032, 0x00 },
    { 0x0033, 0x00 },
    { 0x0034, 0x00 },
    { 0x0035, 0x00 },
    { 0x0036, 0xDA },
    { 0x0037, 0x04 },
    { 0x0038, 0xDA },
    { 0x0039, 0x04 },
    { 0x003A, 0x00 },
    { 0x003B, 0x00 },
    { 0x003C, 0x00 },
    { 0x003D, 0x00 },
    { 0x003F, 0x33 },
    { 0x0040, 0x01 },
    { 0x0041, 0x02 },
    { 0x0042, 0x0B },
    { 0x0043, 0x00 },
    { 0x0044, 0x00 },
    { 0x0045, 0x0C },
    { 0x0046, 0x32 },
    { 0x0047, 0x32 },
    { 0x0048, 0x00 },
    { 0x0049, 0x00 },
    { 0x004A, 0x32 },
    { 0x004B, 0x32 },
    { 0x004C, 0x00 },
    { 0x004D, 0x00 },
    { 0x004E, 0x55 },
    { 0x004F, 0x00 },
    { 0x0050, 0x0F },
    { 0x0051, 0x03 },
    { 0x0052, 0x03 },
    { 0x0053, 0x00 },
    { 0x0054, 0x00 },
    { 0x0055, 0x03 },
    { 0x0056, 0x03 },
    { 0x0057, 0x00 },
    { 0x0058, 0x00 },
    { 0x0059, 0x05 },
    { 0x005A, 0x0D },
    { 0x005B, 0x74 },
    { 0x005C, 0xDA },
    { 0x005D, 0x00 },
    { 0x005E, 0x00 },
    { 0x005F, 0x00 },
    { 0x0060, 0x00 },
    { 0x0061, 0x01 },
    { 0x0062, 0x00 },
    { 0x0063, 0x00 },
    { 0x0064, 0x00 },
    { 0x0065, 0x00 },
    { 0x0066, 0x00 },
    { 0x0067, 0x00 },
    { 0x0068, 0x00 },
    { 0x0069, 0x00 },
    { 0x0092, 0x02 },
    { 0x0093, 0xA0 },
    { 0x0095, 0x00 },
    { 0x0096, 0x90 },
    { 0x0098, 0x70 },
    { 0x009A, 0x02 },
    { 0x009B, 0x70 },
    { 0x009D, 0x04 },
    { 0x009E, 0x60 },
    { 0x00A0, 0x30 },
    { 0x00A2, 0x00 },
    { 0x00A9, 0xF7 },
    { 0x00AA, 0x3C },
    { 0x00AB, 0x00 },
    { 0x00AC, 0x00 },
    { 0x00E5, 0x21 },
    { 0x00EA, 0x1D },
    { 0x00EB, 0x3B },
    { 0x00EC, 0x00 },
    { 0x00ED, 0x00 },
    { 0x0102, 0x01 },
    { 0x0112, 0x06 },
    { 0x0113, 0x09 },
    { 0x0114, 0x3E },
    { 0x0115, 0x18 },
    { 0x0117, 0x01 },
    { 0x0118, 0x09 },
    { 0x0119, 0x3B },
    { 0x011A, 0x28 },
    { 0x013F, 0x00 },
    { 0x0140, 0x00 },
    { 0x0141, 0x40 },
    { 0x0142, 0xFF },
    { 0x0206, 0x00 },
    { 0x0208, 0x01 },
    { 0x0209, 0x00 },
    { 0x020A, 0x00 },
    { 0x020B, 0x00 },
    { 0x020C, 0x00 },
    { 0x020D, 0x00 },
    { 0x020E, 0x01 },
    { 0x020F, 0x00 },
    { 0x0210, 0x00 },
    { 0x0211, 0x00 },
    { 0x0212, 0x58 },
    { 0x0213, 0x02 },
    { 0x0214, 0x00 },
    { 0x0215, 0x00 },
    { 0x0216, 0x00 },
    { 0x0217, 0x00 },
    { 0x0218, 0x01 },
    { 0x0219, 0x00 },
    { 0x021A, 0x00 },
    { 0x021B, 0x00 },
    { 0x021C, 0x00 },
    { 0x021D, 0x00 },
    { 0x021E, 0x00 },
    { 0x021F, 0x00 },
    { 0x0220, 0x00 },
    { 0x0221, 0x00 },
    { 0x0222, 0x00 },
    { 0x0223, 0x00 },
    { 0x0224, 0x00 },
    { 0x0225, 0x00 },
    { 0x0226, 0x00 },
    { 0x0227, 0x00 },
    { 0x0228, 0x00 },
    { 0x0229, 0x00 },
    { 0x022A, 0x00 },
    { 0x022B, 0x00 },
    { 0x022C, 0x00 },
    { 0x022D, 0x00 },
    { 0x022E, 0x00 },
    { 0x022F, 0x00 },
    { 0x0231, 0x0B },
    { 0x0232, 0x0B },
    { 0x0233, 0x0B },
    { 0x0234, 0x0B },
    { 0x0235, 0x00 },
    { 0x0236, 0x88 },
    { 0x0237, 0x54 },
    { 0x0238, 0xD9 },
    { 0x0239, 0xB0 },
    { 0x023A, 0x00 },
    { 0x023B, 0x00 },
    { 0x023C, 0x00 },
    { 0x023D, 0x1B },
    { 0x023E, 0xB7 },
    { 0x0250, 0x00 },
    { 0x0251, 0x00 },
    { 0x0252, 0x00 },
    { 0x0253, 0x00 },
    { 0x0254, 0x00 },
    { 0x0255, 0x00 },
    { 0x026B, 0x44 },
    { 0x026C, 0x54 },
    { 0x026D, 0x41 },
    { 0x026E, 0x2D },
    { 0x026F, 0x32 },
    { 0x0270, 0x31 },
    { 0x0271, 0x37 },
    { 0x0272, 0x35 },
    { 0x028A, 0x00 },
    { 0x028B, 0x00 },
    { 0x028C, 0x00 },
    { 0x028D, 0x00 },
    { 0x028E, 0x00 },
    { 0x028F, 0x00 },
    { 0x0290, 0x00 },
    { 0x0291, 0x00 },
    { 0x0294, 0xC0 },
    { 0x0296, 0x00 },
    { 0x0297, 0x02 },
    { 0x0299, 0x02 },
    { 0x029D, 0xEF },
    { 0x029E, 0x00 },
    { 0x029F, 0x00 },
    { 0x02A9, 0x66 },
    { 0x02AA, 0x02 },
    { 0x02AB, 0x00 },
    { 0x02B7, 0xFF },
    { 0x0302, 0x00 },
    { 0x0303, 0x00 },
    { 0x0304, 0x00 },
    { 0x0305, 0x80 },
    { 0x0306, 0x16 },
    { 0x0307, 0x00 },
    { 0x0308, 0x00 },
    { 0x0309, 0x00 },
    { 0x030A, 0x00 },
    { 0x030B, 0x80 },
    { 0x030C, 0x00 },
    { 0x030D, 0x00 },
    { 0x030E, 0x00 },
    { 0x030F, 0x00 },
    { 0x0310, 0x00 },
    { 0x0311, 0x00 },
    { 0x0312, 0x00 },
    { 0x0313, 0x00 },
    { 0x0314, 0x00 },
    { 0x0315, 0x00 },
    { 0x0316, 0x00 },
    { 0x0317, 0x00 },
    { 0x0338, 0x00 },
    { 0x0339, 0x1F },
    { 0x033B, 0x00 },
    { 0x033C, 0x00 },
    { 0x033D, 0x00 },
    { 0x033E, 0x00 },
    { 0x033F, 0x00 },
    { 0x0340, 0x00 },
    { 0x0341, 0x00 },
    { 0x0342, 0x00 },
    { 0x0343, 0x00 },
    { 0x0344, 0x00 },
    { 0x0345, 0x00 },
    { 0x0346, 0x00 },
    { 0x0359, 0x00 },
    { 0x035A, 0x00 },
    { 0x035B, 0x00 },
    { 0x035C, 0x00 },
    { 0x0487, 0x00 },
    { 0x0508, 0x13 },
    { 0x0509, 0x22 },
    { 0x050A, 0x0C },
    { 0x050B, 0x0B },
    { 0x050C, 0x07 },
    { 0x050D, 0x01 },
    { 0x050E, 0x17 },
    { 0x050F, 0x2C },
    { 0x0510, 0x08 },
    { 0x0511, 0x07 },
    { 0x0512, 0x07 },
    { 0x0513, 0x01 },
    { 0x0515, 0x00 },
    { 0x0516, 0x00 },
    { 0x0517, 0x88 },
    { 0x0518, 0x54 },
    { 0x0519, 0xD9 },
    { 0x051A, 0xB0 },
    { 0x051B, 0x00 },
    { 0x051C, 0x00 },
    { 0x051D, 0x00 },
    { 0x051E, 0x50 },
    { 0x051F, 0xC3 },
    { 0x0521, 0x3B },
    { 0x052A, 0x03 },
    { 0x052B, 0x01 },
    { 0x052C, 0x87 },
    { 0x052D, 0x03 },
    { 0x052E, 0x19 },
    { 0x052F, 0x19 },
    { 0x0531, 0x00 },
    { 0x0532, 0xAE },
    { 0x0533, 0x90 },
    { 0x0534, 0x00 },
    { 0x0535, 0x00 },
    { 0x0536, 0x04 },
    { 0x0537, 0x00 },
    { 0x0538, 0x00 },
    { 0x0539, 0x00 },
    { 0x053A, 0x02 },
    { 0x053B, 0x03 },
    { 0x053C, 0x00 },
    { 0x053D, 0x0C },
    { 0x053E, 0x06 },
    { 0x0589, 0x4E },
    { 0x058A, 0x02 },
    { 0x059B, 0xF8 },   // Set INIT_LO_CLOSE_HO to "0" so that  loop bandwidth or fastlock
                        // bandwidth will primarily determine the settling behavior.
                        // Silabs technical support e-mail 2019.10.25
    { 0x059D, 0x13 },
    { 0x059E, 0x24 },
    { 0x059F, 0x0C },
    { 0x05A0, 0x0B },
    { 0x05A1, 0x07 },
    { 0x05A2, 0x01 },
    { 0x05A6, 0x03 },
    { 0x0802, 0x35 },
    { 0x0803, 0x05 },
    { 0x0804, 0x00 },
    { 0x0805, 0x00 },
    { 0x0806, 0x00 },
    { 0x0807, 0x00 },
    { 0x0808, 0x00 },
    { 0x0809, 0x00 },
    { 0x080A, 0x00 },
    { 0x080B, 0x00 },
    { 0x080C, 0x00 },
    { 0x080D, 0x00 },
    { 0x080E, 0x00 },
    { 0x080F, 0x00 },
    { 0x0810, 0x00 },
    { 0x0811, 0x00 },
    { 0x0812, 0x00 },
    { 0x0813, 0x00 },
    { 0x0814, 0x00 },
    { 0x0815, 0x00 },
    { 0x0816, 0x00 },
    { 0x0817, 0x00 },
    { 0x0818, 0x00 },
    { 0x0819, 0x00 },
    { 0x081A, 0x00 },
    { 0x081B, 0x00 },
    { 0x081C, 0x00 },
    { 0x081D, 0x00 },
    { 0x081E, 0x00 },
    { 0x081F, 0x00 },
    { 0x0820, 0x00 },
    { 0x0821, 0x00 },
    { 0x0822, 0x00 },
    { 0x0823, 0x00 },
    { 0x0824, 0x00 },
    { 0x0825, 0x00 },
    { 0x0826, 0x00 },
    { 0x0827, 0x00 },
    { 0x0828, 0x00 },
    { 0x0829, 0x00 },
    { 0x082A, 0x00 },
    { 0x082B, 0x00 },
    { 0x082C, 0x00 },
    { 0x082D, 0x00 },
    { 0x082E, 0x00 },
    { 0x082F, 0x00 },
    { 0x0830, 0x00 },
    { 0x0831, 0x00 },
    { 0x0832, 0x00 },
    { 0x0833, 0x00 },
    { 0x0834, 0x00 },
    { 0x0835, 0x00 },
    { 0x0836, 0x00 },
    { 0x0837, 0x00 },
    { 0x0838, 0x00 },
    { 0x0839, 0x00 },
    { 0x083A, 0x00 },
    { 0x083B, 0x00 },
    { 0x083C, 0x00 },
    { 0x083D, 0x00 },
    { 0x083E, 0x00 },
    { 0x083F, 0x00 },
    { 0x0840, 0x00 },
    { 0x0841, 0x00 },
    { 0x0842, 0x00 },
    { 0x0843, 0x00 },
    { 0x0844, 0x00 },
    { 0x0845, 0x00 },
    { 0x0846, 0x00 },
    { 0x0847, 0x00 },
    { 0x0848, 0x00 },
    { 0x0849, 0x00 },
    { 0x084A, 0x00 },
    { 0x084B, 0x00 },
    { 0x084C, 0x00 },
    { 0x084D, 0x00 },
    { 0x084E, 0x00 },
    { 0x084F, 0x00 },
    { 0x0850, 0x00 },
    { 0x0851, 0x00 },
    { 0x0852, 0x00 },
    { 0x0853, 0x00 },
    { 0x0854, 0x00 },
    { 0x0855, 0x00 },
    { 0x0856, 0x00 },
    { 0x0857, 0x00 },
    { 0x0858, 0x00 },
    { 0x0859, 0x00 },
    { 0x085A, 0x00 },
    { 0x085B, 0x00 },
    { 0x085C, 0x00 },
    { 0x085D, 0x00 },
    { 0x085E, 0x00 },
    { 0x085F, 0x00 },
    { 0x0860, 0x00 },
    { 0x0861, 0x00 },
    { 0x090E, 0x02 },
    { 0x0943, 0x00 },
    { 0x0949, 0x13 },
    { 0x094A, 0x03 },
    { 0x094E, 0x49 },
    { 0x094F, 0x02 },
    { 0x095E, 0x00 },
    { 0x0A02, 0x00 },
    { 0x0A03, 0x01 },
    { 0x0A04, 0x01 },
    { 0x0A05, 0x01 },
    { 0x0A14, 0x00 },
    { 0x0A1A, 0x00 },
    { 0x0B44, 0x0F },
    { 0x0B46, 0x00 },
    { 0x0B47, 0x0C },
    { 0x0B48, 0x0C },
    { 0x0B4A, 0x02 },
    { 0x0B57, 0xF0 },
    { 0x0B58, 0x00 },
};



// =+=+=+=+=+=+=+=+=+=+=+=+ DTA2127-Like Configuration Properties +=+=+=+=+=+=+=+=+=+=+=+=
//
static const DtDfSi534XClockProps SI5342_CONFIG_NON_FRAC_SDI_CLOCK_PROPS_DTA2127_LIKE[1] =
{
    { 0,                                                // Clock output port index 0
      DT_DF_SI534X_CLK_NON_FRACTIONAL,                  // Non-fractional clock
      (SI534X_EXP12+62008590336LL-1)/62008590336LL,     // 1e12/N0_NUM
      200*SI534X_EXP6,                                  // +/- 200ppm
      148*SI534X_EXP12 + 500LL*SI534X_EXP9              // Freq: 148.5MHz
    }
};
static const DtDfSi534XClockProps SI5342_CONFIG_FRAC_SDI_CLOCK_PROPS_DTA2127_LIKE[1] =
{
    { 0,                                                // Clock output port index 0
      DT_DF_SI534X_CLK_FRACTIONAL,                      // Fractional clock
      (SI534X_EXP12+150709731328LL-1)/150709731328LL,   // 1e12/N0_NUM
      200*SI534X_EXP6,                                  // +/- 200ppm
      1483516484LL*SI534X_EXP5                          // Freq: 148.35MHz
    }
};

// +=+=+=+=+=+=+=+=+=+=+=+=+=+ SI5342 Non-Fractional SDI clock +=+=+=+=+=+=+=+=+=+=+=+=+=+
//
// SI5342 non-fractional SDI clock configuration. 
// Used for the DTA-2127.
// 27MHz XO input, Free-run-only-mode; In1: NC; Out0: 148.5MHz.
//

// Register settings
static const DtDfSi534XRegister SI5342_CONFIG_NON_FRAC_SDI_CLOCK_DTA2127_LIKE[] =
{
    { 0x0006, 0x00 },
    { 0x0007, 0x00 },
    { 0x0008, 0x00 },
    { 0x000B, 0x68 },
    { 0x0016, 0x02 },
    { 0x0017, 0xDC },
    { 0x0018, 0xFF },
    { 0x0019, 0xFF },
    { 0x001A, 0xFF },
    { 0x002B, 0x02 },
    { 0x002C, 0x00 },
    { 0x002D, 0x00 },
    { 0x002E, 0x00 },
    { 0x002F, 0x00 },
    { 0x0030, 0x00 },
    { 0x0031, 0x00 },
    { 0x0032, 0x00 },
    { 0x0033, 0x00 },
    { 0x0034, 0x00 },
    { 0x0035, 0x00 },
    { 0x0036, 0x00 },
    { 0x0037, 0x00 },
    { 0x0038, 0x00 },
    { 0x0039, 0x00 },
    { 0x003A, 0x00 },
    { 0x003B, 0x00 },
    { 0x003C, 0x00 },
    { 0x003D, 0x00 },
    { 0x003F, 0x00 },
    { 0x0040, 0x04 },
    { 0x0041, 0x00 },
    { 0x0042, 0x00 },
    { 0x0043, 0x00 },
    { 0x0044, 0x00 },
    { 0x0045, 0x0B },
    { 0x0046, 0x00 },
    { 0x0047, 0x00 },
    { 0x0048, 0x00 },
    { 0x0049, 0x00 },
    { 0x004A, 0x00 },
    { 0x004B, 0x00 },
    { 0x004C, 0x00 },
    { 0x004D, 0x00 },
    { 0x004E, 0x00 },
    { 0x004F, 0x00 },
    { 0x0050, 0x0F },
    { 0x0051, 0x00 },
    { 0x0052, 0x00 },
    { 0x0053, 0x00 },
    { 0x0054, 0x00 },
    { 0x0055, 0x00 },
    { 0x0056, 0x00 },
    { 0x0057, 0x00 },
    { 0x0058, 0x00 },
    { 0x0059, 0x00 },
    { 0x005A, 0x00 },
    { 0x005B, 0x00 },
    { 0x005C, 0x00 },
    { 0x005D, 0x00 },
    { 0x005E, 0x00 },
    { 0x005F, 0x00 },
    { 0x0060, 0x00 },
    { 0x0061, 0x00 },
    { 0x0062, 0x00 },
    { 0x0063, 0x00 },
    { 0x0064, 0x00 },
    { 0x0065, 0x00 },
    { 0x0066, 0x00 },
    { 0x0067, 0x00 },
    { 0x0068, 0x00 },
    { 0x0069, 0x00 },
    { 0x0092, 0x00 },
    { 0x0093, 0x00 },
    { 0x0095, 0x00 },
    { 0x0096, 0x00 },
    { 0x0098, 0x00 },
    { 0x009A, 0x00 },
    { 0x009B, 0x00 },
    { 0x009D, 0x00 },
    { 0x009E, 0x00 },
    { 0x00A0, 0x00 },
    { 0x00A2, 0x00 },
    { 0x00A9, 0x00 },
    { 0x00AA, 0x00 },
    { 0x00AB, 0x00 },
    { 0x00AC, 0x00 },
    { 0x00E5, 0x01 },
    { 0x00EA, 0x00 },
    { 0x00EB, 0x00 },
    { 0x00EC, 0x00 },
    { 0x00ED, 0x00 },
    { 0x0102, 0x01 },
    { 0x0112, 0x02 },
    { 0x0113, 0x09 },
    { 0x0114, 0x3E },
    { 0x0115, 0x18 },
    { 0x0117, 0x01 },
    { 0x0118, 0x09 },
    { 0x0119, 0x3B },
    { 0x011A, 0x28 },
    { 0x013F, 0x00 },
    { 0x0140, 0x00 },
    { 0x0141, 0x40 },
    { 0x0142, 0xFF },
    { 0x0206, 0x00 },
    { 0x0208, 0x00 },
    { 0x0209, 0x00 },
    { 0x020A, 0x00 },
    { 0x020B, 0x00 },
    { 0x020C, 0x00 },
    { 0x020D, 0x00 },
    { 0x020E, 0x00 },
    { 0x020F, 0x00 },
    { 0x0210, 0x00 },
    { 0x0211, 0x00 },
    { 0x0212, 0x00 },
    { 0x0213, 0x00 },
    { 0x0214, 0x00 },
    { 0x0215, 0x00 },
    { 0x0216, 0x00 },
    { 0x0217, 0x00 },
    { 0x0218, 0x00 },
    { 0x0219, 0x00 },
    { 0x021A, 0x00 },
    { 0x021B, 0x00 },
    { 0x021C, 0x00 },
    { 0x021D, 0x00 },
    { 0x021E, 0x00 },
    { 0x021F, 0x00 },
    { 0x0220, 0x00 },
    { 0x0221, 0x00 },
    { 0x0222, 0x00 },
    { 0x0223, 0x00 },
    { 0x0224, 0x00 },
    { 0x0225, 0x00 },
    { 0x0226, 0x00 },
    { 0x0227, 0x00 },
    { 0x0228, 0x00 },
    { 0x0229, 0x00 },
    { 0x022A, 0x00 },
    { 0x022B, 0x00 },
    { 0x022C, 0x00 },
    { 0x022D, 0x00 },
    { 0x022E, 0x00 },
    { 0x022F, 0x00 },
    { 0x0231, 0x0B },
    { 0x0232, 0x0B },
    { 0x0233, 0x0B },
    { 0x0234, 0x0B },
    { 0x0235, 0x00 },
    { 0x0236, 0x00 },
    { 0x0237, 0x00 },
    { 0x0238, 0xA0 },
    { 0x0239, 0x3D },
    { 0x023A, 0x01 },
    { 0x023B, 0x00 },
    { 0x023C, 0x00 },
    { 0x023D, 0x00 },
    { 0x023E, 0xA0 },
    { 0x0250, 0x01 },
    { 0x0251, 0x00 },
    { 0x0252, 0x00 },
    { 0x0253, 0x00 },
    { 0x0254, 0x00 },
    { 0x0255, 0x00 },
    { 0x026B, 0x44 },
    { 0x026C, 0x54 },
    { 0x026D, 0x41 },
    { 0x026E, 0x2D },
    { 0x026F, 0x32 },
    { 0x0270, 0x31 },
    { 0x0271, 0x32 },
    { 0x0272, 0x37 },
    { 0x028A, 0x00 },
    { 0x028B, 0x00 },
    { 0x028C, 0x00 },
    { 0x028D, 0x00 },
    { 0x028E, 0x00 },
    { 0x028F, 0x00 },
    { 0x0290, 0x00 },
    { 0x0291, 0x00 },
    { 0x0294, 0x80 },
    { 0x0296, 0x00 },
    { 0x0297, 0x00 },
    { 0x0299, 0x00 },
    { 0x029D, 0x00 },
    { 0x029E, 0x00 },
    { 0x029F, 0x00 },
    { 0x02A9, 0x00 },
    { 0x02AA, 0x00 },
    { 0x02AB, 0x00 },
    { 0x02B7, 0xFF },
    { 0x0302, 0x00 },
    { 0x0303, 0x00 },
    { 0x0304, 0x00 },
    { 0x0305, 0x70 },
    { 0x0306, 0x0E },
    { 0x0307, 0x00 },
    { 0x0308, 0x00 },
    { 0x0309, 0x00 },
    { 0x030A, 0x00 },
    { 0x030B, 0xA0 },
    { 0x030C, 0x00 },
    { 0x030D, 0x00 },
    { 0x030E, 0x00 },
    { 0x030F, 0x00 },
    { 0x0310, 0x00 },
    { 0x0311, 0x00 },
    { 0x0312, 0x00 },
    { 0x0313, 0x00 },
    { 0x0314, 0x00 },
    { 0x0315, 0x00 },
    { 0x0316, 0x00 },
    { 0x0317, 0x00 },
    { 0x0338, 0x00 },
    { 0x0339, 0x1F },
    { 0x033B, 0x01 },
    { 0x033C, 0x00 },
    { 0x033D, 0x00 },
    { 0x033E, 0x00 },
    { 0x033F, 0x00 },
    { 0x0340, 0x00 },
    { 0x0341, 0x00 },
    { 0x0342, 0x00 },
    { 0x0343, 0x00 },
    { 0x0344, 0x00 },
    { 0x0345, 0x00 },
    { 0x0346, 0x00 },
    { 0x0359, 0x00 },
    { 0x035A, 0x00 },
    { 0x035B, 0x00 },
    { 0x035C, 0x00 },
    { 0x0487, 0x00 },
    { 0x0508, 0x00 },
    { 0x0509, 0x00 },
    { 0x050A, 0x00 },
    { 0x050B, 0x00 },
    { 0x050C, 0x00 },
    { 0x050D, 0x00 },
    { 0x050E, 0x00 },
    { 0x050F, 0x00 },
    { 0x0510, 0x00 },
    { 0x0511, 0x00 },
    { 0x0512, 0x00 },
    { 0x0513, 0x00 },
    { 0x0515, 0x00 },
    { 0x0516, 0x00 },
    { 0x0517, 0x00 },
    { 0x0518, 0x00 },
    { 0x0519, 0x00 },
    { 0x051A, 0x00 },
    { 0x051B, 0x00 },
    { 0x051C, 0x00 },
    { 0x051D, 0x00 },
    { 0x051E, 0x00 },
    { 0x051F, 0x00 },
    { 0x0521, 0x2B },
    { 0x052A, 0x03 },
    { 0x052B, 0x01 },
    { 0x052C, 0x0F },
    { 0x052D, 0x03 },
    { 0x052E, 0x00 },
    { 0x052F, 0x00 },
    { 0x0531, 0x00 },
    { 0x0532, 0x00 },
    { 0x0533, 0x04 },
    { 0x0534, 0x00 },
    { 0x0535, 0x01 },
    { 0x0536, 0x04 },
    { 0x0537, 0x00 },
    { 0x0538, 0x00 },
    { 0x0539, 0x00 },
    { 0x053D, 0x0A },
    { 0x053E, 0x06 },
    { 0x0589, 0x0C },
    { 0x058A, 0x00 },
    { 0x059B, 0x18 },
    { 0x059D, 0x00 },
    { 0x059E, 0x00 },
    { 0x059F, 0x00 },
    { 0x05A0, 0x00 },
    { 0x05A1, 0x00 },
    { 0x05A2, 0x00 },
    { 0x05A6, 0x00 },
    { 0x0802, 0x35 },
    { 0x0803, 0x05 },
    { 0x0804, 0x01 },
    { 0x0805, 0x00 },
    { 0x0806, 0x00 },
    { 0x0807, 0x00 },
    { 0x0808, 0x00 },
    { 0x0809, 0x00 },
    { 0x080A, 0x00 },
    { 0x080B, 0x00 },
    { 0x080C, 0x00 },
    { 0x080D, 0x00 },
    { 0x080E, 0x00 },
    { 0x080F, 0x00 },
    { 0x0810, 0x00 },
    { 0x0811, 0x00 },
    { 0x0812, 0x00 },
    { 0x0813, 0x00 },
    { 0x0814, 0x00 },
    { 0x0815, 0x00 },
    { 0x0816, 0x00 },
    { 0x0817, 0x00 },
    { 0x0818, 0x00 },
    { 0x0819, 0x00 },
    { 0x081A, 0x00 },
    { 0x081B, 0x00 },
    { 0x081C, 0x00 },
    { 0x081D, 0x00 },
    { 0x081E, 0x00 },
    { 0x081F, 0x00 },
    { 0x0820, 0x00 },
    { 0x0821, 0x00 },
    { 0x0822, 0x00 },
    { 0x0823, 0x00 },
    { 0x0824, 0x00 },
    { 0x0825, 0x00 },
    { 0x0826, 0x00 },
    { 0x0827, 0x00 },
    { 0x0828, 0x00 },
    { 0x0829, 0x00 },
    { 0x082A, 0x00 },
    { 0x082B, 0x00 },
    { 0x082C, 0x00 },
    { 0x082D, 0x00 },
    { 0x082E, 0x00 },
    { 0x082F, 0x00 },
    { 0x0830, 0x00 },
    { 0x0831, 0x00 },
    { 0x0832, 0x00 },
    { 0x0833, 0x00 },
    { 0x0834, 0x00 },
    { 0x0835, 0x00 },
    { 0x0836, 0x00 },
    { 0x0837, 0x00 },
    { 0x0838, 0x00 },
    { 0x0839, 0x00 },
    { 0x083A, 0x00 },
    { 0x083B, 0x00 },
    { 0x083C, 0x00 },
    { 0x083D, 0x00 },
    { 0x083E, 0x00 },
    { 0x083F, 0x00 },
    { 0x0840, 0x00 },
    { 0x0841, 0x00 },
    { 0x0842, 0x00 },
    { 0x0843, 0x00 },
    { 0x0844, 0x00 },
    { 0x0845, 0x00 },
    { 0x0846, 0x00 },
    { 0x0847, 0x00 },
    { 0x0848, 0x00 },
    { 0x0849, 0x00 },
    { 0x084A, 0x00 },
    { 0x084B, 0x00 },
    { 0x084C, 0x00 },
    { 0x084D, 0x00 },
    { 0x084E, 0x00 },
    { 0x084F, 0x00 },
    { 0x0850, 0x00 },
    { 0x0851, 0x00 },
    { 0x0852, 0x00 },
    { 0x0853, 0x00 },
    { 0x0854, 0x00 },
    { 0x0855, 0x00 },
    { 0x0856, 0x00 },
    { 0x0857, 0x00 },
    { 0x0858, 0x00 },
    { 0x0859, 0x00 },
    { 0x085A, 0x00 },
    { 0x085B, 0x00 },
    { 0x085C, 0x00 },
    { 0x085D, 0x00 },
    { 0x085E, 0x00 },
    { 0x085F, 0x00 },
    { 0x0860, 0x00 },
    { 0x0861, 0x00 },
    { 0x090E, 0x03 },
    { 0x0943, 0x00 },
    { 0x0949, 0x00 },
    { 0x094A, 0x00 },
    { 0x094E, 0x49 },
    { 0x094F, 0x02 },
    { 0x095E, 0x00 },
    { 0x0A02, 0x00 },
    { 0x0A03, 0x01 },
    { 0x0A04, 0x00 },
    { 0x0A05, 0x01 },
    { 0x0A14, 0x00 },
    { 0x0A1A, 0x00 },
    { 0x0B44, 0x0F },
    { 0x0B46, 0x00 },
    { 0x0B47, 0x0F },
    { 0x0B48, 0x0F },
    { 0x0B4A, 0x02 },
    { 0x0B57, 0xE0 },
    { 0x0B58, 0x01 },
};

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+ SI5342 Fractional SDI clock +=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//
// SI5342 fractional SDI clock configuration. 
// Used for the DTA-2127.
// 27MHz XO input, Free-run-only-mode; In1: NC; Out0: 148.35MHz.
//

// Register settings
static const DtDfSi534XRegister SI5342_CONFIG_FRAC_SDI_CLOCK_DTA2127_LIKE[] =
{
    { 0x0006, 0x00 },
    { 0x0007, 0x00 },
    { 0x0008, 0x00 },
    { 0x000B, 0x68 },
    { 0x0016, 0x02 },
    { 0x0017, 0xDC },
    { 0x0018, 0xFF },
    { 0x0019, 0xFF },
    { 0x001A, 0xFF },
    { 0x002B, 0x02 },
    { 0x002C, 0x00 },
    { 0x002D, 0x00 },
    { 0x002E, 0x00 },
    { 0x002F, 0x00 },
    { 0x0030, 0x00 },
    { 0x0031, 0x00 },
    { 0x0032, 0x00 },
    { 0x0033, 0x00 },
    { 0x0034, 0x00 },
    { 0x0035, 0x00 },
    { 0x0036, 0x00 },
    { 0x0037, 0x00 },
    { 0x0038, 0x00 },
    { 0x0039, 0x00 },
    { 0x003A, 0x00 },
    { 0x003B, 0x00 },
    { 0x003C, 0x00 },
    { 0x003D, 0x00 },
    { 0x003F, 0x00 },
    { 0x0040, 0x04 },
    { 0x0041, 0x00 },
    { 0x0042, 0x00 },
    { 0x0043, 0x00 },
    { 0x0044, 0x00 },
    { 0x0045, 0x0B },
    { 0x0046, 0x00 },
    { 0x0047, 0x00 },
    { 0x0048, 0x00 },
    { 0x0049, 0x00 },
    { 0x004A, 0x00 },
    { 0x004B, 0x00 },
    { 0x004C, 0x00 },
    { 0x004D, 0x00 },
    { 0x004E, 0x00 },
    { 0x004F, 0x00 },
    { 0x0050, 0x0F },
    { 0x0051, 0x00 },
    { 0x0052, 0x00 },
    { 0x0053, 0x00 },
    { 0x0054, 0x00 },
    { 0x0055, 0x00 },
    { 0x0056, 0x00 },
    { 0x0057, 0x00 },
    { 0x0058, 0x00 },
    { 0x0059, 0x00 },
    { 0x005A, 0x00 },
    { 0x005B, 0x00 },
    { 0x005C, 0x00 },
    { 0x005D, 0x00 },
    { 0x005E, 0x00 },
    { 0x005F, 0x00 },
    { 0x0060, 0x00 },
    { 0x0061, 0x00 },
    { 0x0062, 0x00 },
    { 0x0063, 0x00 },
    { 0x0064, 0x00 },
    { 0x0065, 0x00 },
    { 0x0066, 0x00 },
    { 0x0067, 0x00 },
    { 0x0068, 0x00 },
    { 0x0069, 0x00 },
    { 0x0092, 0x00 },
    { 0x0093, 0x00 },
    { 0x0095, 0x00 },
    { 0x0096, 0x00 },
    { 0x0098, 0x00 },
    { 0x009A, 0x00 },
    { 0x009B, 0x00 },
    { 0x009D, 0x00 },
    { 0x009E, 0x00 },
    { 0x00A0, 0x00 },
    { 0x00A2, 0x00 },
    { 0x00A9, 0x00 },
    { 0x00AA, 0x00 },
    { 0x00AB, 0x00 },
    { 0x00AC, 0x00 },
    { 0x00E5, 0x01 },
    { 0x00EA, 0x00 },
    { 0x00EB, 0x00 },
    { 0x00EC, 0x00 },
    { 0x00ED, 0x00 },
    { 0x0102, 0x01 },
    { 0x0112, 0x06 },
    { 0x0113, 0x09 },
    { 0x0114, 0x3E },
    { 0x0115, 0x18 },
    { 0x0117, 0x01 },
    { 0x0118, 0x09 },
    { 0x0119, 0x3B },
    { 0x011A, 0x28 },
    { 0x013F, 0x00 },
    { 0x0140, 0x00 },
    { 0x0141, 0x40 },
    { 0x0142, 0xFF },
    { 0x0206, 0x00 },
    { 0x0208, 0x00 },
    { 0x0209, 0x00 },
    { 0x020A, 0x00 },
    { 0x020B, 0x00 },
    { 0x020C, 0x00 },
    { 0x020D, 0x00 },
    { 0x020E, 0x00 },
    { 0x020F, 0x00 },
    { 0x0210, 0x00 },
    { 0x0211, 0x00 },
    { 0x0212, 0x00 },
    { 0x0213, 0x00 },
    { 0x0214, 0x00 },
    { 0x0215, 0x00 },
    { 0x0216, 0x00 },
    { 0x0217, 0x00 },
    { 0x0218, 0x00 },
    { 0x0219, 0x00 },
    { 0x021A, 0x00 },
    { 0x021B, 0x00 },
    { 0x021C, 0x00 },
    { 0x021D, 0x00 },
    { 0x021E, 0x00 },
    { 0x021F, 0x00 },
    { 0x0220, 0x00 },
    { 0x0221, 0x00 },
    { 0x0222, 0x00 },
    { 0x0223, 0x00 },
    { 0x0224, 0x00 },
    { 0x0225, 0x00 },
    { 0x0226, 0x00 },
    { 0x0227, 0x00 },
    { 0x0228, 0x00 },
    { 0x0229, 0x00 },
    { 0x022A, 0x00 },
    { 0x022B, 0x00 },
    { 0x022C, 0x00 },
    { 0x022D, 0x00 },
    { 0x022E, 0x00 },
    { 0x022F, 0x00 },
    { 0x0231, 0x0B },
    { 0x0232, 0x0B },
    { 0x0233, 0x0B },
    { 0x0234, 0x0B },
    { 0x0235, 0x00 },
    { 0x0236, 0x00 },
    { 0x0237, 0x00 },
    { 0x0238, 0xE0 },
    { 0x0239, 0xAF },
    { 0x023A, 0x01 },
    { 0x023B, 0x00 },
    { 0x023C, 0x00 },
    { 0x023D, 0x00 },
    { 0x023E, 0xE0 },
    { 0x0250, 0x00 },
    { 0x0251, 0x00 },
    { 0x0252, 0x00 },
    { 0x0253, 0x00 },
    { 0x0254, 0x00 },
    { 0x0255, 0x00 },
    { 0x026B, 0x44 },
    { 0x026C, 0x54 },
    { 0x026D, 0x41 },
    { 0x026E, 0x2D },
    { 0x026F, 0x32 },
    { 0x0270, 0x31 },
    { 0x0271, 0x32 },
    { 0x0272, 0x37 },
    { 0x028A, 0x00 },
    { 0x028B, 0x00 },
    { 0x028C, 0x00 },
    { 0x028D, 0x00 },
    { 0x028E, 0x00 },
    { 0x028F, 0x00 },
    { 0x0290, 0x00 },
    { 0x0291, 0x00 },
    { 0x0294, 0x80 },
    { 0x0296, 0x00 },
    { 0x0297, 0x00 },
    { 0x0299, 0x00 },
    { 0x029D, 0x00 },
    { 0x029E, 0x00 },
    { 0x029F, 0x00 },
    { 0x02A9, 0x00 },
    { 0x02AA, 0x00 },
    { 0x02AB, 0x00 },
    { 0x02B7, 0xFF },
    { 0x0302, 0x00 },
    { 0x0303, 0x00 },
    { 0x0304, 0x00 },
    { 0x0305, 0x17 },
    { 0x0306, 0x23 },
    { 0x0307, 0x00 },
    { 0x0308, 0x00 },
    { 0x0309, 0x00 },
    { 0x030A, 0x00 },
    { 0x030B, 0xC8 },
    { 0x030C, 0x00 },
    { 0x030D, 0x00 },
    { 0x030E, 0x00 },
    { 0x030F, 0x00 },
    { 0x0310, 0x00 },
    { 0x0311, 0x00 },
    { 0x0312, 0x00 },
    { 0x0313, 0x00 },
    { 0x0314, 0x00 },
    { 0x0315, 0x00 },
    { 0x0316, 0x00 },
    { 0x0317, 0x00 },
    { 0x0338, 0x00 },
    { 0x0339, 0x1F },
    { 0x033B, 0x01 },
    { 0x033C, 0x00 },
    { 0x033D, 0x00 },
    { 0x033E, 0x00 },
    { 0x033F, 0x00 },
    { 0x0340, 0x00 },
    { 0x0341, 0x00 },
    { 0x0342, 0x00 },
    { 0x0343, 0x00 },
    { 0x0344, 0x00 },
    { 0x0345, 0x00 },
    { 0x0346, 0x00 },
    { 0x0359, 0x00 },
    { 0x035A, 0x00 },
    { 0x035B, 0x00 },
    { 0x035C, 0x00 },
    { 0x0487, 0x00 },
    { 0x0508, 0x00 },
    { 0x0509, 0x00 },
    { 0x050A, 0x00 },
    { 0x050B, 0x00 },
    { 0x050C, 0x00 },
    { 0x050D, 0x00 },
    { 0x050E, 0x00 },
    { 0x050F, 0x00 },
    { 0x0510, 0x00 },
    { 0x0511, 0x00 },
    { 0x0512, 0x00 },
    { 0x0513, 0x00 },
    { 0x0515, 0x00 },
    { 0x0516, 0x00 },
    { 0x0517, 0x00 },
    { 0x0518, 0x00 },
    { 0x0519, 0x00 },
    { 0x051A, 0x00 },
    { 0x051B, 0x00 },
    { 0x051C, 0x00 },
    { 0x051D, 0x00 },
    { 0x051E, 0x00 },
    { 0x051F, 0x00 },
    { 0x0521, 0x2B },
    { 0x052A, 0x03 },
    { 0x052B, 0x01 },
    { 0x052C, 0x0F },
    { 0x052D, 0x03 },
    { 0x052E, 0x00 },
    { 0x052F, 0x00 },
    { 0x0531, 0x00 },
    { 0x0532, 0x00 },
    { 0x0533, 0x04 },
    { 0x0534, 0x00 },
    { 0x0535, 0x01 },
    { 0x0536, 0x04 },
    { 0x0537, 0x00 },
    { 0x0538, 0x00 },
    { 0x0539, 0x00 },
    { 0x053D, 0x0A },
    { 0x053E, 0x06 },
    { 0x0589, 0x0C },
    { 0x058A, 0x00 },
    { 0x059B, 0x18 },
    { 0x059D, 0x00 },
    { 0x059E, 0x00 },
    { 0x059F, 0x00 },
    { 0x05A0, 0x00 },
    { 0x05A1, 0x00 },
    { 0x05A2, 0x00 },
    { 0x05A6, 0x00 },
    { 0x0802, 0x35 },
    { 0x0803, 0x05 },
    { 0x0804, 0x01 },
    { 0x0805, 0x00 },
    { 0x0806, 0x00 },
    { 0x0807, 0x00 },
    { 0x0808, 0x00 },
    { 0x0809, 0x00 },
    { 0x080A, 0x00 },
    { 0x080B, 0x00 },
    { 0x080C, 0x00 },
    { 0x080D, 0x00 },
    { 0x080E, 0x00 },
    { 0x080F, 0x00 },
    { 0x0810, 0x00 },
    { 0x0811, 0x00 },
    { 0x0812, 0x00 },
    { 0x0813, 0x00 },
    { 0x0814, 0x00 },
    { 0x0815, 0x00 },
    { 0x0816, 0x00 },
    { 0x0817, 0x00 },
    { 0x0818, 0x00 },
    { 0x0819, 0x00 },
    { 0x081A, 0x00 },
    { 0x081B, 0x00 },
    { 0x081C, 0x00 },
    { 0x081D, 0x00 },
    { 0x081E, 0x00 },
    { 0x081F, 0x00 },
    { 0x0820, 0x00 },
    { 0x0821, 0x00 },
    { 0x0822, 0x00 },
    { 0x0823, 0x00 },
    { 0x0824, 0x00 },
    { 0x0825, 0x00 },
    { 0x0826, 0x00 },
    { 0x0827, 0x00 },
    { 0x0828, 0x00 },
    { 0x0829, 0x00 },
    { 0x082A, 0x00 },
    { 0x082B, 0x00 },
    { 0x082C, 0x00 },
    { 0x082D, 0x00 },
    { 0x082E, 0x00 },
    { 0x082F, 0x00 },
    { 0x0830, 0x00 },
    { 0x0831, 0x00 },
    { 0x0832, 0x00 },
    { 0x0833, 0x00 },
    { 0x0834, 0x00 },
    { 0x0835, 0x00 },
    { 0x0836, 0x00 },
    { 0x0837, 0x00 },
    { 0x0838, 0x00 },
    { 0x0839, 0x00 },
    { 0x083A, 0x00 },
    { 0x083B, 0x00 },
    { 0x083C, 0x00 },
    { 0x083D, 0x00 },
    { 0x083E, 0x00 },
    { 0x083F, 0x00 },
    { 0x0840, 0x00 },
    { 0x0841, 0x00 },
    { 0x0842, 0x00 },
    { 0x0843, 0x00 },
    { 0x0844, 0x00 },
    { 0x0845, 0x00 },
    { 0x0846, 0x00 },
    { 0x0847, 0x00 },
    { 0x0848, 0x00 },
    { 0x0849, 0x00 },
    { 0x084A, 0x00 },
    { 0x084B, 0x00 },
    { 0x084C, 0x00 },
    { 0x084D, 0x00 },
    { 0x084E, 0x00 },
    { 0x084F, 0x00 },
    { 0x0850, 0x00 },
    { 0x0851, 0x00 },
    { 0x0852, 0x00 },
    { 0x0853, 0x00 },
    { 0x0854, 0x00 },
    { 0x0855, 0x00 },
    { 0x0856, 0x00 },
    { 0x0857, 0x00 },
    { 0x0858, 0x00 },
    { 0x0859, 0x00 },
    { 0x085A, 0x00 },
    { 0x085B, 0x00 },
    { 0x085C, 0x00 },
    { 0x085D, 0x00 },
    { 0x085E, 0x00 },
    { 0x085F, 0x00 },
    { 0x0860, 0x00 },
    { 0x0861, 0x00 },
    { 0x090E, 0x03 },
    { 0x0943, 0x00 },
    { 0x0949, 0x00 },
    { 0x094A, 0x00 },
    { 0x094E, 0x49 },
    { 0x094F, 0x02 },
    { 0x095E, 0x00 },
    { 0x0A02, 0x00 },
    { 0x0A03, 0x01 },
    { 0x0A04, 0x00 },
    { 0x0A05, 0x01 },
    { 0x0A14, 0x00 },
    { 0x0A1A, 0x00 },
    { 0x0B44, 0x0F },
    { 0x0B46, 0x00 },
    { 0x0B47, 0x0F },
    { 0x0B48, 0x0F },
    { 0x0B4A, 0x02 },
    { 0x0B57, 0xE0 },
    { 0x0B58, 0x01 },
};

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ SI5392 CONFIGURATIONS +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+


// =+=+=+=+=+=+=+=+=+=+=+=+ DTA2127-Like Configuration Properties +=+=+=+=+=+=+=+=+=+=+=+=
//
static const DtDfSi534XClockProps SI5392_CONFIG_FRAC_SDI_CLOCK_PROPS_DTA2127_LIKE[1] =
{
    { 0,                                                // Clock output port index 0
      DT_DF_SI534X_CLK_FRACTIONAL,                      // Fractional clock
      (SI534X_EXP12+150709731328LL-1)/150709731328LL,   // 1e12/N0_NUM
      200*SI534X_EXP6,                                  // +/- 200ppm
      1483516484LL*SI534X_EXP5                          // Freq: 148.35MHz
    }
};
static const DtDfSi534XClockProps SI5392_CONFIG_NON_FRAC_SDI_CLOCK_PROPS_DTA2127_LIKE[1] =
{
    { 0,                                                // Clock output port index 0
      DT_DF_SI534X_CLK_NON_FRACTIONAL,                  // Non-fractional clock
      (SI534X_EXP12+62008590336LL-1)/62008590336LL,     // 1e12/N0_NUM
      200*SI534X_EXP6,                                  // +/- 200ppm
      148*SI534X_EXP12 + 500LL*SI534X_EXP9              // Freq: 148.5MHz
    }
};

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+ SI5392 Fractional SDI clock +=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//
// SI5392 fractional SDI clock configuration. 
// Used for the DTA-2127.
// 27MHz XO input, Free-run-only-mode; In1: NC; Out0: 148.35MHz.
//

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:               Si5392AB Rev A
 * Project File:       Si5392-RevA-DTA-2127-Project Fractional.slabtimeproj
 * Design ID:          DTA-2127
 * Created By:         ClockBuilder Pro v4.4 [2022-03-30]
 * Timestamp:          2022-07-08 09:36:25 GMT+02:00
 * 
 * Design Notes
 * ============
 * Converted from CBPro v3.4 Project File Si5342-RevD-DTA-2127-Project Fractional Clock.slabtimeproj.
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - No warnings
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.3516483516483516... MHz
 * Frequency Synthesis Mode: Fractional
 * Frequency Plan Grade:     B
 * Minimum Base OPN:         Si5392B*
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5392A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5392B*   100 Hz to 350 MHz    "
 * Si5392C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5392D    100 Hz to 350 MHz    "
 * 
 * * Based on your calculated frequency plan, a Si5392B grade device is
 * sufficient for your design. For more in-system configuration flexibility
 * (higher frequencies and/or to enable fractional synthesis), consider
 * selecting device grade Si5392A when specifying an ordering part number (OPN)
 * for your application. See the datasheet Ordering Guide for more information.
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 104d to 107d / 0x68 to 0x6B (selected via A0/A1 pins)
 * 
 * External Reference:
 *    27 MHz (XO - Oscillator)
 * 
 * Inputs:
 *     IN0: Unused
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 148.3516483516483516... MHz [ 148 + 32/91 MHz ] (Free Run)
 *          [ 148.5MHz/1.001 ]
 *          Enabled, LVDS 1.8 V
 *    OUT1: Unused
 * 
 * Frequency Plan
 * ==============
 * Fvco = 13.3264285714285714... GHz [ 13 + 457/1400 GHz ]
 * Fpfd = N/A (DSPLL free run only mode enabled)
 * Fms0 = 296.7032967032967032... MHz [ 296 + 64/91 MHz ]
 * 
 * P dividers:
 *    P0  = Unused
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 493.5714285714285714... [ 493 + 4/7 ]
 * M = N/A (DSPLL free run only mode enabled)
 * N dividers:
 *    N0:
 *       Value: 44.915
 *       OUT0: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N1:
 *       Unused
 * 
 * R dividers:
 *    R0 = 2
 *    R1 = Unused
 * 
 * Nominal Bandwidth:
 *   N/A (DSPLL free run only mode enabled)
 * Fastlock Bandwidth:
 *   N/A (DSPLL free run only mode enabled)
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Hitless Input Switching Assistant
 * =================================
 * Assistant N/A
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 *        Fvco * Nx_DEN
 * Fout = -------------
 *         Nx_NUM * Rz 
 * 
 * N0: DCO Enabled
 * 
 *    Fvco:               13.3264285714285714... GHz [ 13 + 457/1400 GHz ]
 *    N0_NUM:             150709731328
 *    N0_DEN:             3355443200
 *    Step Word:          1
 * 
 *    Desired Step Size:  1 ppt
 *    Actual Step Size:   6.635271599219... ppt
 *    Range:              200 ppm
 * 
 *    OUT0
 *         R0:            2
 *         Initial Freq:  148.351648351648... MHz
 *         Step Size:     0.000984353479... Hz
 *         Min Freq:      148.321989885445... MHz
 *         Max Freq:      148.381318681238... MHz
 * 
 * N1: DCO Disabled
 * 
 * Input/Output Skew Control
 * =========================
 * N0: 44.915
 * 
 *    OUT0  148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 * 
 *    Desired Dynamic Skew Step:  0.000 ps
 *    Actual Dynamic Skew Step:   0 ps
 *    N0_PHASE_STEP:                 0x0 0d
 *    N0_PHASE_COUNT:                0x0 0d
 * 
 *    Use N0_PHASE_INC and N0_PHASE_DEC to perform phase step.
 * 
 * N1 Not Used
 */

// Register settings
static const DtDfSi534XRegister SI5392_CONFIG_FRAC_SDI_CLOCK_DTA2127_LIKE[] =
{
    { 0x0006, 0x00 },
    { 0x0007, 0x00 },
    { 0x0008, 0x00 },
    { 0x000B, 0x68 },
    { 0x0016, 0x02 },
    { 0x0017, 0xDC },
    { 0x0018, 0xFF },
    { 0x0019, 0xFF },
    { 0x001A, 0xFF },
    { 0x002B, 0x02 },
    { 0x002C, 0x00 },
    { 0x002D, 0x00 },
    { 0x002E, 0x00 },
    { 0x002F, 0x00 },
    { 0x0030, 0x00 },
    { 0x0031, 0x00 },
    { 0x0032, 0x00 },
    { 0x0033, 0x00 },
    { 0x0034, 0x00 },
    { 0x0035, 0x00 },
    { 0x0036, 0x00 },
    { 0x0037, 0x00 },
    { 0x0038, 0x00 },
    { 0x0039, 0x00 },
    { 0x003A, 0x00 },
    { 0x003B, 0x00 },
    { 0x003C, 0x00 },
    { 0x003D, 0x00 },
    { 0x003E, 0x00 },
    { 0x003F, 0x00 },
    { 0x0040, 0x04 },
    { 0x0041, 0x00 },
    { 0x0042, 0x00 },
    { 0x0043, 0x00 },
    { 0x0044, 0x00 },
    { 0x0045, 0x0B },
    { 0x0046, 0x00 },
    { 0x0047, 0x00 },
    { 0x0048, 0x00 },
    { 0x0049, 0x00 },
    { 0x004A, 0x00 },
    { 0x004B, 0x00 },
    { 0x004C, 0x00 },
    { 0x004D, 0x00 },
    { 0x004E, 0x00 },
    { 0x004F, 0x00 },
    { 0x0050, 0x0F },
    { 0x0051, 0x00 },
    { 0x0052, 0x00 },
    { 0x0053, 0x00 },
    { 0x0054, 0x00 },
    { 0x0055, 0x00 },
    { 0x0056, 0x00 },
    { 0x0057, 0x00 },
    { 0x0058, 0x00 },
    { 0x0059, 0x00 },
    { 0x005A, 0x00 },
    { 0x005B, 0x00 },
    { 0x005C, 0x00 },
    { 0x005D, 0x00 },
    { 0x005E, 0x00 },
    { 0x005F, 0x00 },
    { 0x0060, 0x00 },
    { 0x0061, 0x00 },
    { 0x0062, 0x00 },
    { 0x0063, 0x00 },
    { 0x0064, 0x00 },
    { 0x0065, 0x00 },
    { 0x0066, 0x00 },
    { 0x0067, 0x00 },
    { 0x0068, 0x00 },
    { 0x0069, 0x00 },
    { 0x0092, 0x00 },
    { 0x0093, 0x00 },
    { 0x0095, 0x00 },
    { 0x0096, 0x00 },
    { 0x0098, 0x00 },
    { 0x009A, 0x00 },
    { 0x009B, 0x00 },
    { 0x009D, 0x00 },
    { 0x009E, 0x00 },
    { 0x00A0, 0x00 },
    { 0x00A2, 0x00 },
    { 0x00A9, 0x00 },
    { 0x00AA, 0x00 },
    { 0x00AB, 0x00 },
    { 0x00AC, 0x00 },
    { 0x00E5, 0x01 },
    { 0x00EA, 0x00 },
    { 0x00EB, 0x00 },
    { 0x00EC, 0x00 },
    { 0x00ED, 0x00 },
    { 0x0102, 0x01 },
    { 0x0112, 0x06 },
    { 0x0113, 0x09 },
    { 0x0114, 0x3E },
    { 0x0115, 0x18 },
    { 0x0117, 0x01 },
    { 0x0118, 0x09 },
    { 0x0119, 0x3B },
    { 0x011A, 0x28 },
    { 0x013F, 0x00 },
    { 0x0140, 0x00 },
    { 0x0141, 0x40 },
    { 0x0142, 0xFF },
    { 0x0206, 0x00 },
    { 0x0208, 0x00 },
    { 0x0209, 0x00 },
    { 0x020A, 0x00 },
    { 0x020B, 0x00 },
    { 0x020C, 0x00 },
    { 0x020D, 0x00 },
    { 0x020E, 0x00 },
    { 0x020F, 0x00 },
    { 0x0210, 0x00 },
    { 0x0211, 0x00 },
    { 0x0212, 0x00 },
    { 0x0213, 0x00 },
    { 0x0214, 0x00 },
    { 0x0215, 0x00 },
    { 0x0216, 0x00 },
    { 0x0217, 0x00 },
    { 0x0218, 0x00 },
    { 0x0219, 0x00 },
    { 0x021A, 0x00 },
    { 0x021B, 0x00 },
    { 0x021C, 0x00 },
    { 0x021D, 0x00 },
    { 0x021E, 0x00 },
    { 0x021F, 0x00 },
    { 0x0220, 0x00 },
    { 0x0221, 0x00 },
    { 0x0222, 0x00 },
    { 0x0223, 0x00 },
    { 0x0224, 0x00 },
    { 0x0225, 0x00 },
    { 0x0226, 0x00 },
    { 0x0227, 0x00 },
    { 0x0228, 0x00 },
    { 0x0229, 0x00 },
    { 0x022A, 0x00 },
    { 0x022B, 0x00 },
    { 0x022C, 0x00 },
    { 0x022D, 0x00 },
    { 0x022E, 0x00 },
    { 0x022F, 0x00 },
    { 0x0231, 0x0B },
    { 0x0232, 0x0B },
    { 0x0233, 0x0B },
    { 0x0234, 0x0B },
    { 0x0235, 0x00 },
    { 0x0236, 0x00 },
    { 0x0237, 0x00 },
    { 0x0238, 0xE0 },
    { 0x0239, 0xAF },
    { 0x023A, 0x01 },
    { 0x023B, 0x00 },
    { 0x023C, 0x00 },
    { 0x023D, 0x00 },
    { 0x023E, 0xE0 },
    { 0x0250, 0x00 },
    { 0x0251, 0x00 },
    { 0x0252, 0x00 },
    { 0x0253, 0x00 },
    { 0x0254, 0x00 },
    { 0x0255, 0x00 },
    { 0x026B, 0x44 },
    { 0x026C, 0x54 },
    { 0x026D, 0x41 },
    { 0x026E, 0x2D },
    { 0x026F, 0x32 },
    { 0x0270, 0x31 },
    { 0x0271, 0x32 },
    { 0x0272, 0x37 },
    { 0x028A, 0x00 },
    { 0x028B, 0x00 },
    { 0x028C, 0x00 },
    { 0x028D, 0x00 },
    { 0x028E, 0x00 },
    { 0x028F, 0x00 },
    { 0x0290, 0x00 },
    { 0x0291, 0x00 },
    { 0x0292, 0x3F },
    { 0x0293, 0x2F },
    { 0x0294, 0x80 },
    { 0x0296, 0x00 },
    { 0x0297, 0x00 },
    { 0x0299, 0x00 },
    { 0x029D, 0x00 },
    { 0x029E, 0x00 },
    { 0x029F, 0x00 },
    { 0x02A9, 0x00 },
    { 0x02AA, 0x00 },
    { 0x02AB, 0x00 },
    { 0x02B7, 0xFF },
    { 0x02BC, 0x00 },
    { 0x0302, 0x00 },
    { 0x0303, 0x00 },
    { 0x0304, 0x00 },
    { 0x0305, 0x17 },
    { 0x0306, 0x23 },
    { 0x0307, 0x00 },
    { 0x0308, 0x00 },
    { 0x0309, 0x00 },
    { 0x030A, 0x00 },
    { 0x030B, 0xC8 },
    { 0x030C, 0x00 },
    { 0x030D, 0x00 },
    { 0x030E, 0x00 },
    { 0x030F, 0x00 },
    { 0x0310, 0x00 },
    { 0x0311, 0x00 },
    { 0x0312, 0x00 },
    { 0x0313, 0x00 },
    { 0x0314, 0x00 },
    { 0x0315, 0x00 },
    { 0x0316, 0x00 },
    { 0x0317, 0x00 },
    { 0x0338, 0x00 },
    { 0x0339, 0x1F },
    { 0x033B, 0x01 },
    { 0x033C, 0x00 },
    { 0x033D, 0x00 },
    { 0x033E, 0x00 },
    { 0x033F, 0x00 },
    { 0x0340, 0x00 },
    { 0x0341, 0x00 },
    { 0x0342, 0x00 },
    { 0x0343, 0x00 },
    { 0x0344, 0x00 },
    { 0x0345, 0x00 },
    { 0x0346, 0x00 },
    { 0x0359, 0x00 },
    { 0x035A, 0x00 },
    { 0x035B, 0x00 },
    { 0x035C, 0x00 },
    { 0x0487, 0x00 },
    { 0x0508, 0x00 },
    { 0x0509, 0x00 },
    { 0x050A, 0x00 },
    { 0x050B, 0x00 },
    { 0x050C, 0x00 },
    { 0x050D, 0x00 },
    { 0x050E, 0x00 },
    { 0x050F, 0x00 },
    { 0x0510, 0x00 },
    { 0x0511, 0x00 },
    { 0x0512, 0x00 },
    { 0x0513, 0x00 },
    { 0x0515, 0x00 },
    { 0x0516, 0x00 },
    { 0x0517, 0x00 },
    { 0x0518, 0x00 },
    { 0x0519, 0x00 },
    { 0x051A, 0x00 },
    { 0x051B, 0x00 },
    { 0x051C, 0x00 },
    { 0x051D, 0x00 },
    { 0x051E, 0x00 },
    { 0x051F, 0x00 },
    { 0x0521, 0x2B },
    { 0x052A, 0x03 },
    { 0x052B, 0x01 },
    { 0x052C, 0x0F },
    { 0x052D, 0x03 },
    { 0x052E, 0x00 },
    { 0x052F, 0x00 },
    { 0x0531, 0x00 },
    { 0x0532, 0x00 },
    { 0x0533, 0x04 },
    { 0x0534, 0x00 },
    { 0x0535, 0x01 },
    { 0x0536, 0x04 },
    { 0x0537, 0x00 },
    { 0x0538, 0x00 },
    { 0x0539, 0x00 },
    { 0x053D, 0x0A },
    { 0x053E, 0x06 },
    { 0x0588, 0x00 },
    { 0x0589, 0x0C },
    { 0x058A, 0x00 },
    { 0x058B, 0x00 },
    { 0x058C, 0x00 },
    { 0x058D, 0x00 },
    { 0x059B, 0x18 },
    { 0x059C, 0x0C },
    { 0x059D, 0x00 },
    { 0x059E, 0x00 },
    { 0x059F, 0x00 },
    { 0x05A0, 0x00 },
    { 0x05A1, 0x00 },
    { 0x05A2, 0x00 },
    { 0x05A4, 0x20 },
    { 0x05A5, 0x00 },
    { 0x05A6, 0x00 },
    { 0x05AC, 0x00 },
    { 0x05AD, 0x00 },
    { 0x05AE, 0x00 },
    { 0x05B1, 0x00 },
    { 0x05B2, 0x00 },
    { 0x0802, 0x35 },
    { 0x0803, 0x05 },
    { 0x0804, 0x01 },
    { 0x0805, 0x00 },
    { 0x0806, 0x00 },
    { 0x0807, 0x00 },
    { 0x0808, 0x00 },
    { 0x0809, 0x00 },
    { 0x080A, 0x00 },
    { 0x080B, 0x00 },
    { 0x080C, 0x00 },
    { 0x080D, 0x00 },
    { 0x080E, 0x00 },
    { 0x080F, 0x00 },
    { 0x0810, 0x00 },
    { 0x0811, 0x00 },
    { 0x0812, 0x00 },
    { 0x0813, 0x00 },
    { 0x0814, 0x00 },
    { 0x0815, 0x00 },
    { 0x0816, 0x00 },
    { 0x0817, 0x00 },
    { 0x0818, 0x00 },
    { 0x0819, 0x00 },
    { 0x081A, 0x00 },
    { 0x081B, 0x00 },
    { 0x081C, 0x00 },
    { 0x081D, 0x00 },
    { 0x081E, 0x00 },
    { 0x081F, 0x00 },
    { 0x0820, 0x00 },
    { 0x0821, 0x00 },
    { 0x0822, 0x00 },
    { 0x0823, 0x00 },
    { 0x0824, 0x00 },
    { 0x0825, 0x00 },
    { 0x0826, 0x00 },
    { 0x0827, 0x00 },
    { 0x0828, 0x00 },
    { 0x0829, 0x00 },
    { 0x082A, 0x00 },
    { 0x082B, 0x00 },
    { 0x082C, 0x00 },
    { 0x082D, 0x00 },
    { 0x082E, 0x00 },
    { 0x082F, 0x00 },
    { 0x0830, 0x00 },
    { 0x0831, 0x00 },
    { 0x0832, 0x00 },
    { 0x0833, 0x00 },
    { 0x0834, 0x00 },
    { 0x0835, 0x00 },
    { 0x0836, 0x00 },
    { 0x0837, 0x00 },
    { 0x0838, 0x00 },
    { 0x0839, 0x00 },
    { 0x083A, 0x00 },
    { 0x083B, 0x00 },
    { 0x083C, 0x00 },
    { 0x083D, 0x00 },
    { 0x083E, 0x00 },
    { 0x083F, 0x00 },
    { 0x0840, 0x00 },
    { 0x0841, 0x00 },
    { 0x0842, 0x00 },
    { 0x0843, 0x00 },
    { 0x0844, 0x00 },
    { 0x0845, 0x00 },
    { 0x0846, 0x00 },
    { 0x0847, 0x00 },
    { 0x0848, 0x00 },
    { 0x0849, 0x00 },
    { 0x084A, 0x00 },
    { 0x084B, 0x00 },
    { 0x084C, 0x00 },
    { 0x084D, 0x00 },
    { 0x084E, 0x00 },
    { 0x084F, 0x00 },
    { 0x0850, 0x00 },
    { 0x0851, 0x00 },
    { 0x0852, 0x00 },
    { 0x0853, 0x00 },
    { 0x0854, 0x00 },
    { 0x0855, 0x00 },
    { 0x0856, 0x00 },
    { 0x0857, 0x00 },
    { 0x0858, 0x00 },
    { 0x0859, 0x00 },
    { 0x085A, 0x00 },
    { 0x085B, 0x00 },
    { 0x085C, 0x00 },
    { 0x085D, 0x00 },
    { 0x085E, 0x00 },
    { 0x085F, 0x00 },
    { 0x0860, 0x00 },
    { 0x0861, 0x00 },
    { 0x090E, 0x03 },
    { 0x0943, 0x00 },
    { 0x0949, 0x00 },
    { 0x094A, 0x00 },
    { 0x094E, 0x49 },
    { 0x094F, 0xF2 },
    { 0x095E, 0x00 },
    { 0x0A02, 0x00 },
    { 0x0A03, 0x01 },
    { 0x0A04, 0x00 },
    { 0x0A05, 0x01 },
    { 0x0A14, 0x00 },
    { 0x0A1A, 0x00 },
    { 0x0A38, 0x00 },
    { 0x0A39, 0x00 },
    { 0x0A3A, 0x00 },
    { 0x0A3C, 0x00 },
    { 0x0A3D, 0x00 },
    { 0x0A3E, 0x00 },
    { 0x0A4C, 0x00 },
    { 0x0A4D, 0x00 },
    { 0x0A4E, 0x00 },
    { 0x0A4F, 0x00 },
    { 0x0A50, 0x00 },
    { 0x0A51, 0x00 },
    { 0x0A52, 0x00 },
    { 0x0A53, 0x00 },
    { 0x0B44, 0x0F },
    { 0x0B46, 0x00 },
    { 0x0B47, 0x0F },
    { 0x0B48, 0x0F },
    { 0x0B4A, 0x02 },
    { 0x0B57, 0xE0 },
    { 0x0B58, 0x01 },
    { 0x0C02, 0x03 },
    { 0x0C03, 0x00 },
    { 0x0C07, 0x00 },
    { 0x0C08, 0x00 },
};



// +=+=+=+=+=+=+=+=+=+=+=+=+=+ SI5392 Non-Fractional SDI clock +=+=+=+=+=+=+=+=+=+=+=+=+=+
//
// SI5392 non-fractional SDI clock configuration. 
// Used for the DTA-2127.
// 27MHz XO input, Free-run-only-mode; In1: NC; Out0: 148.5MHz.
//
/*
 * Design Report
 *
 * Overview
 * ========
 * Part:               Si5392AB Rev A
 * Project File:       Si5392-RevA-DTA-2127-Project Non-fractional.slabtimeproj
 * Design ID:          DTA-2127
 * Created By:         ClockBuilder Pro v4.4 [2022-03-30]
 * Timestamp:          2022-07-08 09:36:56 GMT+02:00
 * 
 * Design Notes
 * ============
 * Converted from CBPro v3.4 Project File Si5342-RevD-DTA-2127-Project Non-fractional Clock.slabtimeproj.
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - No warnings
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Frequency Plan Grade:     B
 * Minimum Base OPN:         Si5392B*
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5392A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5392B*   100 Hz to 350 MHz    "
 * Si5392C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5392D    100 Hz to 350 MHz    "
 * 
 * * Based on your calculated frequency plan, a Si5392B grade device is
 * sufficient for your design. For more in-system configuration flexibility
 * (higher frequencies and/or to enable fractional synthesis), consider
 * selecting device grade Si5392A when specifying an ordering part number (OPN)
 * for your application. See the datasheet Ordering Guide for more information.
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 104d to 107d / 0x68 to 0x6B (selected via A0/A1 pins)
 * 
 * External Reference:
 *    27 MHz (XO - Oscillator)
 * 
 * Inputs:
 *     IN0: Unused
 *     IN1: Unused
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 148.5 MHz (Free Run)
 *          Enabled, LVDS 1.8 V
 *    OUT1: Unused
 * 
 * Frequency Plan
 * ==============
 * Fvco = 13.7214 GHz
 * Fpfd = N/A (DSPLL free run only mode enabled)
 * Fms0 = 594 MHz
 * 
 * P dividers:
 *    P0  = Unused
 *    P1  = Unused
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 508.2
 * M = N/A (DSPLL free run only mode enabled)
 * N dividers:
 *    N0:
 *       Value: 23.1
 *       OUT0: 148.5 MHz
 *    N1:
 *       Unused
 * 
 * R dividers:
 *    R0 = 4
 *    R1 = Unused
 * 
 * Nominal Bandwidth:
 *   N/A (DSPLL free run only mode enabled)
 * Fastlock Bandwidth:
 *   N/A (DSPLL free run only mode enabled)
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Hitless Input Switching Assistant
 * =================================
 * Assistant N/A
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 *        Fvco * Nx_DEN
 * Fout = -------------
 *         Nx_NUM * Rz 
 * 
 * N0: DCO Enabled
 * 
 *    Fvco:               13.7214 GHz
 *    N0_NUM:             62008590336
 *    N0_DEN:             2684354560
 *    Step Word:          1
 * 
 *    Desired Step Size:  1 ppt
 *    Actual Step Size:   16.126797829099... ppt
 *    Range:              200 ppm
 * 
 *    OUT0
 *         R0:            4
 *         Initial Freq:  148.5 MHz
 *         Step Size:     0.002394829477... Hz
 *         Min Freq:      148.470311875775... MHz
 *         Max Freq:      148.529699999473... MHz
 * 
 * N1: DCO Disabled
 * 
 * Input/Output Skew Control
 * =========================
 * N0: 23.1
 * 
 *    OUT0  148.5 MHz
 * 
 *    Desired Dynamic Skew Step:  0.000 ps
 *    Actual Dynamic Skew Step:   0 ps
 *    N0_PHASE_STEP:                 0x0 0d
 *    N0_PHASE_COUNT:                0x0 0d
 * 
 *    Use N0_PHASE_INC and N0_PHASE_DEC to perform phase step.
 * 
 * N1 Not Used
 */


// Register settings
static const DtDfSi534XRegister SI5392_CONFIG_NON_FRAC_SDI_CLOCK_DTA2127_LIKE[] =
{
    { 0x0006, 0x00 },
    { 0x0007, 0x00 },
    { 0x0008, 0x00 },
    { 0x000B, 0x68 },
    { 0x0016, 0x02 },
    { 0x0017, 0xDC },
    { 0x0018, 0xFF },
    { 0x0019, 0xFF },
    { 0x001A, 0xFF },
    { 0x002B, 0x02 },
    { 0x002C, 0x00 },
    { 0x002D, 0x00 },
    { 0x002E, 0x00 },
    { 0x002F, 0x00 },
    { 0x0030, 0x00 },
    { 0x0031, 0x00 },
    { 0x0032, 0x00 },
    { 0x0033, 0x00 },
    { 0x0034, 0x00 },
    { 0x0035, 0x00 },
    { 0x0036, 0x00 },
    { 0x0037, 0x00 },
    { 0x0038, 0x00 },
    { 0x0039, 0x00 },
    { 0x003A, 0x00 },
    { 0x003B, 0x00 },
    { 0x003C, 0x00 },
    { 0x003D, 0x00 },
    { 0x003E, 0x00 },
    { 0x003F, 0x00 },
    { 0x0040, 0x04 },
    { 0x0041, 0x00 },
    { 0x0042, 0x00 },
    { 0x0043, 0x00 },
    { 0x0044, 0x00 },
    { 0x0045, 0x0B },
    { 0x0046, 0x00 },
    { 0x0047, 0x00 },
    { 0x0048, 0x00 },
    { 0x0049, 0x00 },
    { 0x004A, 0x00 },
    { 0x004B, 0x00 },
    { 0x004C, 0x00 },
    { 0x004D, 0x00 },
    { 0x004E, 0x00 },
    { 0x004F, 0x00 },
    { 0x0050, 0x0F },
    { 0x0051, 0x00 },
    { 0x0052, 0x00 },
    { 0x0053, 0x00 },
    { 0x0054, 0x00 },
    { 0x0055, 0x00 },
    { 0x0056, 0x00 },
    { 0x0057, 0x00 },
    { 0x0058, 0x00 },
    { 0x0059, 0x00 },
    { 0x005A, 0x00 },
    { 0x005B, 0x00 },
    { 0x005C, 0x00 },
    { 0x005D, 0x00 },
    { 0x005E, 0x00 },
    { 0x005F, 0x00 },
    { 0x0060, 0x00 },
    { 0x0061, 0x00 },
    { 0x0062, 0x00 },
    { 0x0063, 0x00 },
    { 0x0064, 0x00 },
    { 0x0065, 0x00 },
    { 0x0066, 0x00 },
    { 0x0067, 0x00 },
    { 0x0068, 0x00 },
    { 0x0069, 0x00 },
    { 0x0092, 0x00 },
    { 0x0093, 0x00 },
    { 0x0095, 0x00 },
    { 0x0096, 0x00 },
    { 0x0098, 0x00 },
    { 0x009A, 0x00 },
    { 0x009B, 0x00 },
    { 0x009D, 0x00 },
    { 0x009E, 0x00 },
    { 0x00A0, 0x00 },
    { 0x00A2, 0x00 },
    { 0x00A9, 0x00 },
    { 0x00AA, 0x00 },
    { 0x00AB, 0x00 },
    { 0x00AC, 0x00 },
    { 0x00E5, 0x01 },
    { 0x00EA, 0x00 },
    { 0x00EB, 0x00 },
    { 0x00EC, 0x00 },
    { 0x00ED, 0x00 },
    { 0x0102, 0x01 },
    { 0x0112, 0x02 },
    { 0x0113, 0x09 },
    { 0x0114, 0x3E },
    { 0x0115, 0x18 },
    { 0x0117, 0x01 },
    { 0x0118, 0x09 },
    { 0x0119, 0x3B },
    { 0x011A, 0x28 },
    { 0x013F, 0x00 },
    { 0x0140, 0x00 },
    { 0x0141, 0x40 },
    { 0x0142, 0xFF },
    { 0x0206, 0x00 },
    { 0x0208, 0x00 },
    { 0x0209, 0x00 },
    { 0x020A, 0x00 },
    { 0x020B, 0x00 },
    { 0x020C, 0x00 },
    { 0x020D, 0x00 },
    { 0x020E, 0x00 },
    { 0x020F, 0x00 },
    { 0x0210, 0x00 },
    { 0x0211, 0x00 },
    { 0x0212, 0x00 },
    { 0x0213, 0x00 },
    { 0x0214, 0x00 },
    { 0x0215, 0x00 },
    { 0x0216, 0x00 },
    { 0x0217, 0x00 },
    { 0x0218, 0x00 },
    { 0x0219, 0x00 },
    { 0x021A, 0x00 },
    { 0x021B, 0x00 },
    { 0x021C, 0x00 },
    { 0x021D, 0x00 },
    { 0x021E, 0x00 },
    { 0x021F, 0x00 },
    { 0x0220, 0x00 },
    { 0x0221, 0x00 },
    { 0x0222, 0x00 },
    { 0x0223, 0x00 },
    { 0x0224, 0x00 },
    { 0x0225, 0x00 },
    { 0x0226, 0x00 },
    { 0x0227, 0x00 },
    { 0x0228, 0x00 },
    { 0x0229, 0x00 },
    { 0x022A, 0x00 },
    { 0x022B, 0x00 },
    { 0x022C, 0x00 },
    { 0x022D, 0x00 },
    { 0x022E, 0x00 },
    { 0x022F, 0x00 },
    { 0x0231, 0x0B },
    { 0x0232, 0x0B },
    { 0x0233, 0x0B },
    { 0x0234, 0x0B },
    { 0x0235, 0x00 },
    { 0x0236, 0x00 },
    { 0x0237, 0x00 },
    { 0x0238, 0xA0 },
    { 0x0239, 0x3D },
    { 0x023A, 0x01 },
    { 0x023B, 0x00 },
    { 0x023C, 0x00 },
    { 0x023D, 0x00 },
    { 0x023E, 0xA0 },
    { 0x0250, 0x01 },
    { 0x0251, 0x00 },
    { 0x0252, 0x00 },
    { 0x0253, 0x00 },
    { 0x0254, 0x00 },
    { 0x0255, 0x00 },
    { 0x026B, 0x44 },
    { 0x026C, 0x54 },
    { 0x026D, 0x41 },
    { 0x026E, 0x2D },
    { 0x026F, 0x32 },
    { 0x0270, 0x31 },
    { 0x0271, 0x32 },
    { 0x0272, 0x37 },
    { 0x028A, 0x00 },
    { 0x028B, 0x00 },
    { 0x028C, 0x00 },
    { 0x028D, 0x00 },
    { 0x028E, 0x00 },
    { 0x028F, 0x00 },
    { 0x0290, 0x00 },
    { 0x0291, 0x00 },
    { 0x0292, 0x3F },
    { 0x0293, 0x2F },
    { 0x0294, 0x80 },
    { 0x0296, 0x00 },
    { 0x0297, 0x00 },
    { 0x0299, 0x00 },
    { 0x029D, 0x00 },
    { 0x029E, 0x00 },
    { 0x029F, 0x00 },
    { 0x02A9, 0x00 },
    { 0x02AA, 0x00 },
    { 0x02AB, 0x00 },
    { 0x02B7, 0xFF },
    { 0x02BC, 0x00 },
    { 0x0302, 0x00 },
    { 0x0303, 0x00 },
    { 0x0304, 0x00 },
    { 0x0305, 0x70 },
    { 0x0306, 0x0E },
    { 0x0307, 0x00 },
    { 0x0308, 0x00 },
    { 0x0309, 0x00 },
    { 0x030A, 0x00 },
    { 0x030B, 0xA0 },
    { 0x030C, 0x00 },
    { 0x030D, 0x00 },
    { 0x030E, 0x00 },
    { 0x030F, 0x00 },
    { 0x0310, 0x00 },
    { 0x0311, 0x00 },
    { 0x0312, 0x00 },
    { 0x0313, 0x00 },
    { 0x0314, 0x00 },
    { 0x0315, 0x00 },
    { 0x0316, 0x00 },
    { 0x0317, 0x00 },
    { 0x0338, 0x00 },
    { 0x0339, 0x1F },
    { 0x033B, 0x01 },
    { 0x033C, 0x00 },
    { 0x033D, 0x00 },
    { 0x033E, 0x00 },
    { 0x033F, 0x00 },
    { 0x0340, 0x00 },
    { 0x0341, 0x00 },
    { 0x0342, 0x00 },
    { 0x0343, 0x00 },
    { 0x0344, 0x00 },
    { 0x0345, 0x00 },
    { 0x0346, 0x00 },
    { 0x0359, 0x00 },
    { 0x035A, 0x00 },
    { 0x035B, 0x00 },
    { 0x035C, 0x00 },
    { 0x0487, 0x00 },
    { 0x0508, 0x00 },
    { 0x0509, 0x00 },
    { 0x050A, 0x00 },
    { 0x050B, 0x00 },
    { 0x050C, 0x00 },
    { 0x050D, 0x00 },
    { 0x050E, 0x00 },
    { 0x050F, 0x00 },
    { 0x0510, 0x00 },
    { 0x0511, 0x00 },
    { 0x0512, 0x00 },
    { 0x0513, 0x00 },
    { 0x0515, 0x00 },
    { 0x0516, 0x00 },
    { 0x0517, 0x00 },
    { 0x0518, 0x00 },
    { 0x0519, 0x00 },
    { 0x051A, 0x00 },
    { 0x051B, 0x00 },
    { 0x051C, 0x00 },
    { 0x051D, 0x00 },
    { 0x051E, 0x00 },
    { 0x051F, 0x00 },
    { 0x0521, 0x2B },
    { 0x052A, 0x03 },
    { 0x052B, 0x01 },
    { 0x052C, 0x0F },
    { 0x052D, 0x03 },
    { 0x052E, 0x00 },
    { 0x052F, 0x00 },
    { 0x0531, 0x00 },
    { 0x0532, 0x00 },
    { 0x0533, 0x04 },
    { 0x0534, 0x00 },
    { 0x0535, 0x01 },
    { 0x0536, 0x04 },
    { 0x0537, 0x00 },
    { 0x0538, 0x00 },
    { 0x0539, 0x00 },
    { 0x053D, 0x0A },
    { 0x053E, 0x06 },
    { 0x0588, 0x00 },
    { 0x0589, 0x0C },
    { 0x058A, 0x00 },
    { 0x058B, 0x00 },
    { 0x058C, 0x00 },
    { 0x058D, 0x00 },
    { 0x059B, 0x18 },
    { 0x059C, 0x0C },
    { 0x059D, 0x00 },
    { 0x059E, 0x00 },
    { 0x059F, 0x00 },
    { 0x05A0, 0x00 },
    { 0x05A1, 0x00 },
    { 0x05A2, 0x00 },
    { 0x05A4, 0x20 },
    { 0x05A5, 0x00 },
    { 0x05A6, 0x00 },
    { 0x05AC, 0x00 },
    { 0x05AD, 0x00 },
    { 0x05AE, 0x00 },
    { 0x05B1, 0x00 },
    { 0x05B2, 0x00 },
    { 0x0802, 0x35 },
    { 0x0803, 0x05 },
    { 0x0804, 0x01 },
    { 0x0805, 0x00 },
    { 0x0806, 0x00 },
    { 0x0807, 0x00 },
    { 0x0808, 0x00 },
    { 0x0809, 0x00 },
    { 0x080A, 0x00 },
    { 0x080B, 0x00 },
    { 0x080C, 0x00 },
    { 0x080D, 0x00 },
    { 0x080E, 0x00 },
    { 0x080F, 0x00 },
    { 0x0810, 0x00 },
    { 0x0811, 0x00 },
    { 0x0812, 0x00 },
    { 0x0813, 0x00 },
    { 0x0814, 0x00 },
    { 0x0815, 0x00 },
    { 0x0816, 0x00 },
    { 0x0817, 0x00 },
    { 0x0818, 0x00 },
    { 0x0819, 0x00 },
    { 0x081A, 0x00 },
    { 0x081B, 0x00 },
    { 0x081C, 0x00 },
    { 0x081D, 0x00 },
    { 0x081E, 0x00 },
    { 0x081F, 0x00 },
    { 0x0820, 0x00 },
    { 0x0821, 0x00 },
    { 0x0822, 0x00 },
    { 0x0823, 0x00 },
    { 0x0824, 0x00 },
    { 0x0825, 0x00 },
    { 0x0826, 0x00 },
    { 0x0827, 0x00 },
    { 0x0828, 0x00 },
    { 0x0829, 0x00 },
    { 0x082A, 0x00 },
    { 0x082B, 0x00 },
    { 0x082C, 0x00 },
    { 0x082D, 0x00 },
    { 0x082E, 0x00 },
    { 0x082F, 0x00 },
    { 0x0830, 0x00 },
    { 0x0831, 0x00 },
    { 0x0832, 0x00 },
    { 0x0833, 0x00 },
    { 0x0834, 0x00 },
    { 0x0835, 0x00 },
    { 0x0836, 0x00 },
    { 0x0837, 0x00 },
    { 0x0838, 0x00 },
    { 0x0839, 0x00 },
    { 0x083A, 0x00 },
    { 0x083B, 0x00 },
    { 0x083C, 0x00 },
    { 0x083D, 0x00 },
    { 0x083E, 0x00 },
    { 0x083F, 0x00 },
    { 0x0840, 0x00 },
    { 0x0841, 0x00 },
    { 0x0842, 0x00 },
    { 0x0843, 0x00 },
    { 0x0844, 0x00 },
    { 0x0845, 0x00 },
    { 0x0846, 0x00 },
    { 0x0847, 0x00 },
    { 0x0848, 0x00 },
    { 0x0849, 0x00 },
    { 0x084A, 0x00 },
    { 0x084B, 0x00 },
    { 0x084C, 0x00 },
    { 0x084D, 0x00 },
    { 0x084E, 0x00 },
    { 0x084F, 0x00 },
    { 0x0850, 0x00 },
    { 0x0851, 0x00 },
    { 0x0852, 0x00 },
    { 0x0853, 0x00 },
    { 0x0854, 0x00 },
    { 0x0855, 0x00 },
    { 0x0856, 0x00 },
    { 0x0857, 0x00 },
    { 0x0858, 0x00 },
    { 0x0859, 0x00 },
    { 0x085A, 0x00 },
    { 0x085B, 0x00 },
    { 0x085C, 0x00 },
    { 0x085D, 0x00 },
    { 0x085E, 0x00 },
    { 0x085F, 0x00 },
    { 0x0860, 0x00 },
    { 0x0861, 0x00 },
    { 0x090E, 0x03 },
    { 0x0943, 0x00 },
    { 0x0949, 0x00 },
    { 0x094A, 0x00 },
    { 0x094E, 0x49 },
    { 0x094F, 0xF2 },
    { 0x095E, 0x00 },
    { 0x0A02, 0x00 },
    { 0x0A03, 0x01 },
    { 0x0A04, 0x00 },
    { 0x0A05, 0x01 },
    { 0x0A14, 0x00 },
    { 0x0A1A, 0x00 },
    { 0x0A38, 0x00 },
    { 0x0A39, 0x00 },
    { 0x0A3A, 0x00 },
    { 0x0A3C, 0x00 },
    { 0x0A3D, 0x00 },
    { 0x0A3E, 0x00 },
    { 0x0A4C, 0x00 },
    { 0x0A4D, 0x00 },
    { 0x0A4E, 0x00 },
    { 0x0A4F, 0x00 },
    { 0x0A50, 0x00 },
    { 0x0A51, 0x00 },
    { 0x0A52, 0x00 },
    { 0x0A53, 0x00 },
    { 0x0B44, 0x0F },
    { 0x0B46, 0x00 },
    { 0x0B47, 0x0F },
    { 0x0B48, 0x0F },
    { 0x0B4A, 0x02 },
    { 0x0B57, 0xE0 },
    { 0x0B58, 0x01 },
    { 0x0C02, 0x03 },
    { 0x0C03, 0x00 },
    { 0x0C07, 0x00 },
    { 0x0C08, 0x00 },
};


// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ SI5392 Dual SDI clock +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// SI5392 dual SDI clock (non-fractional and fractional) configuration. 
// Used for the DTA-2172, DTA-2174B, DTA-2178ASI and DTA-2178.
// 54MHz XTAL input, DCO-mode; In1: 27MHz; Out0: 148.35MHz and Out1: 148.5MHz
//

// Properties
static const DtDfSi534XClockProps SI5392_CONFIG_SDI_CLOCK_PROPS_DTA2172_LIKE[2] =
{
    { 0,                                                // Clock output port index 0
      DT_DF_SI534X_CLK_FRACTIONAL,                      // Fractional clock
      (SI534X_EXP12+50046435328LL-1)/50046435328LL,     // Steps: 1e12/N0_NUM ppt
      200*SI534X_EXP6,                                  // Range: +/- 200ppm
      148*SI534X_EXP12 + 32*SI534X_EXP12/91             // Freq: 148.5/1.001 MHz
    },
    { 1,                                                // Clock output port index 1
      DT_DF_SI534X_CLK_NON_FRACTIONAL,                  // Non-fractional clock
      (SI534X_EXP12+93837066240LL-1)/93837066240LL,     // Steps: 1e12/N1_NUM
      200*SI534X_EXP6,                                  // Range: +/- 200ppm
      148*SI534X_EXP12 + 500LL*SI534X_EXP9              // Freq: 148.5MHz
    },
};

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:               Si5392AB Rev A
 * Design ID:          DTA-2172
 * Created By:         ClockBuilder Pro v4.4 [2022-03-30]
 * Timestamp:          2022-07-08 09:38:19 GMT+02:00
 * 
 * Design Notes
 * ============
 * Converted from CBPro v2.35 Project File Si5342-RevD-DTA-2172-Project.slabtimeproj Faster Lock.slabtimeproj.
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - No warnings
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Frequency Plan Grade:     B
 * Minimum Base OPN:         Si5392B*
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5392A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5392B*   100 Hz to 350 MHz    "
 * Si5392C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5392D    100 Hz to 350 MHz    "
 * 
 * * Based on your calculated frequency plan, a Si5392B grade device is
 * sufficient for your design. For more in-system configuration flexibility
 * (higher frequencies and/or to enable fractional synthesis), consider
 * selecting device grade Si5392A when specifying an ordering part number (OPN)
 * for your application. See the datasheet Ordering Guide for more information.
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 104d to 107d / 0x68 to 0x6B (selected via A0/A1 pins)
 * 
 * External Reference:
 *    54 MHz (XTAL - Crystal)
 * 
 * Inputs:
 *     IN0: Unused
 *     IN1: 27 MHz
 *          Standard Differential and Single-ended
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5MHz*1000/1001 ]
 *          Enabled, LVDS 1.8 V
 *    OUT1: 148.5 MHz
 *          Enabled, LVDS 1.8 V
 * 
 * Frequency Plan
 * ==============
 * Fvco = 13.2759890109890109... GHz [ 13 + 5023/18200 GHz ]
 * Fpfd = 296.7032967032967032... kHz [ 296 + 64/91 kHz ]
 * Fms0 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * Fms1 = 594 MHz
 * 
 * P dividers:
 *    P0  = Unused
 *    P1  = 91
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 245.8516483516483516... [ 245 + 155/182 ]
 * M = 8949
 * N dividers:
 *    N0:
 *       Value: 14.915
 *       OUT0: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N1:
 *       Value: 22.3501498501498501... [ 22 + 701/2002 ]
 *       OUT1: 148.5 MHz
 * 
 * R dividers:
 *    R0 = 6
 *    R1 = 4
 * 
 * Nominal Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  134.601 Hz
 *   Coefficients:
 *      BW0:  20
 *      BW1:  35
 *      BW2:  12
 *      BW3:  11
 *      BW4:  31
 *      BW5:  63
 * Fastlock Bandwidth:
 *   Desired: 4.000 kHz
 *   Actual:  4.456 kHz
 *   Coefficients:
 *      BW0:  25
 *      BW1:  47
 *      BW2:  7
 *      BW3:  6
 *      BW4:  31
 *      BW5:  63
 * Holdover Bandwidth:
 *    N/A (Ramped Exit from Holdover)
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Hitless Input Switching Assistant
 * =================================
 * Assistant Disabled
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 *        Fvco * Nx_DEN
 * Fout = -------------
 *         Nx_NUM * Rz 
 * 
 * N0: DCO Enabled
 * 
 *    Fvco:               13.2759890109890109... GHz [ 13 + 5023/18200 GHz ]
 *    N0_NUM:             50046435328
 *    N0_DEN:             3355443200
 *    Step Word:          1
 * 
 *    Desired Step Size:  1 ppt
 *    Actual Step Size:   19.981443103111... ppt
 *    Range:              200 ppm
 * 
 *    OUT0
 *         R0:            6
 *         Initial Freq:  148.351648351648... MHz
 *         Step Size:     0.00296428002... Hz
 *         Min Freq:      148.321989887167... MHz
 *         Max Freq:      148.381318679514... MHz
 * 
 * N1: DCO Enabled
 * 
 *    Fvco:               13.2759890109890109... GHz [ 13 + 5023/18200 GHz ]
 *    N1_NUM:             93837066240
 *    N1_DEN:             4198498304
 *    Step Word:          1
 * 
 *    Desired Step Size:  1 ppt
 *    Actual Step Size:   10.656769654893... ppt
 *    Range:              200 ppm
 * 
 *    OUT1
 *         R1:            4
 *         Initial Freq:  148.5 MHz
 *         Step Size:     0.001582530293... Hz
 *         Min Freq:      148.470311876065... MHz
 *         Max Freq:      148.529699999183... MHz
 * 
 * Input/Output Skew Control
 * =========================
 * N0: 14.915
 * 
 *    OUT0  148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 * 
 *    Desired Dynamic Skew Step:  0.000 ps
 *    Actual Dynamic Skew Step:   0 ps
 *    N0_PHASE_STEP:                 0x0 0d
 *    N0_PHASE_COUNT:                0x0 0d
 * 
 *    Use N0_PHASE_INC and N0_PHASE_DEC to perform phase step.
 * 
 * N1: 22.3501498501498501... [ 22 + 701/2002 ]
 * 
 *    OUT1  148.5 MHz
 * 
 *    Desired Dynamic Skew Step:  0.000 ps
 *    Actual Dynamic Skew Step:   0 ps
 *    N1_PHASE_STEP:                 0x0 0d
 *    N1_PHASE_COUNT:                0x0 0d
 * 
 *    Use N1_PHASE_INC and N1_PHASE_DEC to perform phase step.
 */

static const DtDfSi534XRegister  SI5392_CONFIG_DUAL_SDI_CLOCK_DTA2172_LIKE[] =
{
    { 0x0006, 0x00 },
    { 0x0007, 0x00 },
    { 0x0008, 0x00 },
    { 0x000B, 0x68 },
    { 0x0016, 0x02 },
    { 0x0017, 0xDC },
    { 0x0018, 0xDD },
    { 0x0019, 0xDD },
    { 0x001A, 0xDF },
    { 0x002B, 0x02 },
    { 0x002C, 0x02 },
    { 0x002D, 0x00 },
    { 0x002E, 0x00 },
    { 0x002F, 0x00 },
    { 0x0030, 0xEA },
    { 0x0031, 0x00 },
    { 0x0032, 0x00 },
    { 0x0033, 0x00 },
    { 0x0034, 0x00 },
    { 0x0035, 0x00 },
    { 0x0036, 0x00 },
    { 0x0037, 0x00 },
    { 0x0038, 0x7D },
    { 0x0039, 0x00 },
    { 0x003A, 0x00 },
    { 0x003B, 0x00 },
    { 0x003C, 0x00 },
    { 0x003D, 0x00 },
    { 0x003E, 0x20 },
    { 0x003F, 0x22 },
    { 0x0040, 0x01 },
    { 0x0041, 0x00 },
    { 0x0042, 0x0B },
    { 0x0043, 0x00 },
    { 0x0044, 0x00 },
    { 0x0045, 0x0C },
    { 0x0046, 0x00 },
    { 0x0047, 0x32 },
    { 0x0048, 0x00 },
    { 0x0049, 0x00 },
    { 0x004A, 0x00 },
    { 0x004B, 0x32 },
    { 0x004C, 0x00 },
    { 0x004D, 0x00 },
    { 0x004E, 0x50 },
    { 0x004F, 0x00 },
    { 0x0050, 0x0F },
    { 0x0051, 0x00 },
    { 0x0052, 0x03 },
    { 0x0053, 0x00 },
    { 0x0054, 0x00 },
    { 0x0055, 0x00 },
    { 0x0056, 0x03 },
    { 0x0057, 0x00 },
    { 0x0058, 0x00 },
    { 0x0059, 0x04 },
    { 0x005A, 0x00 },
    { 0x005B, 0x00 },
    { 0x005C, 0x00 },
    { 0x005D, 0x00 },
    { 0x005E, 0x00 },
    { 0x005F, 0x00 },
    { 0x0060, 0x00 },
    { 0x0061, 0x01 },
    { 0x0062, 0x00 },
    { 0x0063, 0x00 },
    { 0x0064, 0x00 },
    { 0x0065, 0x00 },
    { 0x0066, 0x00 },
    { 0x0067, 0x00 },
    { 0x0068, 0x00 },
    { 0x0069, 0x00 },
    { 0x0092, 0x02 },
    { 0x0093, 0xA0 },
    { 0x0095, 0x00 },
    { 0x0096, 0x90 },
    { 0x0098, 0x70 },
    { 0x009A, 0x02 },
    { 0x009B, 0x70 },
    { 0x009D, 0x08 },
    { 0x009E, 0x50 },
    { 0x00A0, 0x30 },
    { 0x00A2, 0x00 },
    { 0x00A9, 0x83 },
    { 0x00AA, 0x1E },
    { 0x00AB, 0x00 },
    { 0x00AC, 0x00 },
    { 0x00E5, 0x00 },
    { 0x00EA, 0x8E },
    { 0x00EB, 0x1D },
    { 0x00EC, 0x00 },
    { 0x00ED, 0x00 },
    { 0x0102, 0x01 },
    { 0x0112, 0x02 },
    { 0x0113, 0x09 },
    { 0x0114, 0x3E },
    { 0x0115, 0x18 },
    { 0x0117, 0x02 },
    { 0x0118, 0x09 },
    { 0x0119, 0x3E },
    { 0x011A, 0x19 },
    { 0x013F, 0x00 },
    { 0x0140, 0x00 },
    { 0x0141, 0x40 },
    { 0x0142, 0xFF },
    { 0x0206, 0x00 },
    { 0x0208, 0x00 },
    { 0x0209, 0x00 },
    { 0x020A, 0x00 },
    { 0x020B, 0x00 },
    { 0x020C, 0x00 },
    { 0x020D, 0x00 },
    { 0x020E, 0x00 },
    { 0x020F, 0x00 },
    { 0x0210, 0x00 },
    { 0x0211, 0x00 },
    { 0x0212, 0x5B },
    { 0x0213, 0x00 },
    { 0x0214, 0x00 },
    { 0x0215, 0x00 },
    { 0x0216, 0x00 },
    { 0x0217, 0x00 },
    { 0x0218, 0x01 },
    { 0x0219, 0x00 },
    { 0x021A, 0x00 },
    { 0x021B, 0x00 },
    { 0x021C, 0x00 },
    { 0x021D, 0x00 },
    { 0x021E, 0x00 },
    { 0x021F, 0x00 },
    { 0x0220, 0x00 },
    { 0x0221, 0x00 },
    { 0x0222, 0x00 },
    { 0x0223, 0x00 },
    { 0x0224, 0x00 },
    { 0x0225, 0x00 },
    { 0x0226, 0x00 },
    { 0x0227, 0x00 },
    { 0x0228, 0x00 },
    { 0x0229, 0x00 },
    { 0x022A, 0x00 },
    { 0x022B, 0x00 },
    { 0x022C, 0x00 },
    { 0x022D, 0x00 },
    { 0x022E, 0x00 },
    { 0x022F, 0x00 },
    { 0x0231, 0x0B },
    { 0x0232, 0x0B },
    { 0x0233, 0x0B },
    { 0x0234, 0x0B },
    { 0x0235, 0x00 },
    { 0x0236, 0x00 },
    { 0x0237, 0x00 },
    { 0x0238, 0xC9 },
    { 0x0239, 0xAE },
    { 0x023A, 0x00 },
    { 0x023B, 0x00 },
    { 0x023C, 0x00 },
    { 0x023D, 0x00 },
    { 0x023E, 0xB6 },
    { 0x0250, 0x02 },
    { 0x0251, 0x00 },
    { 0x0252, 0x00 },
    { 0x0253, 0x01 },
    { 0x0254, 0x00 },
    { 0x0255, 0x00 },
    { 0x026B, 0x44 },
    { 0x026C, 0x54 },
    { 0x026D, 0x41 },
    { 0x026E, 0x2D },
    { 0x026F, 0x32 },
    { 0x0270, 0x31 },
    { 0x0271, 0x37 },
    { 0x0272, 0x32 },
    { 0x028A, 0x00 },
    { 0x028B, 0x00 },
    { 0x028C, 0x00 },
    { 0x028D, 0x00 },
    { 0x028E, 0x00 },
    { 0x028F, 0x00 },
    { 0x0290, 0x00 },
    { 0x0291, 0x00 },
    { 0x0292, 0x3F },
    { 0x0293, 0x2F },
    { 0x0294, 0xD0 },
    { 0x0296, 0x02 },
    { 0x0297, 0x02 },
    { 0x0299, 0x02 },
    { 0x029D, 0x7E },
    { 0x029E, 0x00 },
    { 0x029F, 0x00 },
    { 0x02A9, 0x33 },
    { 0x02AA, 0x01 },
    { 0x02AB, 0x00 },
    { 0x02B7, 0xFF },
    { 0x02BC, 0x00 },
    { 0x0302, 0x00 },
    { 0x0303, 0x00 },
    { 0x0304, 0x00 },
    { 0x0305, 0xA7 },
    { 0x0306, 0x0B },
    { 0x0307, 0x00 },
    { 0x0308, 0x00 },
    { 0x0309, 0x00 },
    { 0x030A, 0x00 },
    { 0x030B, 0xC8 },
    { 0x030C, 0x00 },
    { 0x030D, 0x00 },
    { 0x030E, 0x00 },
    { 0x030F, 0x20 },
    { 0x0310, 0xD9 },
    { 0x0311, 0x15 },
    { 0x0312, 0x00 },
    { 0x0313, 0x00 },
    { 0x0314, 0x00 },
    { 0x0315, 0x40 },
    { 0x0316, 0xFA },
    { 0x0317, 0x00 },
    { 0x0338, 0x00 },
    { 0x0339, 0x1F },
    { 0x033B, 0x01 },
    { 0x033C, 0x00 },
    { 0x033D, 0x00 },
    { 0x033E, 0x00 },
    { 0x033F, 0x00 },
    { 0x0340, 0x00 },
    { 0x0341, 0x01 },
    { 0x0342, 0x00 },
    { 0x0343, 0x00 },
    { 0x0344, 0x00 },
    { 0x0345, 0x00 },
    { 0x0346, 0x00 },
    { 0x0359, 0x00 },
    { 0x035A, 0x00 },
    { 0x035B, 0x00 },
    { 0x035C, 0x00 },
    { 0x0487, 0x00 },
    { 0x0508, 0x14 },
    { 0x0509, 0x23 },
    { 0x050A, 0x0C },
    { 0x050B, 0x0B },
    { 0x050C, 0x1F },
    { 0x050D, 0x3F },
    { 0x050E, 0x19 },
    { 0x050F, 0x2F },
    { 0x0510, 0x07 },
    { 0x0511, 0x06 },
    { 0x0512, 0x1F },
    { 0x0513, 0x3F },
    { 0x0515, 0x00 },
    { 0x0516, 0x00 },
    { 0x0517, 0x00 },
    { 0x0518, 0x80 },
    { 0x0519, 0x7A },
    { 0x051A, 0x11 },
    { 0x051B, 0x00 },
    { 0x051C, 0x00 },
    { 0x051D, 0x00 },
    { 0x051E, 0x00 },
    { 0x051F, 0x80 },
    { 0x0521, 0x2B },
    { 0x052A, 0x03 },
    { 0x052B, 0x01 },
    { 0x052C, 0x87 },
    { 0x052D, 0x03 },
    { 0x052E, 0x19 },
    { 0x052F, 0x19 },
    { 0x0531, 0x00 },
    { 0x0532, 0xF2 },
    { 0x0533, 0x15 },
    { 0x0534, 0x00 },
    { 0x0535, 0x00 },
    { 0x0536, 0x04 },
    { 0x0537, 0x00 },
    { 0x0538, 0x00 },
    { 0x0539, 0x00 },
    { 0x053A, 0x01 },
    { 0x053B, 0x03 },
    { 0x053C, 0x00 },
    { 0x053D, 0x04 },
    { 0x053E, 0x02 },
    { 0x0588, 0x09 },
    { 0x0589, 0x56 },
    { 0x058A, 0x00 },
    { 0x058B, 0x9C },
    { 0x058C, 0x08 },
    { 0x058D, 0x00 },
    { 0x059B, 0x7A },
    { 0x059C, 0x8C },
    { 0x059D, 0x14 },
    { 0x059E, 0x25 },
    { 0x059F, 0x0C },
    { 0x05A0, 0x0B },
    { 0x05A1, 0x1F },
    { 0x05A2, 0x3F },
    { 0x05A4, 0x08 },
    { 0x05A5, 0x00 },
    { 0x05A6, 0x03 },
    { 0x05AC, 0x09 },
    { 0x05AD, 0xF0 },
    { 0x05AE, 0x3E },
    { 0x05B1, 0x93 },
    { 0x05B2, 0x02 },
    { 0x0802, 0x35 },
    { 0x0803, 0x05 },
    { 0x0804, 0x00 },
    { 0x0805, 0x00 },
    { 0x0806, 0x00 },
    { 0x0807, 0x00 },
    { 0x0808, 0x00 },
    { 0x0809, 0x00 },
    { 0x080A, 0x00 },
    { 0x080B, 0x00 },
    { 0x080C, 0x00 },
    { 0x080D, 0x00 },
    { 0x080E, 0x00 },
    { 0x080F, 0x00 },
    { 0x0810, 0x00 },
    { 0x0811, 0x00 },
    { 0x0812, 0x00 },
    { 0x0813, 0x00 },
    { 0x0814, 0x00 },
    { 0x0815, 0x00 },
    { 0x0816, 0x00 },
    { 0x0817, 0x00 },
    { 0x0818, 0x00 },
    { 0x0819, 0x00 },
    { 0x081A, 0x00 },
    { 0x081B, 0x00 },
    { 0x081C, 0x00 },
    { 0x081D, 0x00 },
    { 0x081E, 0x00 },
    { 0x081F, 0x00 },
    { 0x0820, 0x00 },
    { 0x0821, 0x00 },
    { 0x0822, 0x00 },
    { 0x0823, 0x00 },
    { 0x0824, 0x00 },
    { 0x0825, 0x00 },
    { 0x0826, 0x00 },
    { 0x0827, 0x00 },
    { 0x0828, 0x00 },
    { 0x0829, 0x00 },
    { 0x082A, 0x00 },
    { 0x082B, 0x00 },
    { 0x082C, 0x00 },
    { 0x082D, 0x00 },
    { 0x082E, 0x00 },
    { 0x082F, 0x00 },
    { 0x0830, 0x00 },
    { 0x0831, 0x00 },
    { 0x0832, 0x00 },
    { 0x0833, 0x00 },
    { 0x0834, 0x00 },
    { 0x0835, 0x00 },
    { 0x0836, 0x00 },
    { 0x0837, 0x00 },
    { 0x0838, 0x00 },
    { 0x0839, 0x00 },
    { 0x083A, 0x00 },
    { 0x083B, 0x00 },
    { 0x083C, 0x00 },
    { 0x083D, 0x00 },
    { 0x083E, 0x00 },
    { 0x083F, 0x00 },
    { 0x0840, 0x00 },
    { 0x0841, 0x00 },
    { 0x0842, 0x00 },
    { 0x0843, 0x00 },
    { 0x0844, 0x00 },
    { 0x0845, 0x00 },
    { 0x0846, 0x00 },
    { 0x0847, 0x00 },
    { 0x0848, 0x00 },
    { 0x0849, 0x00 },
    { 0x084A, 0x00 },
    { 0x084B, 0x00 },
    { 0x084C, 0x00 },
    { 0x084D, 0x00 },
    { 0x084E, 0x00 },
    { 0x084F, 0x00 },
    { 0x0850, 0x00 },
    { 0x0851, 0x00 },
    { 0x0852, 0x00 },
    { 0x0853, 0x00 },
    { 0x0854, 0x00 },
    { 0x0855, 0x00 },
    { 0x0856, 0x00 },
    { 0x0857, 0x00 },
    { 0x0858, 0x00 },
    { 0x0859, 0x00 },
    { 0x085A, 0x00 },
    { 0x085B, 0x00 },
    { 0x085C, 0x00 },
    { 0x085D, 0x00 },
    { 0x085E, 0x00 },
    { 0x085F, 0x00 },
    { 0x0860, 0x00 },
    { 0x0861, 0x00 },
    { 0x090E, 0x02 },
    { 0x0943, 0x00 },
    { 0x0949, 0x12 },
    { 0x094A, 0x02 },
    { 0x094E, 0x49 },
    { 0x094F, 0xE2 },
    { 0x095E, 0x00 },
    { 0x0A02, 0x00 },
    { 0x0A03, 0x03 },
    { 0x0A04, 0x00 },
    { 0x0A05, 0x03 },
    { 0x0A14, 0x00 },
    { 0x0A1A, 0x00 },
    { 0x0A38, 0x00 },
    { 0x0A39, 0x00 },
    { 0x0A3A, 0x00 },
    { 0x0A3C, 0x00 },
    { 0x0A3D, 0x00 },
    { 0x0A3E, 0x00 },
    { 0x0A4C, 0x00 },
    { 0x0A4D, 0x00 },
    { 0x0A4E, 0x00 },
    { 0x0A4F, 0x00 },
    { 0x0A50, 0x00 },
    { 0x0A51, 0x00 },
    { 0x0A52, 0x00 },
    { 0x0A53, 0x00 },
    { 0x0B44, 0x2F },
    { 0x0B46, 0x00 },
    { 0x0B47, 0x0D },
    { 0x0B48, 0x0D },
    { 0x0B4A, 0x00 },
    { 0x0B57, 0xF0 },
    { 0x0B58, 0x00 },
    { 0x0C02, 0x03 },
    { 0x0C03, 0x02 },
    { 0x0C07, 0x01 },
    { 0x0C08, 0x01 },
};


// =+=+=+=+=+=+=+=+=+=+=+=+ DTA2175-Like Configuration Properties +=+=+=+=+=+=+=+=+=+=+=+=
//
static const DtDfSi534XClockProps SI5392_CONFIG_FRAC_SDI_CLOCK_PROPS_DTA2175_LIKE[1] =
{
    { 0,                                                // Clock output port index 0
      DT_DF_SI534X_CLK_FRACTIONAL,                      // Fractional clock
      (SI534X_EXP12+50046435328LL-1)/50046435328LL,     // Steps: 1e12/N0_NUM
      200*SI534X_EXP6,                                  // Range: +/- 200ppm
      1483516484LL*SI534X_EXP5                          // Freq: 148.35MHz
    }
};
static const DtDfSi534XClockProps SI5392_CONFIG_NON_FRAC_SDI_CLOCK_PROPS_DTA2175_LIKE[1] =
{
    { 0,                                                // Clock output port index 0
      DT_DF_SI534X_CLK_NON_FRACTIONAL,                   // Non-fractional clock
      (SI534X_EXP12+75388420096LL-1)/75388420096LL,     // Steps: 1e12/N0_NUM
      200*SI534X_EXP6,                                  // Range: +/- 200ppm
      148*SI534X_EXP12 + 500LL*SI534X_EXP9              // Freq: 148.5MHz
    },
};

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+ SI5392 Fractional SDI clock +=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//
// SI5392 fractional SDI clock configuration. 
// Used for the DTA-2175.
// 54MHz XTAL input, DCO-mode; In1: 27MHz; Out0: 148.35MHz.
//
/*
 * Design Report
 *
 * Overview
 * ========
 * Part:               Si5392AB Rev A
 * Design ID:          DTA-2175
 * Created By:         ClockBuilder Pro v4.4 [2022-03-30]
 * Timestamp:          2022-07-08 09:39:49 GMT+02:00
 * 
 * Design Notes
 * ============
 * Converted from CBPro v2.35 Project File Si5342-RevD-DTA-2175-Project Fractional Clock.slabtimeproj.
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - No warnings
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.3516483516483516... MHz
 * Frequency Synthesis Mode: Fractional
 * Frequency Plan Grade:     B
 * Minimum Base OPN:         Si5392B*
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5392A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5392B*   100 Hz to 350 MHz    "
 * Si5392C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5392D    100 Hz to 350 MHz    "
 * 
 * * Based on your calculated frequency plan, a Si5392B grade device is
 * sufficient for your design. For more in-system configuration flexibility
 * (higher frequencies and/or to enable fractional synthesis), consider
 * selecting device grade Si5392A when specifying an ordering part number (OPN)
 * for your application. See the datasheet Ordering Guide for more information.
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 104d to 107d / 0x68 to 0x6B (selected via A0/A1 pins)
 * 
 * External Reference:
 *    54 MHz (XTAL - Crystal)
 * 
 * Inputs:
 *     IN0: Unused
 *     IN1: 27 MHz
 *          Standard Differential and Single-ended
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *          [ 148.5MHz/1.001 ]
 *          Enabled, LVDS 1.8 V
 *    OUT1: Unused
 * 
 * Frequency Plan
 * ==============
 * Fvco = 13.2759890109890109... GHz [ 13 + 5023/18200 GHz ]
 * Fpfd = 296.7032967032967032... kHz [ 296 + 64/91 kHz ]
 * Fms0 = 890.1098901098901098... MHz [ 890 + 10/91 MHz ]
 * 
 * P dividers:
 *    P0  = Unused
 *    P1  = 91
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 245.8516483516483516... [ 245 + 155/182 ]
 * M = 8949
 * N dividers:
 *    N0:
 *       Value: 14.915
 *       OUT0: 148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 *    N1:
 *       Unused
 * 
 * R dividers:
 *    R0 = 6
 *    R1 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  134.601 Hz
 *   Coefficients:
 *      BW0:  20
 *      BW1:  35
 *      BW2:  12
 *      BW3:  11
 *      BW4:  31
 *      BW5:  63
 * Fastlock Bandwidth:
 *   Desired: 1.000 kHz
 *   Actual:  1.085 kHz
 *   Coefficients:
 *      BW0:  23
 *      BW1:  43
 *      BW2:  9
 *      BW3:  8
 *      BW4:  31
 *      BW5:  63
 * Holdover Bandwidth:
 *    N/A (Ramped Exit from Holdover)
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Hitless Input Switching Assistant
 * =================================
 * Assistant Disabled
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 *        Fvco * Nx_DEN
 * Fout = -------------
 *         Nx_NUM * Rz 
 * 
 * N0: DCO Enabled
 * 
 *    Fvco:               13.2759890109890109... GHz [ 13 + 5023/18200 GHz ]
 *    N0_NUM:             50046435328
 *    N0_DEN:             3355443200
 *    Step Word:          1
 * 
 *    Desired Step Size:  1 ppt
 *    Actual Step Size:   19.981443103111... ppt
 *    Range:              200 ppm
 * 
 *    OUT0
 *         R0:            6
 *         Initial Freq:  148.351648351648... MHz
 *         Step Size:     0.00296428002... Hz
 *         Min Freq:      148.321989887167... MHz
 *         Max Freq:      148.381318679514... MHz
 * 
 * N1: DCO Disabled
 * 
 * Input/Output Skew Control
 * =========================
 * N0: 14.915
 * 
 *    OUT0  148.3516483516483516... MHz [ 148 + 32/91 MHz ]
 * 
 *    Desired Dynamic Skew Step:  0.000 ps
 *    Actual Dynamic Skew Step:   0 ps
 *    N0_PHASE_STEP:                 0x0 0d
 *    N0_PHASE_COUNT:                0x0 0d
 * 
 *    Use N0_PHASE_INC and N0_PHASE_DEC to perform phase step.
 * 
 * N1 Not Used
 */

// Register settings
static const DtDfSi534XRegister SI5392_CONFIG_FRAC_SDI_CLOCK_DTA2175_LIKE[] =
{
    { 0x0006, 0x00 },
    { 0x0007, 0x00 },
    { 0x0008, 0x00 },
    { 0x000B, 0x68 },
    { 0x0016, 0x02 },
    { 0x0017, 0xDC },
    { 0x0018, 0xDD },
    { 0x0019, 0xDD },
    { 0x001A, 0xDF },
    { 0x002B, 0x02 },
    { 0x002C, 0x02 },
    { 0x002D, 0x00 },
    { 0x002E, 0x00 },
    { 0x002F, 0x00 },
    { 0x0030, 0xEA },
    { 0x0031, 0x00 },
    { 0x0032, 0x00 },
    { 0x0033, 0x00 },
    { 0x0034, 0x00 },
    { 0x0035, 0x00 },
    { 0x0036, 0x00 },
    { 0x0037, 0x00 },
    { 0x0038, 0x7D },
    { 0x0039, 0x00 },
    { 0x003A, 0x00 },
    { 0x003B, 0x00 },
    { 0x003C, 0x00 },
    { 0x003D, 0x00 },
    { 0x003E, 0x20 },
    { 0x003F, 0x22 },
    { 0x0040, 0x01 },
    { 0x0041, 0x00 },
    { 0x0042, 0x0B },
    { 0x0043, 0x00 },
    { 0x0044, 0x00 },
    { 0x0045, 0x0C },
    { 0x0046, 0x00 },
    { 0x0047, 0x32 },
    { 0x0048, 0x00 },
    { 0x0049, 0x00 },
    { 0x004A, 0x00 },
    { 0x004B, 0x32 },
    { 0x004C, 0x00 },
    { 0x004D, 0x00 },
    { 0x004E, 0x50 },
    { 0x004F, 0x00 },
    { 0x0050, 0x0F },
    { 0x0051, 0x00 },
    { 0x0052, 0x03 },
    { 0x0053, 0x00 },
    { 0x0054, 0x00 },
    { 0x0055, 0x00 },
    { 0x0056, 0x03 },
    { 0x0057, 0x00 },
    { 0x0058, 0x00 },
    { 0x0059, 0x04 },
    { 0x005A, 0x00 },
    { 0x005B, 0x00 },
    { 0x005C, 0x00 },
    { 0x005D, 0x00 },
    { 0x005E, 0x00 },
    { 0x005F, 0x00 },
    { 0x0060, 0x00 },
    { 0x0061, 0x01 },
    { 0x0062, 0x00 },
    { 0x0063, 0x00 },
    { 0x0064, 0x00 },
    { 0x0065, 0x00 },
    { 0x0066, 0x00 },
    { 0x0067, 0x00 },
    { 0x0068, 0x00 },
    { 0x0069, 0x00 },
    { 0x0092, 0x02 },
    { 0x0093, 0xA0 },
    { 0x0095, 0x00 },
    { 0x0096, 0x90 },
    { 0x0098, 0x70 },
    { 0x009A, 0x02 },
    { 0x009B, 0x70 },
    { 0x009D, 0x0C },
    { 0x009E, 0x50 },
    { 0x00A0, 0x30 },
    { 0x00A2, 0x00 },
    { 0x00A9, 0x2F },
    { 0x00AA, 0x77 },
    { 0x00AB, 0x00 },
    { 0x00AC, 0x00 },
    { 0x00E5, 0x00 },
    { 0x00EA, 0x3A },
    { 0x00EB, 0x76 },
    { 0x00EC, 0x00 },
    { 0x00ED, 0x00 },
    { 0x0102, 0x01 },
    { 0x0112, 0x02 },
    { 0x0113, 0x09 },
    { 0x0114, 0x3E },
    { 0x0115, 0x18 },
    { 0x0117, 0x01 },
    { 0x0118, 0x09 },
    { 0x0119, 0x3B },
    { 0x011A, 0x28 },
    { 0x013F, 0x00 },
    { 0x0140, 0x00 },
    { 0x0141, 0x40 },
    { 0x0142, 0xFF },
    { 0x0206, 0x00 },
    { 0x0208, 0x00 },
    { 0x0209, 0x00 },
    { 0x020A, 0x00 },
    { 0x020B, 0x00 },
    { 0x020C, 0x00 },
    { 0x020D, 0x00 },
    { 0x020E, 0x00 },
    { 0x020F, 0x00 },
    { 0x0210, 0x00 },
    { 0x0211, 0x00 },
    { 0x0212, 0x5B },
    { 0x0213, 0x00 },
    { 0x0214, 0x00 },
    { 0x0215, 0x00 },
    { 0x0216, 0x00 },
    { 0x0217, 0x00 },
    { 0x0218, 0x01 },
    { 0x0219, 0x00 },
    { 0x021A, 0x00 },
    { 0x021B, 0x00 },
    { 0x021C, 0x00 },
    { 0x021D, 0x00 },
    { 0x021E, 0x00 },
    { 0x021F, 0x00 },
    { 0x0220, 0x00 },
    { 0x0221, 0x00 },
    { 0x0222, 0x00 },
    { 0x0223, 0x00 },
    { 0x0224, 0x00 },
    { 0x0225, 0x00 },
    { 0x0226, 0x00 },
    { 0x0227, 0x00 },
    { 0x0228, 0x00 },
    { 0x0229, 0x00 },
    { 0x022A, 0x00 },
    { 0x022B, 0x00 },
    { 0x022C, 0x00 },
    { 0x022D, 0x00 },
    { 0x022E, 0x00 },
    { 0x022F, 0x00 },
    { 0x0231, 0x0B },
    { 0x0232, 0x0B },
    { 0x0233, 0x0B },
    { 0x0234, 0x0B },
    { 0x0235, 0x00 },
    { 0x0236, 0x00 },
    { 0x0237, 0x00 },
    { 0x0238, 0xC9 },
    { 0x0239, 0xAE },
    { 0x023A, 0x00 },
    { 0x023B, 0x00 },
    { 0x023C, 0x00 },
    { 0x023D, 0x00 },
    { 0x023E, 0xB6 },
    { 0x0250, 0x02 },
    { 0x0251, 0x00 },
    { 0x0252, 0x00 },
    { 0x0253, 0x00 },
    { 0x0254, 0x00 },
    { 0x0255, 0x00 },
    { 0x026B, 0x44 },
    { 0x026C, 0x54 },
    { 0x026D, 0x41 },
    { 0x026E, 0x2D },
    { 0x026F, 0x32 },
    { 0x0270, 0x31 },
    { 0x0271, 0x37 },
    { 0x0272, 0x35 },
    { 0x028A, 0x00 },
    { 0x028B, 0x00 },
    { 0x028C, 0x00 },
    { 0x028D, 0x00 },
    { 0x028E, 0x00 },
    { 0x028F, 0x00 },
    { 0x0290, 0x00 },
    { 0x0291, 0x00 },
    { 0x0292, 0x3F },
    { 0x0293, 0x2F },
    { 0x0294, 0xB0 },
    { 0x0296, 0x02 },
    { 0x0297, 0x02 },
    { 0x0299, 0x02 },
    { 0x029D, 0xD0 },
    { 0x029E, 0x01 },
    { 0x029F, 0x00 },
    { 0x02A9, 0xCC },
    { 0x02AA, 0x04 },
    { 0x02AB, 0x00 },
    { 0x02B7, 0xFF },
    { 0x02BC, 0x00 },
    { 0x0302, 0x00 },
    { 0x0303, 0x00 },
    { 0x0304, 0x00 },
    { 0x0305, 0xA7 },
    { 0x0306, 0x0B },
    { 0x0307, 0x00 },
    { 0x0308, 0x00 },
    { 0x0309, 0x00 },
    { 0x030A, 0x00 },
    { 0x030B, 0xC8 },
    { 0x030C, 0x00 },
    { 0x030D, 0x00 },
    { 0x030E, 0x00 },
    { 0x030F, 0x00 },
    { 0x0310, 0x00 },
    { 0x0311, 0x00 },
    { 0x0312, 0x00 },
    { 0x0313, 0x00 },
    { 0x0314, 0x00 },
    { 0x0315, 0x00 },
    { 0x0316, 0x00 },
    { 0x0317, 0x00 },
    { 0x0338, 0x00 },
    { 0x0339, 0x1F },
    { 0x033B, 0x01 },
    { 0x033C, 0x00 },
    { 0x033D, 0x00 },
    { 0x033E, 0x00 },
    { 0x033F, 0x00 },
    { 0x0340, 0x00 },
    { 0x0341, 0x00 },
    { 0x0342, 0x00 },
    { 0x0343, 0x00 },
    { 0x0344, 0x00 },
    { 0x0345, 0x00 },
    { 0x0346, 0x00 },
    { 0x0359, 0x00 },
    { 0x035A, 0x00 },
    { 0x035B, 0x00 },
    { 0x035C, 0x00 },
    { 0x0487, 0x00 },
    { 0x0508, 0x14 },
    { 0x0509, 0x23 },
    { 0x050A, 0x0C },
    { 0x050B, 0x0B },
    { 0x050C, 0x1F },
    { 0x050D, 0x3F },
    { 0x050E, 0x17 },
    { 0x050F, 0x2B },
    { 0x0510, 0x09 },
    { 0x0511, 0x08 },
    { 0x0512, 0x1F },
    { 0x0513, 0x3F },
    { 0x0515, 0x00 },
    { 0x0516, 0x00 },
    { 0x0517, 0x00 },
    { 0x0518, 0x80 },
    { 0x0519, 0x7A },
    { 0x051A, 0x11 },
    { 0x051B, 0x00 },
    { 0x051C, 0x00 },
    { 0x051D, 0x00 },
    { 0x051E, 0x00 },
    { 0x051F, 0x80 },
    { 0x0521, 0x2B },
    { 0x052A, 0x03 },
    { 0x052B, 0x01 },
    { 0x052C, 0x87 },
    { 0x052D, 0x03 },
    { 0x052E, 0x19 },
    { 0x052F, 0x19 },
    { 0x0531, 0x00 },
    { 0x0532, 0xF2 },
    { 0x0533, 0x15 },
    { 0x0534, 0x00 },
    { 0x0535, 0x00 },
    { 0x0536, 0x04 },
    { 0x0537, 0x00 },
    { 0x0538, 0x00 },
    { 0x0539, 0x00 },
    { 0x053A, 0x01 },
    { 0x053B, 0x03 },
    { 0x053C, 0x00 },
    { 0x053D, 0x04 },
    { 0x053E, 0x02 },
    { 0x0588, 0x09 },
    { 0x0589, 0x56 },
    { 0x058A, 0x00 },
    { 0x058B, 0x9C },
    { 0x058C, 0x08 },
    { 0x058D, 0x00 },
    { 0x059B, 0x7A },
    { 0x059C, 0x8C },
    { 0x059D, 0x14 },
    { 0x059E, 0x25 },
    { 0x059F, 0x0C },
    { 0x05A0, 0x0B },
    { 0x05A1, 0x1F },
    { 0x05A2, 0x3F },
    { 0x05A4, 0x08 },
    { 0x05A5, 0x00 },
    { 0x05A6, 0x03 },
    { 0x05AC, 0x09 },
    { 0x05AD, 0xF0 },
    { 0x05AE, 0x3E },
    { 0x05B1, 0x93 },
    { 0x05B2, 0x02 },
    { 0x0802, 0x35 },
    { 0x0803, 0x05 },
    { 0x0804, 0x00 },
    { 0x0805, 0x00 },
    { 0x0806, 0x00 },
    { 0x0807, 0x00 },
    { 0x0808, 0x00 },
    { 0x0809, 0x00 },
    { 0x080A, 0x00 },
    { 0x080B, 0x00 },
    { 0x080C, 0x00 },
    { 0x080D, 0x00 },
    { 0x080E, 0x00 },
    { 0x080F, 0x00 },
    { 0x0810, 0x00 },
    { 0x0811, 0x00 },
    { 0x0812, 0x00 },
    { 0x0813, 0x00 },
    { 0x0814, 0x00 },
    { 0x0815, 0x00 },
    { 0x0816, 0x00 },
    { 0x0817, 0x00 },
    { 0x0818, 0x00 },
    { 0x0819, 0x00 },
    { 0x081A, 0x00 },
    { 0x081B, 0x00 },
    { 0x081C, 0x00 },
    { 0x081D, 0x00 },
    { 0x081E, 0x00 },
    { 0x081F, 0x00 },
    { 0x0820, 0x00 },
    { 0x0821, 0x00 },
    { 0x0822, 0x00 },
    { 0x0823, 0x00 },
    { 0x0824, 0x00 },
    { 0x0825, 0x00 },
    { 0x0826, 0x00 },
    { 0x0827, 0x00 },
    { 0x0828, 0x00 },
    { 0x0829, 0x00 },
    { 0x082A, 0x00 },
    { 0x082B, 0x00 },
    { 0x082C, 0x00 },
    { 0x082D, 0x00 },
    { 0x082E, 0x00 },
    { 0x082F, 0x00 },
    { 0x0830, 0x00 },
    { 0x0831, 0x00 },
    { 0x0832, 0x00 },
    { 0x0833, 0x00 },
    { 0x0834, 0x00 },
    { 0x0835, 0x00 },
    { 0x0836, 0x00 },
    { 0x0837, 0x00 },
    { 0x0838, 0x00 },
    { 0x0839, 0x00 },
    { 0x083A, 0x00 },
    { 0x083B, 0x00 },
    { 0x083C, 0x00 },
    { 0x083D, 0x00 },
    { 0x083E, 0x00 },
    { 0x083F, 0x00 },
    { 0x0840, 0x00 },
    { 0x0841, 0x00 },
    { 0x0842, 0x00 },
    { 0x0843, 0x00 },
    { 0x0844, 0x00 },
    { 0x0845, 0x00 },
    { 0x0846, 0x00 },
    { 0x0847, 0x00 },
    { 0x0848, 0x00 },
    { 0x0849, 0x00 },
    { 0x084A, 0x00 },
    { 0x084B, 0x00 },
    { 0x084C, 0x00 },
    { 0x084D, 0x00 },
    { 0x084E, 0x00 },
    { 0x084F, 0x00 },
    { 0x0850, 0x00 },
    { 0x0851, 0x00 },
    { 0x0852, 0x00 },
    { 0x0853, 0x00 },
    { 0x0854, 0x00 },
    { 0x0855, 0x00 },
    { 0x0856, 0x00 },
    { 0x0857, 0x00 },
    { 0x0858, 0x00 },
    { 0x0859, 0x00 },
    { 0x085A, 0x00 },
    { 0x085B, 0x00 },
    { 0x085C, 0x00 },
    { 0x085D, 0x00 },
    { 0x085E, 0x00 },
    { 0x085F, 0x00 },
    { 0x0860, 0x00 },
    { 0x0861, 0x00 },
    { 0x090E, 0x02 },
    { 0x0943, 0x00 },
    { 0x0949, 0x02 },
    { 0x094A, 0x02 },
    { 0x094E, 0x49 },
    { 0x094F, 0xF2 },
    { 0x095E, 0x00 },
    { 0x0A02, 0x00 },
    { 0x0A03, 0x01 },
    { 0x0A04, 0x00 },
    { 0x0A05, 0x01 },
    { 0x0A14, 0x00 },
    { 0x0A1A, 0x00 },
    { 0x0A38, 0x00 },
    { 0x0A39, 0x00 },
    { 0x0A3A, 0x00 },
    { 0x0A3C, 0x00 },
    { 0x0A3D, 0x00 },
    { 0x0A3E, 0x00 },
    { 0x0A4C, 0x00 },
    { 0x0A4D, 0x00 },
    { 0x0A4E, 0x00 },
    { 0x0A4F, 0x00 },
    { 0x0A50, 0x00 },
    { 0x0A51, 0x00 },
    { 0x0A52, 0x00 },
    { 0x0A53, 0x00 },
    { 0x0B44, 0x2F },
    { 0x0B46, 0x00 },
    { 0x0B47, 0x0D },
    { 0x0B48, 0x0D },
    { 0x0B4A, 0x02 },
    { 0x0B57, 0xF0 },
    { 0x0B58, 0x00 },
    { 0x0C02, 0x03 },
    { 0x0C03, 0x02 },
    { 0x0C07, 0x01 },
    { 0x0C08, 0x01 },

};

// +=+=+=+=+=+=+=+=+=+=+=+=+=+ SI5392 Non-Fractional SDI clock +=+=+=+=+=+=+=+=+=+=+=+=+=+
//
// SI5392 non-fractional SDI clock configuration. 
// Used for the DTA-2175.
// 54MHz XTAL input, DCO-mode; In1: 27MHz; Out0: 148.5MHz.
//

/*
 * Design Report
 *
 * Overview
 * ========
 * Part:               Si5392AB Rev A
 * Design ID:          DTA-2175
 * Created By:         ClockBuilder Pro v4.4 [2022-03-30]
 * Timestamp:          2022-07-08 09:41:35 GMT+02:00
 * 
 * Design Notes
 * ============
 * Converted from CBPro v2.35 Project File Si5342-RevD-DTA-2175-Project Non-fractional Clock.slabtimeproj.
 * 
 * Design Rule Check
 * =================
 * Errors:
 * - No errors
 * 
 * Warnings:
 * - No warnings
 * 
 * Device Grade
 * ============
 * Maximum Output Frequency: 148.5 MHz
 * Frequency Synthesis Mode: Fractional
 * Frequency Plan Grade:     B
 * Minimum Base OPN:         Si5392B*
 * 
 * Base       Output Clock         Supported Frequency Synthesis Modes
 * OPN Grade  Frequency Range      (Typical Jitter)
 * ---------  -------------------  --------------------------------------------
 * Si5392A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
 * Si5392B*   100 Hz to 350 MHz    "
 * Si5392C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
 * Si5392D    100 Hz to 350 MHz    "
 * 
 * * Based on your calculated frequency plan, a Si5392B grade device is
 * sufficient for your design. For more in-system configuration flexibility
 * (higher frequencies and/or to enable fractional synthesis), consider
 * selecting device grade Si5392A when specifying an ordering part number (OPN)
 * for your application. See the datasheet Ordering Guide for more information.
 * 
 * Design
 * ======
 * Host Interface:
 *    I/O Power Supply: VDD (Core)
 *    SPI Mode: 4-Wire
 *    I2C Address Range: 104d to 107d / 0x68 to 0x6B (selected via A0/A1 pins)
 * 
 * External Reference:
 *    54 MHz (XTAL - Crystal)
 * 
 * Inputs:
 *     IN0: Unused
 *     IN1: 27 MHz
 *          Standard Differential and Single-ended
 *     IN2: Unused
 *     IN3: Unused
 * 
 * Outputs:
 *    OUT0: 148.5 MHz
 *          Enabled, LVDS 1.8 V
 *    OUT1: Unused
 * 
 * Frequency Plan
 * ==============
 * Fvco = 13.345695 GHz
 * Fpfd = 1.9285714285714285... MHz [ 1 + 13/14 MHz ]
 * Fms0 = 594 MHz
 * 
 * P dividers:
 *    P0  = Unused
 *    P1  = 14
 *    P2  = Unused
 *    P3  = Unused
 *    Pxaxb = 1
 * 
 * MXAXB = 247.1425
 * M = 1383.998
 * N dividers:
 *    N0:
 *       Value: 22.4675
 *       OUT0: 148.5 MHz
 *    N1:
 *       Unused
 * 
 * R dividers:
 *    R0 = 4
 *    R1 = Unused
 * 
 * Nominal Bandwidth:
 *   Desired: 100.000 Hz
 *   Actual:  100.647 Hz
 *   Coefficients:
 *      BW0:  19
 *      BW1:  34
 *      BW2:  12
 *      BW3:  11
 *      BW4:  7
 *      BW5:  63
 * Fastlock Bandwidth:
 *   Desired: 1.000 kHz
 *   Actual:  806.093 Hz
 *   Coefficients:
 *      BW0:  22
 *      BW1:  42
 *      BW2:  9
 *      BW3:  8
 *      BW4:  7
 *      BW5:  63
 * Holdover Bandwidth:
 *    N/A (Ramped Exit from Holdover)
 * 
 * Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
 * 
 * Hitless Input Switching Assistant
 * =================================
 * Assistant Disabled
 * 
 * Digitally Controlled Oscillator (DCO)
 * =====================================
 * Mode: Register Direct Write
 * 
 *        Fvco * Nx_DEN
 * Fout = -------------
 *         Nx_NUM * Rz 
 * 
 * N0: DCO Enabled
 * 
 *    Fvco:               13.345695 GHz
 *    N0_NUM:             75388420096
 *    N0_DEN:             3355443200
 *    Step Word:          1
 * 
 *    Desired Step Size:  1 ppt
 *    Actual Step Size:   13.264636647642... ppt
 *    Range:              200 ppm
 * 
 *    OUT0
 *         R0:            4
 *         Initial Freq:  148.5 MHz
 *         Step Size:     0.001969798542... Hz
 *         Min Freq:      148.470311875418... MHz
 *         Max Freq:      148.529699999831... MHz
 * 
 * N1: DCO Disabled
 * 
 * Input/Output Skew Control
 * =========================
 * N0: 22.4675
 * 
 *    OUT0  148.5 MHz
 * 
 *    Desired Dynamic Skew Step:  0.000 ps
 *    Actual Dynamic Skew Step:   0 ps
 *    N0_PHASE_STEP:                 0x0 0d
 *    N0_PHASE_COUNT:                0x0 0d
 * 
 *    Use N0_PHASE_INC and N0_PHASE_DEC to perform phase step.
 * 
 * N1 Not Used
 */

// Register settings
static const DtDfSi534XRegister SI5392_CONFIG_NON_FRAC_SDI_CLOCK_DTA2175_LIKE[] =
{             
    { 0x0006, 0x00 },
    { 0x0007, 0x00 },
    { 0x0008, 0x00 },
    { 0x000B, 0x68 },
    { 0x0016, 0x02 },
    { 0x0017, 0xDC },
    { 0x0018, 0xDD },
    { 0x0019, 0xDD },
    { 0x001A, 0xDF },
    { 0x002B, 0x02 },
    { 0x002C, 0x02 },
    { 0x002D, 0x00 },
    { 0x002E, 0x00 },
    { 0x002F, 0x00 },
    { 0x0030, 0x38 },
    { 0x0031, 0x00 },
    { 0x0032, 0x00 },
    { 0x0033, 0x00 },
    { 0x0034, 0x00 },
    { 0x0035, 0x00 },
    { 0x0036, 0x00 },
    { 0x0037, 0x00 },
    { 0x0038, 0x01 },
    { 0x0039, 0x00 },
    { 0x003A, 0x00 },
    { 0x003B, 0x00 },
    { 0x003C, 0x00 },
    { 0x003D, 0x00 },
    { 0x003E, 0x20 },
    { 0x003F, 0x22 },
    { 0x0040, 0x01 },
    { 0x0041, 0x00 },
    { 0x0042, 0x0B },
    { 0x0043, 0x00 },
    { 0x0044, 0x00 },
    { 0x0045, 0x0C },
    { 0x0046, 0x00 },
    { 0x0047, 0x32 },
    { 0x0048, 0x00 },
    { 0x0049, 0x00 },
    { 0x004A, 0x00 },
    { 0x004B, 0x32 },
    { 0x004C, 0x00 },
    { 0x004D, 0x00 },
    { 0x004E, 0x50 },
    { 0x004F, 0x00 },
    { 0x0050, 0x0F },
    { 0x0051, 0x00 },
    { 0x0052, 0x03 },
    { 0x0053, 0x00 },
    { 0x0054, 0x00 },
    { 0x0055, 0x00 },
    { 0x0056, 0x03 },
    { 0x0057, 0x00 },
    { 0x0058, 0x00 },
    { 0x0059, 0x04 },
    { 0x005A, 0x00 },
    { 0x005B, 0x00 },
    { 0x005C, 0x00 },
    { 0x005D, 0x00 },
    { 0x005E, 0x00 },
    { 0x005F, 0x00 },
    { 0x0060, 0x00 },
    { 0x0061, 0x01 },
    { 0x0062, 0x00 },
    { 0x0063, 0x00 },
    { 0x0064, 0x00 },
    { 0x0065, 0x00 },
    { 0x0066, 0x00 },
    { 0x0067, 0x00 },
    { 0x0068, 0x00 },
    { 0x0069, 0x00 },
    { 0x0092, 0x02 },
    { 0x0093, 0xA0 },
    { 0x0095, 0x00 },
    { 0x0096, 0x90 },
    { 0x0098, 0x70 },
    { 0x009A, 0x02 },
    { 0x009B, 0x70 },
    { 0x009D, 0x0C },
    { 0x009E, 0x50 },
    { 0x00A0, 0x30 },
    { 0x00A2, 0x00 },
    { 0x00A9, 0x84 },
    { 0x00AA, 0x77 },
    { 0x00AB, 0x00 },
    { 0x00AC, 0x00 },
    { 0x00E5, 0x00 },
    { 0x00EA, 0x3A },
    { 0x00EB, 0x76 },
    { 0x00EC, 0x00 },
    { 0x00ED, 0x00 },
    { 0x0102, 0x01 },
    { 0x0112, 0x02 },
    { 0x0113, 0x09 },
    { 0x0114, 0x3E },
    { 0x0115, 0x18 },
    { 0x0117, 0x01 },
    { 0x0118, 0x09 },
    { 0x0119, 0x3B },
    { 0x011A, 0x28 },
    { 0x013F, 0x00 },
    { 0x0140, 0x00 },
    { 0x0141, 0x40 },
    { 0x0142, 0xFF },
    { 0x0206, 0x00 },
    { 0x0208, 0x00 },
    { 0x0209, 0x00 },
    { 0x020A, 0x00 },
    { 0x020B, 0x00 },
    { 0x020C, 0x00 },
    { 0x020D, 0x00 },
    { 0x020E, 0x00 },
    { 0x020F, 0x00 },
    { 0x0210, 0x00 },
    { 0x0211, 0x00 },
    { 0x0212, 0x0E },
    { 0x0213, 0x00 },
    { 0x0214, 0x00 },
    { 0x0215, 0x00 },
    { 0x0216, 0x00 },
    { 0x0217, 0x00 },
    { 0x0218, 0x01 },
    { 0x0219, 0x00 },
    { 0x021A, 0x00 },
    { 0x021B, 0x00 },
    { 0x021C, 0x00 },
    { 0x021D, 0x00 },
    { 0x021E, 0x00 },
    { 0x021F, 0x00 },
    { 0x0220, 0x00 },
    { 0x0221, 0x00 },
    { 0x0222, 0x00 },
    { 0x0223, 0x00 },
    { 0x0224, 0x00 },
    { 0x0225, 0x00 },
    { 0x0226, 0x00 },
    { 0x0227, 0x00 },
    { 0x0228, 0x00 },
    { 0x0229, 0x00 },
    { 0x022A, 0x00 },
    { 0x022B, 0x00 },
    { 0x022C, 0x00 },
    { 0x022D, 0x00 },
    { 0x022E, 0x00 },
    { 0x022F, 0x00 },
    { 0x0231, 0x0B },
    { 0x0232, 0x0B },
    { 0x0233, 0x0B },
    { 0x0234, 0x0B },
    { 0x0235, 0x00 },
    { 0x0236, 0x00 },
    { 0x0237, 0x80 },
    { 0x0238, 0x14 },
    { 0x0239, 0xC1 },
    { 0x023A, 0x00 },
    { 0x023B, 0x00 },
    { 0x023C, 0x00 },
    { 0x023D, 0x00 },
    { 0x023E, 0xC8 },
    { 0x0250, 0x01 },
    { 0x0251, 0x00 },
    { 0x0252, 0x00 },
    { 0x0253, 0x00 },
    { 0x0254, 0x00 },
    { 0x0255, 0x00 },
    { 0x026B, 0x44 },
    { 0x026C, 0x54 },
    { 0x026D, 0x41 },
    { 0x026E, 0x2D },
    { 0x026F, 0x32 },
    { 0x0270, 0x31 },
    { 0x0271, 0x37 },
    { 0x0272, 0x35 },
    { 0x028A, 0x00 },
    { 0x028B, 0x00 },
    { 0x028C, 0x00 },
    { 0x028D, 0x00 },
    { 0x028E, 0x00 },
    { 0x028F, 0x00 },
    { 0x0290, 0x00 },
    { 0x0291, 0x00 },
    { 0x0292, 0x3F },
    { 0x0293, 0x2F },
    { 0x0294, 0xB0 },
    { 0x0296, 0x02 },
    { 0x0297, 0x02 },
    { 0x0299, 0x02 },
    { 0x029D, 0xD0 },
    { 0x029E, 0x01 },
    { 0x029F, 0x00 },
    { 0x02A9, 0xCC },
    { 0x02AA, 0x04 },
    { 0x02AB, 0x00 },
    { 0x02B7, 0xFF },
    { 0x02BC, 0x00 },
    { 0x0302, 0x00 },
    { 0x0303, 0x00 },
    { 0x0304, 0x80 },
    { 0x0305, 0x8D },
    { 0x0306, 0x11 },
    { 0x0307, 0x00 },
    { 0x0308, 0x00 },
    { 0x0309, 0x00 },
    { 0x030A, 0x00 },
    { 0x030B, 0xC8 },
    { 0x030C, 0x00 },
    { 0x030D, 0x00 },
    { 0x030E, 0x00 },
    { 0x030F, 0x00 },
    { 0x0310, 0x00 },
    { 0x0311, 0x00 },
    { 0x0312, 0x00 },
    { 0x0313, 0x00 },
    { 0x0314, 0x00 },
    { 0x0315, 0x00 },
    { 0x0316, 0x00 },
    { 0x0317, 0x00 },
    { 0x0338, 0x00 },
    { 0x0339, 0x1F },
    { 0x033B, 0x01 },
    { 0x033C, 0x00 },
    { 0x033D, 0x00 },
    { 0x033E, 0x00 },
    { 0x033F, 0x00 },
    { 0x0340, 0x00 },
    { 0x0341, 0x00 },
    { 0x0342, 0x00 },
    { 0x0343, 0x00 },
    { 0x0344, 0x00 },
    { 0x0345, 0x00 },
    { 0x0346, 0x00 },
    { 0x0359, 0x00 },
    { 0x035A, 0x00 },
    { 0x035B, 0x00 },
    { 0x035C, 0x00 },
    { 0x0487, 0x00 },
    { 0x0508, 0x13 },
    { 0x0509, 0x22 },
    { 0x050A, 0x0C },
    { 0x050B, 0x0B },
    { 0x050C, 0x07 },
    { 0x050D, 0x3F },
    { 0x050E, 0x16 },
    { 0x050F, 0x2A },
    { 0x0510, 0x09 },
    { 0x0511, 0x08 },
    { 0x0512, 0x07 },
    { 0x0513, 0x3F },
    { 0x0515, 0x00 },
    { 0x0516, 0x00 },
    { 0x0517, 0x80 },
    { 0x0518, 0x8F },
    { 0x0519, 0x47 },
    { 0x051A, 0x05 },
    { 0x051B, 0x00 },
    { 0x051C, 0x00 },
    { 0x051D, 0x00 },
    { 0x051E, 0x00 },
    { 0x051F, 0xFA },
    { 0x0521, 0x3B },
    { 0x052A, 0x03 },
    { 0x052B, 0x01 },
    { 0x052C, 0x87 },
    { 0x052D, 0x03 },
    { 0x052E, 0x19 },
    { 0x052F, 0x19 },
    { 0x0531, 0x00 },
    { 0x0532, 0x61 },
    { 0x0533, 0x03 },
    { 0x0534, 0x00 },
    { 0x0535, 0x00 },
    { 0x0536, 0x04 },
    { 0x0537, 0x00 },
    { 0x0538, 0x00 },
    { 0x0539, 0x00 },
    { 0x053A, 0x01 },
    { 0x053B, 0x03 },
    { 0x053C, 0x00 },
    { 0x053D, 0x04 },
    { 0x053E, 0x02 },
    { 0x0588, 0x07 },
    { 0x0589, 0x0D },
    { 0x058A, 0x00 },
    { 0x058B, 0xD9 },
    { 0x058C, 0x4A },
    { 0x058D, 0x00 },
    { 0x059B, 0x7A },
    { 0x059C, 0x8C },
    { 0x059D, 0x13 },
    { 0x059E, 0x24 },
    { 0x059F, 0x0C },
    { 0x05A0, 0x0B },
    { 0x05A1, 0x07 },
    { 0x05A2, 0x3F },
    { 0x05A4, 0x08 },
    { 0x05A5, 0x00 },
    { 0x05A6, 0x03 },
    { 0x05AC, 0x09 },
    { 0x05AD, 0x44 },
    { 0x05AE, 0x3F },
    { 0x05B1, 0x97 },
    { 0x05B2, 0x02 },
    { 0x0802, 0x35 },
    { 0x0803, 0x05 },
    { 0x0804, 0x00 },
    { 0x0805, 0x00 },
    { 0x0806, 0x00 },
    { 0x0807, 0x00 },
    { 0x0808, 0x00 },
    { 0x0809, 0x00 },
    { 0x080A, 0x00 },
    { 0x080B, 0x00 },
    { 0x080C, 0x00 },
    { 0x080D, 0x00 },
    { 0x080E, 0x00 },
    { 0x080F, 0x00 },
    { 0x0810, 0x00 },
    { 0x0811, 0x00 },
    { 0x0812, 0x00 },
    { 0x0813, 0x00 },
    { 0x0814, 0x00 },
    { 0x0815, 0x00 },
    { 0x0816, 0x00 },
    { 0x0817, 0x00 },
    { 0x0818, 0x00 },
    { 0x0819, 0x00 },
    { 0x081A, 0x00 },
    { 0x081B, 0x00 },
    { 0x081C, 0x00 },
    { 0x081D, 0x00 },
    { 0x081E, 0x00 },
    { 0x081F, 0x00 },
    { 0x0820, 0x00 },
    { 0x0821, 0x00 },
    { 0x0822, 0x00 },
    { 0x0823, 0x00 },
    { 0x0824, 0x00 },
    { 0x0825, 0x00 },
    { 0x0826, 0x00 },
    { 0x0827, 0x00 },
    { 0x0828, 0x00 },
    { 0x0829, 0x00 },
    { 0x082A, 0x00 },
    { 0x082B, 0x00 },
    { 0x082C, 0x00 },
    { 0x082D, 0x00 },
    { 0x082E, 0x00 },
    { 0x082F, 0x00 },
    { 0x0830, 0x00 },
    { 0x0831, 0x00 },
    { 0x0832, 0x00 },
    { 0x0833, 0x00 },
    { 0x0834, 0x00 },
    { 0x0835, 0x00 },
    { 0x0836, 0x00 },
    { 0x0837, 0x00 },
    { 0x0838, 0x00 },
    { 0x0839, 0x00 },
    { 0x083A, 0x00 },
    { 0x083B, 0x00 },
    { 0x083C, 0x00 },
    { 0x083D, 0x00 },
    { 0x083E, 0x00 },
    { 0x083F, 0x00 },
    { 0x0840, 0x00 },
    { 0x0841, 0x00 },
    { 0x0842, 0x00 },
    { 0x0843, 0x00 },
    { 0x0844, 0x00 },
    { 0x0845, 0x00 },
    { 0x0846, 0x00 },
    { 0x0847, 0x00 },
    { 0x0848, 0x00 },
    { 0x0849, 0x00 },
    { 0x084A, 0x00 },
    { 0x084B, 0x00 },
    { 0x084C, 0x00 },
    { 0x084D, 0x00 },
    { 0x084E, 0x00 },
    { 0x084F, 0x00 },
    { 0x0850, 0x00 },
    { 0x0851, 0x00 },
    { 0x0852, 0x00 },
    { 0x0853, 0x00 },
    { 0x0854, 0x00 },
    { 0x0855, 0x00 },
    { 0x0856, 0x00 },
    { 0x0857, 0x00 },
    { 0x0858, 0x00 },
    { 0x0859, 0x00 },
    { 0x085A, 0x00 },
    { 0x085B, 0x00 },
    { 0x085C, 0x00 },
    { 0x085D, 0x00 },
    { 0x085E, 0x00 },
    { 0x085F, 0x00 },
    { 0x0860, 0x00 },
    { 0x0861, 0x00 },
    { 0x090E, 0x02 },
    { 0x0943, 0x00 },
    { 0x0949, 0x02 },
    { 0x094A, 0x02 },
    { 0x094E, 0x49 },
    { 0x094F, 0xF2 },
    { 0x095E, 0x00 },
    { 0x0A02, 0x00 },
    { 0x0A03, 0x01 },
    { 0x0A04, 0x00 },
    { 0x0A05, 0x01 },
    { 0x0A14, 0x00 },
    { 0x0A1A, 0x00 },
    { 0x0A38, 0x00 },
    { 0x0A39, 0x00 },
    { 0x0A3A, 0x00 },
    { 0x0A3C, 0x00 },
    { 0x0A3D, 0x00 },
    { 0x0A3E, 0x00 },
    { 0x0A4C, 0x00 },
    { 0x0A4D, 0x00 },
    { 0x0A4E, 0x00 },
    { 0x0A4F, 0x00 },
    { 0x0A50, 0x00 },
    { 0x0A51, 0x00 },
    { 0x0A52, 0x00 },
    { 0x0A53, 0x00 },
    { 0x0B44, 0x0F },
    { 0x0B46, 0x00 },
    { 0x0B47, 0x0D },
    { 0x0B48, 0x0D },
    { 0x0B4A, 0x02 },
    { 0x0B57, 0xF0 },
    { 0x0B58, 0x00 },
    { 0x0C02, 0x03 },
    { 0x0C03, 0x02 },
    { 0x0C07, 0x01 },
    { 0x0C08, 0x01 },

};


// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ SI5392 Dual SDI clock +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// SI5392 dual clock configuration. 
// Used for the DTA-2131B.
// 54MHz XTAL input, DCO-mode; In1: 27MHz; Out0: 40MHz and Out1: 24MHz
//

// Properties
static const DtDfSi534XClockProps SI5392_CONFIG_CLOCK_PROPS_DTA2131B_LIKE[2] =
{
    { 0,                                                // Clock output port index 0
      DT_DF_SI534X_CLK_NON_FRACTIONAL,                  // Non-fractional clock
      0,                                                // Steps: 0/N0_NUM
      0,                                                // Range: +/- 0ppm
      40*SI534X_EXP12                                   // Freq: 40MHz
    },
    { 1,                                                // Clock output port index 1
      DT_DF_SI534X_CLK_NON_FRACTIONAL,                  // Non-fractional clock
      0,                                                // Steps: 0/N1_NUM
      0,                                                // Range: +/- 0ppm
      24*SI534X_EXP12                                   // Freq: 24MHz
    },
};

// Design Report
//
// Overview
// ========
// Part:               Si5392ABCD Rev A
// Project File:       Si5392-Rev0-DTA-2131B-Project.slabtimeproj
// Design ID:          DTA-2131
// Created By:         ClockBuilder Pro v4.7 [2022-11-18]
// Timestamp:          2022-12-07 13:45:15 GMT+01:00
// 
// Design Rule Check
// =================
// Errors:
// - No errors
// 
// Warnings:
// - No warnings
// 
// Notes:
// - You have selected CMOS output. Please review AN862 "Optimizing Jitter
//   Performance in Next Generation Internet Infrastructure Systems" to ensure
//   your configuration meets your jitter requirements
// 
// Device Grade
// ============
// Maximum Output Frequency: 40 MHz
// Frequency Synthesis Mode: Integer
// Frequency Plan Grade:     D
// Minimum Base OPN:         Si5392D*
// 
// Base       Output Clock         Supported Frequency Synthesis Modes
// OPN Grade  Frequency Range      (Typical Jitter)
// ---------  -------------------  --------------------------------------------
// Si5392A    100 Hz to 1.028 GHz  Integer (< 100 fs) and fractional (< 150 fs)
// Si5392B    100 Hz to 350 MHz    "
// Si5392C    100 Hz to 1.028 GHz  Integer only (< 100 fs)
// Si5392D*   100 Hz to 350 MHz    "
// 
// * Based on your calculated frequency plan, a Si5392D grade device is
// sufficient for your design. For more in-system configuration flexibility
// (higher frequencies and/or to enable fractional synthesis), consider
// selecting device grade Si5392A when specifying an ordering part number (OPN)
// for your application. See the datasheet Ordering Guide for more information.
// 
// Design
// ======
// Host Interface:
//    I/O Power Supply: VDD (Core)
//    SPI Mode: 4-Wire
//    I2C Address Range: 104d to 107d / 0x68 to 0x6B (selected via A0/A1 pins)
// 
// External Reference:
//    54 MHz (XTAL - Crystal)
// 
// Inputs:
//     IN0: Unused
//     IN1: 27 MHz
//          Standard Differential and Single-ended
//     IN2: Unused
//     IN3: Unused
// 
// Outputs:
//    OUT0: 40 MHz
//          Enabled, LVDS 1.8 V
//    OUT1: 24 MHz
//          Enabled, LVCMOS In-Phase 1.8 V 31 ?
// 
// Frequency Plan
// ==============
// Priority: OUT0 is lowest jitter output
// 
// Fvco = 13.44 GHz
// Fpfd = 1.5 MHz
// Fms0 = 480 MHz
// 
// P dividers:
//    P0  = Unused
//    P1  = 18
//    P2  = Unused
//    P3  = Unused
//    Pxaxb = 1
// 
// MXAXB = 248.8888888888888888... [ 248 + 8/9 ]
// M = 1792
// N dividers:
//    N0:
//       Value: 28
//       OUT0: 40 MHz
//       OUT1: 24 MHz
//    N1:
//       Unused
// 
// R dividers:
//    R0 = 12
//    R1 = 20
// 
// Nominal Bandwidth:
//   Desired: 100.000 Hz
//   Actual:  72.650 Hz
//   Coefficients:
//      BW0:  19
//      BW1:  34
//      BW2:  12
//      BW3:  11
//      BW4:  7
//      BW5:  63
// Fastlock Bandwidth:
//   Desired: 1.000 kHz
//   Actual:  1.165 kHz
//   Coefficients:
//      BW0:  23
//      BW1:  44
//      BW2:  8
//      BW3:  7
//      BW4:  7
//      BW5:  63
// Holdover Bandwidth:
//    N/A (Ramped Exit from Holdover)
// 
// Dividers listed above show effective values. These values are translated to register settings by ClockBuilder Pro. For the actual register values, see below. Refer to the Family Reference Manual for information on registers related to frequency plan.
// 
// Hitless Input Switching Assistant
// =================================
// Assistant Disabled
// 
// Digitally Controlled Oscillator (DCO)
// =====================================
// Mode: FINC/FDEC
// 
// N0: DCO Disabled
// 
// N1: DCO Disabled
// 
// Input/Output Skew Control
// =========================
// N0: 28
// 
//    OUT0  40 MHz
//    OUT1  24 MHz
// 
//    Desired Dynamic Skew Step:  0.000 ps
//    Actual Dynamic Skew Step:   0 ps
//    N0_PHASE_STEP:                 0x0 0d
//    N0_PHASE_COUNT:                0x0 0d
// 
//    Use N0_PHASE_INC and N0_PHASE_DEC to perform phase step.
// 
// N1 Not Used
// 

// Register settings
static const DtDfSi534XRegister SI5392_CONFIG_CLOCK_DTA2131B_LIKE[] =
{
    { 0x0006, 0x00 },
    { 0x0007, 0x00 },
    { 0x0008, 0x00 },
    { 0x000B, 0x68 },
    { 0x0016, 0x02 },
    { 0x0017, 0xDC },
    { 0x0018, 0xDD },
    { 0x0019, 0xDD },
    { 0x001A, 0xDF },
    { 0x002B, 0x02 },
    { 0x002C, 0x02 },
    { 0x002D, 0x00 },
    { 0x002E, 0x00 },
    { 0x002F, 0x00 },
    { 0x0030, 0x48 },
    { 0x0031, 0x00 },
    { 0x0032, 0x00 },
    { 0x0033, 0x00 },
    { 0x0034, 0x00 },
    { 0x0035, 0x00 },
    { 0x0036, 0x00 },
    { 0x0037, 0x00 },
    { 0x0038, 0x02 },
    { 0x0039, 0x00 },
    { 0x003A, 0x00 },
    { 0x003B, 0x00 },
    { 0x003C, 0x00 },
    { 0x003D, 0x00 },
    { 0x003E, 0x20 },
    { 0x003F, 0x22 },
    { 0x0040, 0x01 },
    { 0x0041, 0x00 },
    { 0x0042, 0x0B },
    { 0x0043, 0x00 },
    { 0x0044, 0x00 },
    { 0x0045, 0x0C },
    { 0x0046, 0x00 },
    { 0x0047, 0x32 },
    { 0x0048, 0x00 },
    { 0x0049, 0x00 },
    { 0x004A, 0x00 },
    { 0x004B, 0x32 },
    { 0x004C, 0x00 },
    { 0x004D, 0x00 },
    { 0x004E, 0x50 },
    { 0x004F, 0x00 },
    { 0x0050, 0x0F },
    { 0x0051, 0x00 },
    { 0x0052, 0x03 },
    { 0x0053, 0x00 },
    { 0x0054, 0x00 },
    { 0x0055, 0x00 },
    { 0x0056, 0x03 },
    { 0x0057, 0x00 },
    { 0x0058, 0x00 },
    { 0x0059, 0x04 },
    { 0x005A, 0x00 },
    { 0x005B, 0x00 },
    { 0x005C, 0x00 },
    { 0x005D, 0x00 },
    { 0x005E, 0x00 },
    { 0x005F, 0x00 },
    { 0x0060, 0x00 },
    { 0x0061, 0x01 },
    { 0x0062, 0x00 },
    { 0x0063, 0x00 },
    { 0x0064, 0x00 },
    { 0x0065, 0x00 },
    { 0x0066, 0x00 },
    { 0x0067, 0x00 },
    { 0x0068, 0x00 },
    { 0x0069, 0x00 },
    { 0x0092, 0x02 },
    { 0x0093, 0xA0 },
    { 0x0095, 0x00 },
    { 0x0096, 0x80 },
    { 0x0098, 0x60 },
    { 0x009A, 0x02 },
    { 0x009B, 0x60 },
    { 0x009D, 0x04 },
    { 0x009E, 0x40 },
    { 0x00A0, 0x20 },
    { 0x00A2, 0x00 },
    { 0x00A9, 0xD1 },
    { 0x00AA, 0x31 },
    { 0x00AB, 0x00 },
    { 0x00AC, 0x00 },
    { 0x00E5, 0x00 },
    { 0x00EA, 0x05 },
    { 0x00EB, 0x30 },
    { 0x00EC, 0x00 },
    { 0x00ED, 0x00 },
    { 0x0102, 0x01 },
    { 0x0112, 0x02 },
    { 0x0113, 0x09 },
    { 0x0114, 0x3E },
    { 0x0115, 0x18 },
    { 0x0117, 0x02 },
    { 0x0118, 0xCC },
    { 0x0119, 0x00 },
    { 0x011A, 0x18 },
    { 0x013F, 0x00 },
    { 0x0140, 0x00 },
    { 0x0141, 0x40 },
    { 0x0142, 0xFF },
    { 0x0206, 0x00 },
    { 0x0208, 0x00 },
    { 0x0209, 0x00 },
    { 0x020A, 0x00 },
    { 0x020B, 0x00 },
    { 0x020C, 0x00 },
    { 0x020D, 0x00 },
    { 0x020E, 0x00 },
    { 0x020F, 0x00 },
    { 0x0210, 0x00 },
    { 0x0211, 0x00 },
    { 0x0212, 0x12 },
    { 0x0213, 0x00 },
    { 0x0214, 0x00 },
    { 0x0215, 0x00 },
    { 0x0216, 0x00 },
    { 0x0217, 0x00 },
    { 0x0218, 0x01 },
    { 0x0219, 0x00 },
    { 0x021A, 0x00 },
    { 0x021B, 0x00 },
    { 0x021C, 0x00 },
    { 0x021D, 0x00 },
    { 0x021E, 0x00 },
    { 0x021F, 0x00 },
    { 0x0220, 0x00 },
    { 0x0221, 0x00 },
    { 0x0222, 0x00 },
    { 0x0223, 0x00 },
    { 0x0224, 0x00 },
    { 0x0225, 0x00 },
    { 0x0226, 0x00 },
    { 0x0227, 0x00 },
    { 0x0228, 0x00 },
    { 0x0229, 0x00 },
    { 0x022A, 0x00 },
    { 0x022B, 0x00 },
    { 0x022C, 0x00 },
    { 0x022D, 0x00 },
    { 0x022E, 0x00 },
    { 0x022F, 0x00 },
    { 0x0231, 0x0B },
    { 0x0232, 0x0B },
    { 0x0233, 0x0B },
    { 0x0234, 0x0B },
    { 0x0235, 0x00 },
    { 0x0236, 0x00 },
    { 0x0237, 0x00 },
    { 0x0238, 0x00 },
    { 0x0239, 0x8C },
    { 0x023A, 0x00 },
    { 0x023B, 0x00 },
    { 0x023C, 0x00 },
    { 0x023D, 0x00 },
    { 0x023E, 0x90 },
    { 0x0250, 0x05 },
    { 0x0251, 0x00 },
    { 0x0252, 0x00 },
    { 0x0253, 0x09 },
    { 0x0254, 0x00 },
    { 0x0255, 0x00 },
    { 0x026B, 0x44 },
    { 0x026C, 0x54 },
    { 0x026D, 0x41 },
    { 0x026E, 0x2D },
    { 0x026F, 0x32 },
    { 0x0270, 0x31 },
    { 0x0271, 0x33 },
    { 0x0272, 0x31 },
    { 0x028A, 0x00 },
    { 0x028B, 0x00 },
    { 0x028C, 0x00 },
    { 0x028D, 0x00 },
    { 0x028E, 0x00 },
    { 0x028F, 0x00 },
    { 0x0290, 0x00 },
    { 0x0291, 0x00 },
    { 0x0292, 0x3F },
    { 0x0293, 0x2F },
    { 0x0294, 0xC0 },
    { 0x0296, 0x02 },
    { 0x0297, 0x02 },
    { 0x0299, 0x02 },
    { 0x029D, 0x19 },
    { 0x029E, 0x01 },
    { 0x029F, 0x00 },
    { 0x02A9, 0x66 },
    { 0x02AA, 0x02 },
    { 0x02AB, 0x00 },
    { 0x02B7, 0xFF },
    { 0x02BC, 0x00 },
    { 0x0302, 0x00 },
    { 0x0303, 0x00 },
    { 0x0304, 0x00 },
    { 0x0305, 0x00 },
    { 0x0306, 0x0E },
    { 0x0307, 0x00 },
    { 0x0308, 0x00 },
    { 0x0309, 0x00 },
    { 0x030A, 0x00 },
    { 0x030B, 0x80 },
    { 0x030C, 0x00 },
    { 0x030D, 0x00 },
    { 0x030E, 0x00 },
    { 0x030F, 0x00 },
    { 0x0310, 0x00 },
    { 0x0311, 0x00 },
    { 0x0312, 0x00 },
    { 0x0313, 0x00 },
    { 0x0314, 0x00 },
    { 0x0315, 0x00 },
    { 0x0316, 0x00 },
    { 0x0317, 0x00 },
    { 0x0338, 0x00 },
    { 0x0339, 0x1F },
    { 0x033B, 0x00 },
    { 0x033C, 0x00 },
    { 0x033D, 0x00 },
    { 0x033E, 0x00 },
    { 0x033F, 0x00 },
    { 0x0340, 0x00 },
    { 0x0341, 0x00 },
    { 0x0342, 0x00 },
    { 0x0343, 0x00 },
    { 0x0344, 0x00 },
    { 0x0345, 0x00 },
    { 0x0346, 0x00 },
    { 0x0359, 0x00 },
    { 0x035A, 0x00 },
    { 0x035B, 0x00 },
    { 0x035C, 0x00 },
    { 0x0487, 0x00 },
    { 0x0508, 0x13 },
    { 0x0509, 0x22 },
    { 0x050A, 0x0C },
    { 0x050B, 0x0B },
    { 0x050C, 0x07 },
    { 0x050D, 0x3F },
    { 0x050E, 0x17 },
    { 0x050F, 0x2C },
    { 0x0510, 0x08 },
    { 0x0511, 0x07 },
    { 0x0512, 0x07 },
    { 0x0513, 0x3F },
    { 0x0515, 0x00 },
    { 0x0516, 0x00 },
    { 0x0517, 0x00 },
    { 0x0518, 0x00 },
    { 0x0519, 0x80 },
    { 0x051A, 0x03 },
    { 0x051B, 0x00 },
    { 0x051C, 0x00 },
    { 0x051D, 0x00 },
    { 0x051E, 0x00 },
    { 0x051F, 0x80 },
    { 0x0521, 0x2B },
    { 0x052A, 0x03 },
    { 0x052B, 0x01 },
    { 0x052C, 0x87 },
    { 0x052D, 0x03 },
    { 0x052E, 0x19 },
    { 0x052F, 0x19 },
    { 0x0531, 0x00 },
    { 0x0532, 0x58 },
    { 0x0533, 0x04 },
    { 0x0534, 0x00 },
    { 0x0535, 0x00 },
    { 0x0536, 0x04 },
    { 0x0537, 0x00 },
    { 0x0538, 0x00 },
    { 0x0539, 0x00 },
    { 0x053A, 0x01 },
    { 0x053B, 0x03 },
    { 0x053C, 0x00 },
    { 0x053D, 0x04 },
    { 0x053E, 0x02 },
    { 0x0588, 0x07 },
    { 0x0589, 0x0F },
    { 0x058A, 0x00 },
    { 0x058B, 0xA6 },
    { 0x058C, 0x50 },
    { 0x058D, 0x00 },
    { 0x059B, 0x78 },
    { 0x059C, 0x8C },
    { 0x059D, 0x13 },
    { 0x059E, 0x24 },
    { 0x059F, 0x0C },
    { 0x05A0, 0x0B },
    { 0x05A1, 0x07 },
    { 0x05A2, 0x3F },
    { 0x05A4, 0x08 },
    { 0x05A5, 0x00 },
    { 0x05A6, 0x03 },
    { 0x05AC, 0x09 },
    { 0x05AD, 0xB7 },
    { 0x05AE, 0x3F },
    { 0x05B1, 0x9C },
    { 0x05B2, 0x02 },
    { 0x0802, 0x35 },
    { 0x0803, 0x05 },
    { 0x0804, 0x00 },
    { 0x0805, 0x00 },
    { 0x0806, 0x00 },
    { 0x0807, 0x00 },
    { 0x0808, 0x00 },
    { 0x0809, 0x00 },
    { 0x080A, 0x00 },
    { 0x080B, 0x00 },
    { 0x080C, 0x00 },
    { 0x080D, 0x00 },
    { 0x080E, 0x00 },
    { 0x080F, 0x00 },
    { 0x0810, 0x00 },
    { 0x0811, 0x00 },
    { 0x0812, 0x00 },
    { 0x0813, 0x00 },
    { 0x0814, 0x00 },
    { 0x0815, 0x00 },
    { 0x0816, 0x00 },
    { 0x0817, 0x00 },
    { 0x0818, 0x00 },
    { 0x0819, 0x00 },
    { 0x081A, 0x00 },
    { 0x081B, 0x00 },
    { 0x081C, 0x00 },
    { 0x081D, 0x00 },
    { 0x081E, 0x00 },
    { 0x081F, 0x00 },
    { 0x0820, 0x00 },
    { 0x0821, 0x00 },
    { 0x0822, 0x00 },
    { 0x0823, 0x00 },
    { 0x0824, 0x00 },
    { 0x0825, 0x00 },
    { 0x0826, 0x00 },
    { 0x0827, 0x00 },
    { 0x0828, 0x00 },
    { 0x0829, 0x00 },
    { 0x082A, 0x00 },
    { 0x082B, 0x00 },
    { 0x082C, 0x00 },
    { 0x082D, 0x00 },
    { 0x082E, 0x00 },
    { 0x082F, 0x00 },
    { 0x0830, 0x00 },
    { 0x0831, 0x00 },
    { 0x0832, 0x00 },
    { 0x0833, 0x00 },
    { 0x0834, 0x00 },
    { 0x0835, 0x00 },
    { 0x0836, 0x00 },
    { 0x0837, 0x00 },
    { 0x0838, 0x00 },
    { 0x0839, 0x00 },
    { 0x083A, 0x00 },
    { 0x083B, 0x00 },
    { 0x083C, 0x00 },
    { 0x083D, 0x00 },
    { 0x083E, 0x00 },
    { 0x083F, 0x00 },
    { 0x0840, 0x00 },
    { 0x0841, 0x00 },
    { 0x0842, 0x00 },
    { 0x0843, 0x00 },
    { 0x0844, 0x00 },
    { 0x0845, 0x00 },
    { 0x0846, 0x00 },
    { 0x0847, 0x00 },
    { 0x0848, 0x00 },
    { 0x0849, 0x00 },
    { 0x084A, 0x00 },
    { 0x084B, 0x00 },
    { 0x084C, 0x00 },
    { 0x084D, 0x00 },
    { 0x084E, 0x00 },
    { 0x084F, 0x00 },
    { 0x0850, 0x00 },
    { 0x0851, 0x00 },
    { 0x0852, 0x00 },
    { 0x0853, 0x00 },
    { 0x0854, 0x00 },
    { 0x0855, 0x00 },
    { 0x0856, 0x00 },
    { 0x0857, 0x00 },
    { 0x0858, 0x00 },
    { 0x0859, 0x00 },
    { 0x085A, 0x00 },
    { 0x085B, 0x00 },
    { 0x085C, 0x00 },
    { 0x085D, 0x00 },
    { 0x085E, 0x00 },
    { 0x085F, 0x00 },
    { 0x0860, 0x00 },
    { 0x0861, 0x00 },
    { 0x090E, 0x02 },
    { 0x0943, 0x00 },
    { 0x0949, 0x02 },
    { 0x094A, 0x02 },
    { 0x094E, 0x49 },
    { 0x094F, 0xF2 },
    { 0x095E, 0x00 },
    { 0x0A02, 0x00 },
    { 0x0A03, 0x01 },
    { 0x0A04, 0x01 },
    { 0x0A05, 0x01 },
    { 0x0A14, 0x00 },
    { 0x0A1A, 0x00 },
    { 0x0A38, 0x00 },
    { 0x0A39, 0x00 },
    { 0x0A3A, 0x00 },
    { 0x0A3C, 0x00 },
    { 0x0A3D, 0x00 },
    { 0x0A3E, 0x00 },
    { 0x0A4C, 0x00 },
    { 0x0A4D, 0x00 },
    { 0x0A4E, 0x00 },
    { 0x0A4F, 0x00 },
    { 0x0A50, 0x00 },
    { 0x0A51, 0x00 },
    { 0x0A52, 0x00 },
    { 0x0A53, 0x00 },
    { 0x0B44, 0x2F },
    { 0x0B46, 0x00 },
    { 0x0B47, 0x0D },
    { 0x0B48, 0x0D },
    { 0x0B4A, 0x02 },
    { 0x0B57, 0xF0 },
    { 0x0B58, 0x00 },
    { 0x0C02, 0x03 },
    { 0x0C03, 0x02 },
    { 0x0C07, 0x01 },
    { 0x0C08, 0x01 }
};