// #*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcSPIM_RegAccess.h *#*#*#*#*#*#*#*#* (C) 2023 DekTec
//
// Device driver - SpiMaster v7 (SPIM) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block SpiMaster.
// These functions should solely be used by the block controller for SpiMaster.
//
// 2023.03.01 14:11 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND.

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2022 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN No EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//
// 1. Getting fields 'WordSize' and 'TransferMode' from register 'Config3':
//      UInt32 Reg_Config3, WordSize, TransferMode;
//      Reg_Config3  = SPIM_Config3_READ(Bc);
//      WordSize     = SPIM_Config3_GET_WordSize(Reg_Config3);
//      TransferMode = SPIM_Config3_GET_TransferMode(Reg_Config3);
//
// 2. Single-function shorthand for reading field 'IsBusy' from register 'Status':
//      UInt32  IsBusy = SPIM_Status_READ_IsBusy(Bc);
//
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

// +=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// SPIM_Config1_READ_DeviceId
// SPIM_Config2_READ_SpiClockRate
// SPIM_Config3_GET_MaxTransferTime
// SPIM_Config3_GET_TransferMode
// SPIM_Config3_GET_WordSize
// SPIM_Config3_READ
// SPIM_Config3_READ_MaxTransferTime
// SPIM_Config3_READ_TransferMode
// SPIM_Config3_READ_WordSize
// SPIM_Control_READ
// SPIM_Control_SET_ContinueTransfer
// SPIM_Control_SET_StartTransfer
// SPIM_Control_SET_TransferDirection
// SPIM_Control_WRITE
// SPIM_ReceiveData_READ
// SPIM_Status_GET_IsBusy
// SPIM_Status_GET_IsEnabled
// SPIM_Status_READ
// SPIM_Status_READ_IsBusy
// SPIM_Status_READ_IsEnabled
// SPIM_TransmitData_WRITE

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'ContinueTransfer'
#define SPIM_CONTTF_END             0x0   // SPI transaction is complete
#define SPIM_CONTTF_CONTINUE        0x1   // SPI transaction continues

// Value map 'SpiDeviceId'
#define SPIM_SPIDVC_LMH0394         0x1   // Texas Instruments LMH0394 3G-SDI/ASI receiver
#define SPIM_SPIDVC_GS1661          0x2   // Gennum GS1661 HD-SDI/ASI receiver
#define SPIM_SPIDVC_ADS4246         0x3   // Texas Instruments ADS4246 dual-channel
                                          // 14-bit 160-MSPS ADC
#define SPIM_SPIDVC_AD9642          0x4   // Analog Devices AD9642 14-bit
                                          // 170/210/250-MSPS ADC
#define SPIM_SPIDVC_25AA160C        0x5   // Microchip 25AA160C 16K SPI bus serial EEPROM
#define SPIM_SPIDVC_GS3590          0x6   // Gennum GS3590 3G-SDI/ASI cable
                                          // driver/equalizer
#define SPIM_SPIDVC_25AA640A        0x7   // Microchip 25AA640A 64K SPI bus serial EEPROM
#define SPIM_SPIDVC_GS12090         0x8   // Gennum GS12090 12G-SDI/ASI cable
                                          // driver/equalizer
#define SPIM_SPIDVC_ADC342X         0x9   // Texas Instruments ADC342X quad-channel
                                          // 12-bit 25..125-MSPS ADC
#define SPIM_SPIDVC_RFFC5072        0xA   // Qorvo RFFC5072 wideband synthesizer/VCO with
                                          // 6-GHz RF mixer
#define SPIM_SPIDVC_AD9163          0xB   // Analog Devices AD9163 16-bit 12-GSPS RF DAC
                                          // and digital upconverter
#define SPIM_SPIDVC_LTC6952         0xC   // Analog Devices LTC6952 ultralow jitter
                                          // 4.5-GHz PLL
#define SPIM_SPIDVC_ADS8866         0xD   // Texas Instruments ADS8866 16-bit 100-kSPS ADC
#define SPIM_SPIDVC_AD9628          0xE   // Analog Devices AD9628 12-bit 105-MSPS Dual
                                          // ADC
#define SPIM_SPIDVC_AD9266          0xF   // Analog Devices AD9266 16-bit 80-MSPS ADC
#define SPIM_SPIDVC_SpiRegIfMaster  0x10  // SPI-controlled register-interface master
#define SPIM_SPIDVC_TC72            0x11  // Microchip TC72 Digital Temperature Sensor
#define SPIM_SPIDVC_AD5611          0x12  // Analog Devices AD5611 10-bit NanoDac
#define SPIM_SPIDVC_ADF4360         0x13  // Analog Devices ADF4360 Integrated
                                          // Synthesizer and VCO
#define SPIM_SPIDVC_AD9789          0x14  // Analog Devices AD9789 2400 MSPS RF DAC
#define SPIM_SPIDVC_ADS5562         0x15  // Texas Instruments ADS5562 16-bit 80 MSPS ADCs
#define SPIM_SPIDVC_DAC121S101      0x16  // Texas Instruments DAC121S101 12-bit RRO DAC

// Value map 'TransferDirection'
#define SPIM_TFDIR_SEND             0x0   // Transmit data to device
#define SPIM_TFDIR_RECEIVE          0x1   // Receive data from device

// Value map 'TransferMode'
#define SPIM_TRMODE_FULL_DUPLEX     0x0   // Send and receive simultaneously
#define SPIM_TRMODE_HALF_DUPLEX     0x1   // Send or receive
#define SPIM_TRMODE_SIMPLEX_TX      0x2   // Send only

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// +=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 SPIM_Config1_READ_DeviceId(DtBcSPIM* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 SPIM_Config2_READ_SpiClockRate(DtBcSPIM* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x8);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config3' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 SPIM_Config3_READ(DtBcSPIM* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0xC);
}

// Field GET functions.
static __inline UInt32 SPIM_Config3_GET_WordSize(UInt32 Config3)
{
    return Config3 & 0xFF;
}
static __inline UInt32 SPIM_Config3_GET_TransferMode(UInt32 Config3)
{
    return (Config3 & 0x300) >> 8;
}
static __inline UInt32 SPIM_Config3_GET_MaxTransferTime(UInt32 Config3)
{
    return (Config3 & 0xFFFF0000) >> 16;
}

// Field READ functions.
static __inline UInt32 SPIM_Config3_READ_WordSize(DtBcSPIM* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0xC) & 0xFF;
}
static __inline UInt32 SPIM_Config3_READ_TransferMode(DtBcSPIM* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0xC) & 0x300) >> 8;
}
static __inline UInt32 SPIM_Config3_READ_MaxTransferTime(DtBcSPIM* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0xC) & 0xFFFF0000) >> 16;
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 SPIM_Control_READ(DtBcSPIM* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10);
}

// Field SET functions.
static __inline UInt32 SPIM_Control_SET_StartTransfer(UInt32 Control, UInt32 StartTransfer)
{
    DT_ASSERT((StartTransfer & ~0x1) == 0);
    return (Control & ~0x1) | StartTransfer;
}
static __inline UInt32 SPIM_Control_SET_ContinueTransfer(UInt32 Control, UInt32 ContinueTransfer)
{
    DT_ASSERT((ContinueTransfer & ~0x1) == 0);
    return (Control & ~0x2) | (ContinueTransfer << 1);
}
static __inline UInt32 SPIM_Control_SET_TransferDirection(UInt32 Control, UInt32 TransferDirection)
{
    DT_ASSERT((TransferDirection & ~0x1) == 0);
    return (Control & ~0x4) | (TransferDirection << 2);
}

// Register WRITE function.
static __inline void SPIM_Control_WRITE(DtBcSPIM* Bc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10, Control);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 SPIM_Status_READ(DtBcSPIM* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x14);
}

// Field GET functions.
static __inline UInt32 SPIM_Status_GET_IsEnabled(UInt32 Status)
{
    return Status & 0x1;
}
static __inline UInt32 SPIM_Status_GET_IsBusy(UInt32 Status)
{
    return (Status & 0x2) >> 1;
}

// Field READ functions.
static __inline UInt32 SPIM_Status_READ_IsEnabled(DtBcSPIM* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x14) & 0x1;
}
static __inline UInt32 SPIM_Status_READ_IsBusy(DtBcSPIM* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x14) & 0x2) >> 1;
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TransmitData' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function.
static __inline void SPIM_TransmitData_WRITE(DtBcSPIM* Bc, UInt32 TransmitData)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x18, TransmitData);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'ReceiveData' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 SPIM_ReceiveData_READ(DtBcSPIM* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1C);
}

