//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcSDITXP_RegAccess.h *#*#*#*#*#*#*#*# (C) 2019 DekTec
//
// Device driver - SdiTxProtocol v1 (SDITXP) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block SdiTxProtocol.
// These functions should solely be used by the block controller for SdiTxProtocol.
//
// 2019.03.06 11:21 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Single-function shorthand for reading field 'MaxSdiRate' from register 'Config':
//      UInt32  MaxSdiRate = SDITXP_Config_READ_MaxSdiRate(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// SDITXP_Config_GET_MaxSdiRate
// SDITXP_Config_READ
// SDITXP_Config_READ_MaxSdiRate
// SDITXP_Control_READ
// SDITXP_Control_SET_AdpChecksumEnable
// SDITXP_Control_SET_BlockEnable
// SDITXP_Control_SET_ClampEnable
// SDITXP_Control_SET_LevelA2BEnable
// SDITXP_Control_SET_LineCrcEnable
// SDITXP_Control_SET_OperationalMode
// SDITXP_Control_SET_SdiRate
// SDITXP_Control_WRITE
// SDITXP_NumSymClamped_READ

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'OperationalMode'
#define SDITXP_OPMODE_IDLE      0x0  // Block is inactive
#define SDITXP_OPMODE_STANDBY   0x1  // Block is partially operational
#define SDITXP_OPMODE_RUN       0x2  // Block performs its normal function

// Value map 'SdiRate'
#define SDITXP_SDIMODE_SD       0x0  // SDI mode is SD-SDI
#define SDITXP_SDIMODE_HD       0x1  // SDI mode is HD-SDI
#define SDITXP_SDIMODE_3G       0x2  // SDI mode is 3G-SDI
#define SDITXP_SDIMODE_6G       0x3  // SDI mode is 6G-SDI
#define SDITXP_SDIMODE_12G      0x4  // SDI mode is 12G-SDI

// Value map 'BlockEnable'
#define SDITXP_BLKENA_DISABLED  0x0  // Block is entirely disabled
#define SDITXP_BLKENA_ENABLED   0x1  // Block is enabled and processes data

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  SDITXP_Config_READ(DtBcSDITXP* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field GET function
static __inline UInt32  SDITXP_Config_GET_MaxSdiRate(UInt32 Config)
{
    return Config & 0x7;
}

// Field READ function
static __inline UInt32  SDITXP_Config_READ_MaxSdiRate(DtBcSDITXP* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4) & 0x7;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  SDITXP_Control_READ(DtBcSDITXP* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field SET functions
static __inline UInt32  SDITXP_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32  SDITXP_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32  SDITXP_Control_SET_SdiRate(UInt32 Control, UInt32 SdiRate)
{
    DT_ASSERT((SdiRate & ~0x7) == 0);
    return (Control & ~0x70) | (SdiRate << 4);
}
static __inline UInt32  SDITXP_Control_SET_ClampEnable(UInt32 Control, UInt32 ClampEnable)
{
    DT_ASSERT((ClampEnable & ~0x1) == 0);
    return (Control & ~0x80) | (ClampEnable << 7);
}
static __inline UInt32  SDITXP_Control_SET_AdpChecksumEnable(UInt32 Control, UInt32 AdpChecksumEnable)
{
    DT_ASSERT((AdpChecksumEnable & ~0x1) == 0);
    return (Control & ~0x100) | (AdpChecksumEnable << 8);
}
static __inline UInt32  SDITXP_Control_SET_LineCrcEnable(UInt32 Control, UInt32 LineCrcEnable)
{
    DT_ASSERT((LineCrcEnable & ~0x1) == 0);
    return (Control & ~0x200) | (LineCrcEnable << 9);
}
static __inline UInt32  SDITXP_Control_SET_LevelA2BEnable(UInt32 Control, UInt32 LevelA2BEnable)
{
    DT_ASSERT((LevelA2BEnable & ~0x1) == 0);
    return (Control & ~0x400) | (LevelA2BEnable << 10);
}

// Register WRITE function
static __inline void  SDITXP_Control_WRITE(DtBcSDITXP* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x8, Control);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'NumSymClamped' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  SDITXP_NumSymClamped_READ(DtBcSDITXP* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC);
}

