//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcIQUNPCK_RegAccess.h *#*#*#*#*#*#*#* (C) 2021 DekTec
//
// Device driver - IqUnpacker v0 (IQUNPCK) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block IqUnpacker.
// These functions should solely be used by the block controller for IqUnpacker.
//
// 2021.07.01 14:31 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2020 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// IQUNPCK_Control_READ
// IQUNPCK_Control_SET_BlockEnable
// IQUNPCK_Control_SET_OperationalMode
// IQUNPCK_Control_SET_PacketMode
// IQUNPCK_Control_WRITE
// IQUNPCK_IqTimestampCnt_READ
// IQUNPCK_IqTimestampOvfCnt_READ
// IQUNPCK_PacketCnt_READ

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'BlockEnable'
#define IQUNPCK_BLKENA_DISABLED    0x0  // Block is entirely disabled
#define IQUNPCK_BLKENA_ENABLED     0x1  // Block is enabled and processes data

// Value map 'OperationalMode'
#define IQUNPCK_OPMODE_IDLE        0x0  // Block is inactive
#define IQUNPCK_OPMODE_STANDBY     0x1  // Block is partially operational
#define IQUNPCK_OPMODE_RUN         0x2  // Block performs its normal function

// Value map 'PacketMode'
#define IQUNPCK_PCKMODE_IQSAMPLES  0x0  // 32-bit words with 16-bit I+Q sample per word,
                                        // no packets
#define IQUNPCK_PCKMODE_IQPACKETS  0x1  // I/Q samples in packets with timestamps

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IQUNPCK_Control_READ(DtBcIQUNPCK* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field SET functions
static __inline UInt32 IQUNPCK_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32 IQUNPCK_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32 IQUNPCK_Control_SET_PacketMode(UInt32 Control, UInt32 PacketMode)
{
    DT_ASSERT((PacketMode & ~0x3) == 0);
    return (Control & ~0x18) | (PacketMode << 3);
}

// Register WRITE function
static __inline void IQUNPCK_Control_WRITE(DtBcIQUNPCK* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x4, Control);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'PacketCnt' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32 IQUNPCK_PacketCnt_READ(DtBcIQUNPCK* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8) & 0xFFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'IqTimestampCnt' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32 IQUNPCK_IqTimestampCnt_READ(DtBcIQUNPCK* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC) & 0xFFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'IqTimestampOvfCnt' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32 IQUNPCK_IqTimestampOvfCnt_READ(DtBcIQUNPCK* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10) & 0xFFFF;
}

