// #*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcIQAGC_RegAccess.h *#*#*#*#*#*#*#*# (C) 2023 DekTec
//
// Device driver - IqAgc v0 (IQAGC) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block IqAgc.
// These functions should solely be used by the block controller for IqAgc.
//
// 2023.04.25 10:51 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND.

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2022 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN No EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//
// 1. Getting fields 'GainCorrelation1' and 'GainCorrelation2' from register 'Config1':
//      UInt32 Reg_Config1, GainCorrelation1, GainCorrelation2;
//      Reg_Config1      = IQAGC_Config1_READ(Bc);
//      GainCorrelation1 = IQAGC_Config1_GET_GainCorrelation1(Reg_Config1);
//      GainCorrelation2 = IQAGC_Config1_GET_GainCorrelation2(Reg_Config1);
//
// 2. Single-function shorthand for reading field 'GainReadback' from register 'Status':
//      UInt32  GainReadback = IQAGC_Status_READ_GainReadback(Bc);
//
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

// +=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// IQAGC_Config1_GET_DacNumBits
// IQAGC_Config1_GET_GainCorrelation1
// IQAGC_Config1_GET_GainCorrelation2
// IQAGC_Config1_GET_IqBitDepth
// IQAGC_Config1_READ
// IQAGC_Config1_READ_DacNumBits
// IQAGC_Config1_READ_GainCorrelation1
// IQAGC_Config1_READ_GainCorrelation2
// IQAGC_Config1_READ_IqBitDepth
// IQAGC_Config2_GET_MaxDacValue1
// IQAGC_Config2_GET_MinDacValue1
// IQAGC_Config2_READ
// IQAGC_Config2_READ_MaxDacValue1
// IQAGC_Config2_READ_MinDacValue1
// IQAGC_Config3_GET_MaxDacValue2
// IQAGC_Config3_GET_MinDacValue2
// IQAGC_Config3_READ
// IQAGC_Config3_READ_MaxDacValue2
// IQAGC_Config3_READ_MinDacValue2
// IQAGC_Control_READ
// IQAGC_Control_SET_BlockEnable
// IQAGC_Control_SET_GainCorrelation
// IQAGC_Control_SET_ManualGain
// IQAGC_Control_SET_OperationalMode
// IQAGC_Control_SET_SignalType
// IQAGC_Control_SET_UseManualGain
// IQAGC_Control_WRITE
// IQAGC_DacControl_READ
// IQAGC_DacControl_SET_MaxDacValue
// IQAGC_DacControl_SET_MinDacValue
// IQAGC_DacControl_WRITE
// IQAGC_GainStepSize_READ
// IQAGC_GainStepSize_SET_Locked
// IQAGC_GainStepSize_SET_Unlocked
// IQAGC_GainStepSize_WRITE
// IQAGC_MeasurementPeriod_WRITE
// IQAGC_Status_GET_GainReadback
// IQAGC_Status_GET_Lock
// IQAGC_Status_READ
// IQAGC_Status_READ_GainReadback
// IQAGC_Status_READ_Lock
// IQAGC_ThresholdHigh_WRITE
// IQAGC_ThresholdLow_WRITE

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'BlockEnable'
#define IQAGC_BLKENA_DISABLED       0x0  // Block is entirely disabled
#define IQAGC_BLKENA_ENABLED        0x1  // Block is enabled and processes data

// Value map 'GainCorrelation'
#define IQAGC_CORRELATION_POSITIVE  0x0  // High voltage is high gain
#define IQAGC_CORRELATION_NEGATIVE  0x1  // High voltage is low gain

// Value map 'OperationalMode'
#define IQAGC_OPMODE_IDLE           0x0  // Block is inactive
#define IQAGC_OPMODE_STANDBY        0x1  // Block is partially operational
#define IQAGC_OPMODE_RUN            0x2  // Block performs its normal function

// Value map 'SignalType'
#define IQAGC_SIGTYPE_REAL          0x0  // Real (IF) Signal
#define IQAGC_SIGTYPE_COMPLEX       0x1  // Complex (IQ) Signal

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// +=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IQAGC_Config1_READ(DtBcIQAGC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4);
}

// Field GET functions.
static __inline UInt32 IQAGC_Config1_GET_GainCorrelation1(UInt32 Config1)
{
    return Config1 & 0x1;
}
static __inline UInt32 IQAGC_Config1_GET_GainCorrelation2(UInt32 Config1)
{
    return (Config1 & 0x2) >> 1;
}
static __inline UInt32 IQAGC_Config1_GET_IqBitDepth(UInt32 Config1)
{
    return (Config1 & 0x3F0) >> 4;
}
static __inline UInt32 IQAGC_Config1_GET_DacNumBits(UInt32 Config1)
{
    return (Config1 & 0xFC00) >> 10;
}

// Field READ functions.
static __inline UInt32 IQAGC_Config1_READ_GainCorrelation1(DtBcIQAGC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4) & 0x1;
}
static __inline UInt32 IQAGC_Config1_READ_GainCorrelation2(DtBcIQAGC* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x4) & 0x2) >> 1;
}
static __inline UInt32 IQAGC_Config1_READ_IqBitDepth(DtBcIQAGC* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x4) & 0x3F0) >> 4;
}
static __inline UInt32 IQAGC_Config1_READ_DacNumBits(DtBcIQAGC* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x4) & 0xFC00) >> 10;
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IQAGC_Config2_READ(DtBcIQAGC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x8);
}

// Field GET functions.
static __inline UInt32 IQAGC_Config2_GET_MaxDacValue1(UInt32 Config2)
{
    return Config2 & 0xFFFF;
}
static __inline UInt32 IQAGC_Config2_GET_MinDacValue1(UInt32 Config2)
{
    return (Config2 & 0xFFFF0000) >> 16;
}

// Field READ functions.
static __inline UInt32 IQAGC_Config2_READ_MaxDacValue1(DtBcIQAGC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x8) & 0xFFFF;
}
static __inline UInt32 IQAGC_Config2_READ_MinDacValue1(DtBcIQAGC* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x8) & 0xFFFF0000) >> 16;
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config3' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IQAGC_Config3_READ(DtBcIQAGC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0xC);
}

// Field GET functions.
static __inline UInt32 IQAGC_Config3_GET_MaxDacValue2(UInt32 Config3)
{
    return Config3 & 0xFFFF;
}
static __inline UInt32 IQAGC_Config3_GET_MinDacValue2(UInt32 Config3)
{
    return (Config3 & 0xFFFF0000) >> 16;
}

// Field READ functions.
static __inline UInt32 IQAGC_Config3_READ_MaxDacValue2(DtBcIQAGC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0xC) & 0xFFFF;
}
static __inline UInt32 IQAGC_Config3_READ_MinDacValue2(DtBcIQAGC* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0xC) & 0xFFFF0000) >> 16;
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IQAGC_Control_READ(DtBcIQAGC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10);
}

// Field SET functions.
static __inline UInt32 IQAGC_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32 IQAGC_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32 IQAGC_Control_SET_GainCorrelation(UInt32 Control, UInt32 GainCorrelation)
{
    DT_ASSERT((GainCorrelation & ~0x1) == 0);
    return (Control & ~0x8) | (GainCorrelation << 3);
}
static __inline UInt32 IQAGC_Control_SET_SignalType(UInt32 Control, UInt32 SignalType)
{
    DT_ASSERT((SignalType & ~0x1) == 0);
    return (Control & ~0x10) | (SignalType << 4);
}
static __inline UInt32 IQAGC_Control_SET_UseManualGain(UInt32 Control, UInt32 UseManualGain)
{
    DT_ASSERT((UseManualGain & ~0x1) == 0);
    return (Control & ~0x8000) | (UseManualGain << 15);
}
static __inline UInt32 IQAGC_Control_SET_ManualGain(UInt32 Control, UInt32 ManualGain)
{
    DT_ASSERT((ManualGain & ~0xFFFF) == 0);
    return (Control & ~0xFFFF0000) | (ManualGain << 16);
}

// Register WRITE function.
static __inline void IQAGC_Control_WRITE(DtBcIQAGC* Bc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10, Control);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'DacControl' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IQAGC_DacControl_READ(DtBcIQAGC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x14);
}

// Field SET functions.
static __inline UInt32 IQAGC_DacControl_SET_MaxDacValue(UInt32 DacControl, UInt32 MaxDacValue)
{
    DT_ASSERT((MaxDacValue & ~0xFFFF) == 0);
    return (DacControl & ~0xFFFF) | MaxDacValue;
}
static __inline UInt32 IQAGC_DacControl_SET_MinDacValue(UInt32 DacControl, UInt32 MinDacValue)
{
    DT_ASSERT((MinDacValue & ~0xFFFF) == 0);
    return (DacControl & ~0xFFFF0000) | (MinDacValue << 16);
}

// Register WRITE function.
static __inline void IQAGC_DacControl_WRITE(DtBcIQAGC* Bc, UInt32 DacControl)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x14, DacControl);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'GainStepSize' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 IQAGC_GainStepSize_READ(DtBcIQAGC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x18);
}

// Field SET functions.
static __inline UInt32 IQAGC_GainStepSize_SET_Unlocked(UInt32 GainStepSize, UInt32 Unlocked)
{
    DT_ASSERT((Unlocked & ~0xFF) == 0);
    return (GainStepSize & ~0xFF) | Unlocked;
}
static __inline UInt32 IQAGC_GainStepSize_SET_Locked(UInt32 GainStepSize, UInt32 Locked)
{
    DT_ASSERT((Locked & ~0xFF) == 0);
    return (GainStepSize & ~0xFF0000) | (Locked << 16);
}

// Register WRITE function.
static __inline void IQAGC_GainStepSize_WRITE(DtBcIQAGC* Bc, UInt32 GainStepSize)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x18, GainStepSize);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'ThresholdHigh' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function.
static __inline void IQAGC_ThresholdHigh_WRITE(DtBcIQAGC* Bc, UInt32 ThresholdHigh)
{
    DT_ASSERT((ThresholdHigh & ~0x3FFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x1C, ThresholdHigh);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'ThresholdLow' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function.
static __inline void IQAGC_ThresholdLow_WRITE(DtBcIQAGC* Bc, UInt32 ThresholdLow)
{
    DT_ASSERT((ThresholdLow & ~0x3FFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x20, ThresholdLow);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'MeasurementPeriod' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function.
static __inline void IQAGC_MeasurementPeriod_WRITE(DtBcIQAGC* Bc, UInt32 MeasurementPeriod)
{
    DT_ASSERT((MeasurementPeriod & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x24, MeasurementPeriod);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IQAGC_Status_READ(DtBcIQAGC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x28);
}

// Field GET functions.
static __inline UInt32 IQAGC_Status_GET_Lock(UInt32 Status)
{
    return Status & 0x1;
}
static __inline UInt32 IQAGC_Status_GET_GainReadback(UInt32 Status)
{
    return (Status & 0xFFFF0) >> 4;
}

// Field READ functions.
static __inline UInt32 IQAGC_Status_READ_Lock(DtBcIQAGC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x28) & 0x1;
}
static __inline UInt32 IQAGC_Status_READ_GainReadback(DtBcIQAGC* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x28) & 0xFFFF0) >> 4;
}

