//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcIPFIFO_RegAccess.h *#*#*#*#*#*#*#*# (C) 2022 DekTec
//
// Device driver - IpDdrFifo v0 (IPFIFO) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block IpDdrFifo.
// These functions should solely be used by the block controller for IpDdrFifo.
//
// 2022.01.03 16:52 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND.

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2020 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN No EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'Load' and 'Overflow' from register 'FifoStatus':
//      UInt32  Reg_FifoStatus, Load, Overflow;
//      Reg_FifoStatus = IPFIFO_FifoStatus_READ(pBc);
//      Load           = IPFIFO_FifoStatus_GET_Load(Reg_FifoStatus);
//      Overflow       = IPFIFO_FifoStatus_GET_Overflow(Reg_FifoStatus);
//
// 2. Single-function shorthand for reading field 'MaxFifoSize' from register 'Config':
//      UInt32  MaxFifoSize = IPFIFO_Config_READ_MaxFifoSize(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// IPFIFO_Config_GET_MaxFifoSize
// IPFIFO_Config_READ
// IPFIFO_Config_READ_MaxFifoSize
// IPFIFO_Control_READ
// IPFIFO_Control_SET_BlockEnable
// IPFIFO_Control_SET_OperationalMode
// IPFIFO_Control_WRITE
// IPFIFO_FifoAddr_WRITE
// IPFIFO_FifoSize_WRITE
// IPFIFO_FifoStatus_CLEAR_Overflow
// IPFIFO_FifoStatus_GET_Load
// IPFIFO_FifoStatus_GET_Overflow
// IPFIFO_FifoStatus_READ
// IPFIFO_FifoStatus_READ_Load
// IPFIFO_FifoStatus_READ_Overflow

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'BlockEnable'
#define IPFIFO_BLKENA_DISABLED  0x0  // Block is entirely disabled
#define IPFIFO_BLKENA_ENABLED   0x1  // Block is enabled and processes data

// Value map 'OperationalMode'
#define IPFIFO_OPMODE_IDLE      0x0  // Block is inactive
#define IPFIFO_OPMODE_STANDBY   0x1  // Block is partially operational
#define IPFIFO_OPMODE_RUN       0x2  // Block performs its normal function

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IPFIFO_Config_READ(DtBcIPFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field GET function
static __inline UInt32 IPFIFO_Config_GET_MaxFifoSize(UInt32 Config)
{
    return Config & 0xFFFF;
}

// Field READ function
static __inline UInt32 IPFIFO_Config_READ_MaxFifoSize(DtBcIPFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4) & 0xFFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IPFIFO_Control_READ(DtBcIPFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field SET functions
static __inline UInt32 IPFIFO_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32 IPFIFO_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}

// Register WRITE function
static __inline void IPFIFO_Control_WRITE(DtBcIPFIFO* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x8, Control);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FifoAddr' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void IPFIFO_FifoAddr_WRITE(DtBcIPFIFO* pBc, UInt32 FifoAddr)
{
    DT_ASSERT((FifoAddr & ~0x1FFFFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0xC, FifoAddr);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FifoSize' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void IPFIFO_FifoSize_WRITE(DtBcIPFIFO* pBc, UInt32 FifoSize)
{
    DT_ASSERT((FifoSize & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x10, FifoSize);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FifoStatus' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IPFIFO_FifoStatus_READ(DtBcIPFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x14);
}

// Field GET functions
static __inline UInt32 IPFIFO_FifoStatus_GET_Load(UInt32 FifoStatus)
{
    return FifoStatus & 0xFFFF;
}
static __inline UInt32 IPFIFO_FifoStatus_GET_Overflow(UInt32 FifoStatus)
{
    return (FifoStatus & 0x80000000) >> 31;
}

// Field READ functions
static __inline UInt32 IPFIFO_FifoStatus_READ_Load(DtBcIPFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x14) & 0xFFFF;
}
static __inline UInt32 IPFIFO_FifoStatus_READ_Overflow(DtBcIPFIFO* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x14) & 0x80000000) >> 31;
}

// Field CLEAR function
static __inline void IPFIFO_FifoStatus_CLEAR_Overflow(DtBcIPFIFO* pBc)
{
    UInt32  FifoStatus = DtBc_RegRead32((DtBc*)pBc, 0x14);
    DtBc_RegWrite32((DtBc*)pBc, 0x14, FifoStatus | 0x80000000);
}

