//*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcFANC_RegAccess.h *#*#*#*#*#*#*#*#* (C) 2019 DekTec
//
// Device driver - FanCtrl v1 (FANC) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block FanCtrl.
// These functions should solely be used by the block controller for FanCtrl.
//
// 2019.03.14 9:40 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'MeasurementPeriod' and 'WatchdogTimeOut' from register 'Config':
//      UInt32  Reg_Config, MeasurementPeriod, WatchdogTimeOut;
//      Reg_Config        = FANC_Config_READ(pBc);
//      MeasurementPeriod = FANC_Config_GET_MeasurementPeriod(Reg_Config);
//      WatchdogTimeOut   = FANC_Config_GET_WatchdogTimeOut(Reg_Config);
//
// 2. Single-function shorthand for reading field 'IsFanStuck' from register 'Status':
//      UInt32  IsFanStuck = FANC_Status_READ_IsFanStuck(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// FANC_Config_GET_InitialFanSpeed
// FANC_Config_GET_MeasurementPeriod
// FANC_Config_GET_WatchdogTimeOut
// FANC_Config_READ
// FANC_Config_READ_InitialFanSpeed
// FANC_Config_READ_MeasurementPeriod
// FANC_Config_READ_WatchdogTimeOut
// FANC_Control_READ
// FANC_Control_SET_EnableWatchdog
// FANC_Control_SET_FanSpeed
// FANC_Control_SET_OperationalState
// FANC_Control_WRITE
// FANC_Status_GET_IsFanStuck
// FANC_Status_GET_IsWatchdogTimeOut
// FANC_Status_GET_MeasuredFanSpeedRpm
// FANC_Status_GET_PwmCtrlValue
// FANC_Status_READ
// FANC_Status_READ_IsFanStuck
// FANC_Status_READ_IsWatchdogTimeOut
// FANC_Status_READ_MeasuredFanSpeedRpm
// FANC_Status_READ_PwmCtrlValue

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'OperationalState'
#define FANC_OPSTATE_IDLE    0x0  // Idle after power up
#define FANC_OPSTATE_NO_FAN  0x1  // No fan
#define FANC_OPSTATE_NORMAL  0x2  // Normal

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  FANC_Config_READ(DtBcFANC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field GET functions
static __inline UInt32  FANC_Config_GET_MeasurementPeriod(UInt32 Config)
{
    return Config & 0xFFF;
}
static __inline UInt32  FANC_Config_GET_WatchdogTimeOut(UInt32 Config)
{
    return (Config & 0xFFF000) >> 12;
}
static __inline UInt32  FANC_Config_GET_InitialFanSpeed(UInt32 Config)
{
    return (Config & 0x7F000000) >> 24;
}

// Field READ functions
static __inline UInt32  FANC_Config_READ_MeasurementPeriod(DtBcFANC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4) & 0xFFF;
}
static __inline UInt32  FANC_Config_READ_WatchdogTimeOut(DtBcFANC* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0xFFF000) >> 12;
}
static __inline UInt32  FANC_Config_READ_InitialFanSpeed(DtBcFANC* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0x7F000000) >> 24;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  FANC_Control_READ(DtBcFANC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field SET functions
static __inline UInt32  FANC_Control_SET_FanSpeed(UInt32 Control, UInt32 FanSpeed)
{
    DT_ASSERT((FanSpeed & ~0x7F) == 0);
    return (Control & ~0x7F) | FanSpeed;
}
static __inline UInt32  FANC_Control_SET_EnableWatchdog(UInt32 Control, UInt32 EnableWatchdog)
{
    DT_ASSERT((EnableWatchdog & ~0x1) == 0);
    return (Control & ~0x80) | (EnableWatchdog << 7);
}
static __inline UInt32  FANC_Control_SET_OperationalState(UInt32 Control, UInt32 OperationalState)
{
    DT_ASSERT((OperationalState & ~0x3) == 0);
    return (Control & ~0x300) | (OperationalState << 8);
}

// Register WRITE function
static __inline void  FANC_Control_WRITE(DtBcFANC* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x8, Control);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  FANC_Status_READ(DtBcFANC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC);
}

// Field GET functions
static __inline UInt32  FANC_Status_GET_MeasuredFanSpeedRpm(UInt32 Status)
{
    return Status & 0xFFFF;
}
static __inline UInt32  FANC_Status_GET_PwmCtrlValue(UInt32 Status)
{
    return (Status & 0x7F0000) >> 16;
}
static __inline UInt32  FANC_Status_GET_IsWatchdogTimeOut(UInt32 Status)
{
    return (Status & 0x40000000) >> 30;
}
static __inline UInt32  FANC_Status_GET_IsFanStuck(UInt32 Status)
{
    return (Status & 0x80000000) >> 31;
}

// Field READ functions
static __inline UInt32  FANC_Status_READ_MeasuredFanSpeedRpm(DtBcFANC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC) & 0xFFFF;
}
static __inline UInt32  FANC_Status_READ_PwmCtrlValue(DtBcFANC* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x7F0000) >> 16;
}
static __inline UInt32  FANC_Status_READ_IsWatchdogTimeOut(DtBcFANC* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x40000000) >> 30;
}
static __inline UInt32  FANC_Status_READ_IsFanStuck(DtBcFANC* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x80000000) >> 31;
}

