// *#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcEMAC10G_RegAccess.h *#*#*#*#*#*#*#*#*#*#*#*#*# 2024
//
// Device driver - EthMac10G v2 (EMAC10G) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block EthMac10G.
// These functions should solely be used by the block controller for EthMac10G.
//
// 2024.12.03 13:40:55 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND.

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2024 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN No EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//
// 1. Getting fields 'MacAccessTimedout' and 'PhyAccessTimedout' from register 'Status':
//      UInt32 Reg_Status, MacAccessTimedout, PhyAccessTimedout;
//      Reg_Status        = EMAC10G_Status_READ(Bc);
//      MacAccessTimedout = EMAC10G_Status_GET_MacAccessTimedout(Reg_Status);
//      PhyAccessTimedout = EMAC10G_Status_GET_PhyAccessTimedout(Reg_Status);
//
// 2. Single-function shorthand for reading field 'RxStatsPfcCtrlH' from register
//    'LlEthMac1G10GA10_RxStatsPfcCtrlH':
//      UInt32  RxStatsPfcCtrlH =
// EMAC10G_LlEthMac1G10GA10_RxStatsPfcCtrlH_READ_RxStatsPfcCtrlH(Bc);
//
// Updating multiple fields in the same register:
//   UInt32  Reg_EthPhy1G10GA10_PmaCalibrationControl =
// EMAC10G_EthPhy1G10GA10_PmaCalibrationControl_READ(Bc);
//  
// EMAC10G_EthPhy1G10GA10_PmaCalibrationControl_SET_AvalonControl(Reg_EthPhy1G10GA10_PmaCalibrationControl,
// 1);
//  
// EMAC10G_EthPhy1G10GA10_PmaCalibrationControl_SET_CalDone(Reg_EthPhy1G10GA10_PmaCalibrationControl,
// 1);
//   EMAC10G_EthPhy1G10GA10_PmaCalibrationControl_WRITE(Bc,
// Reg_EthPhy1G10GA10_PmaCalibrationControl);
//
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

// +=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// EMAC10G_Configuration_GET_JumboSupport
// EMAC10G_Configuration_READ
// EMAC10G_Configuration_READ_JumboSupport
// EMAC10G_Control_READ
// EMAC10G_Control_SET_BlockEnable
// EMAC10G_Control_SET_FlushFifos
// EMAC10G_Control_SET_MaxDelay
// EMAC10G_Control_SET_OperationalMode
// EMAC10G_Control_SET_PromiscuousMode
// EMAC10G_Control_WRITE
// EMAC10G_EthPhy1G10GA10_PmaCalibrationControl_GET_AvalonControl
// EMAC10G_EthPhy1G10GA10_PmaCalibrationControl_GET_CalDone
// EMAC10G_EthPhy1G10GA10_PmaCalibrationControl_READ
// EMAC10G_EthPhy1G10GA10_PmaCalibrationControl_SET_AvalonControl
// EMAC10G_EthPhy1G10GA10_PmaCalibrationControl_SET_CalDone
// EMAC10G_EthPhy1G10GA10_PmaCalibrationControl_WRITE
// EMAC10G_EthPhy1G10GA10_PmaCalibrationEnable_GET_PmaAdaptTrigReqEn
// EMAC10G_EthPhy1G10GA10_PmaCalibrationEnable_GET_PmaRxCalEn
// EMAC10G_EthPhy1G10GA10_PmaCalibrationEnable_GET_PmaTxCalEn
// EMAC10G_EthPhy1G10GA10_PmaCalibrationEnable_READ
// EMAC10G_EthPhy1G10GA10_PmaCalibrationEnable_SET_PmaAdaptTrigReqEn
// EMAC10G_EthPhy1G10GA10_PmaCalibrationEnable_SET_PmaRxCalEn
// EMAC10G_EthPhy1G10GA10_PmaCalibrationEnable_SET_PmaTxCalEn
// EMAC10G_EthPhy1G10GA10_PmaCalibrationEnable_WRITE
// EMAC10G_EthPhy1G10GA10_PmaCalibrationStatus_GET_AvMmBusy
// EMAC10G_EthPhy1G10GA10_PmaCalibrationStatus_GET_RxCalBusy
// EMAC10G_EthPhy1G10GA10_PmaCalibrationStatus_GET_TxCalBusy
// EMAC10G_EthPhy1G10GA10_PmaCalibrationStatus_READ
// EMAC10G_EthPhy1G10GA10_PmaCalibrationStatus_READ_AvMmBusy
// EMAC10G_EthPhy1G10GA10_PmaCalibrationStatus_READ_RxCalBusy
// EMAC10G_EthPhy1G10GA10_PmaCalibrationStatus_READ_TxCalBusy
// EMAC10G_EthPhy1G10GA10_PmaResetControl_GET_OverrideRxAnalogReset
// EMAC10G_EthPhy1G10GA10_PmaResetControl_GET_OverrideRxDigitalReset
// EMAC10G_EthPhy1G10GA10_PmaResetControl_GET_OverrideTxAnalogReset
// EMAC10G_EthPhy1G10GA10_PmaResetControl_GET_OverrideTxDigitalReset
// EMAC10G_EthPhy1G10GA10_PmaResetControl_GET_RxAnalogReset
// EMAC10G_EthPhy1G10GA10_PmaResetControl_GET_RxDigitalReset
// EMAC10G_EthPhy1G10GA10_PmaResetControl_GET_TxAnalogReset
// EMAC10G_EthPhy1G10GA10_PmaResetControl_GET_TxDigitalReset
// EMAC10G_EthPhy1G10GA10_PmaResetControl_READ
// EMAC10G_EthPhy1G10GA10_PmaResetControl_SET_OverrideRxAnalogReset
// EMAC10G_EthPhy1G10GA10_PmaResetControl_SET_OverrideRxDigitalReset
// EMAC10G_EthPhy1G10GA10_PmaResetControl_SET_OverrideTxAnalogReset
// EMAC10G_EthPhy1G10GA10_PmaResetControl_SET_OverrideTxDigitalReset
// EMAC10G_EthPhy1G10GA10_PmaResetControl_SET_RxAnalogReset
// EMAC10G_EthPhy1G10GA10_PmaResetControl_SET_RxDigitalReset
// EMAC10G_EthPhy1G10GA10_PmaResetControl_SET_TxAnalogReset
// EMAC10G_EthPhy1G10GA10_PmaResetControl_SET_TxDigitalReset
// EMAC10G_EthPhy1G10GA10_PmaResetControl_WRITE
// EMAC10G_LlEthMac1G10GA10_CfErrStat_CLEAR_ResTimeErrStat
// EMAC10G_LlEthMac1G10GA10_CfErrStat_CLEAR_ResTimeNegStat
// EMAC10G_LlEthMac1G10GA10_CfErrStat_CLEAR_RxCfErrStat
// EMAC10G_LlEthMac1G10GA10_CfErrStat_CLEAR_TxCfErrStat
// EMAC10G_LlEthMac1G10GA10_CfErrStat_GET_ResTimeErrStat
// EMAC10G_LlEthMac1G10GA10_CfErrStat_GET_ResTimeNegStat
// EMAC10G_LlEthMac1G10GA10_CfErrStat_GET_RxCfErrStat
// EMAC10G_LlEthMac1G10GA10_CfErrStat_GET_TxCfErrStat
// EMAC10G_LlEthMac1G10GA10_CfErrStat_READ
// EMAC10G_LlEthMac1G10GA10_CfErrStat_READ_ResTimeErrStat
// EMAC10G_LlEthMac1G10GA10_CfErrStat_READ_ResTimeNegStat
// EMAC10G_LlEthMac1G10GA10_CfErrStat_READ_RxCfErrStat
// EMAC10G_LlEthMac1G10GA10_CfErrStat_READ_TxCfErrStat
// EMAC10G_LlEthMac1G10GA10_MacRstCtrl_GET_RxDpRst
// EMAC10G_LlEthMac1G10GA10_MacRstCtrl_GET_TxDpRst
// EMAC10G_LlEthMac1G10GA10_MacRstCtrl_READ
// EMAC10G_LlEthMac1G10GA10_MacRstCtrl_SET_RxDpRst
// EMAC10G_LlEthMac1G10GA10_MacRstCtrl_SET_TxDpRst
// EMAC10G_LlEthMac1G10GA10_MacRstCtrl_WRITE
// EMAC10G_LlEthMac1G10GA10_PrimMacAddrH_READ_PrimMacAddrH
// EMAC10G_LlEthMac1G10GA10_PrimMacAddrH_WRITE_PrimMacAddrH
// EMAC10G_LlEthMac1G10GA10_PrimMacAddrL_READ_PrimMacAddrL
// EMAC10G_LlEthMac1G10GA10_PrimMacAddrL_WRITE_PrimMacAddrL
// EMAC10G_LlEthMac1G10GA10_RxCrcCheckCtrl_READ_RxCrcCheckCtrl
// EMAC10G_LlEthMac1G10GA10_RxCrcCheckCtrl_WRITE_RxCrcCheckCtrl
// EMAC10G_LlEthMac1G10GA10_RxFnsAdj10G_READ_RxFnsAdj10G
// EMAC10G_LlEthMac1G10GA10_RxFnsAdj10G_WRITE_RxFnsAdj10G
// EMAC10G_LlEthMac1G10GA10_RxFnsAdj1G_READ_RxFnsAdj1G
// EMAC10G_LlEthMac1G10GA10_RxFnsAdj1G_WRITE_RxFnsAdj1G
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_EnAllMCast
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_EnAllUCast
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_EnSupp0
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_EnSupp1
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_EnSupp2
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_EnSupp3
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_FwdCtrl
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_FwdPause
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_IgnorePause
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_READ
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_EnAllMCast
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_EnAllUCast
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_EnSupp0
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_EnSupp1
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_EnSupp2
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_EnSupp3
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_FwdCtrl
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_FwdPause
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_IgnorePause
// EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_WRITE
// EMAC10G_LlEthMac1G10GA10_RxFrameMaxLen_READ_RxFrameMaxLen
// EMAC10G_LlEthMac1G10GA10_RxFrameMaxLen_WRITE_RxFrameMaxLen
// EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr0H_READ_RxFrameSpAddr0H
// EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr0H_WRITE_RxFrameSpAddr0H
// EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr0L_READ_RxFrameSpAddr0L
// EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr0L_WRITE_RxFrameSpAddr0L
// EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr1H_READ_RxFrameSpAddr1H
// EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr1H_WRITE_RxFrameSpAddr1H
// EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr1L_READ_RxFrameSpAddr1L
// EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr1L_WRITE_RxFrameSpAddr1L
// EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr2H_READ_RxFrameSpAddr2H
// EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr2H_WRITE_RxFrameSpAddr2H
// EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr2L_READ_RxFrameSpAddr2L
// EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr2L_WRITE_RxFrameSpAddr2L
// EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr3H_READ_RxFrameSpAddr3H
// EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr3H_WRITE_RxFrameSpAddr3H
// EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr3L_READ_RxFrameSpAddr3L
// EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr3L_WRITE_RxFrameSpAddr3L
// EMAC10G_LlEthMac1G10GA10_RxNsAdj10G_READ_RxNsAdj10G
// EMAC10G_LlEthMac1G10GA10_RxNsAdj10G_WRITE_RxNsAdj10G
// EMAC10G_LlEthMac1G10GA10_RxNsAdj1G_READ_RxNsAdj1G
// EMAC10G_LlEthMac1G10GA10_RxNsAdj1G_WRITE_RxNsAdj1G
// EMAC10G_LlEthMac1G10GA10_RxOflowDropCntH_READ_RxOflowDropCntH
// EMAC10G_LlEthMac1G10GA10_RxOflowDropCntL_READ_RxOflowDropCntL
// EMAC10G_LlEthMac1G10GA10_RxOflowTruncCntH_READ_RxOflowTruncCntH
// EMAC10G_LlEthMac1G10GA10_RxOflowTruncCntL_READ_RxOflowTruncCntL
// EMAC10G_LlEthMac1G10GA10_RxP2pMpdFns_GET_MpdValueFns
// EMAC10G_LlEthMac1G10GA10_RxP2pMpdFns_READ
// EMAC10G_LlEthMac1G10GA10_RxP2pMpdFns_SET_MpdValueFns
// EMAC10G_LlEthMac1G10GA10_RxP2pMpdFns_WRITE
// EMAC10G_LlEthMac1G10GA10_RxP2pMpdNs_GET_MpdValid
// EMAC10G_LlEthMac1G10GA10_RxP2pMpdNs_GET_Nanoseconds
// EMAC10G_LlEthMac1G10GA10_RxP2pMpdNs_READ
// EMAC10G_LlEthMac1G10GA10_RxP2pMpdNs_SET_MpdValid
// EMAC10G_LlEthMac1G10GA10_RxP2pMpdNs_SET_Nanoseconds
// EMAC10G_LlEthMac1G10GA10_RxP2pMpdNs_WRITE
// EMAC10G_LlEthMac1G10GA10_RxPadCrcCtrl_READ_RxPadCrcCtrl
// EMAC10G_LlEthMac1G10GA10_RxPadCrcCtrl_WRITE_RxPadCrcCtrl
// EMAC10G_LlEthMac1G10GA10_RxPerMultSpeed_GET_Nanoseconds
// EMAC10G_LlEthMac1G10GA10_RxPerMultSpeed_GET_SubNanoseconds
// EMAC10G_LlEthMac1G10GA10_RxPerMultSpeed_READ
// EMAC10G_LlEthMac1G10GA10_RxPerMultSpeed_SET_Nanoseconds
// EMAC10G_LlEthMac1G10GA10_RxPerMultSpeed_SET_SubNanoseconds
// EMAC10G_LlEthMac1G10GA10_RxPerMultSpeed_WRITE
// EMAC10G_LlEthMac1G10GA10_RxPeriod10G_GET_Nanoseconds
// EMAC10G_LlEthMac1G10GA10_RxPeriod10G_GET_SubNanoseconds
// EMAC10G_LlEthMac1G10GA10_RxPeriod10G_READ
// EMAC10G_LlEthMac1G10GA10_RxPeriod10G_SET_Nanoseconds
// EMAC10G_LlEthMac1G10GA10_RxPeriod10G_SET_SubNanoseconds
// EMAC10G_LlEthMac1G10GA10_RxPeriod10G_WRITE
// EMAC10G_LlEthMac1G10GA10_RxStatsBCastCtrlH_READ_RxStatsBCastCtrlH
// EMAC10G_LlEthMac1G10GA10_RxStatsBCastErrH_READ_RxStatsBCastErrH
// EMAC10G_LlEthMac1G10GA10_RxStatsBCastErrL_READ_RxStatsBCastErrL
// EMAC10G_LlEthMac1G10GA10_RxStatsBCastMacCtrlL_READ_RxStatsBCastMacCtrlL
// EMAC10G_LlEthMac1G10GA10_RxStatsBCastOkH_READ_RxStatsBCastOkH
// EMAC10G_LlEthMac1G10GA10_RxStatsBCastOkL_READ_RxStatsBCastOkL
// EMAC10G_LlEthMac1G10GA10_RxStatsClr_READ_RxStatsClr
// EMAC10G_LlEthMac1G10GA10_RxStatsClr_WRITE_RxStatsClr
// EMAC10G_LlEthMac1G10GA10_RxStatsCrcErrH_READ_RxStatsCrcErrH
// EMAC10G_LlEthMac1G10GA10_RxStatsCrcErrL_READ_RxStatsCrcErrL
// EMAC10G_LlEthMac1G10GA10_RxStatsCrcErrSH_READ_RxStatsCrcErrSH
// EMAC10G_LlEthMac1G10GA10_RxStatsCrcErrSL_READ_RxStatsCrcErrSL
// EMAC10G_LlEthMac1G10GA10_RxStatsFr1024to1518H_READ_RxStatsFr1024to1518H
// EMAC10G_LlEthMac1G10GA10_RxStatsFr1024to1518L_READ_RxStatsFr1024to1518L
// EMAC10G_LlEthMac1G10GA10_RxStatsFr128to255H_READ_RxStatsFr128to255H
// EMAC10G_LlEthMac1G10GA10_RxStatsFr128to255L_READ_RxStatsFr128to255L
// EMAC10G_LlEthMac1G10GA10_RxStatsFr1519toXH_READ_RxStatsFr1519toXH
// EMAC10G_LlEthMac1G10GA10_RxStatsFr1519toXL_READ_RxStatsFr1519toXL
// EMAC10G_LlEthMac1G10GA10_RxStatsFr256to511H_READ_RxStatsFr256to511H
// EMAC10G_LlEthMac1G10GA10_RxStatsFr256to511L_READ_RxStatsFr256to511L
// EMAC10G_LlEthMac1G10GA10_RxStatsFr512to1023H_READ_RxStatsFr512to1023H
// EMAC10G_LlEthMac1G10GA10_RxStatsFr512to1023L_READ_RxStatsFr512to1023L
// EMAC10G_LlEthMac1G10GA10_RxStatsFr64H_READ_RxStatsFr64H
// EMAC10G_LlEthMac1G10GA10_RxStatsFr64L_READ_RxStatsFr64L
// EMAC10G_LlEthMac1G10GA10_RxStatsFr65to127H_READ_RxStatsFr65to127H
// EMAC10G_LlEthMac1G10GA10_RxStatsFr65to127L_READ_RxStatsFr65to127L
// EMAC10G_LlEthMac1G10GA10_RxStatsFragsH_READ_RxStatsFragsH
// EMAC10G_LlEthMac1G10GA10_RxStatsFragsL_READ_RxStatsFragsL
// EMAC10G_LlEthMac1G10GA10_RxStatsFrameErrH_READ_RxStatsFrameErrH
// EMAC10G_LlEthMac1G10GA10_RxStatsFrameErrL_READ_RxStatsFrameErrL
// EMAC10G_LlEthMac1G10GA10_RxStatsFrameOkH_READ_RxStatsFrameOkH
// EMAC10G_LlEthMac1G10GA10_RxStatsFrameOkL_READ_RxStatsFrameOkL
// EMAC10G_LlEthMac1G10GA10_RxStatsIfErrH_READ_RxStatsIfErrH
// EMAC10G_LlEthMac1G10GA10_RxStatsIfErrL_READ_RxStatsIfErrL
// EMAC10G_LlEthMac1G10GA10_RxStatsJabbersH_READ_RxStatsJabbersH
// EMAC10G_LlEthMac1G10GA10_RxStatsJabbersL_READ_RxStatsJabbersL
// EMAC10G_LlEthMac1G10GA10_RxStatsMCastErrH_READ_RxStatsMCastErrH
// EMAC10G_LlEthMac1G10GA10_RxStatsMCastErrL_READ_RxStatsMCastErrL
// EMAC10G_LlEthMac1G10GA10_RxStatsMCastMacCtrlH_READ_RxStatsMCastMacCtrlH
// EMAC10G_LlEthMac1G10GA10_RxStatsMCastMacCtrlL_READ_RxStatsMCastMacCtrlL
// EMAC10G_LlEthMac1G10GA10_RxStatsMCastOkH_READ_RxStatsMCastOkH
// EMAC10G_LlEthMac1G10GA10_RxStatsMCastOkL_READ_RxStatsMCastOkL
// EMAC10G_LlEthMac1G10GA10_RxStatsOSizeH_READ_RxStatsOSizeH
// EMAC10G_LlEthMac1G10GA10_RxStatsOSizeL_READ_RxStatsOSizeL
// EMAC10G_LlEthMac1G10GA10_RxStatsOctetsH_READ_RxStatsOctetsH
// EMAC10G_LlEthMac1G10GA10_RxStatsOctetsL_READ_RxStatsOctetsL
// EMAC10G_LlEthMac1G10GA10_RxStatsOctetsOkH_READ_RxStatsOctetsOkH
// EMAC10G_LlEthMac1G10GA10_RxStatsOctetsOkL_READ_RxStatsOctetsOkL
// EMAC10G_LlEthMac1G10GA10_RxStatsPauseFramesH_READ_RxStatsPauseFramesH
// EMAC10G_LlEthMac1G10GA10_RxStatsPauseFramesL_READ_RxStatsPauseFramesL
// EMAC10G_LlEthMac1G10GA10_RxStatsPfcCtrlH_READ_RxStatsPfcCtrlH
// EMAC10G_LlEthMac1G10GA10_RxStatsPfcCtrlL_READ_RxStatsPfcCtrlL
// EMAC10G_LlEthMac1G10GA10_RxStatsPktsH_READ_RxStatsPktsH
// EMAC10G_LlEthMac1G10GA10_RxStatsPktsL_READ_RxStatsPktsL
// EMAC10G_LlEthMac1G10GA10_RxStatsUCastErrH_READ_RxStatsUCastErrH
// EMAC10G_LlEthMac1G10GA10_RxStatsUCastErrL_READ_RxStatsUCastErrL
// EMAC10G_LlEthMac1G10GA10_RxStatsUCastMacCtrlH_READ_RxStatsUCastMacCtrlH
// EMAC10G_LlEthMac1G10GA10_RxStatsUCastMacCtrlL_READ_RxStatsUCastMacCtrlL
// EMAC10G_LlEthMac1G10GA10_RxStatsUCastOkH_READ_RxStatsUCastOkH
// EMAC10G_LlEthMac1G10GA10_RxStatsUCastOkL_READ_RxStatsUCastOkL
// EMAC10G_LlEthMac1G10GA10_RxStatsUSizeH_READ_RxStatsUSizeH
// EMAC10G_LlEthMac1G10GA10_RxStatsUSizeL_READ_RxStatsUSizeL
// EMAC10G_LlEthMac1G10GA10_RxTransferCtrl_READ_RxTransferCtrl
// EMAC10G_LlEthMac1G10GA10_RxTransferCtrl_WRITE_RxTransferCtrl
// EMAC10G_LlEthMac1G10GA10_RxTransferStat_GET_RxDpStat
// EMAC10G_LlEthMac1G10GA10_RxTransferStat_GET_RxRstStat
// EMAC10G_LlEthMac1G10GA10_RxTransferStat_READ
// EMAC10G_LlEthMac1G10GA10_RxTransferStat_READ_RxDpStat
// EMAC10G_LlEthMac1G10GA10_RxTransferStat_READ_RxRstStat
// EMAC10G_LlEthMac1G10GA10_RxVlanDet_READ_RxVlanDet
// EMAC10G_LlEthMac1G10GA10_RxVlanDet_WRITE_RxVlanDet
// EMAC10G_LlEthMac1G10GA10_TxAsymmetry_GET_AsymDir
// EMAC10G_LlEthMac1G10GA10_TxAsymmetry_GET_AsymEn
// EMAC10G_LlEthMac1G10GA10_TxAsymmetry_GET_AsymVal
// EMAC10G_LlEthMac1G10GA10_TxAsymmetry_READ
// EMAC10G_LlEthMac1G10GA10_TxAsymmetry_SET_AsymDir
// EMAC10G_LlEthMac1G10GA10_TxAsymmetry_SET_AsymEn
// EMAC10G_LlEthMac1G10GA10_TxAsymmetry_SET_AsymVal
// EMAC10G_LlEthMac1G10GA10_TxAsymmetry_WRITE
// EMAC10G_LlEthMac1G10GA10_TxCrcCtrl_READ_TxCrcCtrl
// EMAC10G_LlEthMac1G10GA10_TxCrcCtrl_WRITE_TxCrcCtrl
// EMAC10G_LlEthMac1G10GA10_TxFnsAdj10G_READ_TxFnsAdj10G
// EMAC10G_LlEthMac1G10GA10_TxFnsAdj10G_WRITE_TxFnsAdj10G
// EMAC10G_LlEthMac1G10GA10_TxFnsAdj1G_READ_TxFnsAdj1G
// EMAC10G_LlEthMac1G10GA10_TxFnsAdj1G_WRITE_TxFnsAdj1G
// EMAC10G_LlEthMac1G10GA10_TxFrameMaxLen_READ_TxFrameMaxLen
// EMAC10G_LlEthMac1G10GA10_TxFrameMaxLen_WRITE_TxFrameMaxLen
// EMAC10G_LlEthMac1G10GA10_TxIpg10G_READ_TxIpg10G
// EMAC10G_LlEthMac1G10GA10_TxIpg10G_WRITE_TxIpg10G
// EMAC10G_LlEthMac1G10GA10_TxIpg1G_READ_TxIpg1G
// EMAC10G_LlEthMac1G10GA10_TxIpg1G_WRITE_TxIpg1G
// EMAC10G_LlEthMac1G10GA10_TxNsAdj10G_READ_TxNsAdj10G
// EMAC10G_LlEthMac1G10GA10_TxNsAdj10G_WRITE_TxNsAdj10G
// EMAC10G_LlEthMac1G10GA10_TxNsAdj1G_READ_TxNsAdj1G
// EMAC10G_LlEthMac1G10GA10_TxNsAdj1G_WRITE_TxNsAdj1G
// EMAC10G_LlEthMac1G10GA10_TxP2p_READ_TxP2p
// EMAC10G_LlEthMac1G10GA10_TxP2p_WRITE_TxP2p
// EMAC10G_LlEthMac1G10GA10_TxPadCtrl_READ_TxPadCtrl
// EMAC10G_LlEthMac1G10GA10_TxPadCtrl_WRITE_TxPadCtrl
// EMAC10G_LlEthMac1G10GA10_TxPauseCtrl_READ_TxPauseCtrl
// EMAC10G_LlEthMac1G10GA10_TxPauseCtrl_WRITE_TxPauseCtrl
// EMAC10G_LlEthMac1G10GA10_TxPauseEnable_GET_Enable
// EMAC10G_LlEthMac1G10GA10_TxPauseEnable_GET_Trigger
// EMAC10G_LlEthMac1G10GA10_TxPauseEnable_READ
// EMAC10G_LlEthMac1G10GA10_TxPauseEnable_SET_Enable
// EMAC10G_LlEthMac1G10GA10_TxPauseEnable_SET_Trigger
// EMAC10G_LlEthMac1G10GA10_TxPauseEnable_WRITE
// EMAC10G_LlEthMac1G10GA10_TxPauseHoldoffQuanta_READ_TxPauseHoldoffQuanta
// EMAC10G_LlEthMac1G10GA10_TxPauseHoldoffQuanta_WRITE_TxPauseHoldoffQuanta
// EMAC10G_LlEthMac1G10GA10_TxPauseQuanta_READ_TxPauseQuanta
// EMAC10G_LlEthMac1G10GA10_TxPauseQuanta_WRITE_TxPauseQuanta
// EMAC10G_LlEthMac1G10GA10_TxPckCtrl_READ_TxPckCtrl
// EMAC10G_LlEthMac1G10GA10_TxPckCtrl_WRITE_TxPckCtrl
// EMAC10G_LlEthMac1G10GA10_TxPerMultSpeed_GET_Nanoseconds
// EMAC10G_LlEthMac1G10GA10_TxPerMultSpeed_GET_SubNanoseconds
// EMAC10G_LlEthMac1G10GA10_TxPerMultSpeed_READ
// EMAC10G_LlEthMac1G10GA10_TxPerMultSpeed_SET_Nanoseconds
// EMAC10G_LlEthMac1G10GA10_TxPerMultSpeed_SET_SubNanoseconds
// EMAC10G_LlEthMac1G10GA10_TxPerMultSpeed_WRITE
// EMAC10G_LlEthMac1G10GA10_TxPeriod10G_GET_Nanoseconds
// EMAC10G_LlEthMac1G10GA10_TxPeriod10G_GET_SubNanoseconds
// EMAC10G_LlEthMac1G10GA10_TxPeriod10G_READ
// EMAC10G_LlEthMac1G10GA10_TxPeriod10G_SET_Nanoseconds
// EMAC10G_LlEthMac1G10GA10_TxPeriod10G_SET_SubNanoseconds
// EMAC10G_LlEthMac1G10GA10_TxPeriod10G_WRITE
// EMAC10G_LlEthMac1G10GA10_TxSrcAddrOverride_READ_TxSrcAddrOverride
// EMAC10G_LlEthMac1G10GA10_TxSrcAddrOverride_WRITE_TxSrcAddrOverride
// EMAC10G_LlEthMac1G10GA10_TxStatsBCastCtrlH_READ_TxStatsBCastCtrlH
// EMAC10G_LlEthMac1G10GA10_TxStatsBCastErrH_READ_TxStatsBCastErrH
// EMAC10G_LlEthMac1G10GA10_TxStatsBCastErrL_READ_TxStatsBCastErrL
// EMAC10G_LlEthMac1G10GA10_TxStatsBCastMacCtrlL_READ_TxStatsBCastMacCtrlL
// EMAC10G_LlEthMac1G10GA10_TxStatsBCastOkH_READ_TxStatsBCastOkH
// EMAC10G_LlEthMac1G10GA10_TxStatsBCastOkL_READ_TxStatsBCastOkL
// EMAC10G_LlEthMac1G10GA10_TxStatsClr_READ_TxStatsClr
// EMAC10G_LlEthMac1G10GA10_TxStatsClr_WRITE_TxStatsClr
// EMAC10G_LlEthMac1G10GA10_TxStatsFr1024to1518H_READ_TxStatsFr1024to1518H
// EMAC10G_LlEthMac1G10GA10_TxStatsFr1024to1518L_READ_TxStatsFr1024to1518L
// EMAC10G_LlEthMac1G10GA10_TxStatsFr128to255H_READ_TxStatsFr128to255H
// EMAC10G_LlEthMac1G10GA10_TxStatsFr128to255L_READ_TxStatsFr128to255L
// EMAC10G_LlEthMac1G10GA10_TxStatsFr1519toXH_READ_TxStatsFr1519toXH
// EMAC10G_LlEthMac1G10GA10_TxStatsFr1519toXL_READ_TxStatsFr1519toXL
// EMAC10G_LlEthMac1G10GA10_TxStatsFr256to511H_READ_TxStatsFr256to511H
// EMAC10G_LlEthMac1G10GA10_TxStatsFr256to511L_READ_TxStatsFr256to511L
// EMAC10G_LlEthMac1G10GA10_TxStatsFr512to1023H_READ_TxStatsFr512to1023H
// EMAC10G_LlEthMac1G10GA10_TxStatsFr512to1023L_READ_TxStatsFr512to1023L
// EMAC10G_LlEthMac1G10GA10_TxStatsFr64H_READ_TxStatsFr64H
// EMAC10G_LlEthMac1G10GA10_TxStatsFr64L_READ_TxStatsFr64L
// EMAC10G_LlEthMac1G10GA10_TxStatsFr65to127H_READ_TxStatsFr65to127H
// EMAC10G_LlEthMac1G10GA10_TxStatsFr65to127L_READ_TxStatsFr65to127L
// EMAC10G_LlEthMac1G10GA10_TxStatsFrameErrH_READ_TxStatsFrameErrH
// EMAC10G_LlEthMac1G10GA10_TxStatsFrameErrL_READ_TxStatsFrameErrL
// EMAC10G_LlEthMac1G10GA10_TxStatsFrameOkH_READ_TxStatsFrameOkH
// EMAC10G_LlEthMac1G10GA10_TxStatsFrameOkL_READ_TxStatsFrameOkL
// EMAC10G_LlEthMac1G10GA10_TxStatsIfErrH_READ_TxStatsIfErrH
// EMAC10G_LlEthMac1G10GA10_TxStatsIfErrL_READ_TxStatsIfErrL
// EMAC10G_LlEthMac1G10GA10_TxStatsMCastErrH_READ_TxStatsMCastErrH
// EMAC10G_LlEthMac1G10GA10_TxStatsMCastErrL_READ_TxStatsMCastErrL
// EMAC10G_LlEthMac1G10GA10_TxStatsMCastMacCtrlH_READ_TxStatsMCastMacCtrlH
// EMAC10G_LlEthMac1G10GA10_TxStatsMCastMacCtrlL_READ_TxStatsMCastMacCtrlL
// EMAC10G_LlEthMac1G10GA10_TxStatsMCastOkH_READ_TxStatsMCastOkH
// EMAC10G_LlEthMac1G10GA10_TxStatsMCastOkL_READ_TxStatsMCastOkL
// EMAC10G_LlEthMac1G10GA10_TxStatsOSizeH_READ_TxStatsOSizeH
// EMAC10G_LlEthMac1G10GA10_TxStatsOSizeL_READ_TxStatsOSizeL
// EMAC10G_LlEthMac1G10GA10_TxStatsOctetsH_READ_TxStatsOctetsH
// EMAC10G_LlEthMac1G10GA10_TxStatsOctetsL_READ_TxStatsOctetsL
// EMAC10G_LlEthMac1G10GA10_TxStatsOctetsOkH_READ_TxStatsOctetsOkH
// EMAC10G_LlEthMac1G10GA10_TxStatsOctetsOkL_READ_TxStatsOctetsOkL
// EMAC10G_LlEthMac1G10GA10_TxStatsPauseFramesH_READ_TxStatsPauseFramesH
// EMAC10G_LlEthMac1G10GA10_TxStatsPauseFramesL_READ_TxStatsPauseFramesL
// EMAC10G_LlEthMac1G10GA10_TxStatsPfcCtrlH_READ_TxStatsPfcCtrlH
// EMAC10G_LlEthMac1G10GA10_TxStatsPfcCtrlL_READ_TxStatsPfcCtrlL
// EMAC10G_LlEthMac1G10GA10_TxStatsPktsH_READ_TxStatsPktsH
// EMAC10G_LlEthMac1G10GA10_TxStatsPktsL_READ_TxStatsPktsL
// EMAC10G_LlEthMac1G10GA10_TxStatsUCastErrH_READ_TxStatsUCastErrH
// EMAC10G_LlEthMac1G10GA10_TxStatsUCastErrL_READ_TxStatsUCastErrL
// EMAC10G_LlEthMac1G10GA10_TxStatsUCastMacCtrlH_READ_TxStatsUCastMacCtrlH
// EMAC10G_LlEthMac1G10GA10_TxStatsUCastMacCtrlL_READ_TxStatsUCastMacCtrlL
// EMAC10G_LlEthMac1G10GA10_TxStatsUCastOkH_READ_TxStatsUCastOkH
// EMAC10G_LlEthMac1G10GA10_TxStatsUCastOkL_READ_TxStatsUCastOkL
// EMAC10G_LlEthMac1G10GA10_TxStatsUSizeH_READ_TxStatsUSizeH
// EMAC10G_LlEthMac1G10GA10_TxStatsUSizeL_READ_TxStatsUSizeL
// EMAC10G_LlEthMac1G10GA10_TxTransferStat_GET_TxDpStat
// EMAC10G_LlEthMac1G10GA10_TxTransferStat_GET_TxRstStat
// EMAC10G_LlEthMac1G10GA10_TxTransferStat_READ
// EMAC10G_LlEthMac1G10GA10_TxTransferStat_READ_TxDpStat
// EMAC10G_LlEthMac1G10GA10_TxTransferStat_READ_TxRstStat
// EMAC10G_LlEthMac1G10GA10_TxUflowCntH_READ_TxUflowCntH
// EMAC10G_LlEthMac1G10GA10_TxUflowCntL_READ_TxUflowCntL
// EMAC10G_LlEthMac1G10GA10_TxVlanDet_READ_TxVlanDet
// EMAC10G_LlEthMac1G10GA10_TxVlanDet_WRITE_TxVlanDet
// EMAC10G_RxDelCnt_READ
// EMAC10G_SchedStatClr_READ
// EMAC10G_SchedStatClr_SET_ClrTooEarlyCnt
// EMAC10G_SchedStatClr_SET_ClrTooLateCnt
// EMAC10G_SchedStatClr_WRITE
// EMAC10G_SchedStat_GET_PacketSending
// EMAC10G_SchedStat_GET_PacketWaiting
// EMAC10G_SchedStat_GET_TooEarlyCnt
// EMAC10G_SchedStat_GET_TooLateCnt
// EMAC10G_SchedStat_READ
// EMAC10G_SchedStat_READ_PacketSending
// EMAC10G_SchedStat_READ_PacketWaiting
// EMAC10G_SchedStat_READ_TooEarlyCnt
// EMAC10G_SchedStat_READ_TooLateCnt
// EMAC10G_SchedulingOffset_WRITE
// EMAC10G_Status_CLEAR_MacAccessTimedout
// EMAC10G_Status_CLEAR_PhyAccessTimedout
// EMAC10G_Status_CLEAR_RxOverflow
// EMAC10G_Status_GET_LinkSpeed
// EMAC10G_Status_GET_LinkStat
// EMAC10G_Status_GET_MacAccessTimedout
// EMAC10G_Status_GET_PhyAccessTimedout
// EMAC10G_Status_GET_RxOverflow
// EMAC10G_Status_READ
// EMAC10G_Status_READ_LinkSpeed
// EMAC10G_Status_READ_LinkStat
// EMAC10G_Status_READ_MacAccessTimedout
// EMAC10G_Status_READ_PhyAccessTimedout
// EMAC10G_Status_READ_RxOverflow

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'ArbOwner'
#define EMAC10G_ARBOWNER_User     0x0  // User has control of the internal configuration
                                       // bus
#define EMAC10G_ARBOWNER_PreSICE  0x1  // PreSICE is controlling the internal
                                       // configuration bus

// Value map 'BlockEnable'
#define EMAC10G_BLKENA_DISABLED   0x0  // Block is entirely disabled
#define EMAC10G_BLKENA_ENABLED    0x1  // Block is enabled and processes data

// Value map 'MacCrcCheckEn'
#define EMAC10G_RXCRCEN_IGNORE    0x0  // Ignores the CRC field
#define EMAC10G_RXCRCEN_CHECK     0x1  // Checks the CRC field

// Value map 'MacIpg10G'
#define EMAC10G_IPG_8_BYTES       0x0  // Sets the average IPG to 8 bytes
#define EMAC10G_IPG_12_BYTES      0x1  // Sets the average IPG to 12 bytes

// Value map 'MacLinkSpeed'
#define EMAC10G_LINKSPEED_10G     0x0  // Link speed is 10Gbps
#define EMAC10G_LINKSPEED_1G      0x1  // Link speed is 1Gbps

// Value map 'MacLinkStat'
#define EMAC10G_LINKSTAT_DOWN     0x0  // Link is down
#define EMAC10G_LINKSTAT_UP       0x1  // Link is up

// Value map 'MacPadEn'
#define EMAC10G_PAD_DISABLE       0x0  // Disable padding insertion
#define EMAC10G_PAD_ENABLE        0x1  // Enables padding insertion

// Value map 'MacPathEn'
#define EMAC10G_PATH_ENABLE       0x0  // Enables the path
#define EMAC10G_PATH_DISABLE      0x1  // Disable the path

// Value map 'MacPauseCtrl'
#define EMAC10G_PAUSECTRL_NONE    0x0  // No pause frame transmission
#define EMAC10G_PAUSECTRL_XON     0x1  // Send an XON pause frame
#define EMAC10G_PAUSECTRL_XOFF    0x2  // Send an XOFF pause frame

// Value map 'MacPauseEn'
#define EMAC10G_PAUSEEN_DISABLE   0x0  // Disables pause frame transmission
#define EMAC10G_PAUSEEN_ENABLE    0x1  // Enables pause frame transmission, if Tx path is
                                       // enabled by tx_packet_control.

// Value map 'MacPauseSrc'
#define EMAC10G_PAUSESRC_VECTOR   0x0  // Accepts pause frame requests only from control
                                       // signal avalon_st_pause_data
#define EMAC10G_PAUSESRC_REG      0x1  // Accepts pause frame requests only from register
                                       // setting, TxPauseCtrl

// Value map 'MacRst'
#define EMAC10G_RST_STOP          0x0  // Stops the reset process
#define EMAC10G_RST_START         0x1  // Starts the reset process

// Value map 'MacRstStatus'
#define EMAC10G_RSTSTAT_NOTRESET  0x0  // The datapath is not in reset
#define EMAC10G_RSTSTAT_INRESET   0x1  // The datapath is in reset

// Value map 'MacRxCrcCtrl'
#define EMAC10G_RXCRCCTRL_NONE    0x0  // Keep padding and CRC
#define EMAC10G_RXCRCCTRL_CRC     0x1  // Keep padding, remove CRC
#define EMAC10G_RXCRCCTRL_PADCRC  0x2  // Remove padding and CRC

// Value map 'MacRxFilt'
#define EMAC10G_RXFILT_FILTER     0x0  // Drop matching frames
#define EMAC10G_RXFILT_ACCEPT     0x1  // Accept matching frames

// Value map 'MacRxPause'
#define EMAC10G_RXPAUSE_PROCESS   0x0  // Processes pause frames
#define EMAC10G_RXPAUSE_IGNORE    0x1  // Ignores pause frames

// Value map 'MacSrcOverride'
#define EMAC10G_SRCOVR_DISABLE    0x0  // Disables source address override
#define EMAC10G_SRCOVR_ENABLE     0x1  // Enables source address override

// Value map 'MacStatus'
#define EMAC10G_STATUS_IDLE       0x0  // The datapath is idle
#define EMAC10G_STATUS_ACTIVE     0x1  // A data transfer is in progress

// Value map 'MacSuppEn'
#define EMAC10G_SUPP_DISABLE      0x0  // Disable the use of supplementary address
#define EMAC10G_SUPP_ENABLE       0x1  // Enable the use of supplementary address

// Value map 'MacTxCrcEn'
#define EMAC10G_TXCRC_DISABLE     0x0  // Disables CRC insertion
#define EMAC10G_TXCRC_ENABLE      0x1  // Enables CRC insertion

// Value map 'MacVlanDet'
#define EMAC10G_VLANDET_DETECT    0x0  // The MAC detects VLAN and stacked VLAN frames
#define EMAC10G_VLANDET_NODETECT  0x1  // The MAC does not detect VLAN and stacked VLAN
                                       // frames.

// Value map 'OperationalMode'
#define EMAC10G_OPMODE_IDLE       0x0  // Block is inactive
#define EMAC10G_OPMODE_STANDBY    0x1  // Block is partially operational
#define EMAC10G_OPMODE_RUN        0x2  // Block performs its normal function

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// +=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Configuration' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC10G_Configuration_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x8);
}

// Field GET function.
static __inline UInt32 EMAC10G_Configuration_GET_JumboSupport(UInt32 Configuration)
{
    return Configuration & 0x1;
}

// Field READ function.
static __inline UInt32 EMAC10G_Configuration_READ_JumboSupport(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x8) & 0x1;
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC10G_Control_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0xC);
}

// Field SET functions.
static __inline UInt32 EMAC10G_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32 EMAC10G_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32 EMAC10G_Control_SET_PromiscuousMode(UInt32 Control, UInt32 PromiscuousMode)
{
    DT_ASSERT((PromiscuousMode & ~0x1) == 0);
    return (Control & ~0x8) | (PromiscuousMode << 3);
}
static __inline UInt32 EMAC10G_Control_SET_FlushFifos(UInt32 Control, UInt32 FlushFifos)
{
    DT_ASSERT((FlushFifos & ~0x1) == 0);
    return (Control & ~0x10) | (FlushFifos << 4);
}
static __inline UInt32 EMAC10G_Control_SET_MaxDelay(UInt32 Control, UInt32 MaxDelay)
{
    DT_ASSERT((MaxDelay & ~0xFFFF) == 0);
    return (Control & ~0xFFFF0000) | (MaxDelay << 16);
}

// Register WRITE function.
static __inline void EMAC10G_Control_WRITE(DtBcEMAC10G* Bc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)Bc, 0xC, Control);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC10G_Status_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10);
}

// Field GET functions.
static __inline UInt32 EMAC10G_Status_GET_MacAccessTimedout(UInt32 Status)
{
    return (Status & 0x2) >> 1;
}
static __inline UInt32 EMAC10G_Status_GET_PhyAccessTimedout(UInt32 Status)
{
    return (Status & 0x4) >> 2;
}
static __inline UInt32 EMAC10G_Status_GET_LinkStat(UInt32 Status)
{
    return (Status & 0x100) >> 8;
}
static __inline UInt32 EMAC10G_Status_GET_LinkSpeed(UInt32 Status)
{
    return (Status & 0x400) >> 10;
}
static __inline UInt32 EMAC10G_Status_GET_RxOverflow(UInt32 Status)
{
    return (Status & 0x10000) >> 16;
}

// Field READ functions.
static __inline UInt32 EMAC10G_Status_READ_MacAccessTimedout(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x10) & 0x2) >> 1;
}
static __inline UInt32 EMAC10G_Status_READ_PhyAccessTimedout(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x10) & 0x4) >> 2;
}
static __inline UInt32 EMAC10G_Status_READ_LinkStat(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x10) & 0x100) >> 8;
}
static __inline UInt32 EMAC10G_Status_READ_LinkSpeed(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x10) & 0x400) >> 10;
}
static __inline UInt32 EMAC10G_Status_READ_RxOverflow(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x10) & 0x10000) >> 16;
}

// Field CLEAR functions.
static __inline void EMAC10G_Status_CLEAR_MacAccessTimedout(DtBcEMAC10G* Bc)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10, 0x2);
}
static __inline void EMAC10G_Status_CLEAR_PhyAccessTimedout(DtBcEMAC10G* Bc)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10, 0x4);
}
static __inline void EMAC10G_Status_CLEAR_RxOverflow(DtBcEMAC10G* Bc)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10, 0x10000);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SchedulingOffset' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function.
static __inline void EMAC10G_SchedulingOffset_WRITE(DtBcEMAC10G* Bc, UInt32 SchedulingOffset)
{
    DT_ASSERT((SchedulingOffset & ~0x3FF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x14, SchedulingOffset);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxDelCnt' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_RxDelCnt_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x18);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SchedStat' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC10G_SchedStat_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1C);
}

// Field GET functions.
static __inline UInt32 EMAC10G_SchedStat_GET_TooEarlyCnt(UInt32 SchedStat)
{
    return SchedStat & 0xFF;
}
static __inline UInt32 EMAC10G_SchedStat_GET_TooLateCnt(UInt32 SchedStat)
{
    return (SchedStat & 0xFF00) >> 8;
}
static __inline UInt32 EMAC10G_SchedStat_GET_PacketWaiting(UInt32 SchedStat)
{
    return (SchedStat & 0x10000) >> 16;
}
static __inline UInt32 EMAC10G_SchedStat_GET_PacketSending(UInt32 SchedStat)
{
    return (SchedStat & 0x40000) >> 18;
}

// Field READ functions.
static __inline UInt32 EMAC10G_SchedStat_READ_TooEarlyCnt(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1C) & 0xFF;
}
static __inline UInt32 EMAC10G_SchedStat_READ_TooLateCnt(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x1C) & 0xFF00) >> 8;
}
static __inline UInt32 EMAC10G_SchedStat_READ_PacketWaiting(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x1C) & 0x10000) >> 16;
}
static __inline UInt32 EMAC10G_SchedStat_READ_PacketSending(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x1C) & 0x40000) >> 18;
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SchedStatClr' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC10G_SchedStatClr_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x20);
}

// Field SET functions.
static __inline UInt32 EMAC10G_SchedStatClr_SET_ClrTooEarlyCnt(UInt32 SchedStatClr, UInt32 ClrTooEarlyCnt)
{
    DT_ASSERT((ClrTooEarlyCnt & ~0x1) == 0);
    return (SchedStatClr & ~0x1) | ClrTooEarlyCnt;
}
static __inline UInt32 EMAC10G_SchedStatClr_SET_ClrTooLateCnt(UInt32 SchedStatClr, UInt32 ClrTooLateCnt)
{
    DT_ASSERT((ClrTooLateCnt & ~0x1) == 0);
    return (SchedStatClr & ~0x100) | (ClrTooLateCnt << 8);
}

// Register WRITE function.
static __inline void EMAC10G_SchedStatClr_WRITE(DtBcEMAC10G* Bc, UInt32 SchedStatClr)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x20, SchedStatClr);
}

// -.-.-.-.-.-.-.-.-.- Register 'EthPhy1G10GA10_PmaCalibrationControl' -.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationControl_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x40);
}

// Field GET functions.
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationControl_GET_AvalonControl(UInt32 EthPhy1G10GA10_PmaCalibrationControl)
{
    return EthPhy1G10GA10_PmaCalibrationControl & 0x1;
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationControl_GET_CalDone(UInt32 EthPhy1G10GA10_PmaCalibrationControl)
{
    return (EthPhy1G10GA10_PmaCalibrationControl & 0x2) >> 1;
}

// Field SET functions.
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationControl_SET_AvalonControl(UInt32 EthPhy1G10GA10_PmaCalibrationControl, UInt32 AvalonControl)
{
    DT_ASSERT((AvalonControl & ~0x1) == 0);
    return (EthPhy1G10GA10_PmaCalibrationControl & ~0x1) | AvalonControl;
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationControl_SET_CalDone(UInt32 EthPhy1G10GA10_PmaCalibrationControl, UInt32 CalDone)
{
    DT_ASSERT((CalDone & ~0x1) == 0);
    return (EthPhy1G10GA10_PmaCalibrationControl & ~0x2) | (CalDone << 1);
}

// Register WRITE function.
static __inline void EMAC10G_EthPhy1G10GA10_PmaCalibrationControl_WRITE(DtBcEMAC10G* Bc, UInt32 EthPhy1G10GA10_PmaCalibrationControl)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x40, EthPhy1G10GA10_PmaCalibrationControl);
}

// -.-.-.-.-.-.-.-.-.- Register 'EthPhy1G10GA10_PmaCalibrationEnable' -.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationEnable_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x44);
}

// Field GET functions.
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationEnable_GET_PmaRxCalEn(UInt32 EthPhy1G10GA10_PmaCalibrationEnable)
{
    return (EthPhy1G10GA10_PmaCalibrationEnable & 0x2) >> 1;
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationEnable_GET_PmaTxCalEn(UInt32 EthPhy1G10GA10_PmaCalibrationEnable)
{
    return (EthPhy1G10GA10_PmaCalibrationEnable & 0x20) >> 5;
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationEnable_GET_PmaAdaptTrigReqEn(UInt32 EthPhy1G10GA10_PmaCalibrationEnable)
{
    return (EthPhy1G10GA10_PmaCalibrationEnable & 0x40) >> 6;
}

// Field SET functions.
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationEnable_SET_PmaRxCalEn(UInt32 EthPhy1G10GA10_PmaCalibrationEnable, UInt32 PmaRxCalEn)
{
    DT_ASSERT((PmaRxCalEn & ~0x1) == 0);
    return (EthPhy1G10GA10_PmaCalibrationEnable & ~0x2) | (PmaRxCalEn << 1);
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationEnable_SET_PmaTxCalEn(UInt32 EthPhy1G10GA10_PmaCalibrationEnable, UInt32 PmaTxCalEn)
{
    DT_ASSERT((PmaTxCalEn & ~0x1) == 0);
    return (EthPhy1G10GA10_PmaCalibrationEnable & ~0x20) | (PmaTxCalEn << 5);
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationEnable_SET_PmaAdaptTrigReqEn(UInt32 EthPhy1G10GA10_PmaCalibrationEnable, UInt32 PmaAdaptTrigReqEn)
{
    DT_ASSERT((PmaAdaptTrigReqEn & ~0x1) == 0);
    return (EthPhy1G10GA10_PmaCalibrationEnable & ~0x40) | (PmaAdaptTrigReqEn << 6);
}

// Register WRITE function.
static __inline void EMAC10G_EthPhy1G10GA10_PmaCalibrationEnable_WRITE(DtBcEMAC10G* Bc, UInt32 EthPhy1G10GA10_PmaCalibrationEnable)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x44, EthPhy1G10GA10_PmaCalibrationEnable);
}

// -.-.-.-.-.-.-.-.-.- Register 'EthPhy1G10GA10_PmaCalibrationStatus' -.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationStatus_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4C);
}

// Field GET functions.
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationStatus_GET_TxCalBusy(UInt32 EthPhy1G10GA10_PmaCalibrationStatus)
{
    return EthPhy1G10GA10_PmaCalibrationStatus & 0x1;
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationStatus_GET_RxCalBusy(UInt32 EthPhy1G10GA10_PmaCalibrationStatus)
{
    return (EthPhy1G10GA10_PmaCalibrationStatus & 0x2) >> 1;
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationStatus_GET_AvMmBusy(UInt32 EthPhy1G10GA10_PmaCalibrationStatus)
{
    return (EthPhy1G10GA10_PmaCalibrationStatus & 0x4) >> 2;
}

// Field READ functions.
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationStatus_READ_TxCalBusy(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4C) & 0x1;
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationStatus_READ_RxCalBusy(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x4C) & 0x2) >> 1;
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaCalibrationStatus_READ_AvMmBusy(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x4C) & 0x4) >> 2;
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthPhy1G10GA10_PmaResetControl' -.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x50);
}

// Field GET functions.
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_GET_RxAnalogReset(UInt32 EthPhy1G10GA10_PmaResetControl)
{
    return EthPhy1G10GA10_PmaResetControl & 0x1;
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_GET_RxDigitalReset(UInt32 EthPhy1G10GA10_PmaResetControl)
{
    return (EthPhy1G10GA10_PmaResetControl & 0x2) >> 1;
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_GET_TxAnalogReset(UInt32 EthPhy1G10GA10_PmaResetControl)
{
    return (EthPhy1G10GA10_PmaResetControl & 0x4) >> 2;
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_GET_TxDigitalReset(UInt32 EthPhy1G10GA10_PmaResetControl)
{
    return (EthPhy1G10GA10_PmaResetControl & 0x8) >> 3;
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_GET_OverrideRxAnalogReset(UInt32 EthPhy1G10GA10_PmaResetControl)
{
    return (EthPhy1G10GA10_PmaResetControl & 0x10) >> 4;
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_GET_OverrideRxDigitalReset(UInt32 EthPhy1G10GA10_PmaResetControl)
{
    return (EthPhy1G10GA10_PmaResetControl & 0x20) >> 5;
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_GET_OverrideTxAnalogReset(UInt32 EthPhy1G10GA10_PmaResetControl)
{
    return (EthPhy1G10GA10_PmaResetControl & 0x40) >> 6;
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_GET_OverrideTxDigitalReset(UInt32 EthPhy1G10GA10_PmaResetControl)
{
    return (EthPhy1G10GA10_PmaResetControl & 0x80) >> 7;
}

// Field SET functions.
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_SET_RxAnalogReset(UInt32 EthPhy1G10GA10_PmaResetControl, UInt32 RxAnalogReset)
{
    DT_ASSERT((RxAnalogReset & ~0x1) == 0);
    return (EthPhy1G10GA10_PmaResetControl & ~0x1) | RxAnalogReset;
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_SET_RxDigitalReset(UInt32 EthPhy1G10GA10_PmaResetControl, UInt32 RxDigitalReset)
{
    DT_ASSERT((RxDigitalReset & ~0x1) == 0);
    return (EthPhy1G10GA10_PmaResetControl & ~0x2) | (RxDigitalReset << 1);
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_SET_TxAnalogReset(UInt32 EthPhy1G10GA10_PmaResetControl, UInt32 TxAnalogReset)
{
    DT_ASSERT((TxAnalogReset & ~0x1) == 0);
    return (EthPhy1G10GA10_PmaResetControl & ~0x4) | (TxAnalogReset << 2);
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_SET_TxDigitalReset(UInt32 EthPhy1G10GA10_PmaResetControl, UInt32 TxDigitalReset)
{
    DT_ASSERT((TxDigitalReset & ~0x1) == 0);
    return (EthPhy1G10GA10_PmaResetControl & ~0x8) | (TxDigitalReset << 3);
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_SET_OverrideRxAnalogReset(UInt32 EthPhy1G10GA10_PmaResetControl, UInt32 OverrideRxAnalogReset)
{
    DT_ASSERT((OverrideRxAnalogReset & ~0x1) == 0);
    return (EthPhy1G10GA10_PmaResetControl & ~0x10) | (OverrideRxAnalogReset << 4);
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_SET_OverrideRxDigitalReset(UInt32 EthPhy1G10GA10_PmaResetControl, UInt32 OverrideRxDigitalReset)
{
    DT_ASSERT((OverrideRxDigitalReset & ~0x1) == 0);
    return (EthPhy1G10GA10_PmaResetControl & ~0x20) | (OverrideRxDigitalReset << 5);
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_SET_OverrideTxAnalogReset(UInt32 EthPhy1G10GA10_PmaResetControl, UInt32 OverrideTxAnalogReset)
{
    DT_ASSERT((OverrideTxAnalogReset & ~0x1) == 0);
    return (EthPhy1G10GA10_PmaResetControl & ~0x40) | (OverrideTxAnalogReset << 6);
}
static __inline UInt32 EMAC10G_EthPhy1G10GA10_PmaResetControl_SET_OverrideTxDigitalReset(UInt32 EthPhy1G10GA10_PmaResetControl, UInt32 OverrideTxDigitalReset)
{
    DT_ASSERT((OverrideTxDigitalReset & ~0x1) == 0);
    return (EthPhy1G10GA10_PmaResetControl & ~0x80) | (OverrideTxDigitalReset << 7);
}

// Register WRITE function.
static __inline void EMAC10G_EthPhy1G10GA10_PmaResetControl_WRITE(DtBcEMAC10G* Bc, UInt32 EthPhy1G10GA10_PmaResetControl)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x50, EthPhy1G10GA10_PmaResetControl);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_PrimMacAddrL' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_PrimMacAddrL_READ_PrimMacAddrL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1000);
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_PrimMacAddrL_WRITE_PrimMacAddrL(DtBcEMAC10G* Bc, UInt32 PrimMacAddrL)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x1000, PrimMacAddrL);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_PrimMacAddrH' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_PrimMacAddrH_READ_PrimMacAddrH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1004) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_PrimMacAddrH_WRITE_PrimMacAddrH(DtBcEMAC10G* Bc, UInt32 PrimMacAddrH)
{
    DT_ASSERT((PrimMacAddrH & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x1004, PrimMacAddrH);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_MacRstCtrl' -.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_MacRstCtrl_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1008);
}

// Field GET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_MacRstCtrl_GET_TxDpRst(UInt32 LlEthMac1G10GA10_MacRstCtrl)
{
    return LlEthMac1G10GA10_MacRstCtrl & 0x1;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_MacRstCtrl_GET_RxDpRst(UInt32 LlEthMac1G10GA10_MacRstCtrl)
{
    return (LlEthMac1G10GA10_MacRstCtrl & 0x100) >> 8;
}

// Field SET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_MacRstCtrl_SET_TxDpRst(UInt32 LlEthMac1G10GA10_MacRstCtrl, UInt32 TxDpRst)
{
    DT_ASSERT((TxDpRst & ~0x1) == 0);
    return (LlEthMac1G10GA10_MacRstCtrl & ~0x1) | TxDpRst;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_MacRstCtrl_SET_RxDpRst(UInt32 LlEthMac1G10GA10_MacRstCtrl, UInt32 RxDpRst)
{
    DT_ASSERT((RxDpRst & ~0x1) == 0);
    return (LlEthMac1G10GA10_MacRstCtrl & ~0x100) | (RxDpRst << 8);
}

// Register WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_MacRstCtrl_WRITE(DtBcEMAC10G* Bc, UInt32 LlEthMac1G10GA10_MacRstCtrl)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x1008, LlEthMac1G10GA10_MacRstCtrl);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxPckCtrl' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPckCtrl_READ_TxPckCtrl(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x100C) & 0x1;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxPckCtrl_WRITE_TxPckCtrl(DtBcEMAC10G* Bc, UInt32 TxPckCtrl)
{
    DT_ASSERT((TxPckCtrl & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x100C, TxPckCtrl);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxTransferStat' -.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxTransferStat_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1010);
}

// Field GET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxTransferStat_GET_TxDpStat(UInt32 LlEthMac1G10GA10_TxTransferStat)
{
    return (LlEthMac1G10GA10_TxTransferStat & 0x100) >> 8;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxTransferStat_GET_TxRstStat(UInt32 LlEthMac1G10GA10_TxTransferStat)
{
    return (LlEthMac1G10GA10_TxTransferStat & 0x1000) >> 12;
}

// Field READ functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxTransferStat_READ_TxDpStat(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x1010) & 0x100) >> 8;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxTransferStat_READ_TxRstStat(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x1010) & 0x1000) >> 12;
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxPadCtrl' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPadCtrl_READ_TxPadCtrl(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1014) & 0x1;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxPadCtrl_WRITE_TxPadCtrl(DtBcEMAC10G* Bc, UInt32 TxPadCtrl)
{
    DT_ASSERT((TxPadCtrl & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x1014, TxPadCtrl);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxCrcCtrl' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxCrcCtrl_READ_TxCrcCtrl(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x1018) & 0x2) >> 1;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxCrcCtrl_WRITE_TxCrcCtrl(DtBcEMAC10G* Bc, UInt32 TxCrcCtrl)
{
    DT_ASSERT((TxCrcCtrl & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x1018, (TxCrcCtrl << 1) | 0x1);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxSrcAddrOverride' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxSrcAddrOverride_READ_TxSrcAddrOverride(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x101C) & 0x1;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxSrcAddrOverride_WRITE_TxSrcAddrOverride(DtBcEMAC10G* Bc, UInt32 TxSrcAddrOverride)
{
    DT_ASSERT((TxSrcAddrOverride & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x101C, TxSrcAddrOverride);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxFrameMaxLen' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxFrameMaxLen_READ_TxFrameMaxLen(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1020) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxFrameMaxLen_WRITE_TxFrameMaxLen(DtBcEMAC10G* Bc, UInt32 TxFrameMaxLen)
{
    DT_ASSERT((TxFrameMaxLen & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x1020, TxFrameMaxLen);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxVlanDet' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxVlanDet_READ_TxVlanDet(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1024) & 0x1;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxVlanDet_WRITE_TxVlanDet(DtBcEMAC10G* Bc, UInt32 TxVlanDet)
{
    DT_ASSERT((TxVlanDet & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x1024, TxVlanDet);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxIpg10G' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxIpg10G_READ_TxIpg10G(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1028) & 0x1;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxIpg10G_WRITE_TxIpg10G(DtBcEMAC10G* Bc, UInt32 TxIpg10G)
{
    DT_ASSERT((TxIpg10G & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x1028, TxIpg10G);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxIpg1G' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxIpg1G_READ_TxIpg1G(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x102C) & 0xF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxIpg1G_WRITE_TxIpg1G(DtBcEMAC10G* Bc, UInt32 TxIpg1G)
{
    DT_ASSERT((TxIpg1G & ~0xF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x102C, TxIpg1G);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxUflowCntL' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxUflowCntL_READ_TxUflowCntL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1030);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxUflowCntH' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxUflowCntH_READ_TxUflowCntH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1034) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxPauseCtrl' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPauseCtrl_READ_TxPauseCtrl(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1038) & 0x3;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxPauseCtrl_WRITE_TxPauseCtrl(DtBcEMAC10G* Bc, UInt32 TxPauseCtrl)
{
    DT_ASSERT((TxPauseCtrl & ~0x3) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x1038, TxPauseCtrl);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxPauseQuanta' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPauseQuanta_READ_TxPauseQuanta(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x103C) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxPauseQuanta_WRITE_TxPauseQuanta(DtBcEMAC10G* Bc, UInt32 TxPauseQuanta)
{
    DT_ASSERT((TxPauseQuanta & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x103C, TxPauseQuanta);
}

// .-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxPauseHoldoffQuanta' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPauseHoldoffQuanta_READ_TxPauseHoldoffQuanta(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1040) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxPauseHoldoffQuanta_WRITE_TxPauseHoldoffQuanta(DtBcEMAC10G* Bc, UInt32 TxPauseHoldoffQuanta)
{
    DT_ASSERT((TxPauseHoldoffQuanta & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x1040, TxPauseHoldoffQuanta);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxPauseEnable' -.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPauseEnable_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1044);
}

// Field GET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPauseEnable_GET_Enable(UInt32 LlEthMac1G10GA10_TxPauseEnable)
{
    return LlEthMac1G10GA10_TxPauseEnable & 0x1;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPauseEnable_GET_Trigger(UInt32 LlEthMac1G10GA10_TxPauseEnable)
{
    return (LlEthMac1G10GA10_TxPauseEnable & 0x6) >> 1;
}

// Field SET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPauseEnable_SET_Enable(UInt32 LlEthMac1G10GA10_TxPauseEnable, UInt32 Enable)
{
    DT_ASSERT((Enable & ~0x1) == 0);
    return (LlEthMac1G10GA10_TxPauseEnable & ~0x1) | Enable;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPauseEnable_SET_Trigger(UInt32 LlEthMac1G10GA10_TxPauseEnable, UInt32 Trigger)
{
    DT_ASSERT((Trigger & ~0x3) == 0);
    return (LlEthMac1G10GA10_TxPauseEnable & ~0x6) | (Trigger << 1);
}

// Register WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxPauseEnable_WRITE(DtBcEMAC10G* Bc, UInt32 LlEthMac1G10GA10_TxPauseEnable)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x1044, LlEthMac1G10GA10_TxPauseEnable);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxTransferCtrl' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxTransferCtrl_READ_RxTransferCtrl(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1048) & 0x1;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxTransferCtrl_WRITE_RxTransferCtrl(DtBcEMAC10G* Bc, UInt32 RxTransferCtrl)
{
    DT_ASSERT((RxTransferCtrl & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x1048, RxTransferCtrl);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxTransferStat' -.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxTransferStat_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x104C);
}

// Field GET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxTransferStat_GET_RxDpStat(UInt32 LlEthMac1G10GA10_RxTransferStat)
{
    return (LlEthMac1G10GA10_RxTransferStat & 0x100) >> 8;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxTransferStat_GET_RxRstStat(UInt32 LlEthMac1G10GA10_RxTransferStat)
{
    return (LlEthMac1G10GA10_RxTransferStat & 0x1000) >> 12;
}

// Field READ functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxTransferStat_READ_RxDpStat(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x104C) & 0x100) >> 8;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxTransferStat_READ_RxRstStat(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x104C) & 0x1000) >> 12;
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxPadCrcCtrl' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxPadCrcCtrl_READ_RxPadCrcCtrl(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1050) & 0x3;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxPadCrcCtrl_WRITE_RxPadCrcCtrl(DtBcEMAC10G* Bc, UInt32 RxPadCrcCtrl)
{
    DT_ASSERT((RxPadCrcCtrl & ~0x3) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x1050, RxPadCrcCtrl);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxCrcCheckCtrl' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxCrcCheckCtrl_READ_RxCrcCheckCtrl(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x1054) & 0x2) >> 1;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxCrcCheckCtrl_WRITE_RxCrcCheckCtrl(DtBcEMAC10G* Bc, UInt32 RxCrcCheckCtrl)
{
    DT_ASSERT((RxCrcCheckCtrl & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x1054, RxCrcCheckCtrl << 1);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxFrameCtrl' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1058);
}

// Field GET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_EnAllUCast(UInt32 LlEthMac1G10GA10_RxFrameCtrl)
{
    return LlEthMac1G10GA10_RxFrameCtrl & 0x1;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_EnAllMCast(UInt32 LlEthMac1G10GA10_RxFrameCtrl)
{
    return (LlEthMac1G10GA10_RxFrameCtrl & 0x2) >> 1;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_FwdCtrl(UInt32 LlEthMac1G10GA10_RxFrameCtrl)
{
    return (LlEthMac1G10GA10_RxFrameCtrl & 0x8) >> 3;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_FwdPause(UInt32 LlEthMac1G10GA10_RxFrameCtrl)
{
    return (LlEthMac1G10GA10_RxFrameCtrl & 0x10) >> 4;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_IgnorePause(UInt32 LlEthMac1G10GA10_RxFrameCtrl)
{
    return (LlEthMac1G10GA10_RxFrameCtrl & 0x20) >> 5;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_EnSupp0(UInt32 LlEthMac1G10GA10_RxFrameCtrl)
{
    return (LlEthMac1G10GA10_RxFrameCtrl & 0x10000) >> 16;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_EnSupp1(UInt32 LlEthMac1G10GA10_RxFrameCtrl)
{
    return (LlEthMac1G10GA10_RxFrameCtrl & 0x20000) >> 17;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_EnSupp2(UInt32 LlEthMac1G10GA10_RxFrameCtrl)
{
    return (LlEthMac1G10GA10_RxFrameCtrl & 0x40000) >> 18;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_GET_EnSupp3(UInt32 LlEthMac1G10GA10_RxFrameCtrl)
{
    return (LlEthMac1G10GA10_RxFrameCtrl & 0x80000) >> 19;
}

// Field SET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_EnAllUCast(UInt32 LlEthMac1G10GA10_RxFrameCtrl, UInt32 EnAllUCast)
{
    DT_ASSERT((EnAllUCast & ~0x1) == 0);
    return (LlEthMac1G10GA10_RxFrameCtrl & ~0x1) | EnAllUCast;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_EnAllMCast(UInt32 LlEthMac1G10GA10_RxFrameCtrl, UInt32 EnAllMCast)
{
    DT_ASSERT((EnAllMCast & ~0x1) == 0);
    return (LlEthMac1G10GA10_RxFrameCtrl & ~0x2) | (EnAllMCast << 1);
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_FwdCtrl(UInt32 LlEthMac1G10GA10_RxFrameCtrl, UInt32 FwdCtrl)
{
    DT_ASSERT((FwdCtrl & ~0x1) == 0);
    return (LlEthMac1G10GA10_RxFrameCtrl & ~0x8) | (FwdCtrl << 3);
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_FwdPause(UInt32 LlEthMac1G10GA10_RxFrameCtrl, UInt32 FwdPause)
{
    DT_ASSERT((FwdPause & ~0x1) == 0);
    return (LlEthMac1G10GA10_RxFrameCtrl & ~0x10) | (FwdPause << 4);
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_IgnorePause(UInt32 LlEthMac1G10GA10_RxFrameCtrl, UInt32 IgnorePause)
{
    DT_ASSERT((IgnorePause & ~0x1) == 0);
    return (LlEthMac1G10GA10_RxFrameCtrl & ~0x20) | (IgnorePause << 5);
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_EnSupp0(UInt32 LlEthMac1G10GA10_RxFrameCtrl, UInt32 EnSupp0)
{
    DT_ASSERT((EnSupp0 & ~0x1) == 0);
    return (LlEthMac1G10GA10_RxFrameCtrl & ~0x10000) | (EnSupp0 << 16);
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_EnSupp1(UInt32 LlEthMac1G10GA10_RxFrameCtrl, UInt32 EnSupp1)
{
    DT_ASSERT((EnSupp1 & ~0x1) == 0);
    return (LlEthMac1G10GA10_RxFrameCtrl & ~0x20000) | (EnSupp1 << 17);
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_EnSupp2(UInt32 LlEthMac1G10GA10_RxFrameCtrl, UInt32 EnSupp2)
{
    DT_ASSERT((EnSupp2 & ~0x1) == 0);
    return (LlEthMac1G10GA10_RxFrameCtrl & ~0x40000) | (EnSupp2 << 18);
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_SET_EnSupp3(UInt32 LlEthMac1G10GA10_RxFrameCtrl, UInt32 EnSupp3)
{
    DT_ASSERT((EnSupp3 & ~0x1) == 0);
    return (LlEthMac1G10GA10_RxFrameCtrl & ~0x80000) | (EnSupp3 << 19);
}

// Register WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxFrameCtrl_WRITE(DtBcEMAC10G* Bc, UInt32 LlEthMac1G10GA10_RxFrameCtrl)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x1058, LlEthMac1G10GA10_RxFrameCtrl);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxFrameMaxLen' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameMaxLen_READ_RxFrameMaxLen(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x105C) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxFrameMaxLen_WRITE_RxFrameMaxLen(DtBcEMAC10G* Bc, UInt32 RxFrameMaxLen)
{
    DT_ASSERT((RxFrameMaxLen & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x105C, RxFrameMaxLen);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxVlanDet' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxVlanDet_READ_RxVlanDet(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1060) & 0x1;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxVlanDet_WRITE_RxVlanDet(DtBcEMAC10G* Bc, UInt32 RxVlanDet)
{
    DT_ASSERT((RxVlanDet & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x1060, RxVlanDet);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxFrameSpAddr0L' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr0L_READ_RxFrameSpAddr0L(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1068);
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr0L_WRITE_RxFrameSpAddr0L(DtBcEMAC10G* Bc, UInt32 RxFrameSpAddr0L)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x1068, RxFrameSpAddr0L);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxFrameSpAddr0H' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr0H_READ_RxFrameSpAddr0H(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x106C) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr0H_WRITE_RxFrameSpAddr0H(DtBcEMAC10G* Bc, UInt32 RxFrameSpAddr0H)
{
    DT_ASSERT((RxFrameSpAddr0H & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x106C, RxFrameSpAddr0H);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxFrameSpAddr1L' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr1L_READ_RxFrameSpAddr1L(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1070);
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr1L_WRITE_RxFrameSpAddr1L(DtBcEMAC10G* Bc, UInt32 RxFrameSpAddr1L)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x1070, RxFrameSpAddr1L);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxFrameSpAddr1H' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr1H_READ_RxFrameSpAddr1H(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1074) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr1H_WRITE_RxFrameSpAddr1H(DtBcEMAC10G* Bc, UInt32 RxFrameSpAddr1H)
{
    DT_ASSERT((RxFrameSpAddr1H & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x1074, RxFrameSpAddr1H);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxFrameSpAddr2L' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr2L_READ_RxFrameSpAddr2L(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1078);
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr2L_WRITE_RxFrameSpAddr2L(DtBcEMAC10G* Bc, UInt32 RxFrameSpAddr2L)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x1078, RxFrameSpAddr2L);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxFrameSpAddr2H' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr2H_READ_RxFrameSpAddr2H(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x107C) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr2H_WRITE_RxFrameSpAddr2H(DtBcEMAC10G* Bc, UInt32 RxFrameSpAddr2H)
{
    DT_ASSERT((RxFrameSpAddr2H & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x107C, RxFrameSpAddr2H);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxFrameSpAddr3L' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr3L_READ_RxFrameSpAddr3L(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1080);
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr3L_WRITE_RxFrameSpAddr3L(DtBcEMAC10G* Bc, UInt32 RxFrameSpAddr3L)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x1080, RxFrameSpAddr3L);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxFrameSpAddr3H' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr3H_READ_RxFrameSpAddr3H(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1084) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxFrameSpAddr3H_WRITE_RxFrameSpAddr3H(DtBcEMAC10G* Bc, UInt32 RxFrameSpAddr3H)
{
    DT_ASSERT((RxFrameSpAddr3H & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x1084, RxFrameSpAddr3H);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxOflowTruncCntL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxOflowTruncCntL_READ_RxOflowTruncCntL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1088);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxOflowTruncCntH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxOflowTruncCntH_READ_RxOflowTruncCntH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x108C) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxOflowDropCntL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxOflowDropCntL_READ_RxOflowDropCntL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1090);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxOflowDropCntH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxOflowDropCntH_READ_RxOflowDropCntH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1094) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxPeriod10G' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPeriod10G_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1098);
}

// Field GET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPeriod10G_GET_SubNanoseconds(UInt32 LlEthMac1G10GA10_TxPeriod10G)
{
    return LlEthMac1G10GA10_TxPeriod10G & 0xFFFF;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPeriod10G_GET_Nanoseconds(UInt32 LlEthMac1G10GA10_TxPeriod10G)
{
    return (LlEthMac1G10GA10_TxPeriod10G & 0xF0000) >> 16;
}

// Field SET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPeriod10G_SET_SubNanoseconds(UInt32 LlEthMac1G10GA10_TxPeriod10G, UInt32 SubNanoseconds)
{
    DT_ASSERT((SubNanoseconds & ~0xFFFF) == 0);
    return (LlEthMac1G10GA10_TxPeriod10G & ~0xFFFF) | SubNanoseconds;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPeriod10G_SET_Nanoseconds(UInt32 LlEthMac1G10GA10_TxPeriod10G, UInt32 Nanoseconds)
{
    DT_ASSERT((Nanoseconds & ~0xF) == 0);
    return (LlEthMac1G10GA10_TxPeriod10G & ~0xF0000) | (Nanoseconds << 16);
}

// Register WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxPeriod10G_WRITE(DtBcEMAC10G* Bc, UInt32 LlEthMac1G10GA10_TxPeriod10G)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x1098, LlEthMac1G10GA10_TxPeriod10G);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxFnsAdj10G' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxFnsAdj10G_READ_TxFnsAdj10G(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x109C) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxFnsAdj10G_WRITE_TxFnsAdj10G(DtBcEMAC10G* Bc, UInt32 TxFnsAdj10G)
{
    DT_ASSERT((TxFnsAdj10G & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x109C, TxFnsAdj10G);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxNsAdj10G' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxNsAdj10G_READ_TxNsAdj10G(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10A0) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxNsAdj10G_WRITE_TxNsAdj10G(DtBcEMAC10G* Bc, UInt32 TxNsAdj10G)
{
    DT_ASSERT((TxNsAdj10G & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x10A0, TxNsAdj10G);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxPerMultSpeed' -.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPerMultSpeed_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10A4);
}

// Field GET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPerMultSpeed_GET_SubNanoseconds(UInt32 LlEthMac1G10GA10_TxPerMultSpeed)
{
    return LlEthMac1G10GA10_TxPerMultSpeed & 0xFFFF;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPerMultSpeed_GET_Nanoseconds(UInt32 LlEthMac1G10GA10_TxPerMultSpeed)
{
    return (LlEthMac1G10GA10_TxPerMultSpeed & 0xF0000) >> 16;
}

// Field SET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPerMultSpeed_SET_SubNanoseconds(UInt32 LlEthMac1G10GA10_TxPerMultSpeed, UInt32 SubNanoseconds)
{
    DT_ASSERT((SubNanoseconds & ~0xFFFF) == 0);
    return (LlEthMac1G10GA10_TxPerMultSpeed & ~0xFFFF) | SubNanoseconds;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxPerMultSpeed_SET_Nanoseconds(UInt32 LlEthMac1G10GA10_TxPerMultSpeed, UInt32 Nanoseconds)
{
    DT_ASSERT((Nanoseconds & ~0xF) == 0);
    return (LlEthMac1G10GA10_TxPerMultSpeed & ~0xF0000) | (Nanoseconds << 16);
}

// Register WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxPerMultSpeed_WRITE(DtBcEMAC10G* Bc, UInt32 LlEthMac1G10GA10_TxPerMultSpeed)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10A4, LlEthMac1G10GA10_TxPerMultSpeed);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxFnsAdj1G' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxFnsAdj1G_READ_TxFnsAdj1G(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10A8) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxFnsAdj1G_WRITE_TxFnsAdj1G(DtBcEMAC10G* Bc, UInt32 TxFnsAdj1G)
{
    DT_ASSERT((TxFnsAdj1G & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x10A8, TxFnsAdj1G);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxNsAdj1G' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxNsAdj1G_READ_TxNsAdj1G(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10AC) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxNsAdj1G_WRITE_TxNsAdj1G(DtBcEMAC10G* Bc, UInt32 TxNsAdj1G)
{
    DT_ASSERT((TxNsAdj1G & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x10AC, TxNsAdj1G);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxAsymmetry' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxAsymmetry_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10B0);
}

// Field GET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxAsymmetry_GET_AsymVal(UInt32 LlEthMac1G10GA10_TxAsymmetry)
{
    return LlEthMac1G10GA10_TxAsymmetry & 0xFFFF;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxAsymmetry_GET_AsymDir(UInt32 LlEthMac1G10GA10_TxAsymmetry)
{
    return (LlEthMac1G10GA10_TxAsymmetry & 0x20000) >> 17;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxAsymmetry_GET_AsymEn(UInt32 LlEthMac1G10GA10_TxAsymmetry)
{
    return (LlEthMac1G10GA10_TxAsymmetry & 0x40000) >> 18;
}

// Field SET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxAsymmetry_SET_AsymVal(UInt32 LlEthMac1G10GA10_TxAsymmetry, UInt32 AsymVal)
{
    DT_ASSERT((AsymVal & ~0xFFFF) == 0);
    return (LlEthMac1G10GA10_TxAsymmetry & ~0xFFFF) | AsymVal;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxAsymmetry_SET_AsymDir(UInt32 LlEthMac1G10GA10_TxAsymmetry, UInt32 AsymDir)
{
    DT_ASSERT((AsymDir & ~0x1) == 0);
    return (LlEthMac1G10GA10_TxAsymmetry & ~0x20000) | (AsymDir << 17);
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxAsymmetry_SET_AsymEn(UInt32 LlEthMac1G10GA10_TxAsymmetry, UInt32 AsymEn)
{
    DT_ASSERT((AsymEn & ~0x1) == 0);
    return (LlEthMac1G10GA10_TxAsymmetry & ~0x40000) | (AsymEn << 18);
}

// Register WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxAsymmetry_WRITE(DtBcEMAC10G* Bc, UInt32 LlEthMac1G10GA10_TxAsymmetry)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10B0, LlEthMac1G10GA10_TxAsymmetry);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxP2p' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxP2p_READ_TxP2p(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10B4) & 0x1;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxP2p_WRITE_TxP2p(DtBcEMAC10G* Bc, UInt32 TxP2p)
{
    DT_ASSERT((TxP2p & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x10B4, TxP2p);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_CfErrStat' -.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_CfErrStat_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10B8);
}

// Field GET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_CfErrStat_GET_RxCfErrStat(UInt32 LlEthMac1G10GA10_CfErrStat)
{
    return LlEthMac1G10GA10_CfErrStat & 0x1;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_CfErrStat_GET_TxCfErrStat(UInt32 LlEthMac1G10GA10_CfErrStat)
{
    return (LlEthMac1G10GA10_CfErrStat & 0x10000) >> 16;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_CfErrStat_GET_ResTimeErrStat(UInt32 LlEthMac1G10GA10_CfErrStat)
{
    return (LlEthMac1G10GA10_CfErrStat & 0x20000) >> 17;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_CfErrStat_GET_ResTimeNegStat(UInt32 LlEthMac1G10GA10_CfErrStat)
{
    return (LlEthMac1G10GA10_CfErrStat & 0x40000) >> 18;
}

// Field READ functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_CfErrStat_READ_RxCfErrStat(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10B8) & 0x1;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_CfErrStat_READ_TxCfErrStat(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x10B8) & 0x10000) >> 16;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_CfErrStat_READ_ResTimeErrStat(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x10B8) & 0x20000) >> 17;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_CfErrStat_READ_ResTimeNegStat(DtBcEMAC10G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x10B8) & 0x40000) >> 18;
}

// Field CLEAR functions.
static __inline void EMAC10G_LlEthMac1G10GA10_CfErrStat_CLEAR_RxCfErrStat(DtBcEMAC10G* Bc)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10B8, 0x1);
}
static __inline void EMAC10G_LlEthMac1G10GA10_CfErrStat_CLEAR_TxCfErrStat(DtBcEMAC10G* Bc)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10B8, 0x10000);
}
static __inline void EMAC10G_LlEthMac1G10GA10_CfErrStat_CLEAR_ResTimeErrStat(DtBcEMAC10G* Bc)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10B8, 0x20000);
}
static __inline void EMAC10G_LlEthMac1G10GA10_CfErrStat_CLEAR_ResTimeNegStat(DtBcEMAC10G* Bc)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10B8, 0x40000);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxPeriod10G' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxPeriod10G_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10BC);
}

// Field GET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxPeriod10G_GET_SubNanoseconds(UInt32 LlEthMac1G10GA10_RxPeriod10G)
{
    return LlEthMac1G10GA10_RxPeriod10G & 0xFFFF;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxPeriod10G_GET_Nanoseconds(UInt32 LlEthMac1G10GA10_RxPeriod10G)
{
    return (LlEthMac1G10GA10_RxPeriod10G & 0xF0000) >> 16;
}

// Field SET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxPeriod10G_SET_SubNanoseconds(UInt32 LlEthMac1G10GA10_RxPeriod10G, UInt32 SubNanoseconds)
{
    DT_ASSERT((SubNanoseconds & ~0xFFFF) == 0);
    return (LlEthMac1G10GA10_RxPeriod10G & ~0xFFFF) | SubNanoseconds;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxPeriod10G_SET_Nanoseconds(UInt32 LlEthMac1G10GA10_RxPeriod10G, UInt32 Nanoseconds)
{
    DT_ASSERT((Nanoseconds & ~0xF) == 0);
    return (LlEthMac1G10GA10_RxPeriod10G & ~0xF0000) | (Nanoseconds << 16);
}

// Register WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxPeriod10G_WRITE(DtBcEMAC10G* Bc, UInt32 LlEthMac1G10GA10_RxPeriod10G)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10BC, LlEthMac1G10GA10_RxPeriod10G);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxFnsAdj10G' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFnsAdj10G_READ_RxFnsAdj10G(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10C0) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxFnsAdj10G_WRITE_RxFnsAdj10G(DtBcEMAC10G* Bc, UInt32 RxFnsAdj10G)
{
    DT_ASSERT((RxFnsAdj10G & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x10C0, RxFnsAdj10G);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxNsAdj10G' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxNsAdj10G_READ_RxNsAdj10G(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10C4) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxNsAdj10G_WRITE_RxNsAdj10G(DtBcEMAC10G* Bc, UInt32 RxNsAdj10G)
{
    DT_ASSERT((RxNsAdj10G & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x10C4, RxNsAdj10G);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxPerMultSpeed' -.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxPerMultSpeed_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10C8);
}

// Field GET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxPerMultSpeed_GET_SubNanoseconds(UInt32 LlEthMac1G10GA10_RxPerMultSpeed)
{
    return LlEthMac1G10GA10_RxPerMultSpeed & 0xFFFF;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxPerMultSpeed_GET_Nanoseconds(UInt32 LlEthMac1G10GA10_RxPerMultSpeed)
{
    return (LlEthMac1G10GA10_RxPerMultSpeed & 0xF0000) >> 16;
}

// Field SET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxPerMultSpeed_SET_SubNanoseconds(UInt32 LlEthMac1G10GA10_RxPerMultSpeed, UInt32 SubNanoseconds)
{
    DT_ASSERT((SubNanoseconds & ~0xFFFF) == 0);
    return (LlEthMac1G10GA10_RxPerMultSpeed & ~0xFFFF) | SubNanoseconds;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxPerMultSpeed_SET_Nanoseconds(UInt32 LlEthMac1G10GA10_RxPerMultSpeed, UInt32 Nanoseconds)
{
    DT_ASSERT((Nanoseconds & ~0xF) == 0);
    return (LlEthMac1G10GA10_RxPerMultSpeed & ~0xF0000) | (Nanoseconds << 16);
}

// Register WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxPerMultSpeed_WRITE(DtBcEMAC10G* Bc, UInt32 LlEthMac1G10GA10_RxPerMultSpeed)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10C8, LlEthMac1G10GA10_RxPerMultSpeed);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxFnsAdj1G' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxFnsAdj1G_READ_RxFnsAdj1G(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10CC) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxFnsAdj1G_WRITE_RxFnsAdj1G(DtBcEMAC10G* Bc, UInt32 RxFnsAdj1G)
{
    DT_ASSERT((RxFnsAdj1G & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x10CC, RxFnsAdj1G);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxNsAdj1G' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxNsAdj1G_READ_RxNsAdj1G(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10D0) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxNsAdj1G_WRITE_RxNsAdj1G(DtBcEMAC10G* Bc, UInt32 RxNsAdj1G)
{
    DT_ASSERT((RxNsAdj1G & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x10D0, RxNsAdj1G);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxP2pMpdNs' -.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxP2pMpdNs_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10D4);
}

// Field GET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxP2pMpdNs_GET_Nanoseconds(UInt32 LlEthMac1G10GA10_RxP2pMpdNs)
{
    return LlEthMac1G10GA10_RxP2pMpdNs & 0x3FFFFFFF;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxP2pMpdNs_GET_MpdValid(UInt32 LlEthMac1G10GA10_RxP2pMpdNs)
{
    return (LlEthMac1G10GA10_RxP2pMpdNs & 0x40000000) >> 30;
}

// Field SET functions.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxP2pMpdNs_SET_Nanoseconds(UInt32 LlEthMac1G10GA10_RxP2pMpdNs, UInt32 Nanoseconds)
{
    DT_ASSERT((Nanoseconds & ~0x3FFFFFFF) == 0);
    return (LlEthMac1G10GA10_RxP2pMpdNs & ~0x3FFFFFFF) | Nanoseconds;
}
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxP2pMpdNs_SET_MpdValid(UInt32 LlEthMac1G10GA10_RxP2pMpdNs, UInt32 MpdValid)
{
    DT_ASSERT((MpdValid & ~0x1) == 0);
    return (LlEthMac1G10GA10_RxP2pMpdNs & ~0x40000000) | (MpdValid << 30);
}

// Register WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxP2pMpdNs_WRITE(DtBcEMAC10G* Bc, UInt32 LlEthMac1G10GA10_RxP2pMpdNs)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10D4, LlEthMac1G10GA10_RxP2pMpdNs);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxP2pMpdFns' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxP2pMpdFns_READ(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10D8);
}

// Field GET function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxP2pMpdFns_GET_MpdValueFns(UInt32 LlEthMac1G10GA10_RxP2pMpdFns)
{
    return LlEthMac1G10GA10_RxP2pMpdFns & 0xFFFF;
}

// Field SET function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxP2pMpdFns_SET_MpdValueFns(UInt32 LlEthMac1G10GA10_RxP2pMpdFns, UInt32 MpdValueFns)
{
    DT_ASSERT((MpdValueFns & ~0xFFFF) == 0);
    return (LlEthMac1G10GA10_RxP2pMpdFns & ~0xFFFF) | MpdValueFns;
}

// Register WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxP2pMpdFns_WRITE(DtBcEMAC10G* Bc, UInt32 LlEthMac1G10GA10_RxP2pMpdFns)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10D8, LlEthMac1G10GA10_RxP2pMpdFns);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsClr' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsClr_READ_TxStatsClr(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10DC) & 0x1;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_TxStatsClr_WRITE_TxStatsClr(DtBcEMAC10G* Bc, UInt32 TxStatsClr)
{
    DT_ASSERT((TxStatsClr & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x10DC, TxStatsClr);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFrameOkL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFrameOkL_READ_TxStatsFrameOkL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10E0);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFrameOkH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFrameOkH_READ_TxStatsFrameOkH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10E4);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFrameErrL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFrameErrL_READ_TxStatsFrameErrL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10E8);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFrameErrH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFrameErrH_READ_TxStatsFrameErrH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10EC) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsOctetsOkL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsOctetsOkL_READ_TxStatsOctetsOkL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10F0);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsOctetsOkH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsOctetsOkH_READ_TxStatsOctetsOkH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10F4) & 0xF;
}

// -.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsPauseFramesL' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsPauseFramesL_READ_TxStatsPauseFramesL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10F8);
}

// -.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsPauseFramesH' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsPauseFramesH_READ_TxStatsPauseFramesH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10FC) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsIfErrL' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsIfErrL_READ_TxStatsIfErrL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1100);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsIfErrH' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsIfErrH_READ_TxStatsIfErrH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1104) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsUCastOkL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsUCastOkL_READ_TxStatsUCastOkL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1108);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsUCastOkH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsUCastOkH_READ_TxStatsUCastOkH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x110C) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsUCastErrL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsUCastErrL_READ_TxStatsUCastErrL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1110);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsUCastErrH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsUCastErrH_READ_TxStatsUCastErrH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1114) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsMCastOkL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsMCastOkL_READ_TxStatsMCastOkL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1118);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsMCastOkH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsMCastOkH_READ_TxStatsMCastOkH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x111C) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsMCastErrL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsMCastErrL_READ_TxStatsMCastErrL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1120);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsMCastErrH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsMCastErrH_READ_TxStatsMCastErrH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1124) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsBCastOkL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsBCastOkL_READ_TxStatsBCastOkL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1128);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsBCastOkH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsBCastOkH_READ_TxStatsBCastOkH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x112C) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsBCastErrL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsBCastErrL_READ_TxStatsBCastErrL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1130);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsBCastErrH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsBCastErrH_READ_TxStatsBCastErrH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1134) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsOctetsL' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsOctetsL_READ_TxStatsOctetsL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1138);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsOctetsH' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsOctetsH_READ_TxStatsOctetsH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x113C);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsPktsL' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsPktsL_READ_TxStatsPktsL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1140);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsPktsH' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsPktsH_READ_TxStatsPktsH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1144) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsUSizeL' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsUSizeL_READ_TxStatsUSizeL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1148);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsUSizeH' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsUSizeH_READ_TxStatsUSizeH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x114C) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsOSizeL' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsOSizeL_READ_TxStatsOSizeL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1150);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsOSizeH' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsOSizeH_READ_TxStatsOSizeH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1154) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFr64L' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFr64L_READ_TxStatsFr64L(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1158);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFr64H' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFr64H_READ_TxStatsFr64H(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x115C) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFr65to127L' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFr65to127L_READ_TxStatsFr65to127L(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1160);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFr65to127H' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFr65to127H_READ_TxStatsFr65to127H(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1164) & 0xF;
}

// -.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFr128to255L' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFr128to255L_READ_TxStatsFr128to255L(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1168);
}

// -.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFr128to255H' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFr128to255H_READ_TxStatsFr128to255H(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x116C) & 0xF;
}

// -.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFr256to511L' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFr256to511L_READ_TxStatsFr256to511L(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1170);
}

// -.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFr256to511H' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFr256to511H_READ_TxStatsFr256to511H(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1174) & 0xF;
}

// -.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFr512to1023L' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFr512to1023L_READ_TxStatsFr512to1023L(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1178);
}

// -.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFr512to1023H' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFr512to1023H_READ_TxStatsFr512to1023H(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x117C) & 0xF;
}

// .-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFr1024to1518L' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFr1024to1518L_READ_TxStatsFr1024to1518L(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1180);
}

// .-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFr1024to1518H' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFr1024to1518H_READ_TxStatsFr1024to1518H(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1184) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFr1519toXL' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFr1519toXL_READ_TxStatsFr1519toXL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1188);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsFr1519toXH' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsFr1519toXH_READ_TxStatsFr1519toXH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x118C) & 0xF;
}

// .-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsUCastMacCtrlL' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsUCastMacCtrlL_READ_TxStatsUCastMacCtrlL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1190);
}

// .-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsUCastMacCtrlH' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsUCastMacCtrlH_READ_TxStatsUCastMacCtrlH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1194) & 0xF;
}

// .-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsMCastMacCtrlL' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsMCastMacCtrlL_READ_TxStatsMCastMacCtrlL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1198);
}

// .-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsMCastMacCtrlH' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsMCastMacCtrlH_READ_TxStatsMCastMacCtrlH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x119C) & 0xF;
}

// .-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsBCastMacCtrlL' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsBCastMacCtrlL_READ_TxStatsBCastMacCtrlL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11A0);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsBCastCtrlH' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsBCastCtrlH_READ_TxStatsBCastCtrlH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11A4) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsPfcCtrlL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsPfcCtrlL_READ_TxStatsPfcCtrlL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11A8);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_TxStatsPfcCtrlH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_TxStatsPfcCtrlH_READ_TxStatsPfcCtrlH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11AC) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsClr' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsClr_READ_RxStatsClr(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11B0) & 0x1;
}

// Field WRITE function.
static __inline void EMAC10G_LlEthMac1G10GA10_RxStatsClr_WRITE_RxStatsClr(DtBcEMAC10G* Bc, UInt32 RxStatsClr)
{
    DT_ASSERT((RxStatsClr & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x11B0, RxStatsClr);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFrameOkL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFrameOkL_READ_RxStatsFrameOkL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11B8);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFrameOkH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFrameOkH_READ_RxStatsFrameOkH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11BC);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFrameErrL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFrameErrL_READ_RxStatsFrameErrL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11C0);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFrameErrH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFrameErrH_READ_RxStatsFrameErrH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11C4) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsCrcErrL' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsCrcErrL_READ_RxStatsCrcErrL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11C8);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsCrcErrH' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsCrcErrH_READ_RxStatsCrcErrH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11CC) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsOctetsOkL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsOctetsOkL_READ_RxStatsOctetsOkL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11D0);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsOctetsOkH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsOctetsOkH_READ_RxStatsOctetsOkH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11D4) & 0xF;
}

// -.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsPauseFramesL' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsPauseFramesL_READ_RxStatsPauseFramesL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11D8);
}

// -.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsPauseFramesH' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsPauseFramesH_READ_RxStatsPauseFramesH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11DC) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsIfErrL' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsIfErrL_READ_RxStatsIfErrL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11E0);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsIfErrH' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsIfErrH_READ_RxStatsIfErrH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11E4) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsUCastOkL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsUCastOkL_READ_RxStatsUCastOkL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11E8);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsUCastOkH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsUCastOkH_READ_RxStatsUCastOkH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11EC) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsUCastErrL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsUCastErrL_READ_RxStatsUCastErrL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11F0);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsUCastErrH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsUCastErrH_READ_RxStatsUCastErrH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11F4) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsMCastOkL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsMCastOkL_READ_RxStatsMCastOkL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11F8);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsMCastOkH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsMCastOkH_READ_RxStatsMCastOkH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x11FC) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsMCastErrL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsMCastErrL_READ_RxStatsMCastErrL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1200);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsMCastErrH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsMCastErrH_READ_RxStatsMCastErrH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1204) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsBCastOkL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsBCastOkL_READ_RxStatsBCastOkL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1208);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsBCastOkH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsBCastOkH_READ_RxStatsBCastOkH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x120C) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsBCastErrL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsBCastErrL_READ_RxStatsBCastErrL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1210);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsBCastErrH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsBCastErrH_READ_RxStatsBCastErrH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1214) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsOctetsL' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsOctetsL_READ_RxStatsOctetsL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1218);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsOctetsH' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsOctetsH_READ_RxStatsOctetsH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x121C);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsPktsL' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsPktsL_READ_RxStatsPktsL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1220);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsPktsH' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsPktsH_READ_RxStatsPktsH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1224) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsUSizeL' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsUSizeL_READ_RxStatsUSizeL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1228);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsUSizeH' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsUSizeH_READ_RxStatsUSizeH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x122C) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsOSizeL' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsOSizeL_READ_RxStatsOSizeL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1230);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsOSizeH' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsOSizeH_READ_RxStatsOSizeH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x123C) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFr64L' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFr64L_READ_RxStatsFr64L(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1240);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFr64H' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFr64H_READ_RxStatsFr64H(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1244) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFr65to127L' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFr65to127L_READ_RxStatsFr65to127L(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1248);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFr65to127H' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFr65to127H_READ_RxStatsFr65to127H(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x124C) & 0xF;
}

// -.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFr128to255L' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFr128to255L_READ_RxStatsFr128to255L(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1250);
}

// -.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFr128to255H' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFr128to255H_READ_RxStatsFr128to255H(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1254) & 0xF;
}

// -.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFr256to511L' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFr256to511L_READ_RxStatsFr256to511L(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1258);
}

// -.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFr256to511H' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFr256to511H_READ_RxStatsFr256to511H(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x125C) & 0xF;
}

// -.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFr512to1023L' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFr512to1023L_READ_RxStatsFr512to1023L(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1260);
}

// -.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFr512to1023H' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFr512to1023H_READ_RxStatsFr512to1023H(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1264) & 0xF;
}

// .-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFr1024to1518L' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFr1024to1518L_READ_RxStatsFr1024to1518L(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1268);
}

// .-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFr1024to1518H' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFr1024to1518H_READ_RxStatsFr1024to1518H(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x126C) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFr1519toXL' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFr1519toXL_READ_RxStatsFr1519toXL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1270);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFr1519toXH' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFr1519toXH_READ_RxStatsFr1519toXH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1274) & 0xF;
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFragsL' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFragsL_READ_RxStatsFragsL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1278);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsFragsH' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsFragsH_READ_RxStatsFragsH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x127C) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsJabbersL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsJabbersL_READ_RxStatsJabbersL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1280);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsJabbersH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsJabbersH_READ_RxStatsJabbersH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1284) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsCrcErrSL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsCrcErrSL_READ_RxStatsCrcErrSL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1288);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsCrcErrSH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsCrcErrSH_READ_RxStatsCrcErrSH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x128C) & 0xF;
}

// .-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsUCastMacCtrlL' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsUCastMacCtrlL_READ_RxStatsUCastMacCtrlL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1290);
}

// .-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsUCastMacCtrlH' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsUCastMacCtrlH_READ_RxStatsUCastMacCtrlH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1294) & 0xF;
}

// .-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsMCastMacCtrlL' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsMCastMacCtrlL_READ_RxStatsMCastMacCtrlL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1298);
}

// .-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsMCastMacCtrlH' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsMCastMacCtrlH_READ_RxStatsMCastMacCtrlH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x129C) & 0xF;
}

// .-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsBCastMacCtrlL' -.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsBCastMacCtrlL_READ_RxStatsBCastMacCtrlL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x12A0);
}

// .-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsBCastCtrlH' -.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsBCastCtrlH_READ_RxStatsBCastCtrlH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x12A4) & 0xF;
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsPfcCtrlL' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsPfcCtrlL_READ_RxStatsPfcCtrlL(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x12A8);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'LlEthMac1G10GA10_RxStatsPfcCtrlH' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC10G_LlEthMac1G10GA10_RxStatsPfcCtrlH_READ_RxStatsPfcCtrlH(DtBcEMAC10G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x12AC) & 0xF;
}

