//*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcCDMAC_RegAccess.h *#*#*#*#*#*#*#*# (C) 2019 DekTec
//
// Device driver - DmacContPcie v0 (CDMAC) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block DmacContPcie.
// These functions should solely be used by the block controller for DmacContPcie.
//
// 2019.03.06 11:21 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'PrefetchSize' and 'RxTxCapability' from register 'Config1':
//      UInt32  Reg_Config1, PrefetchSize, RxTxCapability;
//      Reg_Config1    = CDMAC_Config1_READ(pBc);
//      PrefetchSize   = CDMAC_Config1_GET_PrefetchSize(Reg_Config1);
//      RxTxCapability = CDMAC_Config1_GET_RxTxCapability(Reg_Config1);
//
// 2. Single-function shorthand for reading field 'LoadMinMax' from register
//    'ReorderBufLoadMinMax':
//      UInt32  LoadMinMax = CDMAC_ReorderBufLoadMinMax_READ_LoadMinMax(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// CDMAC_BufferSize_WRITE
// CDMAC_Config1_GET_PcieItfDataWidth
// CDMAC_Config1_GET_PrefetchSize
// CDMAC_Config1_GET_RxTxCapability
// CDMAC_Config1_READ
// CDMAC_Config1_READ_PcieItfDataWidth
// CDMAC_Config1_READ_PrefetchSize
// CDMAC_Config1_READ_RxTxCapability
// CDMAC_Config2_GET_ReorderBufSize
// CDMAC_Config2_READ
// CDMAC_Config2_READ_ReorderBufSize
// CDMAC_Control_READ
// CDMAC_Control_SET_BlockEnable
// CDMAC_Control_SET_ChannelFlush
// CDMAC_Control_SET_OperationalMode
// CDMAC_Control_SET_RxOrTx
// CDMAC_Control_SET_TestMode
// CDMAC_Control_WRITE
// CDMAC_ErrorStatus_GET_AlignError
// CDMAC_ErrorStatus_GET_EndTimeout
// CDMAC_ErrorStatus_GET_EndUndefined
// CDMAC_ErrorStatus_READ
// CDMAC_ErrorStatus_READ_AlignError
// CDMAC_ErrorStatus_READ_EndTimeout
// CDMAC_ErrorStatus_READ_EndUndefined
// CDMAC_PointerTableAddrHigh_WRITE
// CDMAC_PointerTableAddrLow_WRITE
// CDMAC_ReorderBufLoadMinMax_GET_LoadMinMax
// CDMAC_ReorderBufLoadMinMax_READ
// CDMAC_ReorderBufLoadMinMax_READ_LoadMinMax
// CDMAC_ReorderBufLoadMinMax_SET_Clear
// CDMAC_ReorderBufLoadMinMax_WRITE
// CDMAC_ReorderBufLoad_READ
// CDMAC_RxReadOffset_WRITE
// CDMAC_RxWriteOffset_READ
// CDMAC_Status_GET_OperationalStatus
// CDMAC_Status_GET_PerformanceCnt
// CDMAC_Status_GET_WaitLocal
// CDMAC_Status_GET_WaitPcie
// CDMAC_Status_READ
// CDMAC_Status_READ_OperationalStatus
// CDMAC_Status_READ_PerformanceCnt
// CDMAC_Status_READ_WaitLocal
// CDMAC_Status_READ_WaitPcie
// CDMAC_TxReadOffset_READ
// CDMAC_TxWriteOffset_WRITE

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'OperationalMode'
#define CDMAC_OPMODE_IDLE        0x0  // Block is inactive
#define CDMAC_OPMODE_STANDBY     0x1  // Block is partially operational
#define CDMAC_OPMODE_RUN         0x2  // Block performs its normal function

// Value map 'OperationalStatus'
#define CDMAC_OPSTATUS_IDLE      0x0  // Block is inactive
#define CDMAC_OPSTATUS_STANDBY   0x1  // Block is partially operational
#define CDMAC_OPSTATUS_RUN       0x2  // Block performs its normal function
#define CDMAC_OPSTATUS_ERROR     0x3  // An error has occurred

// Value map 'BlockEnable'
#define CDMAC_BLKENA_DISABLED    0x0  // Block is entirely disabled
#define CDMAC_BLKENA_ENABLED     0x1  // Block is enabled and processes data

// Value map 'RxTxCapability'
#define CDMAC_RXTXCAP_RX_ONLY    0x0  // Receive only (unidirectional)
#define CDMAC_RXTXCAP_TX_ONLY    0x1  // Transmit only (unidirectional)
#define CDMAC_RXTXCAP_RX_OR_TX   0x2  // Receive and transmit are both supported at
                                      // half-duplex
#define CDMAC_RXTXCAP_RX_AND_TX  0x3  // Receive and transmit are both supported at
                                      // full-duplex

// Value map 'TestMode'
#define CDMAC_TEST_NORMAL        0x0  // 
#define CDMAC_TEST_INTERNAL      0x1  // 
#define CDMAC_TEST_EXTERNAL      0x2  // 

// Value map 'DmaDirection'
#define CDMAC_DIR_RX             0x0  // 
#define CDMAC_DIR_TX             0x1  // 

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  CDMAC_Config1_READ(DtBcCDMAC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field GET functions
static __inline UInt32  CDMAC_Config1_GET_PrefetchSize(UInt32 Config1)
{
    return Config1 & 0xFF;
}
static __inline UInt32  CDMAC_Config1_GET_RxTxCapability(UInt32 Config1)
{
    return (Config1 & 0x300) >> 8;
}
static __inline UInt32  CDMAC_Config1_GET_PcieItfDataWidth(UInt32 Config1)
{
    return (Config1 & 0x3FF0000) >> 16;
}

// Field READ functions
static __inline UInt32  CDMAC_Config1_READ_PrefetchSize(DtBcCDMAC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4) & 0xFF;
}
static __inline UInt32  CDMAC_Config1_READ_RxTxCapability(DtBcCDMAC* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0x300) >> 8;
}
static __inline UInt32  CDMAC_Config1_READ_PcieItfDataWidth(DtBcCDMAC* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0x3FF0000) >> 16;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  CDMAC_Config2_READ(DtBcCDMAC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field GET function
static __inline UInt32  CDMAC_Config2_GET_ReorderBufSize(UInt32 Config2)
{
    return Config2 & 0xFFFFFF;
}

// Field READ function
static __inline UInt32  CDMAC_Config2_READ_ReorderBufSize(DtBcCDMAC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8) & 0xFFFFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  CDMAC_Control_READ(DtBcCDMAC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC);
}

// Field SET functions
static __inline UInt32  CDMAC_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32  CDMAC_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32  CDMAC_Control_SET_RxOrTx(UInt32 Control, UInt32 RxOrTx)
{
    DT_ASSERT((RxOrTx & ~0x1) == 0);
    return (Control & ~0x10) | (RxOrTx << 4);
}
static __inline UInt32  CDMAC_Control_SET_ChannelFlush(UInt32 Control, UInt32 ChannelFlush)
{
    DT_ASSERT((ChannelFlush & ~0x1) == 0);
    return (Control & ~0x20) | (ChannelFlush << 5);
}
static __inline UInt32  CDMAC_Control_SET_TestMode(UInt32 Control, UInt32 TestMode)
{
    DT_ASSERT((TestMode & ~0x3) == 0);
    return (Control & ~0xC0) | (TestMode << 6);
}

// Register WRITE function
static __inline void  CDMAC_Control_WRITE(DtBcCDMAC* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xC, Control);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  CDMAC_Status_READ(DtBcCDMAC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10);
}

// Field GET functions
static __inline UInt32  CDMAC_Status_GET_OperationalStatus(UInt32 Status)
{
    return Status & 0x3;
}
static __inline UInt32  CDMAC_Status_GET_WaitPcie(UInt32 Status)
{
    return (Status & 0x4) >> 2;
}
static __inline UInt32  CDMAC_Status_GET_WaitLocal(UInt32 Status)
{
    return (Status & 0x8) >> 3;
}
static __inline UInt32  CDMAC_Status_GET_PerformanceCnt(UInt32 Status)
{
    return (Status & 0xFFFFFF00) >> 8;
}

// Field READ functions
static __inline UInt32  CDMAC_Status_READ_OperationalStatus(DtBcCDMAC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10) & 0x3;
}
static __inline UInt32  CDMAC_Status_READ_WaitPcie(DtBcCDMAC* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x10) & 0x4) >> 2;
}
static __inline UInt32  CDMAC_Status_READ_WaitLocal(DtBcCDMAC* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x10) & 0x8) >> 3;
}
static __inline UInt32  CDMAC_Status_READ_PerformanceCnt(DtBcCDMAC* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x10) & 0xFFFFFF00) >> 8;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'ErrorStatus' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  CDMAC_ErrorStatus_READ(DtBcCDMAC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x14);
}

// Field GET functions
static __inline UInt32  CDMAC_ErrorStatus_GET_AlignError(UInt32 ErrorStatus)
{
    return ErrorStatus & 0x1;
}
static __inline UInt32  CDMAC_ErrorStatus_GET_EndTimeout(UInt32 ErrorStatus)
{
    return (ErrorStatus & 0x2) >> 1;
}
static __inline UInt32  CDMAC_ErrorStatus_GET_EndUndefined(UInt32 ErrorStatus)
{
    return (ErrorStatus & 0x4) >> 2;
}

// Field READ functions
static __inline UInt32  CDMAC_ErrorStatus_READ_AlignError(DtBcCDMAC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x14) & 0x1;
}
static __inline UInt32  CDMAC_ErrorStatus_READ_EndTimeout(DtBcCDMAC* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x14) & 0x2) >> 1;
}
static __inline UInt32  CDMAC_ErrorStatus_READ_EndUndefined(DtBcCDMAC* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x14) & 0x4) >> 2;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'PointerTableAddrLow' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void  CDMAC_PointerTableAddrLow_WRITE(DtBcCDMAC* pBc, UInt32 PointerTableAddrLow)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x18, PointerTableAddrLow);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'PointerTableAddrHigh' -.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void  CDMAC_PointerTableAddrHigh_WRITE(DtBcCDMAC* pBc, UInt32 PointerTableAddrHigh)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1C, PointerTableAddrHigh);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'BufferSize' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void  CDMAC_BufferSize_WRITE(DtBcCDMAC* pBc, UInt32 BufferSize)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x20, BufferSize);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxReadOffset' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void  CDMAC_RxReadOffset_WRITE(DtBcCDMAC* pBc, UInt32 RxReadOffset)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x24, RxReadOffset);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxWriteOffset' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  CDMAC_RxWriteOffset_READ(DtBcCDMAC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x28);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TxReadOffset' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  CDMAC_TxReadOffset_READ(DtBcCDMAC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x2C);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TxWriteOffset' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void  CDMAC_TxWriteOffset_WRITE(DtBcCDMAC* pBc, UInt32 TxWriteOffset)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x30, TxWriteOffset);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'ReorderBufLoad' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  CDMAC_ReorderBufLoad_READ(DtBcCDMAC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x34) & 0xFFFFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'ReorderBufLoadMinMax' -.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  CDMAC_ReorderBufLoadMinMax_READ(DtBcCDMAC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x38);
}

// Field GET function
static __inline UInt32  CDMAC_ReorderBufLoadMinMax_GET_LoadMinMax(UInt32 ReorderBufLoadMinMax)
{
    return ReorderBufLoadMinMax & 0xFFFFFF;
}

// Field READ function
static __inline UInt32  CDMAC_ReorderBufLoadMinMax_READ_LoadMinMax(DtBcCDMAC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x38) & 0xFFFFFF;
}

// Field SET function
static __inline UInt32  CDMAC_ReorderBufLoadMinMax_SET_Clear(UInt32 ReorderBufLoadMinMax, UInt32 Clear)
{
    DT_ASSERT((Clear & ~0x1) == 0);
    return (ReorderBufLoadMinMax & ~0x80000000) | (Clear << 31);
}

// Register WRITE function
static __inline void  CDMAC_ReorderBufLoadMinMax_WRITE(DtBcCDMAC* pBc, UInt32 ReorderBufLoadMinMax)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x38, ReorderBufLoadMinMax);
}

