//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcCDMACTO_RegAccess.h *#*#*#*#*#*#*#* (C) 2022 DekTec
//
// Device driver - DmacContPcieTimeout v0 (CDMACTO) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block DmacContPcieTimeout.
// These functions should solely be used by the block controller for DmacContPcieTimeout.
//
// 2022.01.03 16:52 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND.

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2020 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN No EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'PrefetchSize' and 'RxTxCapability' from register 'Config1':
//      UInt32  Reg_Config1, PrefetchSize, RxTxCapability;
//      Reg_Config1    = CDMACTO_Config1_READ(pBc);
//      PrefetchSize   = CDMACTO_Config1_GET_PrefetchSize(Reg_Config1);
//      RxTxCapability = CDMACTO_Config1_GET_RxTxCapability(Reg_Config1);
//
// 2. Single-function shorthand for reading field 'LoadMinMax' from register
//    'ReorderBufLoadMinMax':
//      UInt32  LoadMinMax = CDMACTO_ReorderBufLoadMinMax_READ_LoadMinMax(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// CDMACTO_BufferSize_WRITE
// CDMACTO_Config1_GET_PcieItfDataWidth
// CDMACTO_Config1_GET_PrefetchSize
// CDMACTO_Config1_GET_RxTxCapability
// CDMACTO_Config1_READ
// CDMACTO_Config1_READ_PcieItfDataWidth
// CDMACTO_Config1_READ_PrefetchSize
// CDMACTO_Config1_READ_RxTxCapability
// CDMACTO_Config2_GET_ReorderBufSize
// CDMACTO_Config2_READ
// CDMACTO_Config2_READ_ReorderBufSize
// CDMACTO_Control_READ
// CDMACTO_Control_SET_BlockEnable
// CDMACTO_Control_SET_ChannelFlush
// CDMACTO_Control_SET_OperationalMode
// CDMACTO_Control_SET_RxOrTx
// CDMACTO_Control_SET_TestMode
// CDMACTO_Control_WRITE
// CDMACTO_ErrorStatus_GET_AlignError
// CDMACTO_ErrorStatus_GET_EndTimeout
// CDMACTO_ErrorStatus_GET_EndUndefined
// CDMACTO_ErrorStatus_READ
// CDMACTO_ErrorStatus_READ_AlignError
// CDMACTO_ErrorStatus_READ_EndTimeout
// CDMACTO_ErrorStatus_READ_EndUndefined
// CDMACTO_PointerTableAddrHigh_WRITE
// CDMACTO_PointerTableAddrLow_WRITE
// CDMACTO_ReorderBufLoadMinMax_GET_LoadMinMax
// CDMACTO_ReorderBufLoadMinMax_READ
// CDMACTO_ReorderBufLoadMinMax_READ_LoadMinMax
// CDMACTO_ReorderBufLoadMinMax_SET_Clear
// CDMACTO_ReorderBufLoadMinMax_WRITE
// CDMACTO_ReorderBufLoad_READ
// CDMACTO_RxReadOffset_WRITE
// CDMACTO_RxWriteOffset_READ
// CDMACTO_Status_GET_OperationalStatus
// CDMACTO_Status_GET_PerformanceCnt
// CDMACTO_Status_GET_WaitLocal
// CDMACTO_Status_GET_WaitPcie
// CDMACTO_Status_READ
// CDMACTO_Status_READ_OperationalStatus
// CDMACTO_Status_READ_PerformanceCnt
// CDMACTO_Status_READ_WaitLocal
// CDMACTO_Status_READ_WaitPcie
// CDMACTO_TxReadOffset_READ
// CDMACTO_TxWriteOffset_WRITE

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'BlockEnable'
#define CDMACTO_BLKENA_DISABLED    0x0  // Block is entirely disabled
#define CDMACTO_BLKENA_ENABLED     0x1  // Block is enabled and processes data

// Value map 'DmaDirection'
#define CDMACTO_DIR_RX             0x0  // 
#define CDMACTO_DIR_TX             0x1  // 

// Value map 'OperationalMode'
#define CDMACTO_OPMODE_IDLE        0x0  // Block is inactive
#define CDMACTO_OPMODE_STANDBY     0x1  // Block is partially operational
#define CDMACTO_OPMODE_RUN         0x2  // Block performs its normal function

// Value map 'OperationalStatus'
#define CDMACTO_OPSTATUS_IDLE      0x0  // Block is inactive
#define CDMACTO_OPSTATUS_STANDBY   0x1  // Block is partially operational
#define CDMACTO_OPSTATUS_RUN       0x2  // Block performs its normal function
#define CDMACTO_OPSTATUS_ERROR     0x3  // An error has occurred

// Value map 'RxTxCapability'
#define CDMACTO_RXTXCAP_RX_ONLY    0x0  // Receive only (unidirectional)
#define CDMACTO_RXTXCAP_TX_ONLY    0x1  // Transmit only (unidirectional)
#define CDMACTO_RXTXCAP_RX_OR_TX   0x2  // Receive and transmit are both supported at
                                        // half-duplex
#define CDMACTO_RXTXCAP_RX_AND_TX  0x3  // Receive and transmit are both supported at
                                        // full-duplex

// Value map 'TestMode'
#define CDMACTO_TEST_NORMAL        0x0  // 
#define CDMACTO_TEST_INTERNAL      0x1  // 
#define CDMACTO_TEST_EXTERNAL      0x2  // 

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 CDMACTO_Config1_READ(DtBcCDMACTO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field GET functions
static __inline UInt32 CDMACTO_Config1_GET_PrefetchSize(UInt32 Config1)
{
    return Config1 & 0xFF;
}
static __inline UInt32 CDMACTO_Config1_GET_RxTxCapability(UInt32 Config1)
{
    return (Config1 & 0x300) >> 8;
}
static __inline UInt32 CDMACTO_Config1_GET_PcieItfDataWidth(UInt32 Config1)
{
    return (Config1 & 0x3FF0000) >> 16;
}

// Field READ functions
static __inline UInt32 CDMACTO_Config1_READ_PrefetchSize(DtBcCDMACTO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4) & 0xFF;
}
static __inline UInt32 CDMACTO_Config1_READ_RxTxCapability(DtBcCDMACTO* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0x300) >> 8;
}
static __inline UInt32 CDMACTO_Config1_READ_PcieItfDataWidth(DtBcCDMACTO* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0x3FF0000) >> 16;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 CDMACTO_Config2_READ(DtBcCDMACTO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field GET function
static __inline UInt32 CDMACTO_Config2_GET_ReorderBufSize(UInt32 Config2)
{
    return Config2 & 0xFFFFFF;
}

// Field READ function
static __inline UInt32 CDMACTO_Config2_READ_ReorderBufSize(DtBcCDMACTO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8) & 0xFFFFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 CDMACTO_Control_READ(DtBcCDMACTO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC);
}

// Field SET functions
static __inline UInt32 CDMACTO_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32 CDMACTO_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32 CDMACTO_Control_SET_RxOrTx(UInt32 Control, UInt32 RxOrTx)
{
    DT_ASSERT((RxOrTx & ~0x1) == 0);
    return (Control & ~0x10) | (RxOrTx << 4);
}
static __inline UInt32 CDMACTO_Control_SET_ChannelFlush(UInt32 Control, UInt32 ChannelFlush)
{
    DT_ASSERT((ChannelFlush & ~0x1) == 0);
    return (Control & ~0x20) | (ChannelFlush << 5);
}
static __inline UInt32 CDMACTO_Control_SET_TestMode(UInt32 Control, UInt32 TestMode)
{
    DT_ASSERT((TestMode & ~0x3) == 0);
    return (Control & ~0xC0) | (TestMode << 6);
}

// Register WRITE function
static __inline void CDMACTO_Control_WRITE(DtBcCDMACTO* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xC, Control);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 CDMACTO_Status_READ(DtBcCDMACTO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10);
}

// Field GET functions
static __inline UInt32 CDMACTO_Status_GET_OperationalStatus(UInt32 Status)
{
    return Status & 0x3;
}
static __inline UInt32 CDMACTO_Status_GET_WaitPcie(UInt32 Status)
{
    return (Status & 0x4) >> 2;
}
static __inline UInt32 CDMACTO_Status_GET_WaitLocal(UInt32 Status)
{
    return (Status & 0x8) >> 3;
}
static __inline UInt32 CDMACTO_Status_GET_PerformanceCnt(UInt32 Status)
{
    return (Status & 0xFFFFFF00) >> 8;
}

// Field READ functions
static __inline UInt32 CDMACTO_Status_READ_OperationalStatus(DtBcCDMACTO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10) & 0x3;
}
static __inline UInt32 CDMACTO_Status_READ_WaitPcie(DtBcCDMACTO* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x10) & 0x4) >> 2;
}
static __inline UInt32 CDMACTO_Status_READ_WaitLocal(DtBcCDMACTO* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x10) & 0x8) >> 3;
}
static __inline UInt32 CDMACTO_Status_READ_PerformanceCnt(DtBcCDMACTO* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x10) & 0xFFFFFF00) >> 8;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'ErrorStatus' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 CDMACTO_ErrorStatus_READ(DtBcCDMACTO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x14);
}

// Field GET functions
static __inline UInt32 CDMACTO_ErrorStatus_GET_AlignError(UInt32 ErrorStatus)
{
    return ErrorStatus & 0x1;
}
static __inline UInt32 CDMACTO_ErrorStatus_GET_EndTimeout(UInt32 ErrorStatus)
{
    return (ErrorStatus & 0x2) >> 1;
}
static __inline UInt32 CDMACTO_ErrorStatus_GET_EndUndefined(UInt32 ErrorStatus)
{
    return (ErrorStatus & 0x4) >> 2;
}

// Field READ functions
static __inline UInt32 CDMACTO_ErrorStatus_READ_AlignError(DtBcCDMACTO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x14) & 0x1;
}
static __inline UInt32 CDMACTO_ErrorStatus_READ_EndTimeout(DtBcCDMACTO* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x14) & 0x2) >> 1;
}
static __inline UInt32 CDMACTO_ErrorStatus_READ_EndUndefined(DtBcCDMACTO* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x14) & 0x4) >> 2;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'PointerTableAddrLow' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void CDMACTO_PointerTableAddrLow_WRITE(DtBcCDMACTO* pBc, UInt32 PointerTableAddrLow)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x18, PointerTableAddrLow);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'PointerTableAddrHigh' -.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void CDMACTO_PointerTableAddrHigh_WRITE(DtBcCDMACTO* pBc, UInt32 PointerTableAddrHigh)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1C, PointerTableAddrHigh);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'BufferSize' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void CDMACTO_BufferSize_WRITE(DtBcCDMACTO* pBc, UInt32 BufferSize)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x20, BufferSize);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxReadOffset' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void CDMACTO_RxReadOffset_WRITE(DtBcCDMACTO* pBc, UInt32 RxReadOffset)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x24, RxReadOffset);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxWriteOffset' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32 CDMACTO_RxWriteOffset_READ(DtBcCDMACTO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x28);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TxReadOffset' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32 CDMACTO_TxReadOffset_READ(DtBcCDMACTO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x2C);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TxWriteOffset' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void CDMACTO_TxWriteOffset_WRITE(DtBcCDMACTO* pBc, UInt32 TxWriteOffset)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x30, TxWriteOffset);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'ReorderBufLoad' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32 CDMACTO_ReorderBufLoad_READ(DtBcCDMACTO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x34) & 0xFFFFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'ReorderBufLoadMinMax' -.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 CDMACTO_ReorderBufLoadMinMax_READ(DtBcCDMACTO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x38);
}

// Field GET function
static __inline UInt32 CDMACTO_ReorderBufLoadMinMax_GET_LoadMinMax(UInt32 ReorderBufLoadMinMax)
{
    return ReorderBufLoadMinMax & 0xFFFFFF;
}

// Field READ function
static __inline UInt32 CDMACTO_ReorderBufLoadMinMax_READ_LoadMinMax(DtBcCDMACTO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x38) & 0xFFFFFF;
}

// Field SET function
static __inline UInt32 CDMACTO_ReorderBufLoadMinMax_SET_Clear(UInt32 ReorderBufLoadMinMax, UInt32 Clear)
{
    DT_ASSERT((Clear & ~0x1) == 0);
    return (ReorderBufLoadMinMax & ~0x80000000) | (Clear << 31);
}

// Register WRITE function
static __inline void CDMACTO_ReorderBufLoadMinMax_WRITE(DtBcCDMACTO* pBc, UInt32 ReorderBufLoadMinMax)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x38, ReorderBufLoadMinMax);
}

