// #*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcAD9789ITF_RegAccess.h *#*#*#*#*#*#*# (C) 2023 DekTec
//
// Device driver - Ad9789Itf v0 (AD9789ITF) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block Ad9789Itf.
// These functions should solely be used by the block controller for Ad9789Itf.
//
// 2023.01.26 11:06 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND.

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2022 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN No EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//
// 1. Getting fields 'Underflow' and 'Load' from register 'CdcFifoStatus':
//      UInt32 Reg_CdcFifoStatus, Underflow, Load;
//      Reg_CdcFifoStatus = AD9789ITF_CdcFifoStatus_READ(Bc);
//      Underflow         = AD9789ITF_CdcFifoStatus_GET_Underflow(Reg_CdcFifoStatus);
//      Load              = AD9789ITF_CdcFifoStatus_GET_Load(Reg_CdcFifoStatus);
//
// 2. Single-function shorthand for reading field 'Load' from register 'CdcFifoStatus':
//      UInt32  Load = AD9789ITF_CdcFifoStatus_READ_Load(Bc);
//
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

// +=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// AD9789ITF_CdcFifoStatus_CLEAR_Underflow
// AD9789ITF_CdcFifoStatus_GET_Load
// AD9789ITF_CdcFifoStatus_GET_Underflow
// AD9789ITF_CdcFifoStatus_READ
// AD9789ITF_CdcFifoStatus_READ_Load
// AD9789ITF_CdcFifoStatus_READ_Underflow
// AD9789ITF_Control_READ
// AD9789ITF_Control_SET_BlockEnable
// AD9789ITF_Control_SET_OperationalMode
// AD9789ITF_Control_WRITE

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'BlockEnable'
#define AD9789ITF_BLKENA_DISABLED  0x0  // Block is entirely disabled
#define AD9789ITF_BLKENA_ENABLED   0x1  // Block is enabled and processes data

// Value map 'OperationalMode'
#define AD9789ITF_OPMODE_IDLE      0x0  // Block is inactive
#define AD9789ITF_OPMODE_STANDBY   0x1  // Block is partially operational
#define AD9789ITF_OPMODE_RUN       0x2  // Block performs its normal function

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// +=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 AD9789ITF_Control_READ(DtBcAD9789ITF* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x8);
}

// Field SET functions.
static __inline UInt32 AD9789ITF_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32 AD9789ITF_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}

// Register WRITE function.
static __inline void AD9789ITF_Control_WRITE(DtBcAD9789ITF* Bc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x8, Control);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'CdcFifoStatus' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 AD9789ITF_CdcFifoStatus_READ(DtBcAD9789ITF* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0xC);
}

// Field GET functions.
static __inline UInt32 AD9789ITF_CdcFifoStatus_GET_Underflow(UInt32 CdcFifoStatus)
{
    return CdcFifoStatus & 0x1;
}
static __inline UInt32 AD9789ITF_CdcFifoStatus_GET_Load(UInt32 CdcFifoStatus)
{
    return (CdcFifoStatus & 0x3FF0000) >> 16;
}

// Field READ functions.
static __inline UInt32 AD9789ITF_CdcFifoStatus_READ_Underflow(DtBcAD9789ITF* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0xC) & 0x1;
}
static __inline UInt32 AD9789ITF_CdcFifoStatus_READ_Load(DtBcAD9789ITF* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0xC) & 0x3FF0000) >> 16;
}

// Field CLEAR function.
static __inline void AD9789ITF_CdcFifoStatus_CLEAR_Underflow(DtBcAD9789ITF* Bc)
{
    UInt32  CdcFifoStatus = DtBc_RegRead32((DtBc*)Bc, 0xC);
    DtBc_RegWrite32((DtBc*)Bc, 0xC, CdcFifoStatus | 0x1);
}

