//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcAD5320_RegAccess.h *#*#*#*#*#*#*#*# (C) 2019 DekTec
//
// Device driver - DacAd5320Ctrl v-1 (AD5320) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block DacAd5320Ctrl.
// These functions should solely be used by the block controller for DacAd5320Ctrl.
//
// 2019.03.26 8:50 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Single-function shorthand for reading field 'AutoGainStatus' from register
//    'ControlStatus':
//      UInt32  AutoGainStatus = AD5320_ControlStatus_READ_AutoGainStatus(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// AD5320_ControlStatus_GET_AutoGainStatus
// AD5320_ControlStatus_READ
// AD5320_ControlStatus_READ_AutoGainStatus
// AD5320_ControlStatus_SET_GainControl
// AD5320_ControlStatus_WRITE
// AD5320_GainReadback_READ
// AD5320_ManualGain_WRITE
// AD5320_OverflowThreshold_WRITE
// AD5320_StepSizes_READ
// AD5320_StepSizes_SET_StepSizeLocked
// AD5320_StepSizes_SET_StepSizeUnlocked
// AD5320_StepSizes_WRITE
// AD5320_TimeWindow_WRITE
// AD5320_WorkingThreshold_WRITE

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'GainMode'
#define AD5320_GAIN_AUTO    0x0  // Gain automatically calculated
#define AD5320_GAIN_MANUAL  0x1  // Manual gain

// Value map 'GainStatus'
#define AD5320_GAIN_NOLOCK  0x0  // Gain controller is not locked
#define AD5320_GAIN_LOCKED  0x1  // Gain controller is locked

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'ControlStatus' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  AD5320_ControlStatus_READ(DtBcAD5320_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field GET function
static __inline UInt32  AD5320_ControlStatus_GET_AutoGainStatus(UInt32 ControlStatus)
{
    return (ControlStatus & 0x2) >> 1;
}

// Field READ function
static __inline UInt32  AD5320_ControlStatus_READ_AutoGainStatus(DtBcAD5320_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0x2) >> 1;
}

// Field SET function
static __inline UInt32  AD5320_ControlStatus_SET_GainControl(UInt32 ControlStatus, UInt32 GainControl)
{
    DT_ASSERT((GainControl & ~0x1) == 0);
    return (ControlStatus & ~0x1) | GainControl;
}

// Register WRITE function
static __inline void  AD5320_ControlStatus_WRITE(DtBcAD5320_2132* pBc, UInt32 ControlStatus)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x4, ControlStatus);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'StepSizes' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  AD5320_StepSizes_READ(DtBcAD5320_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field SET functions
static __inline UInt32  AD5320_StepSizes_SET_StepSizeUnlocked(UInt32 StepSizes, UInt32 StepSizeUnlocked)
{
    DT_ASSERT((StepSizeUnlocked & ~0xFF) == 0);
    return (StepSizes & ~0xFF) | StepSizeUnlocked;
}
static __inline UInt32  AD5320_StepSizes_SET_StepSizeLocked(UInt32 StepSizes, UInt32 StepSizeLocked)
{
    DT_ASSERT((StepSizeLocked & ~0xFF) == 0);
    return (StepSizes & ~0xFF0000) | (StepSizeLocked << 16);
}

// Register WRITE function
static __inline void  AD5320_StepSizes_WRITE(DtBcAD5320_2132* pBc, UInt32 StepSizes)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x8, StepSizes);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'OverflowThreshold' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void  AD5320_OverflowThreshold_WRITE(DtBcAD5320_2132* pBc, UInt32 OverflowThreshold)
{
    DT_ASSERT((OverflowThreshold & ~0x3FFFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0xC, OverflowThreshold);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'WorkingThreshold' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void  AD5320_WorkingThreshold_WRITE(DtBcAD5320_2132* pBc, UInt32 WorkingThreshold)
{
    DT_ASSERT((WorkingThreshold & ~0x3FFFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x10, WorkingThreshold);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TimeWindow' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void  AD5320_TimeWindow_WRITE(DtBcAD5320_2132* pBc, UInt32 TimeWindow)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x14, TimeWindow);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'ManualGain' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void  AD5320_ManualGain_WRITE(DtBcAD5320_2132* pBc, UInt32 ManualGain)
{
    DT_ASSERT((ManualGain & ~0xFFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x18, ManualGain);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'GainReadback' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  AD5320_GainReadback_READ(DtBcAD5320_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1C) & 0xFFF;
}

