//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtuDemodFwStore.c *#*#*#*#*#*#*# (C) 2014-2016 DekTec
//

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Copyright (C) 2014-2016 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Include files -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-
#include <DtuIncludes.h>

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Demodulator hex code +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- DTU-234 -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.
const DtuInitRegisterStruct  REG_PREUPLOAD_DTU234 = 
{
    {
        {
            {
                0xA0,   // HCTL1
                0x01
            }
        },
        {
            {
                0x2E,   // TSTCTL
                0x00
            }
        },
        {
            {
                0xCA,   // JDEC
                0x07
            }
        }
    },
    3
};
const DtuInitRegisterStruct  REG_STOPUPLOAD_DTU234 =
{
    {
        {
            {
                0xA0,   // HCTL1
                0x00
            }
        }
    },
    1
};

const DtuInitRegisterStruct  REG_POSTUPLOAD_DTU234 =
{
    {
        {
            {
                0xA8,   // HABSTAT
                0x16
            }
        },
        {
            {
                0xA8,   // HABSTAT
                0x06
            }
        }
    },
    2
};

const DtuHexStruct DEMOD_FIRMWARE_DTU234 = 
{
    {
        {
            /*Address = */ 0, /*DataCount = */ 3, 
            /*Data = */
            { 
                2, 1, 0
            }
        },
        {
            /*Address = */ 256, /*DataCount = */ 1872, 
            /*Data = */
            { 
                117, 129, 206, 117, 32, 0, 210, 0, 120, 0, 121, 0, 18, 118, 17, 18, 
                118, 172, 144, 0, 9, 116, 17, 240, 2, 64, 49, 229, 150, 27, 180, 8, 
                3, 2, 62, 59, 180, 10, 3, 2, 62, 62, 180, 11, 3, 2, 62, 65, 
                180, 12, 3, 2, 62, 68, 180, 17, 3, 2, 62, 71, 180, 6, 3, 2, 
                62, 74, 180, 20, 3, 2, 62, 80, 180, 21, 3, 2, 63, 108, 180, 22, 
                3, 2, 63, 111, 180, 1, 3, 2, 3, 251, 180, 2, 3, 2, 4, 70, 
                180, 5, 3, 2, 62, 77, 2, 63, 85, 2, 71, 228, 2, 71, 232, 192, 
                2, 18, 63, 41, 208, 2, 117, 134, 0, 125, 0, 133, 31, 150, 133, 34, 
                150, 133, 35, 150, 133, 37, 150, 120, 145, 121, 2, 18, 63, 69, 144, 56, 
                228, 121, 4, 18, 63, 65, 120, 155, 121, 8, 18, 63, 69, 144, 56, 6, 
                121, 4, 18, 63, 65, 120, 163, 121, 16, 18, 63, 69, 228, 245, 150, 2, 
                71, 246, 229, 35, 84, 127, 68, 16, 245, 35, 144, 56, 30, 121, 8, 229, 
                150, 240, 163, 217, 250, 117, 34, 0, 229, 36, 84, 252, 245, 36, 229, 198, 
                84, 207, 68, 16, 245, 198, 2, 71, 246, 144, 57, 44, 224, 32, 231, 3, 
                2, 71, 228, 229, 35, 68, 144, 245, 35, 117, 28, 0, 144, 56, 30, 229, 
                150, 240, 163, 229, 150, 240, 144, 56, 228, 121, 4, 120, 2, 229, 150, 240, 
                163, 217, 250, 144, 56, 32, 121, 6, 216, 243, 128, 185, 192, 2, 18, 63, 
                41, 208, 2, 117, 134, 0, 125, 0, 120, 183, 121, 12, 18, 63, 69, 120, 
                84, 121, 32, 18, 63, 69, 144, 55, 4, 121, 48, 18, 63, 65, 120, 131, 
                121, 4, 18, 63, 69, 120, 255, 134, 150, 133, 129, 150, 228, 245, 150, 2, 
                71, 246, 144, 54, 224, 229, 150, 240, 163, 229, 150, 240, 144, 54, 228, 229, 
                150, 240, 163, 229, 150, 240, 144, 54, 232, 229, 150, 240, 144, 54, 236, 229, 
                150, 240, 2, 71, 232, 187, 3, 20, 133, 150, 12, 18, 63, 53, 229, 150, 
                85, 8, 69, 150, 245, 8, 18, 63, 49, 2, 1, 108, 2, 71, 228, 187, 
                2, 250, 32, 4, 247, 210, 4, 144, 55, 52, 229, 150, 240, 163, 229, 150, 
                240, 2, 1, 108, 192, 2, 18, 63, 41, 208, 2, 117, 134, 0, 125, 0, 
                133, 31, 150, 133, 34, 150, 120, 147, 121, 4, 18, 63, 69, 127, 4, 117, 
                12, 78, 18, 63, 57, 120, 8, 121, 4, 18, 63, 69, 127, 4, 117, 12, 
                79, 18, 63, 57, 120, 8, 121, 4, 18, 63, 69, 127, 4, 117, 12, 101, 
                18, 63, 57, 120, 8, 121, 4, 18, 63, 69, 144, 61, 171, 121, 1, 18, 
                63, 65, 120, 145, 121, 2, 18, 63, 69, 144, 56, 219, 121, 1, 18, 63, 
                65, 228, 245, 150, 2, 71, 246, 144, 0, 9, 224, 245, 150, 163, 224, 245, 
                150, 144, 57, 57, 224, 245, 150, 117, 12, 224, 18, 63, 53, 133, 8, 150, 
                117, 150, 0, 2, 71, 246, 141, 21, 229, 150, 249, 84, 31, 251, 233, 84, 
                128, 249, 170, 150, 10, 133, 150, 8, 117, 12, 253, 18, 63, 49, 175, 150, 
                15, 223, 254, 233, 96, 26, 67, 8, 3, 18, 63, 49, 127, 15, 223, 254, 
                83, 8, 253, 18, 63, 49, 127, 15, 223, 254, 83, 8, 252, 18, 63, 49, 
                172, 150, 173, 150, 236, 84, 192, 180, 192, 14, 141, 8, 18, 63, 49, 236, 
                84, 63, 4, 255, 223, 254, 128, 103, 233, 96, 4, 126, 9, 128, 5, 236, 
                84, 7, 4, 254, 233, 96, 5, 190, 1, 2, 125, 0, 237, 35, 253, 236, 
                32, 230, 17, 32, 231, 28, 237, 32, 224, 5, 83, 8, 253, 128, 31, 67, 
                8, 2, 128, 26, 237, 32, 224, 5, 83, 8, 251, 128, 17, 67, 8, 4, 
                128, 12, 237, 32, 224, 5, 83, 8, 247, 128, 3, 67, 8, 8, 18, 63, 
                49, 236, 32, 229, 6, 67, 8, 1, 18, 63, 49, 234, 255, 223, 254, 236, 
                32, 229, 6, 83, 8, 254, 18, 63, 49, 234, 255, 223, 254, 222, 165, 219, 
                40, 233, 96, 22, 83, 8, 252, 18, 63, 49, 67, 8, 1, 18, 63, 49, 
                127, 15, 223, 254, 67, 8, 2, 18, 63, 49, 133, 21, 149, 229, 150, 210, 
                231, 133, 21, 149, 245, 150, 127, 0, 34, 97, 80, 229, 150, 84, 192, 96, 
                36, 187, 4, 30, 254, 169, 150, 133, 150, 23, 168, 150, 233, 48, 231, 8, 
                190, 64, 5, 18, 94, 173, 128, 2, 232, 247, 9, 8, 213, 23, 237, 2, 
                1, 108, 2, 71, 228, 187, 5, 27, 133, 150, 131, 133, 150, 130, 133, 150, 
                23, 168, 150, 133, 131, 133, 133, 130, 132, 232, 240, 163, 8, 213, 23, 249, 
                2, 1, 108, 2, 71, 228, 187, 6, 250, 133, 150, 22, 133, 150, 131, 169, 
                150, 133, 150, 133, 133, 150, 21, 171, 150, 229, 22, 84, 192, 112, 2, 137, 
                130, 229, 22, 84, 12, 112, 3, 133, 21, 132, 229, 22, 84, 192, 96, 27, 
                233, 48, 231, 19, 229, 22, 32, 231, 14, 192, 131, 192, 130, 18, 93, 21, 
                208, 130, 208, 131, 9, 128, 7, 231, 9, 128, 2, 224, 163, 248, 229, 22, 
                84, 12, 96, 41, 229, 21, 48, 231, 25, 229, 22, 32, 227, 20, 137, 23, 
                229, 21, 249, 192, 131, 192, 130, 18, 94, 173, 208, 130, 208, 131, 169, 23, 
                128, 7, 136, 23, 229, 21, 248, 166, 23, 5, 21, 128, 9, 117, 134, 1, 
                232, 240, 163, 117, 134, 0, 219, 162, 33, 108, 210, 4, 194, 5, 127, 0, 
                117, 134, 1, 144, 55, 52, 224, 245, 131, 163, 224, 245, 130, 117, 134, 0, 
                224, 84, 240, 250, 224, 84, 15, 251, 163, 186, 16, 3, 2, 62, 83, 186, 
                32, 3, 2, 62, 86, 186, 64, 3, 2, 62, 89, 186, 80, 3, 2, 62, 
                95, 186, 48, 3, 2, 62, 92, 186, 96, 3, 2, 62, 98, 186, 112, 3, 
                2, 62, 101, 2, 62, 38, 117, 134, 1, 144, 55, 52, 229, 131, 240, 163, 
                229, 130, 240, 32, 5, 3, 129, 221, 15, 34, 224, 163, 245, 12, 224, 163, 
                245, 8, 18, 63, 49, 161, 22, 224, 163, 245, 12, 27, 235, 255, 120, 8, 
                224, 163, 246, 8, 219, 250, 18, 63, 61, 161, 22, 224, 163, 245, 133, 224, 
                163, 245, 132, 27, 27, 224, 163, 117, 134, 1, 240, 163, 117, 134, 0, 219, 
                244, 161, 22, 117, 14, 0, 117, 15, 1, 224, 163, 245, 16, 224, 163, 245, 
                17, 133, 27, 141, 133, 26, 139, 210, 5, 194, 6, 210, 171, 210, 142, 161, 
                22, 117, 134, 1, 144, 55, 55, 117, 134, 0, 224, 163, 117, 134, 1, 240, 
                163, 117, 134, 0, 219, 244, 192, 131, 192, 130, 18, 62, 27, 208, 130, 208, 
                131, 127, 0, 161, 22, 123, 72, 133, 36, 12, 18, 63, 53, 229, 8, 84, 
                240, 248, 224, 163, 84, 15, 72, 245, 8, 18, 63, 49, 117, 12, 37, 32, 
                144, 253, 133, 12, 157, 224, 163, 32, 144, 253, 245, 158, 219, 247, 161, 22, 
                123, 16, 133, 34, 12, 18, 63, 53, 229, 8, 84, 248, 248, 224, 163, 84, 
                7, 72, 245, 8, 18, 63, 49, 117, 12, 35, 128, 211, 18, 119, 39, 18, 
                119, 78, 208, 134, 208, 131, 208, 130, 208, 208, 208, 224, 50, 192, 224, 192, 
                208, 48, 129, 10, 229, 135, 68, 1, 245, 135, 194, 129, 128, 28, 48, 130, 
                6, 210, 1, 194, 130, 128, 19, 48, 131, 4, 194, 131, 128, 12, 48, 132, 
                4, 194, 132, 128, 5, 48, 134, 2, 194, 134, 229, 145, 84, 191, 245, 145, 
                2, 5, 248, 192, 224, 192, 208, 229, 145, 84, 223, 245, 145, 2, 5, 248, 
                192, 224, 192, 208, 2, 5, 248, 192, 224, 192, 208, 229, 145, 84, 127, 245, 
                145, 2, 5, 248, 192, 224, 192, 208, 194, 133, 194, 220, 2, 5, 248, 50, 
                192, 224, 192, 208, 194, 135, 229, 135, 68, 1, 245, 135, 2, 5, 248, 192, 
                224, 192, 208, 229, 195, 48, 224, 20, 210, 3, 117, 149, 0, 133, 25, 140, 
                133, 24, 138, 117, 13, 0, 194, 2, 210, 169, 210, 140, 229, 145, 84, 239, 
                245, 145, 2, 5, 248, 192, 224, 192, 208, 192, 130, 192, 131, 192, 134, 117, 
                134, 0, 144, 55, 54, 224, 5, 13, 195, 149, 13, 96, 9, 133, 25, 140, 
                133, 24, 138, 2, 5, 242, 210, 2, 194, 169, 194, 140, 117, 195, 2, 2, 
                5, 242, 192, 224, 192, 208, 229, 15, 36, 1, 245, 15, 228, 53, 14, 245, 
                14, 229, 17, 149, 15, 229, 16, 149, 14, 64, 8, 133, 27, 141, 133, 26, 
                139, 128, 6, 210, 6, 194, 171, 194, 142, 208, 208, 208, 224, 50, 50, 144, 
                55, 55, 190, 0, 20, 229, 150, 240, 163, 219, 250, 192, 5, 192, 2, 18, 
                62, 27, 208, 2, 208, 5, 2, 71, 232, 229, 150, 240, 163, 27, 192, 5, 
                192, 2, 18, 62, 31, 208, 2, 208, 5, 224, 163, 245, 150, 219, 250, 2, 
                71, 232, 117, 134, 0, 195, 239, 117, 240, 96, 164, 36, 64, 245, 130, 229, 
                240, 52, 57, 245, 131, 117, 134, 1, 144, 61, 96, 120, 96, 117, 134, 0, 
                224, 163, 117, 134, 1, 240, 163, 216, 244, 117, 134, 0, 34, 2, 0, 4, 
                6, 64, 2, 0, 12, 6, 149, 2, 0, 20, 6, 96, 2, 0, 28, 6, 
                194, 2, 0, 36, 6, 95, 2, 0, 44, 6, 238, 2, 0, 52, 6, 84, 
                2, 0, 68, 6, 111, 2, 0, 76, 6, 51, 2, 0, 84, 5, 253, 2, 
                0, 92, 6, 71, 2, 62, 20, 4, 202, 2, 62, 36, 1, 27, 2, 62, 
                51, 6, 239, 2, 62, 60, 1, 111, 2, 62, 63, 1, 178, 2, 62, 66, 
                1, 217, 2, 62, 69, 2, 12, 2, 62, 72, 2, 66, 2, 62, 75, 2, 
                101, 2, 62, 78, 2, 127, 2, 62, 81, 2, 148, 2, 62, 84, 5, 42, 
                2, 62, 87, 5, 55, 2, 62, 90, 5, 75, 2, 62, 93, 5, 129, 2, 
                62, 96, 5, 99, 2, 62, 99, 5, 165, 2, 62, 102, 5, 208, 2, 63, 
                86, 1, 105, 2, 63, 109, 2, 247, 2, 63, 112, 3, 22, 3, 56, 225, 
                155, 252, 192, 3, 56, 253, 0, 0, 0, 3, 57, 1, 0, 0, 0, 12, 
                57, 12, 0, 80, 246, 144, 0, 0, 0, 0, 0, 0, 0, 0, 1, 57, 
                46, 3, 2, 57, 240, 246, 4, 2, 58, 80, 253, 193, 2, 58, 176, 47, 
                239, 2, 59, 16, 208, 178, 2, 59, 112, 47, 239, 2, 59, 208, 223, 239, 
                4, 60, 46, 68, 9, 47, 239, 2, 60, 144, 244, 171, 2, 60, 240, 244, 
                171, 1, 0, 10, 6, 2, 61, 228, 38, 224, 2, 61, 242, 39, 124, 0
            }
        },
        {
            /*Address = */ 9952, /*DataCount = */ 290, 
            /*Data = */
            { 
                243, 0, 101, 18, 50, 15, 255, 50, 7, 64, 50, 16, 255, 131, 51, 57, 
                59, 246, 17, 8, 57, 52, 104, 5, 246, 17, 9, 57, 51, 8, 21, 252, 
                15, 1, 61, 104, 15, 0, 15, 0, 0, 0, 0, 0, 252, 15, 3, 61, 
                96, 255, 0, 255, 0, 255, 0, 0, 0, 252, 15, 2, 61, 100, 255, 0, 
                255, 0, 255, 0, 0, 0, 252, 15, 9, 61, 108, 255, 0, 255, 0, 255, 
                0, 0, 0, 252, 15, 8, 61, 112, 255, 0, 255, 0, 255, 0, 0, 0, 
                252, 15, 114, 57, 60, 3, 128, 1, 128, 240, 0, 0, 0, 246, 17, 8, 
                57, 52, 104, 0, 244, 3, 104, 61, 169, 242, 18, 104, 246, 17, 9, 57, 
                51, 8, 16, 244, 3, 104, 61, 168, 242, 18, 104, 252, 15, 1, 61, 156, 
                15, 0, 15, 0, 0, 0, 0, 0, 50, 3, 19, 0, 243, 0, 101, 25, 
                18, 5, 64, 243, 16, 104, 35, 244, 2, 104, 4, 0, 244, 6, 104, 39, 
                187, 252, 15, 33, 61, 140, 255, 0, 255, 0, 0, 128, 0, 128, 252, 15, 
                61, 61, 148, 255, 0, 0, 0, 0, 0, 0, 0, 252, 15, 62, 61, 152, 
                255, 0, 0, 0, 0, 0, 0, 0, 226, 39, 210, 252, 15, 33, 54, 224, 
                255, 0, 255, 0, 0, 128, 0, 128, 148, 61, 4, 54, 232, 148, 62, 4, 
                54, 236, 246, 17, 250, 57, 50, 1, 0, 18, 43, 7, 37, 16, 0, 45, 
                0, 0, 246, 17, 54, 57, 45, 32, 16, 18, 17, 8, 82, 0, 25, 18, 
                11, 0, 37, 29, 6, 17, 0, 0, 37, 16, 0, 40, 0, 0, 50, 3, 
                26, 0
            }
        },
        {
            /*Address = */ 14400, /*DataCount = */ 2, 
            /*Data = */
            { 
                7, 77
            }
        }
    }, /*HexBlockCount = */ 4
};

const DtuHexStruct DEMOD_FIRMWARE_DTU234_REV9 =
{
    {
        {
            /*Address = */ 0, /*DataCount = */ 3,
            /*Data = */
            {
            2, 1, 0
            }
        },
        {
            /*Address = */ 256, /*DataCount = */ 1872,
            /*Data = */
            {
            117, 129, 206, 117, 32, 0, 210, 0, 120, 0, 121, 0, 18, 118, 17, 18,
            118, 172, 144, 0, 9, 116, 14, 240, 2, 64, 49, 3, 56, 225, 155, 252,
            192, 3, 56, 253, 0, 0, 0, 3, 57, 1, 0, 0, 0, 8, 57, 16,
            0, 0, 0, 0, 0, 0, 0, 0, 1, 57, 46, 3, 1, 57, 179, 255,
            2, 57, 240, 246, 4, 1, 58, 19, 255, 2, 58, 80, 253, 193, 1, 58,
            115, 255, 2, 58, 176, 47, 239, 1, 58, 211, 255, 2, 59, 16, 208, 178,
            1, 59, 51, 255, 2, 59, 112, 47, 239, 1, 59, 147, 255, 2, 59, 208,
            223, 239, 1, 59, 243, 255, 4, 60, 46, 68, 9, 47, 239, 1, 60, 83,
            255, 2, 60, 144, 244, 171, 1, 60, 179, 255, 2, 60, 240, 244, 171, 1,
            /* Offset */
            0, 10, 6, 2, 61, 228, 38, 224, 2, 61, 242, 39, 124, 0
            }
        },
        {
            /*Address = */ 9952, /*DataCount = */ 290,
            /*Data = */
            {
            243, 0, 101, 18, 50, 15, 255, 50, 7, 64, 50, 16, 255, 131, 51, 57,
            59, 246, 17, 8, 57, 52, 104, 5, 246, 17, 9, 57, 51, 8, 21, 252,
            15, 1, 61, 104, 15, 0, 15, 0, 0, 0, 0, 0, 252, 15, 3, 61,
            96, 255, 0, 255, 0, 255, 0, 0, 0, 252, 15, 2, 61, 100, 255, 0,
            255, 0, 255, 0, 0, 0, 252, 15, 9, 61, 108, 255, 0, 255, 0, 255,
            0, 0, 0, 252, 15, 8, 61, 112, 255, 0, 255, 0, 255, 0, 0, 0,
            252, 15, 114, 57, 60, 3, 128, 1, 128, 240, 0, 0, 0, 246, 17, 8,
            57, 52, 104, 0, 244, 3, 104, 61, 169, 242, 18, 104, 246, 17, 9, 57,
            51, 8, 16, 244, 3, 104, 61, 168, 242, 18, 104, 252, 15, 1, 61, 156,
            15, 0, 15, 0, 0, 0, 0, 0, 50, 3, 19, 0, 243, 0, 101, 25,
            18, 5, 64, 243, 16, 104, 35, 244, 2, 104, 4, 0, 244, 6, 104, 39,
            187, 252, 15, 33, 61, 140, 255, 0, 255, 0, 0, 128, 0, 128, 252, 15,
            61, 61, 148, 255, 0, 0, 0, 0, 0, 0, 0, 252, 15, 62, 61, 152,
            255, 0, 0, 0, 0, 0, 0, 0, 226, 39, 210, 252, 15, 33, 54, 224,
            255, 0, 255, 0, 0, 128, 0, 128, 148, 61, 4, 54, 232, 148, 62, 4,
            54, 236, 246, 17, 250, 57, 50, 1, 0, 18, 43, 7, 37, 16, 0, 45,
            0, 0, 246, 17, 54, 57, 45, 32, 16, 18, 17, 8, 82, 0, 25, 18,
            11, 0, 37, 29, 6, 17, 0, 0, 37, 16, 0, 40, 0, 0, 50, 3, 26, 0
            }
        },
        {
            /*Address = */ 14400, /*DataCount = */ 2,
            /*Data = */
            {
            1, 27
            }
        }
    }, /*HexBlockCount = */ 4
};

//=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Demodulator firmware store +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
// Important: When adding a new revision keep in mind that the m_MinHwRev has 3 digits.
//            i.e. V9.00 is noted as 900.
const DtuDemodFirmwareStore  DtuDemodFirmwareStores[] =
{
    // DTU-234
    { 0x0222,  0, 0x18, 0xA9, 0xAA, 0xAB, 0xA2, &REG_PREUPLOAD_DTU234, &REG_STOPUPLOAD_DTU234, &REG_POSTUPLOAD_DTU234, &DEMOD_FIRMWARE_DTU234},
    { 0x0222,  900, 0x18, 0xA9, 0xAA, 0xAB, 0xA2, &REG_PREUPLOAD_DTU234, &REG_STOPUPLOAD_DTU234, &REG_POSTUPLOAD_DTU234, &DEMOD_FIRMWARE_DTU234_REV9}
};
const Int  DtuDemodFirmwareStoreCount = sizeof(DtuDemodFirmwareStores)/sizeof(DtuDemodFirmwareStores[0]);

