//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcTSRXFMT_RegAccess.h *#*#*#*#*#*#*#* (C) 2019 DekTec
//
// Device driver - TsRxFmtTrp v0 (TSRXFMT) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block TsRxFmtTrp.
// These functions should solely be used by the block controller for TsRxFmtTrp.
//
// 2019.03.06 11:21 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'OperationalStatus' and 'PacketSize' from register 'Status':
//      UInt32  Reg_Status, OperationalStatus, PacketSize;
//      Reg_Status        = TSRXFMT_Status_READ(pBc);
//      OperationalStatus = TSRXFMT_Status_GET_OperationalStatus(Reg_Status);
//      PacketSize        = TSRXFMT_Status_GET_PacketSize(Reg_Status);
//
// 2. Single-function shorthand for reading field 'PacketSize' from register 'Status':
//      UInt32  PacketSize = TSRXFMT_Status_READ_PacketSize(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// TSRXFMT_Control_READ
// TSRXFMT_Control_SET_BlockEnable
// TSRXFMT_Control_SET_OperationalMode
// TSRXFMT_Control_SET_PacketMode
// TSRXFMT_Control_SET_SyncMode
// TSRXFMT_Control_WRITE
// TSRXFMT_Status_GET_OperationalStatus
// TSRXFMT_Status_GET_PacketSize
// TSRXFMT_Status_READ
// TSRXFMT_Status_READ_OperationalStatus
// TSRXFMT_Status_READ_PacketSize

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'BlockEnable'
#define TSRXFMT_BLKENA_DISABLED   0x0  // Block is entirely disabled
#define TSRXFMT_BLKENA_ENABLED    0x1  // Block is enabled and processes data

// Value map 'OperationalMode'
#define TSRXFMT_OPMODE_IDLE       0x0  // Block is inactive
#define TSRXFMT_OPMODE_STANDBY    0x1  // Block is partially operational
#define TSRXFMT_OPMODE_RUN        0x2  // Block performs its normal function

// Value map 'OperationalStatus'
#define TSRXFMT_OPSTATUS_IDLE     0x0  // Block is inactive
#define TSRXFMT_OPSTATUS_STANDBY  0x1  // Block is partially operational
#define TSRXFMT_OPSTATUS_RUN      0x2  // Block performs its normal function
#define TSRXFMT_OPSTATUS_ERROR    0x3  // An error has occurred

// Value map 'SyncMode'
#define TSRXFMT_SYNC_AUTO         0x0  // Synchronize to 188- or 204-byte packets
#define TSRXFMT_SYNC_188          0x2  // Synchronize to 188-byte packets only
#define TSRXFMT_SYNC_204          0x3  // Synchronize to 204-byte packets only

// Value map 'PacketMode'
#define TSRXFMT_PCKMODE_AUTO      0x0  // Align transport packets if synchronized
#define TSRXFMT_PCKMODE_RAW       0x1  // Do not align transport packets

// Value map 'PacketSize'
#define TSRXFMT_PCKSIZE_UNKNOWN   0x0  // Synchronizer not locked
#define TSRXFMT_PCKSIZE_188       0x2  // 188-byte transport packets detected
#define TSRXFMT_PCKSIZE_204       0x3  // 204-byte transport packets detected

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  TSRXFMT_Control_READ(DtBcTSRXFMT* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field SET functions
static __inline UInt32  TSRXFMT_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32  TSRXFMT_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32  TSRXFMT_Control_SET_SyncMode(UInt32 Control, UInt32 SyncMode)
{
    DT_ASSERT((SyncMode & ~0x3) == 0);
    return (Control & ~0x18) | (SyncMode << 3);
}
static __inline UInt32  TSRXFMT_Control_SET_PacketMode(UInt32 Control, UInt32 PacketMode)
{
    DT_ASSERT((PacketMode & ~0x1) == 0);
    return (Control & ~0x20) | (PacketMode << 5);
}

// Register WRITE function
static __inline void  TSRXFMT_Control_WRITE(DtBcTSRXFMT* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x4, Control);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  TSRXFMT_Status_READ(DtBcTSRXFMT* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field GET functions
static __inline UInt32  TSRXFMT_Status_GET_OperationalStatus(UInt32 Status)
{
    return Status & 0x3;
}
static __inline UInt32  TSRXFMT_Status_GET_PacketSize(UInt32 Status)
{
    return (Status & 0xC) >> 2;
}

// Field READ functions
static __inline UInt32  TSRXFMT_Status_READ_OperationalStatus(DtBcTSRXFMT* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8) & 0x3;
}
static __inline UInt32  TSRXFMT_Status_READ_PacketSize(DtBcTSRXFMT* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x8) & 0xC) >> 2;
}

