//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcTOD_RegAccess.h *#*#*#*#*#*#*#*#* (C) 2019 DekTec
//
// Device driver - TimeOfDay v0 (TOD) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block TimeOfDay.
// These functions should solely be used by the block controller for TimeOfDay.
//
// 2019.03.06 11:21 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Single-function shorthand for reading field 'SysClockAccuracy' from register
//    'Config2':
//      UInt32  SysClockAccuracy = TOD_Config2_READ_SysClockAccuracy(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// TOD_AdjustmentCount_READ
// TOD_ClockIncr_WRITE
// TOD_Config1_READ_SysClockFreq
// TOD_Config2_GET_SysClockAccuracy
// TOD_Config2_READ
// TOD_Config2_READ_SysClockAccuracy
// TOD_FractionAdjust_WRITE
// TOD_PeriodicInterval_WRITE
// TOD_SecondsAdjust_WRITE
// TOD_TodNanoseconds_READ
// TOD_TodSeconds_READ

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  TOD_Config1_READ_SysClockFreq(DtBcTOD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  TOD_Config2_READ(DtBcTOD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC);
}

// Field GET function
static __inline UInt32  TOD_Config2_GET_SysClockAccuracy(UInt32 Config2)
{
    return Config2 & 0xFFF;
}

// Field READ function
static __inline UInt32  TOD_Config2_READ_SysClockAccuracy(DtBcTOD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC) & 0xFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'PeriodicInterval' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void  TOD_PeriodicInterval_WRITE(DtBcTOD* pBc, UInt32 PeriodicInterval)
{
    DT_ASSERT((PeriodicInterval & ~0x3FF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x10, PeriodicInterval);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TodSeconds' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  TOD_TodSeconds_READ(DtBcTOD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x14);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TodNanoseconds' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  TOD_TodNanoseconds_READ(DtBcTOD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x18) & 0x3FFFFFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SecondsAdjust' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void  TOD_SecondsAdjust_WRITE(DtBcTOD* pBc, UInt32 SecondsAdjust)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1C, SecondsAdjust);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FractionAdjust' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void  TOD_FractionAdjust_WRITE(DtBcTOD* pBc, UInt32 FractionAdjust)
{
    DT_ASSERT((FractionAdjust & ~0x3FFFFFFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x20, FractionAdjust);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'ClockIncr' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void  TOD_ClockIncr_WRITE(DtBcTOD* pBc, UInt32 ClockIncr)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x24, ClockIncr);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'AdjustmentCount' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  TOD_AdjustmentCount_READ(DtBcTOD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x28) & 0xFFFF;
}

