//*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcSDITXPHY_RegAccess.h *#*#*#*#*#*#*#* (C) 2022 DekTec
//
// Device driver - SdiTxPhy v6 (SDITXPHY) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block SdiTxPhy.
// These functions should solely be used by the block controller for SdiTxPhy.
//
// 2022.01.26 13:31 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND.

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2020 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN No EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'DeviceFamily' and 'MaxSdiRate' from register 'Config':
//      UInt32  Reg_Config, DeviceFamily, MaxSdiRate;
//      Reg_Config   = SDITXPHY_Config_READ(pBc);
//      DeviceFamily = SDITXPHY_Config_GET_DeviceFamily(Reg_Config);
//      MaxSdiRate   = SDITXPHY_Config_GET_MaxSdiRate(Reg_Config);
//
// 2. Single-function shorthand for reading field 'IsFifoInhibited' from register
//    'CdcFifoStatus':
//      UInt32  IsFifoInhibited = SDITXPHY_CdcFifoStatus_READ_IsFifoInhibited(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// SDITXPHY_C10A10_ArbitrationCtrl_GET_ArbiterCtrlPma
// SDITXPHY_C10A10_ArbitrationCtrl_GET_CalDonePma
// SDITXPHY_C10A10_ArbitrationCtrl_READ
// SDITXPHY_C10A10_ArbitrationCtrl_SET_ArbiterCtrlPma
// SDITXPHY_C10A10_ArbitrationCtrl_SET_CalDonePma
// SDITXPHY_C10A10_ArbitrationCtrl_WRITE
// SDITXPHY_C10A10_CalCapability_GET_AvMmBusy
// SDITXPHY_C10A10_CalCapability_GET_RxCalBusy
// SDITXPHY_C10A10_CalCapability_GET_RxCalBusyEn
// SDITXPHY_C10A10_CalCapability_GET_TxCalBusy
// SDITXPHY_C10A10_CalCapability_GET_TxCalBusyEn
// SDITXPHY_C10A10_CalCapability_READ
// SDITXPHY_C10A10_CalCapability_READ_AvMmBusy
// SDITXPHY_C10A10_CalCapability_READ_RxCalBusy
// SDITXPHY_C10A10_CalCapability_READ_TxCalBusy
// SDITXPHY_C10A10_CalCapability_SET_RxCalBusyEn
// SDITXPHY_C10A10_CalCapability_SET_TxCalBusyEn
// SDITXPHY_C10A10_CalCapability_WRITE
// SDITXPHY_C10A10_CalEnable_GET_AdaptEn
// SDITXPHY_C10A10_CalEnable_GET_Reserved2
// SDITXPHY_C10A10_CalEnable_GET_Reserved3
// SDITXPHY_C10A10_CalEnable_GET_Reserved4
// SDITXPHY_C10A10_CalEnable_GET_RxCalEn
// SDITXPHY_C10A10_CalEnable_GET_TxCalEn
// SDITXPHY_C10A10_CalEnable_READ
// SDITXPHY_C10A10_CalEnable_SET_AdaptEn
// SDITXPHY_C10A10_CalEnable_SET_Reserved2
// SDITXPHY_C10A10_CalEnable_SET_Reserved3
// SDITXPHY_C10A10_CalEnable_SET_Reserved4
// SDITXPHY_C10A10_CalEnable_SET_RxCalEn
// SDITXPHY_C10A10_CalEnable_SET_TxCalEn
// SDITXPHY_C10A10_CalEnable_WRITE
// SDITXPHY_C10A10_PllLookup_GET_Pll0
// SDITXPHY_C10A10_PllLookup_GET_Pll1
// SDITXPHY_C10A10_PllLookup_GET_Pll2
// SDITXPHY_C10A10_PllLookup_GET_Pll3
// SDITXPHY_C10A10_PllLookup_READ
// SDITXPHY_C10A10_PllLookup_READ_Pll0
// SDITXPHY_C10A10_PllLookup_READ_Pll1
// SDITXPHY_C10A10_PllLookup_READ_Pll2
// SDITXPHY_C10A10_PllLookup_READ_Pll3
// SDITXPHY_C10A10_PllSelectionMux_READ
// SDITXPHY_C10A10_PllSelectionMux_WRITE
// SDITXPHY_C10A10_TxCtrl_GET_Reserved
// SDITXPHY_C10A10_TxCtrl_GET_SlewRateCtrl
// SDITXPHY_C10A10_TxCtrl_READ
// SDITXPHY_C10A10_TxCtrl_SET_Reserved
// SDITXPHY_C10A10_TxCtrl_SET_SlewRateCtrl
// SDITXPHY_C10A10_TxCtrl_WRITE
// SDITXPHY_CdcFifoControl_READ
// SDITXPHY_CdcFifoControl_SET_InhibitFifo
// SDITXPHY_CdcFifoControl_WRITE
// SDITXPHY_CdcFifoStatus_CLEAR_Underflow
// SDITXPHY_CdcFifoStatus_GET_IsFifoInhibited
// SDITXPHY_CdcFifoStatus_GET_Load
// SDITXPHY_CdcFifoStatus_GET_Underflow
// SDITXPHY_CdcFifoStatus_READ
// SDITXPHY_CdcFifoStatus_READ_IsFifoInhibited
// SDITXPHY_CdcFifoStatus_READ_Load
// SDITXPHY_CdcFifoStatus_READ_Underflow
// SDITXPHY_Config_GET_DeviceFamily
// SDITXPHY_Config_GET_MaxSdiRate
// SDITXPHY_Config_GET_NumClocks
// SDITXPHY_Config_GET_PllIdClk1
// SDITXPHY_Config_GET_PllIdClk2
// SDITXPHY_Config_READ
// SDITXPHY_Config_READ_DeviceFamily
// SDITXPHY_Config_READ_MaxSdiRate
// SDITXPHY_Config_READ_NumClocks
// SDITXPHY_Config_READ_PllIdClk1
// SDITXPHY_Config_READ_PllIdClk2
// SDITXPHY_Control_READ
// SDITXPHY_Control_SET_Arm
// SDITXPHY_Control_SET_BlockEnable
// SDITXPHY_Control_SET_GenlockSofDelay
// SDITXPHY_Control_SET_OperationalMode
// SDITXPHY_Control_SET_SrcFactor
// SDITXPHY_Control_SET_TxClkReset
// SDITXPHY_Control_SET_XcvrReset
// SDITXPHY_Control_WRITE
// SDITXPHY_Status_CLEAR_AccessTimedout
// SDITXPHY_Status_GET_AccessTimedout
// SDITXPHY_Status_GET_ArmStatus
// SDITXPHY_Status_GET_CalBusy
// SDITXPHY_Status_GET_OperationalStatus
// SDITXPHY_Status_GET_ResetInProgress
// SDITXPHY_Status_GET_WaitRequest
// SDITXPHY_Status_READ
// SDITXPHY_Status_READ_AccessTimedout
// SDITXPHY_Status_READ_ArmStatus
// SDITXPHY_Status_READ_CalBusy
// SDITXPHY_Status_READ_OperationalStatus
// SDITXPHY_Status_READ_ResetInProgress
// SDITXPHY_Status_READ_WaitRequest

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'ArbOwner'
#define SDITXPHY_ARBOWNER_User       0x0  // User has control of the internal
                                          // configuration bus
#define SDITXPHY_ARBOWNER_PreSICE    0x1  // PreSICE is controlling the internal
                                          // configuration bus

// Value map 'ArmStatus'
#define SDITXPHY_ARMSTATUS_IDLE      0x0  // Transmission starts when operational mode
                                          // becomes RUN
#define SDITXPHY_ARMSTATUS_PREARMED  0x1  // Armed and awaiting RUN
#define SDITXPHY_ARMSTATUS_ARMED     0x2  // Armed and awaiting GenlockSoF before
                                          // starting transmission

// Value map 'BlockEnable'
#define SDITXPHY_BLKENA_DISABLED     0x0  // Block is entirely disabled
#define SDITXPHY_BLKENA_ENABLED      0x1  // Block is enabled and processes data

// Value map 'CalDone'
#define SDITXPHY_CALDONE_Busy        0x0  // Calibration is running
#define SDITXPHY_CALDONE_Done        0x1  // Calibration is done

// Value map 'CalEn'
#define SDITXPHY_CALEN_Disable       0x0  // Disable calibration
#define SDITXPHY_CALEN_Enable        0x1  // Enable calibration

// Value map 'DeviceFamily'
#define SDITXPHY_FAMILY_CV           0x0  // Intel Cyclone V
#define SDITXPHY_FAMILY_C10          0x1  // Intel Cyclone 10
#define SDITXPHY_FAMILY_A10          0x2  // Intel Arria 10

// Value map 'OperationalMode'
#define SDITXPHY_OPMODE_IDLE         0x0  // Block is inactive
#define SDITXPHY_OPMODE_STANDBY      0x1  // Block is partially operational
#define SDITXPHY_OPMODE_RUN          0x2  // Block performs its normal function

// Value map 'OperationalStatus'
#define SDITXPHY_OPSTATUS_IDLE       0x0  // Block is inactive
#define SDITXPHY_OPSTATUS_STANDBY    0x1  // Block is partially operational
#define SDITXPHY_OPSTATUS_RUN        0x2  // Block performs its normal function
#define SDITXPHY_OPSTATUS_ERROR      0x3  // An error has occurred

// Value map 'SdiRate'
#define SDITXPHY_SDIMODE_SD          0x0  // SDI mode is SD-SDI
#define SDITXPHY_SDIMODE_HD          0x1  // SDI mode is HD-SDI
#define SDITXPHY_SDIMODE_3G          0x2  // SDI mode is 3G-SDI
#define SDITXPHY_SDIMODE_6G          0x3  // SDI mode is 6G-SDI
#define SDITXPHY_SDIMODE_12G         0x4  // SDI mode is 12G-SDI

// Value map 'SdiSrcFactor'
#define SDITXPHY_SDIMODE_BYPASS      0x0  // No up/down-sampling (x1)
#define SDITXPHY_SDIMODE_x2          0x1  // x2 up/down-sampling
#define SDITXPHY_SDIMODE_x11         0x2  // x11 up/down sampling
#define SDITXPHY_SDIMODE_x4          0x3  // x4 up/down-sampling
#define SDITXPHY_SDIMODE_x8          0x4  // x8 up/down sampling
#define SDITXPHY_SDIMODE_x44         0x5  // x44 up/down sampling

// Value map 'SlewRate'
#define SDITXPHY_SLEWRATE_SLEW_R0    0x0  // Slew rate 0
#define SDITXPHY_SLEWRATE_SLEW_R1    0x1  // Slew rate 1
#define SDITXPHY_SLEWRATE_SLEW_R2    0x2  // Slew rate 2
#define SDITXPHY_SLEWRATE_SLEW_R3    0x3  // Slew rate 3
#define SDITXPHY_SLEWRATE_SLEW_R4    0x4  // Slew rate 4
#define SDITXPHY_SLEWRATE_SLEW_R5    0x5  // Slew rate 5

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 SDITXPHY_Config_READ(DtBcSDITXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field GET functions
static __inline UInt32 SDITXPHY_Config_GET_DeviceFamily(UInt32 Config)
{
    return Config & 0xF;
}
static __inline UInt32 SDITXPHY_Config_GET_MaxSdiRate(UInt32 Config)
{
    return (Config & 0x70) >> 4;
}
static __inline UInt32 SDITXPHY_Config_GET_NumClocks(UInt32 Config)
{
    return (Config & 0x180) >> 7;
}
static __inline UInt32 SDITXPHY_Config_GET_PllIdClk1(UInt32 Config)
{
    return (Config & 0x7FE00) >> 9;
}
static __inline UInt32 SDITXPHY_Config_GET_PllIdClk2(UInt32 Config)
{
    return (Config & 0x1FF80000) >> 19;
}

// Field READ functions
static __inline UInt32 SDITXPHY_Config_READ_DeviceFamily(DtBcSDITXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4) & 0xF;
}
static __inline UInt32 SDITXPHY_Config_READ_MaxSdiRate(DtBcSDITXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0x70) >> 4;
}
static __inline UInt32 SDITXPHY_Config_READ_NumClocks(DtBcSDITXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0x180) >> 7;
}
static __inline UInt32 SDITXPHY_Config_READ_PllIdClk1(DtBcSDITXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0x7FE00) >> 9;
}
static __inline UInt32 SDITXPHY_Config_READ_PllIdClk2(DtBcSDITXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0x1FF80000) >> 19;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 SDITXPHY_Control_READ(DtBcSDITXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field SET functions
static __inline UInt32 SDITXPHY_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32 SDITXPHY_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32 SDITXPHY_Control_SET_XcvrReset(UInt32 Control, UInt32 XcvrReset)
{
    DT_ASSERT((XcvrReset & ~0x1) == 0);
    return (Control & ~0x8) | (XcvrReset << 3);
}
static __inline UInt32 SDITXPHY_Control_SET_Arm(UInt32 Control, UInt32 Arm)
{
    DT_ASSERT((Arm & ~0x1) == 0);
    return (Control & ~0x10) | (Arm << 4);
}
static __inline UInt32 SDITXPHY_Control_SET_SrcFactor(UInt32 Control, UInt32 SrcFactor)
{
    DT_ASSERT((SrcFactor & ~0xF) == 0);
    return (Control & ~0x1E0) | (SrcFactor << 5);
}
static __inline UInt32 SDITXPHY_Control_SET_GenlockSofDelay(UInt32 Control, UInt32 GenlockSofDelay)
{
    DT_ASSERT((GenlockSofDelay & ~0xFFFF) == 0);
    return (Control & ~0xFFFF000) | (GenlockSofDelay << 12);
}
static __inline UInt32 SDITXPHY_Control_SET_TxClkReset(UInt32 Control, UInt32 TxClkReset)
{
    DT_ASSERT((TxClkReset & ~0x1) == 0);
    return (Control & ~0x10000000) | (TxClkReset << 28);
}

// Register WRITE function
static __inline void SDITXPHY_Control_WRITE(DtBcSDITXPHY* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x8, Control);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 SDITXPHY_Status_READ(DtBcSDITXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC);
}

// Field GET functions
static __inline UInt32 SDITXPHY_Status_GET_OperationalStatus(UInt32 Status)
{
    return Status & 0x3;
}
static __inline UInt32 SDITXPHY_Status_GET_ResetInProgress(UInt32 Status)
{
    return (Status & 0x4) >> 2;
}
static __inline UInt32 SDITXPHY_Status_GET_ArmStatus(UInt32 Status)
{
    return (Status & 0x30) >> 4;
}
static __inline UInt32 SDITXPHY_Status_GET_CalBusy(UInt32 Status)
{
    return (Status & 0x40) >> 6;
}
static __inline UInt32 SDITXPHY_Status_GET_WaitRequest(UInt32 Status)
{
    return (Status & 0x80) >> 7;
}
static __inline UInt32 SDITXPHY_Status_GET_AccessTimedout(UInt32 Status)
{
    return (Status & 0x100) >> 8;
}

// Field READ functions
static __inline UInt32 SDITXPHY_Status_READ_OperationalStatus(DtBcSDITXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x3;
}
static __inline UInt32 SDITXPHY_Status_READ_ResetInProgress(DtBcSDITXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x4) >> 2;
}
static __inline UInt32 SDITXPHY_Status_READ_ArmStatus(DtBcSDITXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x30) >> 4;
}
static __inline UInt32 SDITXPHY_Status_READ_CalBusy(DtBcSDITXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x40) >> 6;
}
static __inline UInt32 SDITXPHY_Status_READ_WaitRequest(DtBcSDITXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x80) >> 7;
}
static __inline UInt32 SDITXPHY_Status_READ_AccessTimedout(DtBcSDITXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x100) >> 8;
}

// Field CLEAR function
static __inline void SDITXPHY_Status_CLEAR_AccessTimedout(DtBcSDITXPHY* pBc)
{
    UInt32  Status = DtBc_RegRead32((DtBc*)pBc, 0xC);
    DtBc_RegWrite32((DtBc*)pBc, 0xC, Status | 0x100);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'CdcFifoControl' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 SDITXPHY_CdcFifoControl_READ(DtBcSDITXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10);
}

// Field SET function
static __inline UInt32 SDITXPHY_CdcFifoControl_SET_InhibitFifo(UInt32 CdcFifoControl, UInt32 InhibitFifo)
{
    DT_ASSERT((InhibitFifo & ~0x1) == 0);
    return (CdcFifoControl & ~0x10) | (InhibitFifo << 4);
}

// Register WRITE function
static __inline void SDITXPHY_CdcFifoControl_WRITE(DtBcSDITXPHY* pBc, UInt32 CdcFifoControl)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10, CdcFifoControl);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'CdcFifoStatus' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDITXPHY_CdcFifoStatus_READ(DtBcSDITXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x14);
}

// Field GET functions
static __inline UInt32 SDITXPHY_CdcFifoStatus_GET_Underflow(UInt32 CdcFifoStatus)
{
    return CdcFifoStatus & 0x1;
}
static __inline UInt32 SDITXPHY_CdcFifoStatus_GET_Load(UInt32 CdcFifoStatus)
{
    return (CdcFifoStatus & 0xFF00) >> 8;
}
static __inline UInt32 SDITXPHY_CdcFifoStatus_GET_IsFifoInhibited(UInt32 CdcFifoStatus)
{
    return (CdcFifoStatus & 0x10000) >> 16;
}

// Field READ functions
static __inline UInt32 SDITXPHY_CdcFifoStatus_READ_Underflow(DtBcSDITXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x14) & 0x1;
}
static __inline UInt32 SDITXPHY_CdcFifoStatus_READ_Load(DtBcSDITXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x14) & 0xFF00) >> 8;
}
static __inline UInt32 SDITXPHY_CdcFifoStatus_READ_IsFifoInhibited(DtBcSDITXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x14) & 0x10000) >> 16;
}

// Field CLEAR function
static __inline void SDITXPHY_CdcFifoStatus_CLEAR_Underflow(DtBcSDITXPHY* pBc)
{
    UInt32  CdcFifoStatus = DtBc_RegRead32((DtBc*)pBc, 0x14);
    DtBc_RegWrite32((DtBc*)pBc, 0x14, CdcFifoStatus | 0x1);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'PllSelectionMux' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32 SDITXPHY_C10A10_PllSelectionMux_READ(DtBcSDITXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x20) & 0xFF;
}

// Field WRITE function
static __inline void SDITXPHY_C10A10_PllSelectionMux_WRITE(DtBcSDITXPHY* pBc, UInt32 PllSelectionMux)
{
    DT_ASSERT((PllSelectionMux & ~0xFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x20, PllSelectionMux);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'PllLookup' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDITXPHY_C10A10_PllLookup_READ(DtBcSDITXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x24);
}

// Field GET functions
static __inline UInt32 SDITXPHY_C10A10_PllLookup_GET_Pll0(UInt32 PllLookup)
{
    return PllLookup & 0xF;
}
static __inline UInt32 SDITXPHY_C10A10_PllLookup_GET_Pll1(UInt32 PllLookup)
{
    return (PllLookup & 0xF0) >> 4;
}
static __inline UInt32 SDITXPHY_C10A10_PllLookup_GET_Pll2(UInt32 PllLookup)
{
    return (PllLookup & 0xF00) >> 8;
}
static __inline UInt32 SDITXPHY_C10A10_PllLookup_GET_Pll3(UInt32 PllLookup)
{
    return (PllLookup & 0xF000) >> 12;
}

// Field READ functions
static __inline UInt32 SDITXPHY_C10A10_PllLookup_READ_Pll0(DtBcSDITXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x24) & 0xF;
}
static __inline UInt32 SDITXPHY_C10A10_PllLookup_READ_Pll1(DtBcSDITXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x24) & 0xF0) >> 4;
}
static __inline UInt32 SDITXPHY_C10A10_PllLookup_READ_Pll2(DtBcSDITXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x24) & 0xF00) >> 8;
}
static __inline UInt32 SDITXPHY_C10A10_PllLookup_READ_Pll3(DtBcSDITXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x24) & 0xF000) >> 12;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TxCtrl' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 SDITXPHY_C10A10_TxCtrl_READ(DtBcSDITXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x28);
}

// Field GET functions
static __inline UInt32 SDITXPHY_C10A10_TxCtrl_GET_SlewRateCtrl(UInt32 TxCtrl)
{
    return TxCtrl & 0x7;
}
static __inline UInt32 SDITXPHY_C10A10_TxCtrl_GET_Reserved(UInt32 TxCtrl)
{
    return (TxCtrl & 0xF8) >> 3;
}

// Field SET functions
static __inline UInt32 SDITXPHY_C10A10_TxCtrl_SET_SlewRateCtrl(UInt32 TxCtrl, UInt32 SlewRateCtrl)
{
    DT_ASSERT((SlewRateCtrl & ~0x7) == 0);
    return (TxCtrl & ~0x7) | SlewRateCtrl;
}
static __inline UInt32 SDITXPHY_C10A10_TxCtrl_SET_Reserved(UInt32 TxCtrl, UInt32 Reserved)
{
    DT_ASSERT((Reserved & ~0x1F) == 0);
    return (TxCtrl & ~0xF8) | (Reserved << 3);
}

// Register WRITE function
static __inline void SDITXPHY_C10A10_TxCtrl_WRITE(DtBcSDITXPHY* pBc, UInt32 TxCtrl)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x28, TxCtrl);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'ArbitrationCtrl' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 SDITXPHY_C10A10_ArbitrationCtrl_READ(DtBcSDITXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x2C);
}

// Field GET functions
static __inline UInt32 SDITXPHY_C10A10_ArbitrationCtrl_GET_ArbiterCtrlPma(UInt32 ArbitrationCtrl)
{
    return ArbitrationCtrl & 0x1;
}
static __inline UInt32 SDITXPHY_C10A10_ArbitrationCtrl_GET_CalDonePma(UInt32 ArbitrationCtrl)
{
    return (ArbitrationCtrl & 0x2) >> 1;
}

// Field SET functions
static __inline UInt32 SDITXPHY_C10A10_ArbitrationCtrl_SET_ArbiterCtrlPma(UInt32 ArbitrationCtrl, UInt32 ArbiterCtrlPma)
{
    DT_ASSERT((ArbiterCtrlPma & ~0x1) == 0);
    return (ArbitrationCtrl & ~0x1) | ArbiterCtrlPma;
}
static __inline UInt32 SDITXPHY_C10A10_ArbitrationCtrl_SET_CalDonePma(UInt32 ArbitrationCtrl, UInt32 CalDonePma)
{
    DT_ASSERT((CalDonePma & ~0x1) == 0);
    return (ArbitrationCtrl & ~0x2) | (CalDonePma << 1);
}

// Register WRITE function
static __inline void SDITXPHY_C10A10_ArbitrationCtrl_WRITE(DtBcSDITXPHY* pBc, UInt32 ArbitrationCtrl)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x2C, ArbitrationCtrl);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'CalEnable' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDITXPHY_C10A10_CalEnable_READ(DtBcSDITXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x30);
}

// Field GET functions
static __inline UInt32 SDITXPHY_C10A10_CalEnable_GET_Reserved2(UInt32 CalEnable)
{
    return CalEnable & 0x1;
}
static __inline UInt32 SDITXPHY_C10A10_CalEnable_GET_RxCalEn(UInt32 CalEnable)
{
    return (CalEnable & 0x2) >> 1;
}
static __inline UInt32 SDITXPHY_C10A10_CalEnable_GET_Reserved3(UInt32 CalEnable)
{
    return (CalEnable & 0x1C) >> 2;
}
static __inline UInt32 SDITXPHY_C10A10_CalEnable_GET_TxCalEn(UInt32 CalEnable)
{
    return (CalEnable & 0x20) >> 5;
}
static __inline UInt32 SDITXPHY_C10A10_CalEnable_GET_AdaptEn(UInt32 CalEnable)
{
    return (CalEnable & 0x40) >> 6;
}
static __inline UInt32 SDITXPHY_C10A10_CalEnable_GET_Reserved4(UInt32 CalEnable)
{
    return (CalEnable & 0x80) >> 7;
}

// Field SET functions
static __inline UInt32 SDITXPHY_C10A10_CalEnable_SET_Reserved2(UInt32 CalEnable, UInt32 Reserved2)
{
    DT_ASSERT((Reserved2 & ~0x1) == 0);
    return (CalEnable & ~0x1) | Reserved2;
}
static __inline UInt32 SDITXPHY_C10A10_CalEnable_SET_RxCalEn(UInt32 CalEnable, UInt32 RxCalEn)
{
    DT_ASSERT((RxCalEn & ~0x1) == 0);
    return (CalEnable & ~0x2) | (RxCalEn << 1);
}
static __inline UInt32 SDITXPHY_C10A10_CalEnable_SET_Reserved3(UInt32 CalEnable, UInt32 Reserved3)
{
    DT_ASSERT((Reserved3 & ~0x7) == 0);
    return (CalEnable & ~0x1C) | (Reserved3 << 2);
}
static __inline UInt32 SDITXPHY_C10A10_CalEnable_SET_TxCalEn(UInt32 CalEnable, UInt32 TxCalEn)
{
    DT_ASSERT((TxCalEn & ~0x1) == 0);
    return (CalEnable & ~0x20) | (TxCalEn << 5);
}
static __inline UInt32 SDITXPHY_C10A10_CalEnable_SET_AdaptEn(UInt32 CalEnable, UInt32 AdaptEn)
{
    DT_ASSERT((AdaptEn & ~0x1) == 0);
    return (CalEnable & ~0x40) | (AdaptEn << 6);
}
static __inline UInt32 SDITXPHY_C10A10_CalEnable_SET_Reserved4(UInt32 CalEnable, UInt32 Reserved4)
{
    DT_ASSERT((Reserved4 & ~0x1) == 0);
    return (CalEnable & ~0x80) | (Reserved4 << 7);
}

// Register WRITE function
static __inline void SDITXPHY_C10A10_CalEnable_WRITE(DtBcSDITXPHY* pBc, UInt32 CalEnable)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x30, CalEnable);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'CalCapability' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDITXPHY_C10A10_CalCapability_READ(DtBcSDITXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x34);
}

// Field GET functions
static __inline UInt32 SDITXPHY_C10A10_CalCapability_GET_TxCalBusy(UInt32 CalCapability)
{
    return CalCapability & 0x1;
}
static __inline UInt32 SDITXPHY_C10A10_CalCapability_GET_RxCalBusy(UInt32 CalCapability)
{
    return (CalCapability & 0x2) >> 1;
}
static __inline UInt32 SDITXPHY_C10A10_CalCapability_GET_AvMmBusy(UInt32 CalCapability)
{
    return (CalCapability & 0x4) >> 2;
}
static __inline UInt32 SDITXPHY_C10A10_CalCapability_GET_TxCalBusyEn(UInt32 CalCapability)
{
    return (CalCapability & 0x10) >> 4;
}
static __inline UInt32 SDITXPHY_C10A10_CalCapability_GET_RxCalBusyEn(UInt32 CalCapability)
{
    return (CalCapability & 0x20) >> 5;
}

// Field READ functions
static __inline UInt32 SDITXPHY_C10A10_CalCapability_READ_TxCalBusy(DtBcSDITXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x34) & 0x1;
}
static __inline UInt32 SDITXPHY_C10A10_CalCapability_READ_RxCalBusy(DtBcSDITXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x34) & 0x2) >> 1;
}
static __inline UInt32 SDITXPHY_C10A10_CalCapability_READ_AvMmBusy(DtBcSDITXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x34) & 0x4) >> 2;
}

// Field SET functions
static __inline UInt32 SDITXPHY_C10A10_CalCapability_SET_TxCalBusyEn(UInt32 CalCapability, UInt32 TxCalBusyEn)
{
    DT_ASSERT((TxCalBusyEn & ~0x1) == 0);
    return (CalCapability & ~0x10) | (TxCalBusyEn << 4);
}
static __inline UInt32 SDITXPHY_C10A10_CalCapability_SET_RxCalBusyEn(UInt32 CalCapability, UInt32 RxCalBusyEn)
{
    DT_ASSERT((RxCalBusyEn & ~0x1) == 0);
    return (CalCapability & ~0x20) | (RxCalBusyEn << 5);
}

// Register WRITE function
static __inline void SDITXPHY_C10A10_CalCapability_WRITE(DtBcSDITXPHY* pBc, UInt32 CalCapability)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x34, CalCapability);
}

