//*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcSDIRXPHY_RegAccess.h *#*#*#*#*#*#*#* (C) 2022 DekTec
//
// Device driver - SdiRxPhy v5 (SDIRXPHY) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block SdiRxPhy.
// These functions should solely be used by the block controller for SdiRxPhy.
//
// 2022.01.26 13:31 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND.

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2020 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN No EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'DeviceFamily' and 'MaxSdiRate' from register 'Config':
//      UInt32  Reg_Config, DeviceFamily, MaxSdiRate;
//      Reg_Config   = SDIRXPHY_Config_READ(pBc);
//      DeviceFamily = SDIRXPHY_Config_GET_DeviceFamily(Reg_Config);
//      MaxSdiRate   = SDIRXPHY_Config_GET_MaxSdiRate(Reg_Config);
//
// 2. Single-function shorthand for reading field 'Load' from register 'CdcFifoStatus':
//      UInt32  Load = SDIRXPHY_CdcFifoStatus_READ_Load(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// SDIRXPHY_C10A10_ArbitrationCtrl_GET_ArbiterCtrlPma
// SDIRXPHY_C10A10_ArbitrationCtrl_GET_CalDonePma
// SDIRXPHY_C10A10_ArbitrationCtrl_READ
// SDIRXPHY_C10A10_ArbitrationCtrl_SET_ArbiterCtrlPma
// SDIRXPHY_C10A10_ArbitrationCtrl_SET_CalDonePma
// SDIRXPHY_C10A10_ArbitrationCtrl_WRITE
// SDIRXPHY_C10A10_CalCapability_GET_AvMmBusy
// SDIRXPHY_C10A10_CalCapability_GET_RxCalBusy
// SDIRXPHY_C10A10_CalCapability_GET_RxCalBusyEn
// SDIRXPHY_C10A10_CalCapability_GET_TxCalBusy
// SDIRXPHY_C10A10_CalCapability_GET_TxCalBusyEn
// SDIRXPHY_C10A10_CalCapability_READ
// SDIRXPHY_C10A10_CalCapability_READ_AvMmBusy
// SDIRXPHY_C10A10_CalCapability_READ_RxCalBusy
// SDIRXPHY_C10A10_CalCapability_READ_TxCalBusy
// SDIRXPHY_C10A10_CalCapability_SET_RxCalBusyEn
// SDIRXPHY_C10A10_CalCapability_SET_TxCalBusyEn
// SDIRXPHY_C10A10_CalCapability_WRITE
// SDIRXPHY_C10A10_CalEnable_GET_AdaptEn
// SDIRXPHY_C10A10_CalEnable_GET_Reserved32
// SDIRXPHY_C10A10_CalEnable_GET_Reserved33
// SDIRXPHY_C10A10_CalEnable_GET_Reserved34
// SDIRXPHY_C10A10_CalEnable_GET_RxCalEn
// SDIRXPHY_C10A10_CalEnable_GET_TxCalEn
// SDIRXPHY_C10A10_CalEnable_READ
// SDIRXPHY_C10A10_CalEnable_SET_AdaptEn
// SDIRXPHY_C10A10_CalEnable_SET_Reserved32
// SDIRXPHY_C10A10_CalEnable_SET_Reserved33
// SDIRXPHY_C10A10_CalEnable_SET_Reserved34
// SDIRXPHY_C10A10_CalEnable_SET_RxCalEn
// SDIRXPHY_C10A10_CalEnable_SET_TxCalEn
// SDIRXPHY_C10A10_CalEnable_WRITE
// SDIRXPHY_C10A10_CdrPllSettings10_GET_ChgpmpCurrentDnPd
// SDIRXPHY_C10A10_CdrPllSettings10_GET_Reserved28
// SDIRXPHY_C10A10_CdrPllSettings10_GET_Reserved29
// SDIRXPHY_C10A10_CdrPllSettings10_READ
// SDIRXPHY_C10A10_CdrPllSettings10_SET_ChgpmpCurrentDnPd
// SDIRXPHY_C10A10_CdrPllSettings10_SET_Reserved28
// SDIRXPHY_C10A10_CdrPllSettings10_SET_Reserved29
// SDIRXPHY_C10A10_CdrPllSettings10_WRITE
// SDIRXPHY_C10A10_CdrPllSettings4_GET_LfResistorPd
// SDIRXPHY_C10A10_CdrPllSettings4_GET_Reserved0
// SDIRXPHY_C10A10_CdrPllSettings4_GET_Reserved1
// SDIRXPHY_C10A10_CdrPllSettings4_READ
// SDIRXPHY_C10A10_CdrPllSettings4_SET_LfResistorPd
// SDIRXPHY_C10A10_CdrPllSettings4_SET_Reserved0
// SDIRXPHY_C10A10_CdrPllSettings4_SET_Reserved1
// SDIRXPHY_C10A10_CdrPllSettings4_WRITE
// SDIRXPHY_C10A10_CdrPllSettings8_GET_ChgpmpCurrentUpPd
// SDIRXPHY_C10A10_CdrPllSettings8_GET_Reserved27
// SDIRXPHY_C10A10_CdrPllSettings8_READ
// SDIRXPHY_C10A10_CdrPllSettings8_SET_ChgpmpCurrentUpPd
// SDIRXPHY_C10A10_CdrPllSettings8_SET_Reserved27
// SDIRXPHY_C10A10_CdrPllSettings8_WRITE
// SDIRXPHY_C10A10_CdrPllSettings9_GET_PdLCounter
// SDIRXPHY_C10A10_CdrPllSettings9_GET_Reserved2
// SDIRXPHY_C10A10_CdrPllSettings9_GET_Reserved3
// SDIRXPHY_C10A10_CdrPllSettings9_READ
// SDIRXPHY_C10A10_CdrPllSettings9_SET_PdLCounter
// SDIRXPHY_C10A10_CdrPllSettings9_SET_Reserved2
// SDIRXPHY_C10A10_CdrPllSettings9_SET_Reserved3
// SDIRXPHY_C10A10_CdrPllSettings9_WRITE
// SDIRXPHY_C10A10_PcsPmaSel_GET_PcsPmaBlockSel
// SDIRXPHY_C10A10_PcsPmaSel_GET_Reserved4
// SDIRXPHY_C10A10_PcsPmaSel_READ
// SDIRXPHY_C10A10_PcsPmaSel_SET_PcsPmaBlockSel
// SDIRXPHY_C10A10_PcsPmaSel_SET_Reserved4
// SDIRXPHY_C10A10_PcsPmaSel_WRITE
// SDIRXPHY_C10A10_PcsRxBlockSel_GET_Reserved5
// SDIRXPHY_C10A10_PcsRxBlockSel_GET_RxBlockSel
// SDIRXPHY_C10A10_PcsRxBlockSel_GET_RxClkOut
// SDIRXPHY_C10A10_PcsRxBlockSel_READ
// SDIRXPHY_C10A10_PcsRxBlockSel_SET_Reserved5
// SDIRXPHY_C10A10_PcsRxBlockSel_SET_RxBlockSel
// SDIRXPHY_C10A10_PcsRxBlockSel_SET_RxClkOut
// SDIRXPHY_C10A10_PcsRxBlockSel_WRITE
// SDIRXPHY_C10A10_PmaEqSettings_GET_EqualizerBw
// SDIRXPHY_C10A10_PmaEqSettings_GET_Reserved36
// SDIRXPHY_C10A10_PmaEqSettings_GET_Reserved37
// SDIRXPHY_C10A10_PmaEqSettings_READ
// SDIRXPHY_C10A10_PmaEqSettings_SET_EqualizerBw
// SDIRXPHY_C10A10_PmaEqSettings_SET_Reserved36
// SDIRXPHY_C10A10_PmaEqSettings_SET_Reserved37
// SDIRXPHY_C10A10_PmaEqSettings_WRITE
// SDIRXPHY_C10A10_PmaRxDeser_GET_DeserFactor
// SDIRXPHY_C10A10_PmaRxDeser_GET_Reserved30
// SDIRXPHY_C10A10_PmaRxDeser_READ
// SDIRXPHY_C10A10_PmaRxDeser_SET_DeserFactor
// SDIRXPHY_C10A10_PmaRxDeser_SET_Reserved30
// SDIRXPHY_C10A10_PmaRxDeser_WRITE
// SDIRXPHY_C10A10_PmaSettings_GET_RateSwitchFlag
// SDIRXPHY_C10A10_PmaSettings_GET_Reserved35
// SDIRXPHY_C10A10_PmaSettings_READ
// SDIRXPHY_C10A10_PmaSettings_SET_RateSwitchFlag
// SDIRXPHY_C10A10_PmaSettings_SET_Reserved35
// SDIRXPHY_C10A10_PmaSettings_WRITE
// SDIRXPHY_C10A10_Reserved38_READ
// SDIRXPHY_C10A10_Reserved38_WRITE
// SDIRXPHY_C10A10_Reserved39_READ
// SDIRXPHY_C10A10_Reserved39_WRITE
// SDIRXPHY_C10A10_Reserved40_READ
// SDIRXPHY_C10A10_Reserved40_WRITE
// SDIRXPHY_C10A10_Reserved41_READ
// SDIRXPHY_C10A10_Reserved41_WRITE
// SDIRXPHY_C10A10_RxPcs10G0_GET_GbRxIdWidth
// SDIRXPHY_C10A10_RxPcs10G0_GET_GbRxOdWidth
// SDIRXPHY_C10A10_RxPcs10G0_GET_Reserved17
// SDIRXPHY_C10A10_RxPcs10G0_READ
// SDIRXPHY_C10A10_RxPcs10G0_SET_GbRxIdWidth
// SDIRXPHY_C10A10_RxPcs10G0_SET_GbRxOdWidth
// SDIRXPHY_C10A10_RxPcs10G0_SET_Reserved17
// SDIRXPHY_C10A10_RxPcs10G0_WRITE
// SDIRXPHY_C10A10_RxPcs10G1_GET_RdfifoClken
// SDIRXPHY_C10A10_RxPcs10G1_GET_Reserved18
// SDIRXPHY_C10A10_RxPcs10G1_GET_WrfifoClken
// SDIRXPHY_C10A10_RxPcs10G1_READ
// SDIRXPHY_C10A10_RxPcs10G1_SET_RdfifoClken
// SDIRXPHY_C10A10_RxPcs10G1_SET_Reserved18
// SDIRXPHY_C10A10_RxPcs10G1_SET_WrfifoClken
// SDIRXPHY_C10A10_RxPcs10G1_WRITE
// SDIRXPHY_C10A10_RxPcs10G2_GET_GbExpClken
// SDIRXPHY_C10A10_RxPcs10G2_GET_Reserved19
// SDIRXPHY_C10A10_RxPcs10G2_GET_Reserved20
// SDIRXPHY_C10A10_RxPcs10G2_READ
// SDIRXPHY_C10A10_RxPcs10G2_SET_GbExpClken
// SDIRXPHY_C10A10_RxPcs10G2_SET_Reserved19
// SDIRXPHY_C10A10_RxPcs10G2_SET_Reserved20
// SDIRXPHY_C10A10_RxPcs10G2_WRITE
// SDIRXPHY_C10A10_RxPcs10G3_GET_Reserved21
// SDIRXPHY_C10A10_RxPcs10G3_GET_Reserved22
// SDIRXPHY_C10A10_RxPcs10G3_GET_StretchNumStages
// SDIRXPHY_C10A10_RxPcs10G3_READ
// SDIRXPHY_C10A10_RxPcs10G3_SET_Reserved21
// SDIRXPHY_C10A10_RxPcs10G3_SET_Reserved22
// SDIRXPHY_C10A10_RxPcs10G3_SET_StretchNumStages
// SDIRXPHY_C10A10_RxPcs10G3_WRITE
// SDIRXPHY_C10A10_RxPcs10G4_GET_FifoDoubleRead
// SDIRXPHY_C10A10_RxPcs10G4_GET_FifoStopRd
// SDIRXPHY_C10A10_RxPcs10G4_GET_Reserved23
// SDIRXPHY_C10A10_RxPcs10G4_GET_Reserved24
// SDIRXPHY_C10A10_RxPcs10G4_READ
// SDIRXPHY_C10A10_RxPcs10G4_SET_FifoDoubleRead
// SDIRXPHY_C10A10_RxPcs10G4_SET_FifoStopRd
// SDIRXPHY_C10A10_RxPcs10G4_SET_Reserved23
// SDIRXPHY_C10A10_RxPcs10G4_SET_Reserved24
// SDIRXPHY_C10A10_RxPcs10G4_WRITE
// SDIRXPHY_C10A10_RxPcs10G5_GET_PhcompRdDel
// SDIRXPHY_C10A10_RxPcs10G5_GET_Reserved25
// SDIRXPHY_C10A10_RxPcs10G5_READ
// SDIRXPHY_C10A10_RxPcs10G5_SET_PhcompRdDel
// SDIRXPHY_C10A10_RxPcs10G5_SET_Reserved25
// SDIRXPHY_C10A10_RxPcs10G5_WRITE
// SDIRXPHY_C10A10_RxPcs8G0_GET_PmaDw
// SDIRXPHY_C10A10_RxPcs8G0_GET_Reserved6
// SDIRXPHY_C10A10_RxPcs8G0_READ
// SDIRXPHY_C10A10_RxPcs8G0_SET_PmaDw
// SDIRXPHY_C10A10_RxPcs8G0_SET_Reserved6
// SDIRXPHY_C10A10_RxPcs8G0_WRITE
// SDIRXPHY_C10A10_RxPcs8G1_GET_Reserved7
// SDIRXPHY_C10A10_RxPcs8G1_GET_WaPd
// SDIRXPHY_C10A10_RxPcs8G1_GET_WaPldControlled
// SDIRXPHY_C10A10_RxPcs8G1_READ
// SDIRXPHY_C10A10_RxPcs8G1_SET_Reserved7
// SDIRXPHY_C10A10_RxPcs8G1_SET_WaPd
// SDIRXPHY_C10A10_RxPcs8G1_SET_WaPldControlled
// SDIRXPHY_C10A10_RxPcs8G1_WRITE
// SDIRXPHY_C10A10_RxPcs8G2_GET_Decoder8B10B
// SDIRXPHY_C10A10_RxPcs8G2_GET_Reserved8
// SDIRXPHY_C10A10_RxPcs8G2_READ
// SDIRXPHY_C10A10_RxPcs8G2_SET_Decoder8B10B
// SDIRXPHY_C10A10_RxPcs8G2_SET_Reserved8
// SDIRXPHY_C10A10_RxPcs8G2_WRITE
// SDIRXPHY_C10A10_RxPcs8G3_GET_ByteDeserializer
// SDIRXPHY_C10A10_RxPcs8G3_GET_Reserved9
// SDIRXPHY_C10A10_RxPcs8G3_READ
// SDIRXPHY_C10A10_RxPcs8G3_SET_ByteDeserializer
// SDIRXPHY_C10A10_RxPcs8G3_SET_Reserved9
// SDIRXPHY_C10A10_RxPcs8G3_WRITE
// SDIRXPHY_C10A10_RxPcs8G4_GET_PhaseCompRdptr
// SDIRXPHY_C10A10_RxPcs8G4_GET_Reserved10
// SDIRXPHY_C10A10_RxPcs8G4_GET_Reserved11
// SDIRXPHY_C10A10_RxPcs8G4_GET_Reserved12
// SDIRXPHY_C10A10_RxPcs8G4_GET_WaDispErrFlag
// SDIRXPHY_C10A10_RxPcs8G4_READ
// SDIRXPHY_C10A10_RxPcs8G4_SET_PhaseCompRdptr
// SDIRXPHY_C10A10_RxPcs8G4_SET_Reserved10
// SDIRXPHY_C10A10_RxPcs8G4_SET_Reserved11
// SDIRXPHY_C10A10_RxPcs8G4_SET_Reserved12
// SDIRXPHY_C10A10_RxPcs8G4_SET_WaDispErrFlag
// SDIRXPHY_C10A10_RxPcs8G4_WRITE
// SDIRXPHY_C10A10_RxPcs8G5_GET_Reserved13
// SDIRXPHY_C10A10_RxPcs8G5_GET_Reserved14
// SDIRXPHY_C10A10_RxPcs8G5_GET_WaBoundaryLockCtrl
// SDIRXPHY_C10A10_RxPcs8G5_READ
// SDIRXPHY_C10A10_RxPcs8G5_SET_Reserved13
// SDIRXPHY_C10A10_RxPcs8G5_SET_Reserved14
// SDIRXPHY_C10A10_RxPcs8G5_SET_WaBoundaryLockCtrl
// SDIRXPHY_C10A10_RxPcs8G5_WRITE
// SDIRXPHY_C10A10_RxPcs8G6_GET_ClockGateDwPcWrclk
// SDIRXPHY_C10A10_RxPcs8G6_GET_ClockGatePcRdclk
// SDIRXPHY_C10A10_RxPcs8G6_GET_ClockGateSwPcWrclk
// SDIRXPHY_C10A10_RxPcs8G6_GET_Reserved15
// SDIRXPHY_C10A10_RxPcs8G6_READ
// SDIRXPHY_C10A10_RxPcs8G6_SET_ClockGateDwPcWrclk
// SDIRXPHY_C10A10_RxPcs8G6_SET_ClockGatePcRdclk
// SDIRXPHY_C10A10_RxPcs8G6_SET_ClockGateSwPcWrclk
// SDIRXPHY_C10A10_RxPcs8G6_SET_Reserved15
// SDIRXPHY_C10A10_RxPcs8G6_WRITE
// SDIRXPHY_C10A10_RxPcs8G7_GET_ClockGateBdsDec
// SDIRXPHY_C10A10_RxPcs8G7_GET_ClockGateDwWa
// SDIRXPHY_C10A10_RxPcs8G7_GET_ClockGateSwWa
// SDIRXPHY_C10A10_RxPcs8G7_GET_Reserved16
// SDIRXPHY_C10A10_RxPcs8G7_READ
// SDIRXPHY_C10A10_RxPcs8G7_SET_ClockGateBdsDec
// SDIRXPHY_C10A10_RxPcs8G7_SET_ClockGateDwWa
// SDIRXPHY_C10A10_RxPcs8G7_SET_ClockGateSwWa
// SDIRXPHY_C10A10_RxPcs8G7_SET_Reserved16
// SDIRXPHY_C10A10_RxPcs8G7_WRITE
// SDIRXPHY_C10A10_RxPcsFifo_GET_DoubleReadMode
// SDIRXPHY_C10A10_RxPcsFifo_GET_ProtMode
// SDIRXPHY_C10A10_RxPcsFifo_GET_Reserved26
// SDIRXPHY_C10A10_RxPcsFifo_READ
// SDIRXPHY_C10A10_RxPcsFifo_SET_DoubleReadMode
// SDIRXPHY_C10A10_RxPcsFifo_SET_ProtMode
// SDIRXPHY_C10A10_RxPcsFifo_SET_Reserved26
// SDIRXPHY_C10A10_RxPcsFifo_WRITE
// SDIRXPHY_CdcFifoStatus_CLEAR_Overflow
// SDIRXPHY_CdcFifoStatus_GET_Load
// SDIRXPHY_CdcFifoStatus_GET_Overflow
// SDIRXPHY_CdcFifoStatus_READ
// SDIRXPHY_CdcFifoStatus_READ_Load
// SDIRXPHY_CdcFifoStatus_READ_Overflow
// SDIRXPHY_Config_GET_DeviceFamily
// SDIRXPHY_Config_GET_MaxSdiRate
// SDIRXPHY_Config_READ
// SDIRXPHY_Config_READ_DeviceFamily
// SDIRXPHY_Config_READ_MaxSdiRate
// SDIRXPHY_Control_READ
// SDIRXPHY_Control_SET_BlockEnable
// SDIRXPHY_Control_SET_LockMode
// SDIRXPHY_Control_SET_OperationalMode
// SDIRXPHY_Control_SET_PllReset
// SDIRXPHY_Control_SET_RxClkReset
// SDIRXPHY_Control_SET_SdiRate
// SDIRXPHY_Control_SET_SrcFactor
// SDIRXPHY_Control_SET_XcvrReset
// SDIRXPHY_Control_WRITE
// SDIRXPHY_Status_CLEAR_AccessTimedout
// SDIRXPHY_Status_GET_AccessTimedout
// SDIRXPHY_Status_GET_CalBusy
// SDIRXPHY_Status_GET_CarrierDetect
// SDIRXPHY_Status_GET_LockedToData
// SDIRXPHY_Status_GET_LockedToRef
// SDIRXPHY_Status_GET_NumEdgesDetected
// SDIRXPHY_Status_GET_ResetInProgress
// SDIRXPHY_Status_GET_WaitRequest
// SDIRXPHY_Status_READ
// SDIRXPHY_Status_READ_AccessTimedout
// SDIRXPHY_Status_READ_CalBusy
// SDIRXPHY_Status_READ_CarrierDetect
// SDIRXPHY_Status_READ_LockedToData
// SDIRXPHY_Status_READ_LockedToRef
// SDIRXPHY_Status_READ_NumEdgesDetected
// SDIRXPHY_Status_READ_ResetInProgress
// SDIRXPHY_Status_READ_WaitRequest

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map '8b10b'
#define SDIRXPHY_8B10B_DISABLE               0x3  // dis_8b10b - used for HD/3G/6G
#define SDIRXPHY_8B10B_ENABLE_IBM            0x7  // en_8b10b_ibm - used for 12G

// Value map 'ArbOwner'
#define SDIRXPHY_ARBOWNER_User               0x0  // User has control of the internal
                                                  // configuration bus
#define SDIRXPHY_ARBOWNER_PreSICE            0x1  // PreSICE is controlling the internal
                                                  // configuration bus

// Value map 'Bds'
#define SDIRXPHY_BDS_DISABLE                 0x0  // dis_bds - used for 12G
#define SDIRXPHY_BDS_EN_BY_2                 0x2  // en_bds_by_2 - used for HD/3G/6G

// Value map 'BdsClkGate'
#define SDIRXPHY_BDSCLKGATE_DISABLE          0x0  // dis_bds_dec_asn_clk_gating - used
                                                  // for HD/3G/6G
#define SDIRXPHY_BDSCLKGATE_ENABLE           0x1  // en_bds_dec_asn_clk_gating - used for
                                                  // 12G

// Value map 'BlockEnable'
#define SDIRXPHY_BLKENA_DISABLED             0x0  // Block is entirely disabled
#define SDIRXPHY_BLKENA_ENABLED              0x1  // Block is enabled and processes data

// Value map 'BoundLock'
#define SDIRXPHY_BOUNDLOCK_SYNC_SM           0x2  // sync_sm - used for 12G
#define SDIRXPHY_BOUNDLOCK_BIT_SLIP          0x4  // bit_slip - used for HD/3G/6G

// Value map 'CalDone'
#define SDIRXPHY_CALDONE_Busy                0x0  // Calibration is running
#define SDIRXPHY_CALDONE_Done                0x1  // Calibration is done

// Value map 'CalEn'
#define SDIRXPHY_CALEN_Disable               0x0  // Disable calibration
#define SDIRXPHY_CALEN_Enable                0x1  // Enable calibration

// Value map 'ClkGateDwWa'
#define SDIRXPHY_CLKGATEDWWA_DISABLE         0x0  // dis_dw_wa_clk_gating - used for 6G
#define SDIRXPHY_CLKGATEDWWA_ENABLE          0x1  // en_dw_wa_clk_gating - used for
                                                  // HD/3G/12G

// Value map 'ClkGateSwWa'
#define SDIRXPHY_CLKGATESWWA_DISABLE         0x0  // dis_sw_wa_clk_gating - used for
                                                  // HD/3G/6G
#define SDIRXPHY_CLKGATESWWA_ENABLE          0x1  // en_sw_wa_clk_gating - used for 12G

// Value map 'CpCurrentDn'
#define SDIRXPHY_CPCURRENTDN_SETTING_3       0x3  // cp_current_pd_dn_setting3 - used for
                                                  // 12G
#define SDIRXPHY_CPCURRENTDN_SETTING_4       0x4  // cp_current_pd_dn_setting4 - used for
                                                  // HD/3G/6G

// Value map 'CpCurrentUp'
#define SDIRXPHY_CPCURRENTUP_SETTING_3       0x3  // cp_current_pd_up_setting3 - used for
                                                  // 12G
#define SDIRXPHY_CPCURRENTUP_SETTING_4       0x4  // cp_current_pd_up_setting4 - used for
                                                  // HD/3G/6G

// Value map 'DeserFactor'
#define SDIRXPHY_DESERFACTOR_10              0x1  // 10 - used for HD/3G
#define SDIRXPHY_DESERFACTOR_20              0x3  // 20 - used for 6G
#define SDIRXPHY_DESERFACTOR_40              0x7  // 40 - used for 12G

// Value map 'DeviceFamily'
#define SDIRXPHY_FAMILY_CV                   0x0  // Intel Cyclone V
#define SDIRXPHY_FAMILY_C10                  0x1  // Intel Cyclone 10
#define SDIRXPHY_FAMILY_A10                  0x2  // Intel Arria 10

// Value map 'DispErrFlag'
#define SDIRXPHY_DISPERRFLAG_ENABLE          0x0  // en_disp_err_flag - used for 12G
#define SDIRXPHY_DISPERRFLAG_DISABLE         0x1  // dis_disp_err_flag - used for HD/3G/6G

// Value map 'DoubleReadMode'
#define SDIRXPHY_DOUBLEREADMODE_DISABLE      0x0  // double_read_dis - used for HD/3G/6G
#define SDIRXPHY_DOUBLEREADMODE_ENABLE       0x1  // double_read_en - used for 12G

// Value map 'DwWrclkGate'
#define SDIRXPHY_DWWRCLKGATE_DISABLE         0x0  // dis_dw_pc_wrclk_gating - used for 6G
#define SDIRXPHY_DWWRCLKGATE_ENABLE          0x1  // en_dw_pc_wrclk_gating - used for
                                                  // HD/3G/12G

// Value map 'EnRdptr'
#define SDIRXPHY_ENRDPTR_DISABLE             0x0  // disable_rdptr - used for 12G
#define SDIRXPHY_ENRDPTR_ENABLE              0x1  // enable_rdptr - used for HD/3G/6G

// Value map 'EqBw'
#define SDIRXPHY_EQBW_EQ_BW_1                0x0  // In high data rate mode, datarate <=
                                                  // 5G - used for HD/3G
#define SDIRXPHY_EQBW_EQ_BW_2                0x1  // In high data rate mode, 5G <
                                                  // datarate <= 10G - used for 6G
#define SDIRXPHY_EQBW_EQ_BW_3                0x2  // In high data rate mode, 10G <
                                                  // datarate <= 20G - used for 12G
#define SDIRXPHY_EQBW_EQ_BW_4                0x3  // In high data rate mode, 20G <
                                                  // datarate <= 25.78G - not used

// Value map 'FifoDoubleRead'
#define SDIRXPHY_FIFODOUBLEREAD_DISABLE      0x0  // fifo_double_read_dis - used for
                                                  // HD/3G/6G
#define SDIRXPHY_FIFODOUBLEREAD_ENABLE       0x1  // fifo_double_read_en - used for 12G

// Value map 'FifoStopRd'
#define SDIRXPHY_FIFOSTOPRD_EMPTY            0x0  // rd_empty - used for 12G
#define SDIRXPHY_FIFOSTOPRD_N_EMPTY          0x1  // n_rd_empty - used for HD/3G/6G

// Value map 'GbExpClken'
#define SDIRXPHY_GBEXPCLKEN_DISABLE          0x0  // gbexp_clk_dis - used for HD/3G/6G
#define SDIRXPHY_GBEXPCLKEN_ENABLE           0x1  // gbexp_clk_en - used for 12G

// Value map 'GbRxIdWidth'
#define SDIRXPHY_GBRXIDWIDTH_40              0x1  // width_40 - used for 12G
#define SDIRXPHY_GBRXIDWIDTH_64              0x2  // width_64 - used for HD/3G/6G

// Value map 'GbRxOdWidth'
#define SDIRXPHY_GBRXODWIDTH_40              0x3  // width_40 - used for 12G
#define SDIRXPHY_GBRXODWIDTH_64              0x5  // width_64 - used for HD/3G/6G

// Value map 'LCounter'
#define SDIRXPHY_LCOUNTER_DIV_BY_1           0x1  // Count, or divide by, 1 - used for
                                                  // 12G rate
#define SDIRXPHY_LCOUNTER_DIV_BY_2           0x3  // Count, or divide by, 2 - used for 6G
                                                  // rate
#define SDIRXPHY_LCOUNTER_DIV_BY_4           0x4  // Count, or divide by, 4 - used for 3G
                                                  // rate
#define SDIRXPHY_LCOUNTER_DIV_BY_8           0x5  // Count, or divide by, 8 - used for HD
                                                  // rate

// Value map 'LfPd'
#define SDIRXPHY_LFPD_SETTING_0              0x0  // lf_pd_setting0 - used for HD rate
#define SDIRXPHY_LFPD_SETTING_2              0x2  // lf_pd_setting2 - used for 12G rate
#define SDIRXPHY_LFPD_SETTING_3              0x3  // lf_pd_setting3 - used for 3G/6G rates

// Value map 'LockMode'
#define SDIRXPHY_LOCKMODE_LOCK_TO_DATA       0x0  // Lock-to-Data
#define SDIRXPHY_LOCKMODE_LOCK_TO_REF        0x1  // Lock-to-Reference

// Value map 'OperationalMode'
#define SDIRXPHY_OPMODE_IDLE                 0x0  // Block is inactive
#define SDIRXPHY_OPMODE_STANDBY              0x1  // Block is partially operational
#define SDIRXPHY_OPMODE_RUN                  0x2  // Block performs its normal function

// Value map 'PcRdclkGate'
#define SDIRXPHY_PCRDCLKGATE_DISABLE         0x0  // dis_pc_rdclk_gating - used for
                                                  // HD/3G/6G
#define SDIRXPHY_PCRDCLKGATE_ENABLE          0x1  // en_pc_rdclk_gating - used for 12G

// Value map 'Pcs'
#define SDIRXPHY_PCS_EIGHT_G_PCS             0x1  // 8G PCS - used for HD/3G/6G
#define SDIRXPHY_PCS_TEN_G_PCS               0x2  // 10G PCS - used for 12G

// Value map 'PhcompRdDel'
#define SDIRXPHY_PHCOMPRDDEL_PHCOMP_RD_DEL2  0x2  // phcomp_rd_del2 - used for HD/3G/6G
#define SDIRXPHY_PHCOMPRDDEL_PHCOMP_RD_DEL3  0x3  // phcomp_rd_del3 - used for 12G

// Value map 'PldCtrl'
#define SDIRXPHY_PLDCTRL_PLD_CTRL_SW_ALT     0x1  // pld_ctrl_sw_alt - equivalent to
                                                  // pld_ctrl_sw
#define SDIRXPHY_PLDCTRL_RISING_EDGE_DW      0x2  // rising_edge_sensitive_dw/dis_pld_ctrl
                                                  // - used for 6G/12G
#define SDIRXPHY_PLDCTRL_PLD_CTRL_SW         0x3  // pld_ctrl_sw - used for HD/3G

// Value map 'PmaDw'
#define SDIRXPHY_PMADW_10                    0x2  // ten_bit - used for HD/3G
#define SDIRXPHY_PMADW_20                    0xF  // twenty_bit - used for 6G

// Value map 'ProtMode'
#define SDIRXPHY_PROTMODE_NON_TENG           0x0  // non_teng_mode - used for HD/3G/6G
#define SDIRXPHY_PROTMODE_TENG               0x1  // teng_mode - used for 12G

// Value map 'RateSwitch'
#define SDIRXPHY_RATESWITCH_Switched         0x0  // CDR Charge Pump Bandwidth has
                                                  // switched (to or from 12G)
#define SDIRXPHY_RATESWITCH_NotSwitched      0x1  // CDR Charge Pump Bandwidth has not
                                                  // changed

// Value map 'RdfifoClken'
#define SDIRXPHY_RDFIFOCLKEN_DISABLE         0x0  // rdfifo_clk_dis - used for HD/3G/6G
#define SDIRXPHY_RDFIFOCLKEN_ENABLE          0x1  // rdfifo_clk_en - used for 12G

// Value map 'RxBlkSel'
#define SDIRXPHY_RXBLKSEL_EIGHTG             0x0  // 8G - used for HD/3G/6G
#define SDIRXPHY_RXBLKSEL_TENG               0x1  // 10G - used for 12G

// Value map 'RxClkOut'
#define SDIRXPHY_RXCLKOUT_EIGHTG_CLK_OUT     0x0  // 8G Clock Out - used for HD/3G/6G
#define SDIRXPHY_RXCLKOUT_TENG_CLK_OUT       0x1  // 10G Clock Out - used for 12G

// Value map 'SdiRate'
#define SDIRXPHY_SDIMODE_SD                  0x0  // SDI mode is SD-SDI
#define SDIRXPHY_SDIMODE_HD                  0x1  // SDI mode is HD-SDI
#define SDIRXPHY_SDIMODE_3G                  0x2  // SDI mode is 3G-SDI
#define SDIRXPHY_SDIMODE_6G                  0x3  // SDI mode is 6G-SDI
#define SDIRXPHY_SDIMODE_12G                 0x4  // SDI mode is 12G-SDI

// Value map 'SdiSrcFactor'
#define SDIRXPHY_SDIMODE_BYPASS              0x0  // No up/down-sampling (x1)
#define SDIRXPHY_SDIMODE_x2                  0x1  // x2 up/down-sampling
#define SDIRXPHY_SDIMODE_x11                 0x2  // x11 up/down sampling
#define SDIRXPHY_SDIMODE_x4                  0x3  // x4 up/down-sampling
#define SDIRXPHY_SDIMODE_x8                  0x4  // x8 up/down sampling
#define SDIRXPHY_SDIMODE_x44                 0x5  // x44 up/down sampling

// Value map 'Stretch'
#define SDIRXPHY_STRETCH_0                   0x0  // zero_stage - used for HD/3G/6G
#define SDIRXPHY_STRETCH_2                   0x2  // two_stage - used for 12G

// Value map 'SwWrclkGate'
#define SDIRXPHY_SWWRCLKGATE_DISABLE         0x0  // dis_sw_pc_wrclk_gating - used for
                                                  // HD/3G/6G
#define SDIRXPHY_SWWRCLKGATE_ENABLE          0x1  // en_sw_pc_wrclk_gating - used for 12G

// Value map 'WaPd'
#define SDIRXPHY_WAPD_WA_PD_7                0x0  // wa_pd_7 - used for HD/3G/6G
#define SDIRXPHY_WAPD_WA_PD_10               0x2  // wa_pd_10 - used for 12G

// Value map 'WrfifoClken'
#define SDIRXPHY_WRFIFOCLKEN_DISABLE         0x0  // wrfifo_clk_dis - used for HD/3G/6G
#define SDIRXPHY_WRFIFOCLKEN_ENABLE          0x1  // wrifo_clk_en - used for 12G

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 SDIRXPHY_Config_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_Config_GET_DeviceFamily(UInt32 Config)
{
    return Config & 0xF;
}
static __inline UInt32 SDIRXPHY_Config_GET_MaxSdiRate(UInt32 Config)
{
    return (Config & 0x70) >> 4;
}

// Field READ functions
static __inline UInt32 SDIRXPHY_Config_READ_DeviceFamily(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4) & 0xF;
}
static __inline UInt32 SDIRXPHY_Config_READ_MaxSdiRate(DtBcSDIRXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0x70) >> 4;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 SDIRXPHY_Control_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field SET functions
static __inline UInt32 SDIRXPHY_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32 SDIRXPHY_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32 SDIRXPHY_Control_SET_RxClkReset(UInt32 Control, UInt32 RxClkReset)
{
    DT_ASSERT((RxClkReset & ~0x1) == 0);
    return (Control & ~0x8) | (RxClkReset << 3);
}
static __inline UInt32 SDIRXPHY_Control_SET_PllReset(UInt32 Control, UInt32 PllReset)
{
    DT_ASSERT((PllReset & ~0x1) == 0);
    return (Control & ~0x10) | (PllReset << 4);
}
static __inline UInt32 SDIRXPHY_Control_SET_LockMode(UInt32 Control, UInt32 LockMode)
{
    DT_ASSERT((LockMode & ~0x1) == 0);
    return (Control & ~0x20) | (LockMode << 5);
}
static __inline UInt32 SDIRXPHY_Control_SET_SrcFactor(UInt32 Control, UInt32 SrcFactor)
{
    DT_ASSERT((SrcFactor & ~0xF) == 0);
    return (Control & ~0x3C0) | (SrcFactor << 6);
}
static __inline UInt32 SDIRXPHY_Control_SET_SdiRate(UInt32 Control, UInt32 SdiRate)
{
    DT_ASSERT((SdiRate & ~0x7) == 0);
    return (Control & ~0x1C00) | (SdiRate << 10);
}
static __inline UInt32 SDIRXPHY_Control_SET_XcvrReset(UInt32 Control, UInt32 XcvrReset)
{
    DT_ASSERT((XcvrReset & ~0x1) == 0);
    return (Control & ~0x2000) | (XcvrReset << 13);
}

// Register WRITE function
static __inline void SDIRXPHY_Control_WRITE(DtBcSDIRXPHY* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x8, Control);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 SDIRXPHY_Status_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_Status_GET_ResetInProgress(UInt32 Status)
{
    return Status & 0x1;
}
static __inline UInt32 SDIRXPHY_Status_GET_LockedToRef(UInt32 Status)
{
    return (Status & 0x2) >> 1;
}
static __inline UInt32 SDIRXPHY_Status_GET_LockedToData(UInt32 Status)
{
    return (Status & 0x4) >> 2;
}
static __inline UInt32 SDIRXPHY_Status_GET_CarrierDetect(UInt32 Status)
{
    return (Status & 0x8) >> 3;
}
static __inline UInt32 SDIRXPHY_Status_GET_NumEdgesDetected(UInt32 Status)
{
    return (Status & 0x3FFFF00) >> 8;
}
static __inline UInt32 SDIRXPHY_Status_GET_CalBusy(UInt32 Status)
{
    return (Status & 0x4000000) >> 26;
}
static __inline UInt32 SDIRXPHY_Status_GET_WaitRequest(UInt32 Status)
{
    return (Status & 0x8000000) >> 27;
}
static __inline UInt32 SDIRXPHY_Status_GET_AccessTimedout(UInt32 Status)
{
    return (Status & 0x20000000) >> 29;
}

// Field READ functions
static __inline UInt32 SDIRXPHY_Status_READ_ResetInProgress(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x1;
}
static __inline UInt32 SDIRXPHY_Status_READ_LockedToRef(DtBcSDIRXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x2) >> 1;
}
static __inline UInt32 SDIRXPHY_Status_READ_LockedToData(DtBcSDIRXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x4) >> 2;
}
static __inline UInt32 SDIRXPHY_Status_READ_CarrierDetect(DtBcSDIRXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x8) >> 3;
}
static __inline UInt32 SDIRXPHY_Status_READ_NumEdgesDetected(DtBcSDIRXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x3FFFF00) >> 8;
}
static __inline UInt32 SDIRXPHY_Status_READ_CalBusy(DtBcSDIRXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x4000000) >> 26;
}
static __inline UInt32 SDIRXPHY_Status_READ_WaitRequest(DtBcSDIRXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x8000000) >> 27;
}
static __inline UInt32 SDIRXPHY_Status_READ_AccessTimedout(DtBcSDIRXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x20000000) >> 29;
}

// Field CLEAR function
static __inline void SDIRXPHY_Status_CLEAR_AccessTimedout(DtBcSDIRXPHY* pBc)
{
    UInt32  Status = DtBc_RegRead32((DtBc*)pBc, 0xC);
    DtBc_RegWrite32((DtBc*)pBc, 0xC, Status | 0x20000000);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'CdcFifoStatus' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_CdcFifoStatus_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_CdcFifoStatus_GET_Overflow(UInt32 CdcFifoStatus)
{
    return CdcFifoStatus & 0x1;
}
static __inline UInt32 SDIRXPHY_CdcFifoStatus_GET_Load(UInt32 CdcFifoStatus)
{
    return (CdcFifoStatus & 0xFF00) >> 8;
}

// Field READ functions
static __inline UInt32 SDIRXPHY_CdcFifoStatus_READ_Overflow(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10) & 0x1;
}
static __inline UInt32 SDIRXPHY_CdcFifoStatus_READ_Load(DtBcSDIRXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x10) & 0xFF00) >> 8;
}

// Field CLEAR function
static __inline void SDIRXPHY_CdcFifoStatus_CLEAR_Overflow(DtBcSDIRXPHY* pBc)
{
    UInt32  CdcFifoStatus = DtBc_RegRead32((DtBc*)pBc, 0x10);
    DtBc_RegWrite32((DtBc*)pBc, 0x10, CdcFifoStatus | 0x1);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'CdrPllSettings4' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings4_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x80);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings4_GET_Reserved0(UInt32 CdrPllSettings4)
{
    return CdrPllSettings4 & 0x3;
}
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings4_GET_LfResistorPd(UInt32 CdrPllSettings4)
{
    return (CdrPllSettings4 & 0xC) >> 2;
}
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings4_GET_Reserved1(UInt32 CdrPllSettings4)
{
    return (CdrPllSettings4 & 0xF0) >> 4;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings4_SET_Reserved0(UInt32 CdrPllSettings4, UInt32 Reserved0)
{
    DT_ASSERT((Reserved0 & ~0x3) == 0);
    return (CdrPllSettings4 & ~0x3) | Reserved0;
}
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings4_SET_LfResistorPd(UInt32 CdrPllSettings4, UInt32 LfResistorPd)
{
    DT_ASSERT((LfResistorPd & ~0x3) == 0);
    return (CdrPllSettings4 & ~0xC) | (LfResistorPd << 2);
}
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings4_SET_Reserved1(UInt32 CdrPllSettings4, UInt32 Reserved1)
{
    DT_ASSERT((Reserved1 & ~0xF) == 0);
    return (CdrPllSettings4 & ~0xF0) | (Reserved1 << 4);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_CdrPllSettings4_WRITE(DtBcSDIRXPHY* pBc, UInt32 CdrPllSettings4)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x80, CdrPllSettings4);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'CdrPllSettings9' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings9_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x84);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings9_GET_Reserved2(UInt32 CdrPllSettings9)
{
    return CdrPllSettings9 & 0x7;
}
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings9_GET_PdLCounter(UInt32 CdrPllSettings9)
{
    return (CdrPllSettings9 & 0x38) >> 3;
}
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings9_GET_Reserved3(UInt32 CdrPllSettings9)
{
    return (CdrPllSettings9 & 0xC0) >> 6;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings9_SET_Reserved2(UInt32 CdrPllSettings9, UInt32 Reserved2)
{
    DT_ASSERT((Reserved2 & ~0x7) == 0);
    return (CdrPllSettings9 & ~0x7) | Reserved2;
}
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings9_SET_PdLCounter(UInt32 CdrPllSettings9, UInt32 PdLCounter)
{
    DT_ASSERT((PdLCounter & ~0x7) == 0);
    return (CdrPllSettings9 & ~0x38) | (PdLCounter << 3);
}
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings9_SET_Reserved3(UInt32 CdrPllSettings9, UInt32 Reserved3)
{
    DT_ASSERT((Reserved3 & ~0x3) == 0);
    return (CdrPllSettings9 & ~0xC0) | (Reserved3 << 6);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_CdrPllSettings9_WRITE(DtBcSDIRXPHY* pBc, UInt32 CdrPllSettings9)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x84, CdrPllSettings9);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'PcsPmaSel' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_PcsPmaSel_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x88);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_PcsPmaSel_GET_PcsPmaBlockSel(UInt32 PcsPmaSel)
{
    return PcsPmaSel & 0x3;
}
static __inline UInt32 SDIRXPHY_C10A10_PcsPmaSel_GET_Reserved4(UInt32 PcsPmaSel)
{
    return (PcsPmaSel & 0xFC) >> 2;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_PcsPmaSel_SET_PcsPmaBlockSel(UInt32 PcsPmaSel, UInt32 PcsPmaBlockSel)
{
    DT_ASSERT((PcsPmaBlockSel & ~0x3) == 0);
    return (PcsPmaSel & ~0x3) | PcsPmaBlockSel;
}
static __inline UInt32 SDIRXPHY_C10A10_PcsPmaSel_SET_Reserved4(UInt32 PcsPmaSel, UInt32 Reserved4)
{
    DT_ASSERT((Reserved4 & ~0x3F) == 0);
    return (PcsPmaSel & ~0xFC) | (Reserved4 << 2);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_PcsPmaSel_WRITE(DtBcSDIRXPHY* pBc, UInt32 PcsPmaSel)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x88, PcsPmaSel);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'PcsRxBlockSel' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_PcsRxBlockSel_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8C);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_PcsRxBlockSel_GET_RxBlockSel(UInt32 PcsRxBlockSel)
{
    return PcsRxBlockSel & 0x3;
}
static __inline UInt32 SDIRXPHY_C10A10_PcsRxBlockSel_GET_Reserved5(UInt32 PcsRxBlockSel)
{
    return (PcsRxBlockSel & 0x3C) >> 2;
}
static __inline UInt32 SDIRXPHY_C10A10_PcsRxBlockSel_GET_RxClkOut(UInt32 PcsRxBlockSel)
{
    return (PcsRxBlockSel & 0xC0) >> 6;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_PcsRxBlockSel_SET_RxBlockSel(UInt32 PcsRxBlockSel, UInt32 RxBlockSel)
{
    DT_ASSERT((RxBlockSel & ~0x3) == 0);
    return (PcsRxBlockSel & ~0x3) | RxBlockSel;
}
static __inline UInt32 SDIRXPHY_C10A10_PcsRxBlockSel_SET_Reserved5(UInt32 PcsRxBlockSel, UInt32 Reserved5)
{
    DT_ASSERT((Reserved5 & ~0xF) == 0);
    return (PcsRxBlockSel & ~0x3C) | (Reserved5 << 2);
}
static __inline UInt32 SDIRXPHY_C10A10_PcsRxBlockSel_SET_RxClkOut(UInt32 PcsRxBlockSel, UInt32 RxClkOut)
{
    DT_ASSERT((RxClkOut & ~0x3) == 0);
    return (PcsRxBlockSel & ~0xC0) | (RxClkOut << 6);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_PcsRxBlockSel_WRITE(DtBcSDIRXPHY* pBc, UInt32 PcsRxBlockSel)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x8C, PcsRxBlockSel);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxPcs8G0' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G0_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x90);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G0_GET_Reserved6(UInt32 RxPcs8G0)
{
    return RxPcs8G0 & 0xF;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G0_GET_PmaDw(UInt32 RxPcs8G0)
{
    return (RxPcs8G0 & 0xF0) >> 4;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G0_SET_Reserved6(UInt32 RxPcs8G0, UInt32 Reserved6)
{
    DT_ASSERT((Reserved6 & ~0xF) == 0);
    return (RxPcs8G0 & ~0xF) | Reserved6;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G0_SET_PmaDw(UInt32 RxPcs8G0, UInt32 PmaDw)
{
    DT_ASSERT((PmaDw & ~0xF) == 0);
    return (RxPcs8G0 & ~0xF0) | (PmaDw << 4);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_RxPcs8G0_WRITE(DtBcSDIRXPHY* pBc, UInt32 RxPcs8G0)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x90, RxPcs8G0);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxPcs8G1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G1_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x94);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G1_GET_WaPd(UInt32 RxPcs8G1)
{
    return RxPcs8G1 & 0x7;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G1_GET_Reserved7(UInt32 RxPcs8G1)
{
    return (RxPcs8G1 & 0x8) >> 3;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G1_GET_WaPldControlled(UInt32 RxPcs8G1)
{
    return (RxPcs8G1 & 0xF0) >> 4;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G1_SET_WaPd(UInt32 RxPcs8G1, UInt32 WaPd)
{
    DT_ASSERT((WaPd & ~0x7) == 0);
    return (RxPcs8G1 & ~0x7) | WaPd;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G1_SET_Reserved7(UInt32 RxPcs8G1, UInt32 Reserved7)
{
    DT_ASSERT((Reserved7 & ~0x1) == 0);
    return (RxPcs8G1 & ~0x8) | (Reserved7 << 3);
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G1_SET_WaPldControlled(UInt32 RxPcs8G1, UInt32 WaPldControlled)
{
    DT_ASSERT((WaPldControlled & ~0xF) == 0);
    return (RxPcs8G1 & ~0xF0) | (WaPldControlled << 4);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_RxPcs8G1_WRITE(DtBcSDIRXPHY* pBc, UInt32 RxPcs8G1)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x94, RxPcs8G1);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxPcs8G2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G2_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x98);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G2_GET_Decoder8B10B(UInt32 RxPcs8G2)
{
    return RxPcs8G2 & 0x7;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G2_GET_Reserved8(UInt32 RxPcs8G2)
{
    return (RxPcs8G2 & 0xF8) >> 3;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G2_SET_Decoder8B10B(UInt32 RxPcs8G2, UInt32 Decoder8B10B)
{
    DT_ASSERT((Decoder8B10B & ~0x7) == 0);
    return (RxPcs8G2 & ~0x7) | Decoder8B10B;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G2_SET_Reserved8(UInt32 RxPcs8G2, UInt32 Reserved8)
{
    DT_ASSERT((Reserved8 & ~0x1F) == 0);
    return (RxPcs8G2 & ~0xF8) | (Reserved8 << 3);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_RxPcs8G2_WRITE(DtBcSDIRXPHY* pBc, UInt32 RxPcs8G2)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x98, RxPcs8G2);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxPcs8G3' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G3_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x9C);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G3_GET_Reserved9(UInt32 RxPcs8G3)
{
    return RxPcs8G3 & 0x1F;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G3_GET_ByteDeserializer(UInt32 RxPcs8G3)
{
    return (RxPcs8G3 & 0xE0) >> 5;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G3_SET_Reserved9(UInt32 RxPcs8G3, UInt32 Reserved9)
{
    DT_ASSERT((Reserved9 & ~0x1F) == 0);
    return (RxPcs8G3 & ~0x1F) | Reserved9;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G3_SET_ByteDeserializer(UInt32 RxPcs8G3, UInt32 ByteDeserializer)
{
    DT_ASSERT((ByteDeserializer & ~0x7) == 0);
    return (RxPcs8G3 & ~0xE0) | (ByteDeserializer << 5);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_RxPcs8G3_WRITE(DtBcSDIRXPHY* pBc, UInt32 RxPcs8G3)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x9C, RxPcs8G3);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxPcs8G4' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G4_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xA0);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G4_GET_Reserved10(UInt32 RxPcs8G4)
{
    return RxPcs8G4 & 0xF;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G4_GET_PhaseCompRdptr(UInt32 RxPcs8G4)
{
    return (RxPcs8G4 & 0x10) >> 4;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G4_GET_Reserved11(UInt32 RxPcs8G4)
{
    return (RxPcs8G4 & 0x20) >> 5;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G4_GET_WaDispErrFlag(UInt32 RxPcs8G4)
{
    return (RxPcs8G4 & 0x40) >> 6;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G4_GET_Reserved12(UInt32 RxPcs8G4)
{
    return (RxPcs8G4 & 0x80) >> 7;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G4_SET_Reserved10(UInt32 RxPcs8G4, UInt32 Reserved10)
{
    DT_ASSERT((Reserved10 & ~0xF) == 0);
    return (RxPcs8G4 & ~0xF) | Reserved10;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G4_SET_PhaseCompRdptr(UInt32 RxPcs8G4, UInt32 PhaseCompRdptr)
{
    DT_ASSERT((PhaseCompRdptr & ~0x1) == 0);
    return (RxPcs8G4 & ~0x10) | (PhaseCompRdptr << 4);
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G4_SET_Reserved11(UInt32 RxPcs8G4, UInt32 Reserved11)
{
    DT_ASSERT((Reserved11 & ~0x1) == 0);
    return (RxPcs8G4 & ~0x20) | (Reserved11 << 5);
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G4_SET_WaDispErrFlag(UInt32 RxPcs8G4, UInt32 WaDispErrFlag)
{
    DT_ASSERT((WaDispErrFlag & ~0x1) == 0);
    return (RxPcs8G4 & ~0x40) | (WaDispErrFlag << 6);
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G4_SET_Reserved12(UInt32 RxPcs8G4, UInt32 Reserved12)
{
    DT_ASSERT((Reserved12 & ~0x1) == 0);
    return (RxPcs8G4 & ~0x80) | (Reserved12 << 7);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_RxPcs8G4_WRITE(DtBcSDIRXPHY* pBc, UInt32 RxPcs8G4)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xA0, RxPcs8G4);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxPcs8G5' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G5_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xA4);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G5_GET_Reserved13(UInt32 RxPcs8G5)
{
    return RxPcs8G5 & 0xF;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G5_GET_WaBoundaryLockCtrl(UInt32 RxPcs8G5)
{
    return (RxPcs8G5 & 0x70) >> 4;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G5_GET_Reserved14(UInt32 RxPcs8G5)
{
    return (RxPcs8G5 & 0x80) >> 7;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G5_SET_Reserved13(UInt32 RxPcs8G5, UInt32 Reserved13)
{
    DT_ASSERT((Reserved13 & ~0xF) == 0);
    return (RxPcs8G5 & ~0xF) | Reserved13;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G5_SET_WaBoundaryLockCtrl(UInt32 RxPcs8G5, UInt32 WaBoundaryLockCtrl)
{
    DT_ASSERT((WaBoundaryLockCtrl & ~0x7) == 0);
    return (RxPcs8G5 & ~0x70) | (WaBoundaryLockCtrl << 4);
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G5_SET_Reserved14(UInt32 RxPcs8G5, UInt32 Reserved14)
{
    DT_ASSERT((Reserved14 & ~0x1) == 0);
    return (RxPcs8G5 & ~0x80) | (Reserved14 << 7);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_RxPcs8G5_WRITE(DtBcSDIRXPHY* pBc, UInt32 RxPcs8G5)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xA4, RxPcs8G5);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxPcs8G6' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G6_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xA8);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G6_GET_ClockGatePcRdclk(UInt32 RxPcs8G6)
{
    return RxPcs8G6 & 0x1;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G6_GET_ClockGateDwPcWrclk(UInt32 RxPcs8G6)
{
    return (RxPcs8G6 & 0x2) >> 1;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G6_GET_ClockGateSwPcWrclk(UInt32 RxPcs8G6)
{
    return (RxPcs8G6 & 0x4) >> 2;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G6_GET_Reserved15(UInt32 RxPcs8G6)
{
    return (RxPcs8G6 & 0xF8) >> 3;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G6_SET_ClockGatePcRdclk(UInt32 RxPcs8G6, UInt32 ClockGatePcRdclk)
{
    DT_ASSERT((ClockGatePcRdclk & ~0x1) == 0);
    return (RxPcs8G6 & ~0x1) | ClockGatePcRdclk;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G6_SET_ClockGateDwPcWrclk(UInt32 RxPcs8G6, UInt32 ClockGateDwPcWrclk)
{
    DT_ASSERT((ClockGateDwPcWrclk & ~0x1) == 0);
    return (RxPcs8G6 & ~0x2) | (ClockGateDwPcWrclk << 1);
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G6_SET_ClockGateSwPcWrclk(UInt32 RxPcs8G6, UInt32 ClockGateSwPcWrclk)
{
    DT_ASSERT((ClockGateSwPcWrclk & ~0x1) == 0);
    return (RxPcs8G6 & ~0x4) | (ClockGateSwPcWrclk << 2);
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G6_SET_Reserved15(UInt32 RxPcs8G6, UInt32 Reserved15)
{
    DT_ASSERT((Reserved15 & ~0x1F) == 0);
    return (RxPcs8G6 & ~0xF8) | (Reserved15 << 3);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_RxPcs8G6_WRITE(DtBcSDIRXPHY* pBc, UInt32 RxPcs8G6)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xA8, RxPcs8G6);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxPcs8G7' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G7_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xAC);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G7_GET_Reserved16(UInt32 RxPcs8G7)
{
    return RxPcs8G7 & 0x1F;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G7_GET_ClockGateDwWa(UInt32 RxPcs8G7)
{
    return (RxPcs8G7 & 0x20) >> 5;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G7_GET_ClockGateSwWa(UInt32 RxPcs8G7)
{
    return (RxPcs8G7 & 0x40) >> 6;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G7_GET_ClockGateBdsDec(UInt32 RxPcs8G7)
{
    return (RxPcs8G7 & 0x80) >> 7;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G7_SET_Reserved16(UInt32 RxPcs8G7, UInt32 Reserved16)
{
    DT_ASSERT((Reserved16 & ~0x1F) == 0);
    return (RxPcs8G7 & ~0x1F) | Reserved16;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G7_SET_ClockGateDwWa(UInt32 RxPcs8G7, UInt32 ClockGateDwWa)
{
    DT_ASSERT((ClockGateDwWa & ~0x1) == 0);
    return (RxPcs8G7 & ~0x20) | (ClockGateDwWa << 5);
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G7_SET_ClockGateSwWa(UInt32 RxPcs8G7, UInt32 ClockGateSwWa)
{
    DT_ASSERT((ClockGateSwWa & ~0x1) == 0);
    return (RxPcs8G7 & ~0x40) | (ClockGateSwWa << 6);
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs8G7_SET_ClockGateBdsDec(UInt32 RxPcs8G7, UInt32 ClockGateBdsDec)
{
    DT_ASSERT((ClockGateBdsDec & ~0x1) == 0);
    return (RxPcs8G7 & ~0x80) | (ClockGateBdsDec << 7);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_RxPcs8G7_WRITE(DtBcSDIRXPHY* pBc, UInt32 RxPcs8G7)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xAC, RxPcs8G7);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxPcs10G0' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G0_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xB0);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G0_GET_GbRxOdWidth(UInt32 RxPcs10G0)
{
    return RxPcs10G0 & 0x7;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G0_GET_GbRxIdWidth(UInt32 RxPcs10G0)
{
    return (RxPcs10G0 & 0x18) >> 3;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G0_GET_Reserved17(UInt32 RxPcs10G0)
{
    return (RxPcs10G0 & 0xE0) >> 5;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G0_SET_GbRxOdWidth(UInt32 RxPcs10G0, UInt32 GbRxOdWidth)
{
    DT_ASSERT((GbRxOdWidth & ~0x7) == 0);
    return (RxPcs10G0 & ~0x7) | GbRxOdWidth;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G0_SET_GbRxIdWidth(UInt32 RxPcs10G0, UInt32 GbRxIdWidth)
{
    DT_ASSERT((GbRxIdWidth & ~0x3) == 0);
    return (RxPcs10G0 & ~0x18) | (GbRxIdWidth << 3);
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G0_SET_Reserved17(UInt32 RxPcs10G0, UInt32 Reserved17)
{
    DT_ASSERT((Reserved17 & ~0x7) == 0);
    return (RxPcs10G0 & ~0xE0) | (Reserved17 << 5);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_RxPcs10G0_WRITE(DtBcSDIRXPHY* pBc, UInt32 RxPcs10G0)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xB0, RxPcs10G0);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxPcs10G1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G1_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xB4);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G1_GET_RdfifoClken(UInt32 RxPcs10G1)
{
    return RxPcs10G1 & 0x1;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G1_GET_WrfifoClken(UInt32 RxPcs10G1)
{
    return (RxPcs10G1 & 0x2) >> 1;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G1_GET_Reserved18(UInt32 RxPcs10G1)
{
    return (RxPcs10G1 & 0xFC) >> 2;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G1_SET_RdfifoClken(UInt32 RxPcs10G1, UInt32 RdfifoClken)
{
    DT_ASSERT((RdfifoClken & ~0x1) == 0);
    return (RxPcs10G1 & ~0x1) | RdfifoClken;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G1_SET_WrfifoClken(UInt32 RxPcs10G1, UInt32 WrfifoClken)
{
    DT_ASSERT((WrfifoClken & ~0x1) == 0);
    return (RxPcs10G1 & ~0x2) | (WrfifoClken << 1);
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G1_SET_Reserved18(UInt32 RxPcs10G1, UInt32 Reserved18)
{
    DT_ASSERT((Reserved18 & ~0x3F) == 0);
    return (RxPcs10G1 & ~0xFC) | (Reserved18 << 2);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_RxPcs10G1_WRITE(DtBcSDIRXPHY* pBc, UInt32 RxPcs10G1)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xB4, RxPcs10G1);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxPcs10G2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G2_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xB8);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G2_GET_Reserved19(UInt32 RxPcs10G2)
{
    return RxPcs10G2 & 0x7;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G2_GET_GbExpClken(UInt32 RxPcs10G2)
{
    return (RxPcs10G2 & 0x8) >> 3;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G2_GET_Reserved20(UInt32 RxPcs10G2)
{
    return (RxPcs10G2 & 0xF0) >> 4;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G2_SET_Reserved19(UInt32 RxPcs10G2, UInt32 Reserved19)
{
    DT_ASSERT((Reserved19 & ~0x7) == 0);
    return (RxPcs10G2 & ~0x7) | Reserved19;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G2_SET_GbExpClken(UInt32 RxPcs10G2, UInt32 GbExpClken)
{
    DT_ASSERT((GbExpClken & ~0x1) == 0);
    return (RxPcs10G2 & ~0x8) | (GbExpClken << 3);
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G2_SET_Reserved20(UInt32 RxPcs10G2, UInt32 Reserved20)
{
    DT_ASSERT((Reserved20 & ~0xF) == 0);
    return (RxPcs10G2 & ~0xF0) | (Reserved20 << 4);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_RxPcs10G2_WRITE(DtBcSDIRXPHY* pBc, UInt32 RxPcs10G2)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xB8, RxPcs10G2);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxPcs10G3' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G3_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xBC);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G3_GET_Reserved21(UInt32 RxPcs10G3)
{
    return RxPcs10G3 & 0x1;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G3_GET_StretchNumStages(UInt32 RxPcs10G3)
{
    return (RxPcs10G3 & 0x6) >> 1;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G3_GET_Reserved22(UInt32 RxPcs10G3)
{
    return (RxPcs10G3 & 0xF8) >> 3;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G3_SET_Reserved21(UInt32 RxPcs10G3, UInt32 Reserved21)
{
    DT_ASSERT((Reserved21 & ~0x1) == 0);
    return (RxPcs10G3 & ~0x1) | Reserved21;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G3_SET_StretchNumStages(UInt32 RxPcs10G3, UInt32 StretchNumStages)
{
    DT_ASSERT((StretchNumStages & ~0x3) == 0);
    return (RxPcs10G3 & ~0x6) | (StretchNumStages << 1);
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G3_SET_Reserved22(UInt32 RxPcs10G3, UInt32 Reserved22)
{
    DT_ASSERT((Reserved22 & ~0x1F) == 0);
    return (RxPcs10G3 & ~0xF8) | (Reserved22 << 3);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_RxPcs10G3_WRITE(DtBcSDIRXPHY* pBc, UInt32 RxPcs10G3)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xBC, RxPcs10G3);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxPcs10G4' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G4_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC0);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G4_GET_Reserved23(UInt32 RxPcs10G4)
{
    return RxPcs10G4 & 0x1F;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G4_GET_FifoStopRd(UInt32 RxPcs10G4)
{
    return (RxPcs10G4 & 0x20) >> 5;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G4_GET_Reserved24(UInt32 RxPcs10G4)
{
    return (RxPcs10G4 & 0x40) >> 6;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G4_GET_FifoDoubleRead(UInt32 RxPcs10G4)
{
    return (RxPcs10G4 & 0x80) >> 7;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G4_SET_Reserved23(UInt32 RxPcs10G4, UInt32 Reserved23)
{
    DT_ASSERT((Reserved23 & ~0x1F) == 0);
    return (RxPcs10G4 & ~0x1F) | Reserved23;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G4_SET_FifoStopRd(UInt32 RxPcs10G4, UInt32 FifoStopRd)
{
    DT_ASSERT((FifoStopRd & ~0x1) == 0);
    return (RxPcs10G4 & ~0x20) | (FifoStopRd << 5);
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G4_SET_Reserved24(UInt32 RxPcs10G4, UInt32 Reserved24)
{
    DT_ASSERT((Reserved24 & ~0x1) == 0);
    return (RxPcs10G4 & ~0x40) | (Reserved24 << 6);
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G4_SET_FifoDoubleRead(UInt32 RxPcs10G4, UInt32 FifoDoubleRead)
{
    DT_ASSERT((FifoDoubleRead & ~0x1) == 0);
    return (RxPcs10G4 & ~0x80) | (FifoDoubleRead << 7);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_RxPcs10G4_WRITE(DtBcSDIRXPHY* pBc, UInt32 RxPcs10G4)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xC0, RxPcs10G4);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxPcs10G5' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G5_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC4);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G5_GET_PhcompRdDel(UInt32 RxPcs10G5)
{
    return RxPcs10G5 & 0x7;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G5_GET_Reserved25(UInt32 RxPcs10G5)
{
    return (RxPcs10G5 & 0xF8) >> 3;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G5_SET_PhcompRdDel(UInt32 RxPcs10G5, UInt32 PhcompRdDel)
{
    DT_ASSERT((PhcompRdDel & ~0x7) == 0);
    return (RxPcs10G5 & ~0x7) | PhcompRdDel;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcs10G5_SET_Reserved25(UInt32 RxPcs10G5, UInt32 Reserved25)
{
    DT_ASSERT((Reserved25 & ~0x1F) == 0);
    return (RxPcs10G5 & ~0xF8) | (Reserved25 << 3);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_RxPcs10G5_WRITE(DtBcSDIRXPHY* pBc, UInt32 RxPcs10G5)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xC4, RxPcs10G5);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxPcsFifo' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_RxPcsFifo_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC8);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcsFifo_GET_ProtMode(UInt32 RxPcsFifo)
{
    return RxPcsFifo & 0x1;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcsFifo_GET_DoubleReadMode(UInt32 RxPcsFifo)
{
    return (RxPcsFifo & 0x2) >> 1;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcsFifo_GET_Reserved26(UInt32 RxPcsFifo)
{
    return (RxPcsFifo & 0xFC) >> 2;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_RxPcsFifo_SET_ProtMode(UInt32 RxPcsFifo, UInt32 ProtMode)
{
    DT_ASSERT((ProtMode & ~0x1) == 0);
    return (RxPcsFifo & ~0x1) | ProtMode;
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcsFifo_SET_DoubleReadMode(UInt32 RxPcsFifo, UInt32 DoubleReadMode)
{
    DT_ASSERT((DoubleReadMode & ~0x1) == 0);
    return (RxPcsFifo & ~0x2) | (DoubleReadMode << 1);
}
static __inline UInt32 SDIRXPHY_C10A10_RxPcsFifo_SET_Reserved26(UInt32 RxPcsFifo, UInt32 Reserved26)
{
    DT_ASSERT((Reserved26 & ~0x3F) == 0);
    return (RxPcsFifo & ~0xFC) | (Reserved26 << 2);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_RxPcsFifo_WRITE(DtBcSDIRXPHY* pBc, UInt32 RxPcsFifo)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xC8, RxPcsFifo);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'CdrPllSettings8' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings8_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xCC);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings8_GET_Reserved27(UInt32 CdrPllSettings8)
{
    return CdrPllSettings8 & 0x1F;
}
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings8_GET_ChgpmpCurrentUpPd(UInt32 CdrPllSettings8)
{
    return (CdrPllSettings8 & 0xE0) >> 5;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings8_SET_Reserved27(UInt32 CdrPllSettings8, UInt32 Reserved27)
{
    DT_ASSERT((Reserved27 & ~0x1F) == 0);
    return (CdrPllSettings8 & ~0x1F) | Reserved27;
}
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings8_SET_ChgpmpCurrentUpPd(UInt32 CdrPllSettings8, UInt32 ChgpmpCurrentUpPd)
{
    DT_ASSERT((ChgpmpCurrentUpPd & ~0x7) == 0);
    return (CdrPllSettings8 & ~0xE0) | (ChgpmpCurrentUpPd << 5);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_CdrPllSettings8_WRITE(DtBcSDIRXPHY* pBc, UInt32 CdrPllSettings8)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xCC, CdrPllSettings8);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'CdrPllSettings10' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings10_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xD0);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings10_GET_Reserved28(UInt32 CdrPllSettings10)
{
    return CdrPllSettings10 & 0x7;
}
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings10_GET_ChgpmpCurrentDnPd(UInt32 CdrPllSettings10)
{
    return (CdrPllSettings10 & 0x38) >> 3;
}
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings10_GET_Reserved29(UInt32 CdrPllSettings10)
{
    return (CdrPllSettings10 & 0xC0) >> 6;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings10_SET_Reserved28(UInt32 CdrPllSettings10, UInt32 Reserved28)
{
    DT_ASSERT((Reserved28 & ~0x7) == 0);
    return (CdrPllSettings10 & ~0x7) | Reserved28;
}
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings10_SET_ChgpmpCurrentDnPd(UInt32 CdrPllSettings10, UInt32 ChgpmpCurrentDnPd)
{
    DT_ASSERT((ChgpmpCurrentDnPd & ~0x7) == 0);
    return (CdrPllSettings10 & ~0x38) | (ChgpmpCurrentDnPd << 3);
}
static __inline UInt32 SDIRXPHY_C10A10_CdrPllSettings10_SET_Reserved29(UInt32 CdrPllSettings10, UInt32 Reserved29)
{
    DT_ASSERT((Reserved29 & ~0x3) == 0);
    return (CdrPllSettings10 & ~0xC0) | (Reserved29 << 6);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_CdrPllSettings10_WRITE(DtBcSDIRXPHY* pBc, UInt32 CdrPllSettings10)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xD0, CdrPllSettings10);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'PmaRxDeser' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_PmaRxDeser_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xD4);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_PmaRxDeser_GET_DeserFactor(UInt32 PmaRxDeser)
{
    return PmaRxDeser & 0xF;
}
static __inline UInt32 SDIRXPHY_C10A10_PmaRxDeser_GET_Reserved30(UInt32 PmaRxDeser)
{
    return (PmaRxDeser & 0xF0) >> 4;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_PmaRxDeser_SET_DeserFactor(UInt32 PmaRxDeser, UInt32 DeserFactor)
{
    DT_ASSERT((DeserFactor & ~0xF) == 0);
    return (PmaRxDeser & ~0xF) | DeserFactor;
}
static __inline UInt32 SDIRXPHY_C10A10_PmaRxDeser_SET_Reserved30(UInt32 PmaRxDeser, UInt32 Reserved30)
{
    DT_ASSERT((Reserved30 & ~0xF) == 0);
    return (PmaRxDeser & ~0xF0) | (Reserved30 << 4);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_PmaRxDeser_WRITE(DtBcSDIRXPHY* pBc, UInt32 PmaRxDeser)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xD4, PmaRxDeser);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'ArbitrationCtrl' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_ArbitrationCtrl_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xD8);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_ArbitrationCtrl_GET_ArbiterCtrlPma(UInt32 ArbitrationCtrl)
{
    return ArbitrationCtrl & 0x1;
}
static __inline UInt32 SDIRXPHY_C10A10_ArbitrationCtrl_GET_CalDonePma(UInt32 ArbitrationCtrl)
{
    return (ArbitrationCtrl & 0x2) >> 1;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_ArbitrationCtrl_SET_ArbiterCtrlPma(UInt32 ArbitrationCtrl, UInt32 ArbiterCtrlPma)
{
    DT_ASSERT((ArbiterCtrlPma & ~0x1) == 0);
    return (ArbitrationCtrl & ~0x1) | ArbiterCtrlPma;
}
static __inline UInt32 SDIRXPHY_C10A10_ArbitrationCtrl_SET_CalDonePma(UInt32 ArbitrationCtrl, UInt32 CalDonePma)
{
    DT_ASSERT((CalDonePma & ~0x1) == 0);
    return (ArbitrationCtrl & ~0x2) | (CalDonePma << 1);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_ArbitrationCtrl_WRITE(DtBcSDIRXPHY* pBc, UInt32 ArbitrationCtrl)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xD8, ArbitrationCtrl);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'CalEnable' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_CalEnable_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xDC);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_CalEnable_GET_Reserved32(UInt32 CalEnable)
{
    return CalEnable & 0x1;
}
static __inline UInt32 SDIRXPHY_C10A10_CalEnable_GET_RxCalEn(UInt32 CalEnable)
{
    return (CalEnable & 0x2) >> 1;
}
static __inline UInt32 SDIRXPHY_C10A10_CalEnable_GET_Reserved33(UInt32 CalEnable)
{
    return (CalEnable & 0x1C) >> 2;
}
static __inline UInt32 SDIRXPHY_C10A10_CalEnable_GET_TxCalEn(UInt32 CalEnable)
{
    return (CalEnable & 0x20) >> 5;
}
static __inline UInt32 SDIRXPHY_C10A10_CalEnable_GET_AdaptEn(UInt32 CalEnable)
{
    return (CalEnable & 0x40) >> 6;
}
static __inline UInt32 SDIRXPHY_C10A10_CalEnable_GET_Reserved34(UInt32 CalEnable)
{
    return (CalEnable & 0x80) >> 7;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_CalEnable_SET_Reserved32(UInt32 CalEnable, UInt32 Reserved32)
{
    DT_ASSERT((Reserved32 & ~0x1) == 0);
    return (CalEnable & ~0x1) | Reserved32;
}
static __inline UInt32 SDIRXPHY_C10A10_CalEnable_SET_RxCalEn(UInt32 CalEnable, UInt32 RxCalEn)
{
    DT_ASSERT((RxCalEn & ~0x1) == 0);
    return (CalEnable & ~0x2) | (RxCalEn << 1);
}
static __inline UInt32 SDIRXPHY_C10A10_CalEnable_SET_Reserved33(UInt32 CalEnable, UInt32 Reserved33)
{
    DT_ASSERT((Reserved33 & ~0x7) == 0);
    return (CalEnable & ~0x1C) | (Reserved33 << 2);
}
static __inline UInt32 SDIRXPHY_C10A10_CalEnable_SET_TxCalEn(UInt32 CalEnable, UInt32 TxCalEn)
{
    DT_ASSERT((TxCalEn & ~0x1) == 0);
    return (CalEnable & ~0x20) | (TxCalEn << 5);
}
static __inline UInt32 SDIRXPHY_C10A10_CalEnable_SET_AdaptEn(UInt32 CalEnable, UInt32 AdaptEn)
{
    DT_ASSERT((AdaptEn & ~0x1) == 0);
    return (CalEnable & ~0x40) | (AdaptEn << 6);
}
static __inline UInt32 SDIRXPHY_C10A10_CalEnable_SET_Reserved34(UInt32 CalEnable, UInt32 Reserved34)
{
    DT_ASSERT((Reserved34 & ~0x1) == 0);
    return (CalEnable & ~0x80) | (Reserved34 << 7);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_CalEnable_WRITE(DtBcSDIRXPHY* pBc, UInt32 CalEnable)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xDC, CalEnable);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'PmaSettings' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_PmaSettings_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xE0);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_PmaSettings_GET_Reserved35(UInt32 PmaSettings)
{
    return PmaSettings & 0x7F;
}
static __inline UInt32 SDIRXPHY_C10A10_PmaSettings_GET_RateSwitchFlag(UInt32 PmaSettings)
{
    return (PmaSettings & 0x80) >> 7;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_PmaSettings_SET_Reserved35(UInt32 PmaSettings, UInt32 Reserved35)
{
    DT_ASSERT((Reserved35 & ~0x7F) == 0);
    return (PmaSettings & ~0x7F) | Reserved35;
}
static __inline UInt32 SDIRXPHY_C10A10_PmaSettings_SET_RateSwitchFlag(UInt32 PmaSettings, UInt32 RateSwitchFlag)
{
    DT_ASSERT((RateSwitchFlag & ~0x1) == 0);
    return (PmaSettings & ~0x80) | (RateSwitchFlag << 7);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_PmaSettings_WRITE(DtBcSDIRXPHY* pBc, UInt32 PmaSettings)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xE0, PmaSettings);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'PmaEqSettings' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_PmaEqSettings_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xE4);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_PmaEqSettings_GET_Reserved36(UInt32 PmaEqSettings)
{
    return PmaEqSettings & 0xF;
}
static __inline UInt32 SDIRXPHY_C10A10_PmaEqSettings_GET_EqualizerBw(UInt32 PmaEqSettings)
{
    return (PmaEqSettings & 0x30) >> 4;
}
static __inline UInt32 SDIRXPHY_C10A10_PmaEqSettings_GET_Reserved37(UInt32 PmaEqSettings)
{
    return (PmaEqSettings & 0xC0) >> 6;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_PmaEqSettings_SET_Reserved36(UInt32 PmaEqSettings, UInt32 Reserved36)
{
    DT_ASSERT((Reserved36 & ~0xF) == 0);
    return (PmaEqSettings & ~0xF) | Reserved36;
}
static __inline UInt32 SDIRXPHY_C10A10_PmaEqSettings_SET_EqualizerBw(UInt32 PmaEqSettings, UInt32 EqualizerBw)
{
    DT_ASSERT((EqualizerBw & ~0x3) == 0);
    return (PmaEqSettings & ~0x30) | (EqualizerBw << 4);
}
static __inline UInt32 SDIRXPHY_C10A10_PmaEqSettings_SET_Reserved37(UInt32 PmaEqSettings, UInt32 Reserved37)
{
    DT_ASSERT((Reserved37 & ~0x3) == 0);
    return (PmaEqSettings & ~0xC0) | (Reserved37 << 6);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_PmaEqSettings_WRITE(DtBcSDIRXPHY* pBc, UInt32 PmaEqSettings)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xE4, PmaEqSettings);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Reserved38' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32 SDIRXPHY_C10A10_Reserved38_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xE8) & 0xFF;
}

// Field WRITE function
static __inline void SDIRXPHY_C10A10_Reserved38_WRITE(DtBcSDIRXPHY* pBc, UInt32 Reserved38)
{
    DT_ASSERT((Reserved38 & ~0xFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0xE8, Reserved38);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Reserved39' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32 SDIRXPHY_C10A10_Reserved39_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xEC) & 0xFF;
}

// Field WRITE function
static __inline void SDIRXPHY_C10A10_Reserved39_WRITE(DtBcSDIRXPHY* pBc, UInt32 Reserved39)
{
    DT_ASSERT((Reserved39 & ~0xFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0xEC, Reserved39);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Reserved40' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32 SDIRXPHY_C10A10_Reserved40_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xF0) & 0xFF;
}

// Field WRITE function
static __inline void SDIRXPHY_C10A10_Reserved40_WRITE(DtBcSDIRXPHY* pBc, UInt32 Reserved40)
{
    DT_ASSERT((Reserved40 & ~0xFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0xF0, Reserved40);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Reserved41' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32 SDIRXPHY_C10A10_Reserved41_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xF4) & 0xFF;
}

// Field WRITE function
static __inline void SDIRXPHY_C10A10_Reserved41_WRITE(DtBcSDIRXPHY* pBc, UInt32 Reserved41)
{
    DT_ASSERT((Reserved41 & ~0xFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0xF4, Reserved41);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'CalCapability' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 SDIRXPHY_C10A10_CalCapability_READ(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xF8);
}

// Field GET functions
static __inline UInt32 SDIRXPHY_C10A10_CalCapability_GET_TxCalBusy(UInt32 CalCapability)
{
    return CalCapability & 0x1;
}
static __inline UInt32 SDIRXPHY_C10A10_CalCapability_GET_RxCalBusy(UInt32 CalCapability)
{
    return (CalCapability & 0x2) >> 1;
}
static __inline UInt32 SDIRXPHY_C10A10_CalCapability_GET_AvMmBusy(UInt32 CalCapability)
{
    return (CalCapability & 0x4) >> 2;
}
static __inline UInt32 SDIRXPHY_C10A10_CalCapability_GET_TxCalBusyEn(UInt32 CalCapability)
{
    return (CalCapability & 0x10) >> 4;
}
static __inline UInt32 SDIRXPHY_C10A10_CalCapability_GET_RxCalBusyEn(UInt32 CalCapability)
{
    return (CalCapability & 0x20) >> 5;
}

// Field READ functions
static __inline UInt32 SDIRXPHY_C10A10_CalCapability_READ_TxCalBusy(DtBcSDIRXPHY* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xF8) & 0x1;
}
static __inline UInt32 SDIRXPHY_C10A10_CalCapability_READ_RxCalBusy(DtBcSDIRXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xF8) & 0x2) >> 1;
}
static __inline UInt32 SDIRXPHY_C10A10_CalCapability_READ_AvMmBusy(DtBcSDIRXPHY* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xF8) & 0x4) >> 2;
}

// Field SET functions
static __inline UInt32 SDIRXPHY_C10A10_CalCapability_SET_TxCalBusyEn(UInt32 CalCapability, UInt32 TxCalBusyEn)
{
    DT_ASSERT((TxCalBusyEn & ~0x1) == 0);
    return (CalCapability & ~0x10) | (TxCalBusyEn << 4);
}
static __inline UInt32 SDIRXPHY_C10A10_CalCapability_SET_RxCalBusyEn(UInt32 CalCapability, UInt32 RxCalBusyEn)
{
    DT_ASSERT((RxCalBusyEn & ~0x1) == 0);
    return (CalCapability & ~0x20) | (RxCalBusyEn << 5);
}

// Register WRITE function
static __inline void SDIRXPHY_C10A10_CalCapability_WRITE(DtBcSDIRXPHY* pBc, UInt32 CalCapability)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xF8, CalCapability);
}

