//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcIQMISC_RegAccess.h *#*#*#*#*#*#*#*# (C) 2021 DekTec
//
// Device driver - IqMiscProc v0 (IQMISC) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block IqMiscProc.
// These functions should solely be used by the block controller for IqMiscProc.
//
// 2021.07.01 14:30 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2020 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// IQMISC_Control_READ
// IQMISC_Control_SET_BlockEnable
// IQMISC_Control_SET_MuteI
// IQMISC_Control_SET_MuteQ
// IQMISC_Control_SET_OperationalMode
// IQMISC_Control_SET_SpecInv
// IQMISC_Control_SET_TestPattern
// IQMISC_Control_WRITE
// IQMISC_NoiseLevel_WRITE
// IQMISC_Offset_WRITE
// IQMISC_OutputLevel_WRITE

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'BlockEnable'
#define IQMISC_BLKENA_DISABLED   0x0  // Block is entirely disabled
#define IQMISC_BLKENA_ENABLED    0x1  // Block is enabled and processes data

// Value map 'OperationalMode'
#define IQMISC_OPMODE_IDLE       0x0  // Block is inactive
#define IQMISC_OPMODE_STANDBY    0x1  // Block is partially operational
#define IQMISC_OPMODE_RUN        0x2  // Block performs its normal function

// Value map 'TestPattern'
#define IQMISC_TESTPATT_NONE     0x0  // No test pattern
#define IQMISC_TESTPATT_NYQ      0x1  // Nyquist
#define IQMISC_TESTPATT_HALFNYQ  0x2  // Half Nyquist
#define IQMISC_TESTPATT_CW       0x3  // Constant value for I and Q
#define IQMISC_TESTPATT_CI       0x4  // Constant value for I
#define IQMISC_TESTPATT_CQ       0x5  // Constant value for Q

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IQMISC_Control_READ(DtBcIQMISC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field SET functions
static __inline UInt32 IQMISC_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32 IQMISC_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32 IQMISC_Control_SET_MuteI(UInt32 Control, UInt32 MuteI)
{
    DT_ASSERT((MuteI & ~0x1) == 0);
    return (Control & ~0x8) | (MuteI << 3);
}
static __inline UInt32 IQMISC_Control_SET_MuteQ(UInt32 Control, UInt32 MuteQ)
{
    DT_ASSERT((MuteQ & ~0x1) == 0);
    return (Control & ~0x10) | (MuteQ << 4);
}
static __inline UInt32 IQMISC_Control_SET_SpecInv(UInt32 Control, UInt32 SpecInv)
{
    DT_ASSERT((SpecInv & ~0x1) == 0);
    return (Control & ~0x20) | (SpecInv << 5);
}
static __inline UInt32 IQMISC_Control_SET_TestPattern(UInt32 Control, UInt32 TestPattern)
{
    DT_ASSERT((TestPattern & ~0x7) == 0);
    return (Control & ~0x1C0) | (TestPattern << 6);
}

// Register WRITE function
static __inline void IQMISC_Control_WRITE(DtBcIQMISC* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x4, Control);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'NoiseLevel' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void IQMISC_NoiseLevel_WRITE(DtBcIQMISC* pBc, UInt32 NoiseLevel)
{
    DT_ASSERT((NoiseLevel & ~0x3FFFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x8, NoiseLevel);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'OutputLevel' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void IQMISC_OutputLevel_WRITE(DtBcIQMISC* pBc, UInt32 OutputLevel)
{
    DT_ASSERT((OutputLevel & ~0x3FFFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0xC, OutputLevel);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Offset' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void IQMISC_Offset_WRITE(DtBcIQMISC* pBc, UInt32 Offset)
{
    DT_ASSERT((Offset & ~0xFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x10, Offset);
}

