//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcIQJESD_RegAccess.h *#*#*#*#*#*#*#*# (C) 2022 DekTec
//
// Device driver - IqJesdDacItf v0 (IQJESD) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block IqJesdDacItf.
// These functions should solely be used by the block controller for IqJesdDacItf.
//
// 2022.03.17 9:29 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND.

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2020 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN No EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'PllAccessTimedout' and 'XcvrAccessTimedout' from register 'Status':
//      UInt32  Reg_Status, PllAccessTimedout, XcvrAccessTimedout;
//      Reg_Status         = IQJESD_Status_READ(pBc);
//      PllAccessTimedout  = IQJESD_Status_GET_PllAccessTimedout(Reg_Status);
//      XcvrAccessTimedout = IQJESD_Status_GET_XcvrAccessTimedout(Reg_Status);
//
// 2. Single-function shorthand for reading field 'AvMmBusy' from register
//    'JesdPhy_Status2':
//      UInt32  AvMmBusy = IQJESD_JesdPhy_Status2_READ_AvMmBusy(pBc);
//
// Updating multiple fields in the same register:
//   UInt32  Reg_Pll_AvmmArbitration = IQJESD_Pll_AvmmArbitration_READ(pBc);
//   IQJESD_Pll_AvmmArbitration_SET_ArbiterCtrl(Reg_Pll_AvmmArbitration, 1);
//   IQJESD_Pll_AvmmArbitration_SET_CalDone(Reg_Pll_AvmmArbitration, 1);
//   IQJESD_Pll_AvmmArbitration_WRITE(pBc, Reg_Pll_AvmmArbitration);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// IQJESD_Control_READ
// IQJESD_Control_SET_BlockEnable
// IQJESD_Control_SET_OperationalMode
// IQJESD_Control_SET_PhyLinkReset
// IQJESD_Control_WRITE
// IQJESD_JesdPhy_AvmmArbitration_GET_ArbiterCtrl
// IQJESD_JesdPhy_AvmmArbitration_GET_CalDone
// IQJESD_JesdPhy_AvmmArbitration_READ
// IQJESD_JesdPhy_AvmmArbitration_SET_ArbiterCtrl
// IQJESD_JesdPhy_AvmmArbitration_SET_CalDone
// IQJESD_JesdPhy_AvmmArbitration_WRITE
// IQJESD_JesdPhy_Calibration_GET_AdaptEnable
// IQJESD_JesdPhy_Calibration_GET_TxCalEnable
// IQJESD_JesdPhy_Calibration_READ
// IQJESD_JesdPhy_Calibration_SET_AdaptEnable
// IQJESD_JesdPhy_Calibration_SET_TxCalEnable
// IQJESD_JesdPhy_Calibration_WRITE
// IQJESD_JesdPhy_Control_GET_OverrideTxAnalogReset
// IQJESD_JesdPhy_Control_GET_OverrideTxDigitalReset
// IQJESD_JesdPhy_Control_GET_TxAnalogReset
// IQJESD_JesdPhy_Control_GET_TxDigitalReset
// IQJESD_JesdPhy_Control_READ
// IQJESD_JesdPhy_Control_SET_OverrideTxAnalogReset
// IQJESD_JesdPhy_Control_SET_OverrideTxDigitalReset
// IQJESD_JesdPhy_Control_SET_TxAnalogReset
// IQJESD_JesdPhy_Control_SET_TxDigitalReset
// IQJESD_JesdPhy_Control_WRITE
// IQJESD_JesdPhy_Status2_GET_AvMmBusy
// IQJESD_JesdPhy_Status2_GET_TxCalBusy
// IQJESD_JesdPhy_Status2_READ
// IQJESD_JesdPhy_Status2_READ_AvMmBusy
// IQJESD_JesdPhy_Status2_READ_TxCalBusy
// IQJESD_JesdTx_SyncnSysrefCtrl_GET_CsrLinkReinit
// IQJESD_JesdTx_SyncnSysrefCtrl_GET_CsrSysrefAlwayson
// IQJESD_JesdTx_SyncnSysrefCtrl_GET_Reserved
// IQJESD_JesdTx_SyncnSysrefCtrl_READ
// IQJESD_JesdTx_SyncnSysrefCtrl_SET_CsrLinkReinit
// IQJESD_JesdTx_SyncnSysrefCtrl_SET_CsrSysrefAlwayson
// IQJESD_JesdTx_SyncnSysrefCtrl_SET_Reserved
// IQJESD_JesdTx_SyncnSysrefCtrl_WRITE
// IQJESD_Pll_AvmmArbitration_GET_ArbiterCtrl
// IQJESD_Pll_AvmmArbitration_GET_CalDone
// IQJESD_Pll_AvmmArbitration_READ
// IQJESD_Pll_AvmmArbitration_SET_ArbiterCtrl
// IQJESD_Pll_AvmmArbitration_SET_CalDone
// IQJESD_Pll_AvmmArbitration_WRITE
// IQJESD_Pll_Calibration_GET_Enable
// IQJESD_Pll_Calibration_READ
// IQJESD_Pll_Calibration_SET_Enable
// IQJESD_Pll_Calibration_WRITE
// IQJESD_Pll_Control_GET_OverridePllPowerdown
// IQJESD_Pll_Control_GET_PllPowerdown
// IQJESD_Pll_Control_READ
// IQJESD_Pll_Control_SET_OverridePllPowerdown
// IQJESD_Pll_Control_SET_PllPowerdown
// IQJESD_Pll_Control_WRITE
// IQJESD_Pll_Status_GET_AvMmBusy
// IQJESD_Pll_Status_GET_CalBusy
// IQJESD_Pll_Status_GET_Locked
// IQJESD_Pll_Status_READ
// IQJESD_Pll_Status_READ_AvMmBusy
// IQJESD_Pll_Status_READ_CalBusy
// IQJESD_Pll_Status_READ_Locked
// IQJESD_Status_CLEAR_PllAccessTimedout
// IQJESD_Status_CLEAR_PllLockLossLatched
// IQJESD_Status_CLEAR_XcvrAccessTimedout
// IQJESD_Status_GET_PllAccessTimedout
// IQJESD_Status_GET_PllLockLossLatched
// IQJESD_Status_GET_XcvrAccessTimedout
// IQJESD_Status_READ
// IQJESD_Status_READ_PllAccessTimedout
// IQJESD_Status_READ_PllLockLossLatched
// IQJESD_Status_READ_XcvrAccessTimedout

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'ArbitrationRequest'
#define IQJESD_ARBREQ_User       0x0  // Request control of the internal configuration bus
#define IQJESD_ARBREQ_PreSICE    0x1  // Pass back control to the PreSICE configuration
                                      // engine

// Value map 'BlockEnable'
#define IQJESD_BLKENA_DISABLED   0x0  // Block is entirely disabled
#define IQJESD_BLKENA_ENABLED    0x1  // Block is enabled and processes data

// Value map 'BusOwner'
#define IQJESD_BUSOWNER_User     0x0  // User has control of the internal configuration
                                      // bus
#define IQJESD_BUSOWNER_PreSICE  0x1  // PreSICE is controlling the internal
                                      // configuration bus

// Value map 'OperationalMode'
#define IQJESD_OPMODE_IDLE       0x0  // Block is inactive
#define IQJESD_OPMODE_STANDBY    0x1  // Block is partially operational
#define IQJESD_OPMODE_RUN        0x2  // Block performs its normal function

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IQJESD_Control_READ(DtBcIQJESD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field SET functions
static __inline UInt32 IQJESD_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32 IQJESD_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32 IQJESD_Control_SET_PhyLinkReset(UInt32 Control, UInt32 PhyLinkReset)
{
    DT_ASSERT((PhyLinkReset & ~0x1) == 0);
    return (Control & ~0x8) | (PhyLinkReset << 3);
}

// Register WRITE function
static __inline void IQJESD_Control_WRITE(DtBcIQJESD* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x8, Control);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IQJESD_Status_READ(DtBcIQJESD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC);
}

// Field GET functions
static __inline UInt32 IQJESD_Status_GET_PllAccessTimedout(UInt32 Status)
{
    return Status & 0x1;
}
static __inline UInt32 IQJESD_Status_GET_XcvrAccessTimedout(UInt32 Status)
{
    return (Status & 0x2) >> 1;
}
static __inline UInt32 IQJESD_Status_GET_PllLockLossLatched(UInt32 Status)
{
    return (Status & 0x4) >> 2;
}

// Field READ functions
static __inline UInt32 IQJESD_Status_READ_PllAccessTimedout(DtBcIQJESD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x1;
}
static __inline UInt32 IQJESD_Status_READ_XcvrAccessTimedout(DtBcIQJESD* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x2) >> 1;
}
static __inline UInt32 IQJESD_Status_READ_PllLockLossLatched(DtBcIQJESD* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x4) >> 2;
}

// Field CLEAR functions
static __inline void IQJESD_Status_CLEAR_PllAccessTimedout(DtBcIQJESD* pBc)
{
    UInt32  Status = DtBc_RegRead32((DtBc*)pBc, 0xC);
    DtBc_RegWrite32((DtBc*)pBc, 0xC, Status | 0x1);
}
static __inline void IQJESD_Status_CLEAR_XcvrAccessTimedout(DtBcIQJESD* pBc)
{
    UInt32  Status = DtBc_RegRead32((DtBc*)pBc, 0xC);
    DtBc_RegWrite32((DtBc*)pBc, 0xC, Status | 0x2);
}
static __inline void IQJESD_Status_CLEAR_PllLockLossLatched(DtBcIQJESD* pBc)
{
    UInt32  Status = DtBc_RegRead32((DtBc*)pBc, 0xC);
    DtBc_RegWrite32((DtBc*)pBc, 0xC, Status | 0x4);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Pll_AvmmArbitration' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IQJESD_Pll_AvmmArbitration_READ(DtBcIQJESD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x20);
}

// Field GET functions
static __inline UInt32 IQJESD_Pll_AvmmArbitration_GET_ArbiterCtrl(UInt32 Pll_AvmmArbitration)
{
    return Pll_AvmmArbitration & 0x1;
}
static __inline UInt32 IQJESD_Pll_AvmmArbitration_GET_CalDone(UInt32 Pll_AvmmArbitration)
{
    return (Pll_AvmmArbitration & 0x2) >> 1;
}

// Field SET functions
static __inline UInt32 IQJESD_Pll_AvmmArbitration_SET_ArbiterCtrl(UInt32 Pll_AvmmArbitration, UInt32 ArbiterCtrl)
{
    DT_ASSERT((ArbiterCtrl & ~0x1) == 0);
    return (Pll_AvmmArbitration & ~0x1) | ArbiterCtrl;
}
static __inline UInt32 IQJESD_Pll_AvmmArbitration_SET_CalDone(UInt32 Pll_AvmmArbitration, UInt32 CalDone)
{
    DT_ASSERT((CalDone & ~0x1) == 0);
    return (Pll_AvmmArbitration & ~0x2) | (CalDone << 1);
}

// Register WRITE function
static __inline void IQJESD_Pll_AvmmArbitration_WRITE(DtBcIQJESD* pBc, UInt32 Pll_AvmmArbitration)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x20, Pll_AvmmArbitration);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Pll_Calibration' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IQJESD_Pll_Calibration_READ(DtBcIQJESD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x24);
}

// Field GET function
static __inline UInt32 IQJESD_Pll_Calibration_GET_Enable(UInt32 Pll_Calibration)
{
    return Pll_Calibration & 0x1;
}

// Field SET function
static __inline UInt32 IQJESD_Pll_Calibration_SET_Enable(UInt32 Pll_Calibration, UInt32 Enable)
{
    DT_ASSERT((Enable & ~0x1) == 0);
    return (Pll_Calibration & ~0x1) | Enable;
}

// Register WRITE function
static __inline void IQJESD_Pll_Calibration_WRITE(DtBcIQJESD* pBc, UInt32 Pll_Calibration)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x24, Pll_Calibration);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Pll_Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IQJESD_Pll_Status_READ(DtBcIQJESD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x28);
}

// Field GET functions
static __inline UInt32 IQJESD_Pll_Status_GET_Locked(UInt32 Pll_Status)
{
    return Pll_Status & 0x1;
}
static __inline UInt32 IQJESD_Pll_Status_GET_CalBusy(UInt32 Pll_Status)
{
    return (Pll_Status & 0x2) >> 1;
}
static __inline UInt32 IQJESD_Pll_Status_GET_AvMmBusy(UInt32 Pll_Status)
{
    return (Pll_Status & 0x4) >> 2;
}

// Field READ functions
static __inline UInt32 IQJESD_Pll_Status_READ_Locked(DtBcIQJESD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x28) & 0x1;
}
static __inline UInt32 IQJESD_Pll_Status_READ_CalBusy(DtBcIQJESD* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x28) & 0x2) >> 1;
}
static __inline UInt32 IQJESD_Pll_Status_READ_AvMmBusy(DtBcIQJESD* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x28) & 0x4) >> 2;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Pll_Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IQJESD_Pll_Control_READ(DtBcIQJESD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x2C);
}

// Field GET functions
static __inline UInt32 IQJESD_Pll_Control_GET_PllPowerdown(UInt32 Pll_Control)
{
    return Pll_Control & 0x1;
}
static __inline UInt32 IQJESD_Pll_Control_GET_OverridePllPowerdown(UInt32 Pll_Control)
{
    return (Pll_Control & 0x2) >> 1;
}

// Field SET functions
static __inline UInt32 IQJESD_Pll_Control_SET_PllPowerdown(UInt32 Pll_Control, UInt32 PllPowerdown)
{
    DT_ASSERT((PllPowerdown & ~0x1) == 0);
    return (Pll_Control & ~0x1) | PllPowerdown;
}
static __inline UInt32 IQJESD_Pll_Control_SET_OverridePllPowerdown(UInt32 Pll_Control, UInt32 OverridePllPowerdown)
{
    DT_ASSERT((OverridePllPowerdown & ~0x1) == 0);
    return (Pll_Control & ~0x2) | (OverridePllPowerdown << 1);
}

// Register WRITE function
static __inline void IQJESD_Pll_Control_WRITE(DtBcIQJESD* pBc, UInt32 Pll_Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x2C, Pll_Control);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'JesdTx_SyncnSysrefCtrl' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IQJESD_JesdTx_SyncnSysrefCtrl_READ(DtBcIQJESD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x30);
}

// Field GET functions
static __inline UInt32 IQJESD_JesdTx_SyncnSysrefCtrl_GET_CsrLinkReinit(UInt32 JesdTx_SyncnSysrefCtrl)
{
    return JesdTx_SyncnSysrefCtrl & 0x1;
}
static __inline UInt32 IQJESD_JesdTx_SyncnSysrefCtrl_GET_CsrSysrefAlwayson(UInt32 JesdTx_SyncnSysrefCtrl)
{
    return (JesdTx_SyncnSysrefCtrl & 0x2) >> 1;
}
static __inline UInt32 IQJESD_JesdTx_SyncnSysrefCtrl_GET_Reserved(UInt32 JesdTx_SyncnSysrefCtrl)
{
    return (JesdTx_SyncnSysrefCtrl & 0xFFFFFFF8) >> 3;
}

// Field SET functions
static __inline UInt32 IQJESD_JesdTx_SyncnSysrefCtrl_SET_CsrLinkReinit(UInt32 JesdTx_SyncnSysrefCtrl, UInt32 CsrLinkReinit)
{
    DT_ASSERT((CsrLinkReinit & ~0x1) == 0);
    return (JesdTx_SyncnSysrefCtrl & ~0x1) | CsrLinkReinit;
}
static __inline UInt32 IQJESD_JesdTx_SyncnSysrefCtrl_SET_CsrSysrefAlwayson(UInt32 JesdTx_SyncnSysrefCtrl, UInt32 CsrSysrefAlwayson)
{
    DT_ASSERT((CsrSysrefAlwayson & ~0x1) == 0);
    return (JesdTx_SyncnSysrefCtrl & ~0x2) | (CsrSysrefAlwayson << 1);
}
static __inline UInt32 IQJESD_JesdTx_SyncnSysrefCtrl_SET_Reserved(UInt32 JesdTx_SyncnSysrefCtrl, UInt32 Reserved)
{
    DT_ASSERT((Reserved & ~0x1FFFFFFF) == 0);
    return (JesdTx_SyncnSysrefCtrl & ~0xFFFFFFF8) | (Reserved << 3);
}

// Register WRITE function
static __inline void IQJESD_JesdTx_SyncnSysrefCtrl_WRITE(DtBcIQJESD* pBc, UInt32 JesdTx_SyncnSysrefCtrl)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x30, JesdTx_SyncnSysrefCtrl);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'JesdPhy_AvmmArbitration' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IQJESD_JesdPhy_AvmmArbitration_READ(DtBcIQJESD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x40);
}

// Field GET functions
static __inline UInt32 IQJESD_JesdPhy_AvmmArbitration_GET_ArbiterCtrl(UInt32 JesdPhy_AvmmArbitration)
{
    return JesdPhy_AvmmArbitration & 0x1;
}
static __inline UInt32 IQJESD_JesdPhy_AvmmArbitration_GET_CalDone(UInt32 JesdPhy_AvmmArbitration)
{
    return (JesdPhy_AvmmArbitration & 0x2) >> 1;
}

// Field SET functions
static __inline UInt32 IQJESD_JesdPhy_AvmmArbitration_SET_ArbiterCtrl(UInt32 JesdPhy_AvmmArbitration, UInt32 ArbiterCtrl)
{
    DT_ASSERT((ArbiterCtrl & ~0x1) == 0);
    return (JesdPhy_AvmmArbitration & ~0x1) | ArbiterCtrl;
}
static __inline UInt32 IQJESD_JesdPhy_AvmmArbitration_SET_CalDone(UInt32 JesdPhy_AvmmArbitration, UInt32 CalDone)
{
    DT_ASSERT((CalDone & ~0x1) == 0);
    return (JesdPhy_AvmmArbitration & ~0x2) | (CalDone << 1);
}

// Register WRITE function
static __inline void IQJESD_JesdPhy_AvmmArbitration_WRITE(DtBcIQJESD* pBc, UInt32 JesdPhy_AvmmArbitration)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x40, JesdPhy_AvmmArbitration);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'JesdPhy_Calibration' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IQJESD_JesdPhy_Calibration_READ(DtBcIQJESD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x44);
}

// Field GET functions
static __inline UInt32 IQJESD_JesdPhy_Calibration_GET_TxCalEnable(UInt32 JesdPhy_Calibration)
{
    return (JesdPhy_Calibration & 0x20) >> 5;
}
static __inline UInt32 IQJESD_JesdPhy_Calibration_GET_AdaptEnable(UInt32 JesdPhy_Calibration)
{
    return (JesdPhy_Calibration & 0x40) >> 6;
}

// Field SET functions
static __inline UInt32 IQJESD_JesdPhy_Calibration_SET_TxCalEnable(UInt32 JesdPhy_Calibration, UInt32 TxCalEnable)
{
    DT_ASSERT((TxCalEnable & ~0x1) == 0);
    return (JesdPhy_Calibration & ~0x20) | (TxCalEnable << 5);
}
static __inline UInt32 IQJESD_JesdPhy_Calibration_SET_AdaptEnable(UInt32 JesdPhy_Calibration, UInt32 AdaptEnable)
{
    DT_ASSERT((AdaptEnable & ~0x1) == 0);
    return (JesdPhy_Calibration & ~0x40) | (AdaptEnable << 6);
}

// Register WRITE function
static __inline void IQJESD_JesdPhy_Calibration_WRITE(DtBcIQJESD* pBc, UInt32 JesdPhy_Calibration)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x44, JesdPhy_Calibration);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'JesdPhy_Status2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IQJESD_JesdPhy_Status2_READ(DtBcIQJESD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x48);
}

// Field GET functions
static __inline UInt32 IQJESD_JesdPhy_Status2_GET_TxCalBusy(UInt32 JesdPhy_Status2)
{
    return JesdPhy_Status2 & 0x1;
}
static __inline UInt32 IQJESD_JesdPhy_Status2_GET_AvMmBusy(UInt32 JesdPhy_Status2)
{
    return (JesdPhy_Status2 & 0x4) >> 2;
}

// Field READ functions
static __inline UInt32 IQJESD_JesdPhy_Status2_READ_TxCalBusy(DtBcIQJESD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x48) & 0x1;
}
static __inline UInt32 IQJESD_JesdPhy_Status2_READ_AvMmBusy(DtBcIQJESD* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x48) & 0x4) >> 2;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'JesdPhy_Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IQJESD_JesdPhy_Control_READ(DtBcIQJESD* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4C);
}

// Field GET functions
static __inline UInt32 IQJESD_JesdPhy_Control_GET_TxAnalogReset(UInt32 JesdPhy_Control)
{
    return (JesdPhy_Control & 0x4) >> 2;
}
static __inline UInt32 IQJESD_JesdPhy_Control_GET_TxDigitalReset(UInt32 JesdPhy_Control)
{
    return (JesdPhy_Control & 0x8) >> 3;
}
static __inline UInt32 IQJESD_JesdPhy_Control_GET_OverrideTxAnalogReset(UInt32 JesdPhy_Control)
{
    return (JesdPhy_Control & 0x40) >> 6;
}
static __inline UInt32 IQJESD_JesdPhy_Control_GET_OverrideTxDigitalReset(UInt32 JesdPhy_Control)
{
    return (JesdPhy_Control & 0x80) >> 7;
}

// Field SET functions
static __inline UInt32 IQJESD_JesdPhy_Control_SET_TxAnalogReset(UInt32 JesdPhy_Control, UInt32 TxAnalogReset)
{
    DT_ASSERT((TxAnalogReset & ~0x1) == 0);
    return (JesdPhy_Control & ~0x4) | (TxAnalogReset << 2);
}
static __inline UInt32 IQJESD_JesdPhy_Control_SET_TxDigitalReset(UInt32 JesdPhy_Control, UInt32 TxDigitalReset)
{
    DT_ASSERT((TxDigitalReset & ~0x1) == 0);
    return (JesdPhy_Control & ~0x8) | (TxDigitalReset << 3);
}
static __inline UInt32 IQJESD_JesdPhy_Control_SET_OverrideTxAnalogReset(UInt32 JesdPhy_Control, UInt32 OverrideTxAnalogReset)
{
    DT_ASSERT((OverrideTxAnalogReset & ~0x1) == 0);
    return (JesdPhy_Control & ~0x40) | (OverrideTxAnalogReset << 6);
}
static __inline UInt32 IQJESD_JesdPhy_Control_SET_OverrideTxDigitalReset(UInt32 JesdPhy_Control, UInt32 OverrideTxDigitalReset)
{
    DT_ASSERT((OverrideTxDigitalReset & ~0x1) == 0);
    return (JesdPhy_Control & ~0x80) | (OverrideTxDigitalReset << 7);
}

// Register WRITE function
static __inline void IQJESD_JesdPhy_Control_WRITE(DtBcIQJESD* pBc, UInt32 JesdPhy_Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x4C, JesdPhy_Control);
}

