// *#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcIQDOWNSRC.h *#*#*#*#*#*#*#*#*#* (C) 2022 DekTec
//
//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Copyright (C) 2018 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

#ifndef __DT_BC_IQDOWNSRC_H
#define __DT_BC_IQDOWNSRC_H

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Include files -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-
#include "DtBc.h"

// Name and short-name of the IqDownSrc block (must match block ID)
#define DT_BC_IQDOWNSRC_NAME        "IqDownsampler"
#define DT_BC_IQDOWNSRC_SHORTNAME   "IQDOWNSRC"

// MACRO: to init an block-controller-ID for the IQDOWNSRC-BC
#define DT_BC_IQDOWNSRC_INIT_ID(ID, ROLE, INSTANCE, UUID)                                \
do                                                                                       \
{                                                                                        \
    DT_BC_INIT_ID(ID, DT_BC_IQDOWNSRC_NAME, DT_BC_IQDOWNSRC_SHORTNAME, ROLE, INSTANCE,   \
                                                                                  UUID); \
}                                                                                        \
while (0)

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ DtBcIQDOWNSRC definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=


// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- DtBcIQDOWNSRC -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.
typedef  struct _DtBcIQDOWNSRC
{
    // NOTE: common block data must be the first members to allow casting to DtBc
    DT_BC_COMMON_DATA;

    // Cached settings
    Bool  m_BlockEnabled;
    Int  m_OperationalMode;
    Bool  m_Bypass;
    Int  m_SampleRateRatio;
}  DtBcIQDOWNSRC;

// -.-.-.-.-.-.-.-.-.-.-.-.-.- DtBcIQDOWNSRC public functions -.-.-.-.-.-.-.-.-.-.-.-.-.-.

void  DtBcIQDOWNSRC_Close(DtBc*);
DtBcIQDOWNSRC*  DtBcIQDOWNSRC_Open(Int  Address, DtCore*, DtPt*  pPt, 
                                             const char*  pRole, Int  Instance, Int  Uuid,
                                             Bool  CreateStub);
DtStatus DtBcIQDOWNSRC_GetOperationalMode(DtBcIQDOWNSRC* pBc, Int* pOpMode);
DtStatus DtBcIQDOWNSRC_GetConvRatePars(DtBcIQDOWNSRC*, Int*, UInt32*);
DtStatus DtBcIQDOWNSRC_SetOperationalMode(DtBcIQDOWNSRC* pBc, Int OpMode);
DtStatus DtBcIQDOWNSRC_SetConvRatePars(DtBcIQDOWNSRC*, Int, UInt32);

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
// +=+=+=+=+=+=+=+=+=+=+=+=+=+ DtIoStubBcIQDOWNSRC definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- DtIoStubBcIQDOWNSRC -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-
//  Io-control stub for an IQDOWNSRC Block
typedef struct _DtIoStubBcIQDOWNSRC
{
    // NOTE: common stub data must be the first members to allow casting to 
    // DtBcIoCtl
    DT_IOSTUB_BC_COMMON_DATA;
}  DtIoStubBcIQDOWNSRC;

// .-.-.-.-.-.-.-.-.-.-.-.- DtIoStubBcIQDOWNSRC public functions -.-.-.-.-.-.-.-.-.-.-.-.-
void  DtIoStubBcIQDOWNSRC_Close(DtIoStub*);
DtIoStubBcIQDOWNSRC*  DtIoStubBcIQDOWNSRC_Open(DtBc*);

#endif  // #ifndef __DT_BC_IQDOWNSRC_H
