//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcIPSECG_RegAccess.h *#*#*#*#*#*#*#*# (C) 2019 DekTec
//
// Device driver - IpSecurityGuard v1 (IPSECG) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block IpSecurityGuard.
// These functions should solely be used by the block controller for IpSecurityGuard.
//
// 2019.03.06 11:21 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'IsAlgoBusy' and 'IsSecurityOk' from register 'Status':
//      UInt32  Reg_Status, IsAlgoBusy, IsSecurityOk;
//      Reg_Status   = IPSECG_Status_READ(pBc);
//      IsAlgoBusy   = IPSECG_Status_GET_IsAlgoBusy(Reg_Status);
//      IsSecurityOk = IPSECG_Status_GET_IsSecurityOk(Reg_Status);
//
// 2. Single-function shorthand for reading field 'IsSecurityOk' from register 'Status':
//      UInt32  IsSecurityOk = IPSECG_Status_READ_IsSecurityOk(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// IPSECG_BoardId0_READ
// IPSECG_BoardId1_READ
// IPSECG_Challenge0_WRITE
// IPSECG_Challenge1_WRITE
// IPSECG_Challenge2_WRITE
// IPSECG_Control_READ
// IPSECG_Control_SET_Command
// IPSECG_Control_WRITE
// IPSECG_EncryptedStr_WRITE
// IPSECG_Response0_READ
// IPSECG_Response1_READ
// IPSECG_Response2_READ
// IPSECG_Status_GET_IsAlgoBusy
// IPSECG_Status_GET_IsSecurityOk
// IPSECG_Status_READ
// IPSECG_Status_READ_IsAlgoBusy
// IPSECG_Status_READ_IsSecurityOk

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'SecCommand'
#define IPSECG_CMD_NOP               0x0  // No operation
#define IPSECG_CMD_CheckBoardId      0x1  // Check board ID
#define IPSECG_CMD_EncryptChallenge  0x2  // Encrypt challenge

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  IPSECG_Control_READ(DtBcIPSECG* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field SET function
static __inline UInt32  IPSECG_Control_SET_Command(UInt32 Control, UInt32 Command)
{
    DT_ASSERT((Command & ~0x3) == 0);
    return (Control & ~0x3) | Command;
}

// Register WRITE function
static __inline void  IPSECG_Control_WRITE(DtBcIPSECG* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x4, Control);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  IPSECG_Status_READ(DtBcIPSECG* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field GET functions
static __inline UInt32  IPSECG_Status_GET_IsAlgoBusy(UInt32 Status)
{
    return Status & 0x1;
}
static __inline UInt32  IPSECG_Status_GET_IsSecurityOk(UInt32 Status)
{
    return (Status & 0x2) >> 1;
}

// Field READ functions
static __inline UInt32  IPSECG_Status_READ_IsAlgoBusy(DtBcIPSECG* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8) & 0x1;
}
static __inline UInt32  IPSECG_Status_READ_IsSecurityOk(DtBcIPSECG* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x8) & 0x2) >> 1;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'BoardId0' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  IPSECG_BoardId0_READ(DtBcIPSECG* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'BoardId1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  IPSECG_BoardId1_READ(DtBcIPSECG* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Challenge0' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void  IPSECG_Challenge0_WRITE(DtBcIPSECG* pBc, UInt32 Challenge0)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x14, Challenge0);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Challenge1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void  IPSECG_Challenge1_WRITE(DtBcIPSECG* pBc, UInt32 Challenge1)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x18, Challenge1);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Challenge2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void  IPSECG_Challenge2_WRITE(DtBcIPSECG* pBc, UInt32 Challenge2)
{
    DT_ASSERT((Challenge2 & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x1C, Challenge2);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Response0' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  IPSECG_Response0_READ(DtBcIPSECG* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x20);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Response1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  IPSECG_Response1_READ(DtBcIPSECG* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x24);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Response2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  IPSECG_Response2_READ(DtBcIPSECG* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x28) & 0xFFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EncryptedStr' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void  IPSECG_EncryptedStr_WRITE(DtBcIPSECG* pBc, UInt32 EncryptedStr)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x2C, EncryptedStr);
}

