//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcIPROUT_RegAccess.h *#*#*#*#*#*#*#*# (C) 2022 DekTec
//
// Device driver - IpRouter v0 (IPROUT) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block IpRouter.
// These functions should solely be used by the block controller for IpRouter.
//
// 2022.01.03 16:53 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND.

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2020 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN No EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// IPROUT_Control_READ
// IPROUT_Control_SET_Duplicate
// IPROUT_Control_SET_FilterEnable
// IPROUT_Control_SET_MatchDestIp
// IPROUT_Control_SET_MatchDestPort
// IPROUT_Control_SET_MatchSrcIp
// IPROUT_Control_SET_MatchSrcPort
// IPROUT_Control_SET_MatchVlan
// IPROUT_Control_WRITE
// IPROUT_DestIp_Indexed_WRITE_DestIp
// IPROUT_Port_Indexed_READ
// IPROUT_Port_Indexed_SET_DestPort
// IPROUT_Port_Indexed_SET_SrcPort
// IPROUT_Port_Indexed_WRITE
// IPROUT_SrcIp_Indexed_WRITE_SrcIp
// IPROUT_Vlan_READ
// IPROUT_Vlan_SET_Id1
// IPROUT_Vlan_SET_Id2
// IPROUT_Vlan_SET_Tpid1
// IPROUT_Vlan_SET_Tpid2
// IPROUT_Vlan_WRITE

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'IpMatch'
#define IPROUT_IPMATCH_IGNORE       0x0  // Ignore IP address for matching
#define IPROUT_IPMATCH_IPV4         0x1  // Match IP address as an IPv4 address
#define IPROUT_IPMATCH_IPV6         0x2  // Match IP address as an IPv6 address

// Value map 'TpidTypes'
#define IPROUT_TPID_V802_1Q         0x0  // TPID is 8100h (802.1Q-1998)
#define IPROUT_TPID_V802_1ad        0x1  // TPID is 88A8h (802.1ad/802.1Q-2011)

// Value map 'VlanMatch'
#define IPROUT_VLANMATCH_NONE       0x0  // Match when no VLAN is present
#define IPROUT_VLANMATCH_ONELEVEL   0x1  // Match one level of VLAN
#define IPROUT_VLANMATCH_TWOLEVELS  0x3  // Match two levels of VLAN

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IPROUT_Control_READ(DtBcIPROUT* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field SET functions
static __inline UInt32 IPROUT_Control_SET_FilterEnable(UInt32 Control, UInt32 FilterEnable)
{
    DT_ASSERT((FilterEnable & ~0x1) == 0);
    return (Control & ~0x10) | (FilterEnable << 4);
}
static __inline UInt32 IPROUT_Control_SET_MatchVlan(UInt32 Control, UInt32 MatchVlan)
{
    DT_ASSERT((MatchVlan & ~0x3) == 0);
    return (Control & ~0x300) | (MatchVlan << 8);
}
static __inline UInt32 IPROUT_Control_SET_MatchSrcIp(UInt32 Control, UInt32 MatchSrcIp)
{
    DT_ASSERT((MatchSrcIp & ~0x3) == 0);
    return (Control & ~0x3000) | (MatchSrcIp << 12);
}
static __inline UInt32 IPROUT_Control_SET_MatchDestIp(UInt32 Control, UInt32 MatchDestIp)
{
    DT_ASSERT((MatchDestIp & ~0x3) == 0);
    return (Control & ~0xC000) | (MatchDestIp << 14);
}
static __inline UInt32 IPROUT_Control_SET_MatchSrcPort(UInt32 Control, UInt32 MatchSrcPort)
{
    DT_ASSERT((MatchSrcPort & ~0x7) == 0);
    return (Control & ~0x70000) | (MatchSrcPort << 16);
}
static __inline UInt32 IPROUT_Control_SET_MatchDestPort(UInt32 Control, UInt32 MatchDestPort)
{
    DT_ASSERT((MatchDestPort & ~0x7) == 0);
    return (Control & ~0x700000) | (MatchDestPort << 20);
}
static __inline UInt32 IPROUT_Control_SET_Duplicate(UInt32 Control, UInt32 Duplicate)
{
    DT_ASSERT((Duplicate & ~0x1) == 0);
    return (Control & ~0x1000000) | (Duplicate << 24);
}

// Register WRITE function
static __inline void IPROUT_Control_WRITE(DtBcIPROUT* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x4, Control);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Vlan' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 IPROUT_Vlan_READ(DtBcIPROUT* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field SET functions
static __inline UInt32 IPROUT_Vlan_SET_Id1(UInt32 Vlan, UInt32 Id1)
{
    DT_ASSERT((Id1 & ~0xFFF) == 0);
    return (Vlan & ~0xFFF) | Id1;
}
static __inline UInt32 IPROUT_Vlan_SET_Tpid1(UInt32 Vlan, UInt32 Tpid1)
{
    DT_ASSERT((Tpid1 & ~0x1) == 0);
    return (Vlan & ~0x1000) | (Tpid1 << 12);
}
static __inline UInt32 IPROUT_Vlan_SET_Id2(UInt32 Vlan, UInt32 Id2)
{
    DT_ASSERT((Id2 & ~0xFFF) == 0);
    return (Vlan & ~0xFFF0000) | (Id2 << 16);
}
static __inline UInt32 IPROUT_Vlan_SET_Tpid2(UInt32 Vlan, UInt32 Tpid2)
{
    DT_ASSERT((Tpid2 & ~0x1) == 0);
    return (Vlan & ~0x10000000) | (Tpid2 << 28);
}

// Register WRITE function
static __inline void IPROUT_Vlan_WRITE(DtBcIPROUT* pBc, UInt32 Vlan)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x8, Vlan);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SrcIp_Indexed' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void IPROUT_SrcIp_Indexed_WRITE_SrcIp(DtBcIPROUT* pBc, UInt32 SrcIp, Int Idx)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xC+4*Idx, SrcIp);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'DestIp_Indexed' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void IPROUT_DestIp_Indexed_WRITE_DestIp(DtBcIPROUT* pBc, UInt32 DestIp, Int Idx)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1C+4*Idx, DestIp);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Port_Indexed' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 IPROUT_Port_Indexed_READ(DtBcIPROUT* pBc, Int Idx)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x2C+4*Idx);
}

// Field SET functions
static __inline UInt32 IPROUT_Port_Indexed_SET_SrcPort(UInt32 Port_Indexed, UInt32 SrcPort)
{
    DT_ASSERT((SrcPort & ~0xFFFF) == 0);
    return (Port_Indexed & ~0xFFFF) | SrcPort;
}
static __inline UInt32 IPROUT_Port_Indexed_SET_DestPort(UInt32 Port_Indexed, UInt32 DestPort)
{
    DT_ASSERT((DestPort & ~0xFFFF) == 0);
    return (Port_Indexed & ~0xFFFF0000) | (DestPort << 16);
}

// Register WRITE function
static __inline void IPROUT_Port_Indexed_WRITE(DtBcIPROUT* pBc, UInt32 Port_Indexed, Int Idx)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x2C+4*Idx, Port_Indexed);
}

