//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcGPSTIME_RegAccess.h *#*#*#*#*#*#*#* (C) 2021 DekTec
//
// Device driver - GpsTime v0 (GPSTIME) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block GpsTime.
// These functions should solely be used by the block controller for GpsTime.
//
// 2021.07.01 14:31 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2020 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'OnePpsErrCnt' and 'OnePpsValid' from register 'StatusOnePps':
//      UInt32  Reg_StatusOnePps, OnePpsErrCnt, OnePpsValid;
//      Reg_StatusOnePps = GPSTIME_StatusOnePps_READ(pBc);
//      OnePpsErrCnt     = GPSTIME_StatusOnePps_GET_OnePpsErrCnt(Reg_StatusOnePps);
//      OnePpsValid      = GPSTIME_StatusOnePps_GET_OnePpsValid(Reg_StatusOnePps);
//
// 2. Single-function shorthand for reading field 'TenMHzPeriodCnt' from register
//    'StatusTenMHz':
//      UInt32  TenMHzPeriodCnt = GPSTIME_StatusTenMHz_READ_TenMHzPeriodCnt(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// GPSTIME_ControlOnePps_READ
// GPSTIME_ControlOnePps_SET_HoldOffOnePps
// GPSTIME_ControlOnePps_WRITE
// GPSTIME_StatusOnePps_GET_OnePpsErrCnt
// GPSTIME_StatusOnePps_GET_OnePpsTrailingTime
// GPSTIME_StatusOnePps_GET_OnePpsValid
// GPSTIME_StatusOnePps_READ
// GPSTIME_StatusOnePps_READ_OnePpsErrCnt
// GPSTIME_StatusOnePps_READ_OnePpsTrailingTime
// GPSTIME_StatusOnePps_READ_OnePpsValid
// GPSTIME_StatusTenMHz_GET_TenMHzPeriodCnt
// GPSTIME_StatusTenMHz_READ
// GPSTIME_StatusTenMHz_READ_TenMHzPeriodCnt
// GPSTIME_Time_READ

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'StatusOnePps' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 GPSTIME_StatusOnePps_READ(DtBcGPSTIME* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field GET functions
static __inline UInt32 GPSTIME_StatusOnePps_GET_OnePpsErrCnt(UInt32 StatusOnePps)
{
    return StatusOnePps & 0xFFFF;
}
static __inline UInt32 GPSTIME_StatusOnePps_GET_OnePpsValid(UInt32 StatusOnePps)
{
    return (StatusOnePps & 0x10000) >> 16;
}
static __inline UInt32 GPSTIME_StatusOnePps_GET_OnePpsTrailingTime(UInt32 StatusOnePps)
{
    return (StatusOnePps & 0xF80000) >> 19;
}

// Field READ functions
static __inline UInt32 GPSTIME_StatusOnePps_READ_OnePpsErrCnt(DtBcGPSTIME* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4) & 0xFFFF;
}
static __inline UInt32 GPSTIME_StatusOnePps_READ_OnePpsValid(DtBcGPSTIME* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0x10000) >> 16;
}
static __inline UInt32 GPSTIME_StatusOnePps_READ_OnePpsTrailingTime(DtBcGPSTIME* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0xF80000) >> 19;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'StatusTenMHz' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 GPSTIME_StatusTenMHz_READ(DtBcGPSTIME* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field GET function
static __inline UInt32 GPSTIME_StatusTenMHz_GET_TenMHzPeriodCnt(UInt32 StatusTenMHz)
{
    return StatusTenMHz & 0xFFFF;
}

// Field READ function
static __inline UInt32 GPSTIME_StatusTenMHz_READ_TenMHzPeriodCnt(DtBcGPSTIME* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8) & 0xFFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Time' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32 GPSTIME_Time_READ(DtBcGPSTIME* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x3FFFFFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'ControlOnePps' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 GPSTIME_ControlOnePps_READ(DtBcGPSTIME* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10);
}

// Field SET function
static __inline UInt32 GPSTIME_ControlOnePps_SET_HoldOffOnePps(UInt32 ControlOnePps, UInt32 HoldOffOnePps)
{
    DT_ASSERT((HoldOffOnePps & ~0x1) == 0);
    return (ControlOnePps & ~0x1) | HoldOffOnePps;
}

// Register WRITE function
static __inline void GPSTIME_ControlOnePps_WRITE(DtBcGPSTIME* pBc, UInt32 ControlOnePps)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10, ControlOnePps);
}

