//*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcFPGATEMP_RegAccess.h *#*#*#*#*#*#*#* (C) 2019 DekTec
//
// Device driver - FpgaTemperature v0 (FPGATEMP) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block FpgaTemperature.
// These functions should solely be used by the block controller for FpgaTemperature.
//
// 2019.03.06 11:21 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'TempThresholdHigh' and 'TempThresholdLow' from register 'Config':
//      UInt32  Reg_Config, TempThresholdHigh, TempThresholdLow;
//      Reg_Config        = FPGATEMP_Config_READ(pBc);
//      TempThresholdHigh = FPGATEMP_Config_GET_TempThresholdHigh(Reg_Config);
//      TempThresholdLow  = FPGATEMP_Config_GET_TempThresholdLow(Reg_Config);
//
// 2. Single-function shorthand for reading field 'TempAlarm' from register 'Status':
//      UInt32  TempAlarm = FPGATEMP_Status_READ_TempAlarm(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// FPGATEMP_Config_GET_TempThresholdHigh
// FPGATEMP_Config_GET_TempThresholdLow
// FPGATEMP_Config_READ
// FPGATEMP_Config_READ_TempThresholdHigh
// FPGATEMP_Config_READ_TempThresholdLow
// FPGATEMP_Status_GET_TempAlarm
// FPGATEMP_Status_GET_Temperature
// FPGATEMP_Status_READ
// FPGATEMP_Status_READ_TempAlarm
// FPGATEMP_Status_READ_Temperature

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  FPGATEMP_Config_READ(DtBcFPGATEMP* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field GET functions
static __inline UInt32  FPGATEMP_Config_GET_TempThresholdHigh(UInt32 Config)
{
    return Config & 0xFF;
}
static __inline UInt32  FPGATEMP_Config_GET_TempThresholdLow(UInt32 Config)
{
    return (Config & 0xFF00) >> 8;
}

// Field READ functions
static __inline UInt32  FPGATEMP_Config_READ_TempThresholdHigh(DtBcFPGATEMP* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4) & 0xFF;
}
static __inline UInt32  FPGATEMP_Config_READ_TempThresholdLow(DtBcFPGATEMP* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0xFF00) >> 8;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  FPGATEMP_Status_READ(DtBcFPGATEMP* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field GET functions
static __inline UInt32  FPGATEMP_Status_GET_Temperature(UInt32 Status)
{
    return Status & 0xFF;
}
static __inline UInt32  FPGATEMP_Status_GET_TempAlarm(UInt32 Status)
{
    return (Status & 0x100) >> 8;
}

// Field READ functions
static __inline UInt32  FPGATEMP_Status_READ_Temperature(DtBcFPGATEMP* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8) & 0xFF;
}
static __inline UInt32  FPGATEMP_Status_READ_TempAlarm(DtBcFPGATEMP* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x8) & 0x100) >> 8;
}

