// *#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcEMAC25G_RegAccess.h *#*#*#*#*#*#*#*#*#*#*#*#*# 2025
//
// Device driver - EthMac25G v1 (EMAC25G) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block EthMac25G.
// These functions should solely be used by the block controller for EthMac25G.
//
// 2025.01.10 15:37:44 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND.

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2024 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN No EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//
// 1. Getting fields 'MacAccessTimedout' and 'TranscAccessTimedout' from register
//    'Status':
//      UInt32 Reg_Status, MacAccessTimedout, TranscAccessTimedout;
//      Reg_Status           = EMAC25G_Status_READ(Bc);
//      MacAccessTimedout    = EMAC25G_Status_GET_MacAccessTimedout(Reg_Status);
//      TranscAccessTimedout = EMAC25G_Status_GET_TranscAccessTimedout(Reg_Status);
//
// 2. Single-function shorthand for reading field 'ChAvmmBusy' from register
//    'EthTransc25GS10Shim_PhyReg481':
//      UInt32  ChAvmmBusy = EMAC25G_EthTransc25GS10Shim_PhyReg481_READ_ChAvmmBusy(Bc);
//
// Updating multiple fields in the same register:
//   UInt32  Reg_EthMac25GS10_PhyConfig = EMAC25G_EthMac25GS10_PhyConfig_READ(Bc);
//   EMAC25G_EthMac25GS10_PhyConfig_SET_EioSysRst(Reg_EthMac25GS10_PhyConfig, 1);
//   EMAC25G_EthMac25GS10_PhyConfig_SET_SoftTxpRst(Reg_EthMac25GS10_PhyConfig, 1);
//   EMAC25G_EthMac25GS10_PhyConfig_WRITE(Bc, Reg_EthMac25GS10_PhyConfig);
//
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

// +=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// EMAC25G_Configuration_GET_JumboSupport
// EMAC25G_Configuration_READ
// EMAC25G_Configuration_READ_JumboSupport
// EMAC25G_Control_READ
// EMAC25G_Control_SET_BlockEnable
// EMAC25G_Control_SET_ChannelReset
// EMAC25G_Control_SET_ClrRxDelCnt
// EMAC25G_Control_SET_CsrRst
// EMAC25G_Control_SET_FlushFifos
// EMAC25G_Control_SET_MaxDelay
// EMAC25G_Control_SET_OperationalMode
// EMAC25G_Control_SET_PromiscuousMode
// EMAC25G_Control_SET_RxRst
// EMAC25G_Control_SET_SpeedSel
// EMAC25G_Control_SET_TxRst
// EMAC25G_Control_WRITE
// EMAC25G_EthMac25GS10_PhyClk_GET_RxCdrPllLocked
// EMAC25G_EthMac25GS10_PhyClk_GET_TxMacPllLocked
// EMAC25G_EthMac25GS10_PhyClk_GET_TxPcsReady
// EMAC25G_EthMac25GS10_PhyClk_READ
// EMAC25G_EthMac25GS10_PhyClk_READ_RxCdrPllLocked
// EMAC25G_EthMac25GS10_PhyClk_READ_TxMacPllLocked
// EMAC25G_EthMac25GS10_PhyClk_READ_TxPcsReady
// EMAC25G_EthMac25GS10_PhyConfig_GET_EioSysRst
// EMAC25G_EthMac25GS10_PhyConfig_GET_SetDataLock
// EMAC25G_EthMac25GS10_PhyConfig_GET_SetRefLock
// EMAC25G_EthMac25GS10_PhyConfig_GET_SoftRxpRst
// EMAC25G_EthMac25GS10_PhyConfig_GET_SoftTxpRst
// EMAC25G_EthMac25GS10_PhyConfig_READ
// EMAC25G_EthMac25GS10_PhyConfig_SET_EioSysRst
// EMAC25G_EthMac25GS10_PhyConfig_SET_SetDataLock
// EMAC25G_EthMac25GS10_PhyConfig_SET_SetRefLock
// EMAC25G_EthMac25GS10_PhyConfig_SET_SoftRxpRst
// EMAC25G_EthMac25GS10_PhyConfig_SET_SoftTxpRst
// EMAC25G_EthMac25GS10_PhyConfig_WRITE
// EMAC25G_EthMac25GS10_PhyEioFlagSel_READ_PhyEioFlagSel
// EMAC25G_EthMac25GS10_PhyEioFlagSel_WRITE_PhyEioFlagSel
// EMAC25G_EthMac25GS10_PhyEioFlags_READ_PhyEioFlags
// EMAC25G_EthMac25GS10_PhyEioFlags_WRITE_PhyEioFlags
// EMAC25G_EthMac25GS10_PhyEioFreqLock_READ_PhyEioFreqLock
// EMAC25G_EthMac25GS10_PhyEioSloop_READ_PhyEioSloop
// EMAC25G_EthMac25GS10_PhyEioSloop_WRITE_PhyEioSloop
// EMAC25G_EthMac25GS10_PhyFrmErr_READ_PhyFrmErr
// EMAC25G_EthMac25GS10_PhyKhzRx_READ_PhyKhzRx
// EMAC25G_EthMac25GS10_PhyKhzTx_READ_PhyKhzTx
// EMAC25G_EthMac25GS10_PhyLaneDeskewed_GET_DeskChanged
// EMAC25G_EthMac25GS10_PhyLaneDeskewed_GET_Deskewed
// EMAC25G_EthMac25GS10_PhyLaneDeskewed_READ
// EMAC25G_EthMac25GS10_PhyLaneDeskewed_READ_DeskChanged
// EMAC25G_EthMac25GS10_PhyLaneDeskewed_READ_Deskewed
// EMAC25G_EthMac25GS10_PhyName0_READ_PhyName0
// EMAC25G_EthMac25GS10_PhyName1_READ_PhyName1
// EMAC25G_EthMac25GS10_PhyName2_READ_PhyName2
// EMAC25G_EthMac25GS10_PhyRevId_READ_PhyRevId
// EMAC25G_EthMac25GS10_PhyRxPcsAligned_GET_RxErrRate
// EMAC25G_EthMac25GS10_PhyRxPcsAligned_GET_RxPcsAligned
// EMAC25G_EthMac25GS10_PhyRxPcsAligned_READ
// EMAC25G_EthMac25GS10_PhyRxPcsAligned_READ_RxErrRate
// EMAC25G_EthMac25GS10_PhyRxPcsAligned_READ_RxPcsAligned
// EMAC25G_EthMac25GS10_PhySclrFrmErr_READ_PhySclrFrmErr
// EMAC25G_EthMac25GS10_PhySclrFrmErr_WRITE_PhySclrFrmErr
// EMAC25G_EthMac25GS10_PhyScratch_READ_PhyScratch
// EMAC25G_EthMac25GS10_PhyScratch_WRITE_PhyScratch
// EMAC25G_EthMac25GS10_PhyTlkitAccess_READ_PhyTlkitAccess
// EMAC25G_EthMac25GS10_PhyTlkitAccess_WRITE_PhyTlkitAccess
// EMAC25G_EthMac25GS10_PhyWordLock_READ_PhyWordLock
// EMAC25G_EthMac25GS10_PhyWordLock_WRITE_PhyWordLock
// EMAC25G_EthMac25GS10_RxMacControl_GET_PreChkEna
// EMAC25G_EthMac25GS10_RxMacControl_GET_VlanDetDis
// EMAC25G_EthMac25GS10_RxMacControl_READ
// EMAC25G_EthMac25GS10_RxMacControl_SET_PreChkEna
// EMAC25G_EthMac25GS10_RxMacControl_SET_VlanDetDis
// EMAC25G_EthMac25GS10_RxMacControl_WRITE
// EMAC25G_EthMac25GS10_RxMacCrcConfig_READ_RxMacCrcConfig
// EMAC25G_EthMac25GS10_RxMacCrcConfig_WRITE_RxMacCrcConfig
// EMAC25G_EthMac25GS10_RxMacLinkFault_GET_LocalFault
// EMAC25G_EthMac25GS10_RxMacLinkFault_GET_RemoteFault
// EMAC25G_EthMac25GS10_RxMacLinkFault_READ
// EMAC25G_EthMac25GS10_RxMacLinkFault_READ_LocalFault
// EMAC25G_EthMac25GS10_RxMacLinkFault_READ_RemoteFault
// EMAC25G_EthMac25GS10_RxMacMaxRxSize_READ_RxMacMaxRxSize
// EMAC25G_EthMac25GS10_RxMacMaxRxSize_WRITE_RxMacMaxRxSize
// EMAC25G_EthMac25GS10_RxMacName0_READ_RxMacName0
// EMAC25G_EthMac25GS10_RxMacName1_READ_RxMacName1
// EMAC25G_EthMac25GS10_RxMacName2_READ_RxMacName2
// EMAC25G_EthMac25GS10_RxMacRevId_READ_RxMacRevId
// EMAC25G_EthMac25GS10_RxMacScratch_READ_RxMacScratch
// EMAC25G_EthMac25GS10_RxPtpClkPeriod_GET_Nano
// EMAC25G_EthMac25GS10_RxPtpClkPeriod_GET_NanoFrac
// EMAC25G_EthMac25GS10_RxPtpClkPeriod_READ
// EMAC25G_EthMac25GS10_RxPtpClkPeriod_SET_Nano
// EMAC25G_EthMac25GS10_RxPtpClkPeriod_SET_NanoFrac
// EMAC25G_EthMac25GS10_RxPtpClkPeriod_WRITE
// EMAC25G_EthMac25GS10_RxPtpName0_READ_RxPtpName0
// EMAC25G_EthMac25GS10_RxPtpName1_READ_RxPtpName1
// EMAC25G_EthMac25GS10_RxPtpName2_READ_RxPtpName2
// EMAC25G_EthMac25GS10_RxPtpPmaLatency_GET_Nano
// EMAC25G_EthMac25GS10_RxPtpPmaLatency_GET_NanoFrac
// EMAC25G_EthMac25GS10_RxPtpPmaLatency_READ
// EMAC25G_EthMac25GS10_RxPtpPmaLatency_SET_Nano
// EMAC25G_EthMac25GS10_RxPtpPmaLatency_SET_NanoFrac
// EMAC25G_EthMac25GS10_RxPtpPmaLatency_WRITE
// EMAC25G_EthMac25GS10_RxPtpRevId_READ_RxPtpRevId
// EMAC25G_EthMac25GS10_RxPtpScratch_READ_RxPtpScratch
// EMAC25G_EthMac25GS10_RxStat1024To1518Hi_READ_RxStat1024To1518Hi
// EMAC25G_EthMac25GS10_RxStat1024To1518Lo_READ_RxStat1024To1518Lo
// EMAC25G_EthMac25GS10_RxStat128To255Hi_READ_RxStat128To255Hi
// EMAC25G_EthMac25GS10_RxStat128To255Lo_READ_RxStat128To255Lo
// EMAC25G_EthMac25GS10_RxStat1519ToMaxHi_READ_RxStat1519ToMaxHi
// EMAC25G_EthMac25GS10_RxStat1519ToMaxLo_READ_RxStat1519ToMaxLo
// EMAC25G_EthMac25GS10_RxStat256To511Hi_READ_RxStat256To511Hi
// EMAC25G_EthMac25GS10_RxStat256To511Lo_READ_RxStat256To511Lo
// EMAC25G_EthMac25GS10_RxStat512To1023Hi_READ_RxStat512To1023Hi
// EMAC25G_EthMac25GS10_RxStat512To1023Lo_READ_RxStat512To1023Lo
// EMAC25G_EthMac25GS10_RxStat64bHi_READ_RxStat64bHi
// EMAC25G_EthMac25GS10_RxStat64bLo_READ_RxStat64bLo
// EMAC25G_EthMac25GS10_RxStat65To127Hi_READ_RxStat65To127Hi
// EMAC25G_EthMac25GS10_RxStat65To127Lo_READ_RxStat65To127Lo
// EMAC25G_EthMac25GS10_RxStatBcastCtrlErrHi_READ_RxStatBcastCtrlErrHi
// EMAC25G_EthMac25GS10_RxStatBcastCtrlErrLo_READ_RxStatBcastCtrlErrLo
// EMAC25G_EthMac25GS10_RxStatBcastCtrlOkHi_READ_RxStatBcastCtrlOkHi
// EMAC25G_EthMac25GS10_RxStatBcastCtrlOkLo_READ_RxStatBcastCtrlOkLo
// EMAC25G_EthMac25GS10_RxStatBcastDataErrHi_READ_RxStatBcastDataErrHi
// EMAC25G_EthMac25GS10_RxStatBcastDataErrLo_READ_RxStatBcastDataErrLo
// EMAC25G_EthMac25GS10_RxStatBcastDataOkHi_READ_RxStatBcastDataOkHi
// EMAC25G_EthMac25GS10_RxStatBcastDataOkLo_READ_RxStatBcastDataOkLo
// EMAC25G_EthMac25GS10_RxStatConfig_GET_ParityErrClr
// EMAC25G_EthMac25GS10_RxStatConfig_GET_RxStatReset
// EMAC25G_EthMac25GS10_RxStatConfig_GET_ShadowReq
// EMAC25G_EthMac25GS10_RxStatConfig_READ
// EMAC25G_EthMac25GS10_RxStatConfig_SET_ParityErrClr
// EMAC25G_EthMac25GS10_RxStatConfig_SET_RxStatReset
// EMAC25G_EthMac25GS10_RxStatConfig_SET_ShadowReq
// EMAC25G_EthMac25GS10_RxStatConfig_WRITE
// EMAC25G_EthMac25GS10_RxStatCrcErrHi_READ_RxStatCrcErrHi
// EMAC25G_EthMac25GS10_RxStatCrcErrLo_READ_RxStatCrcErrLo
// EMAC25G_EthMac25GS10_RxStatFcsHi_READ_RxStatFcsHi
// EMAC25G_EthMac25GS10_RxStatFcsLo_READ_RxStatFcsLo
// EMAC25G_EthMac25GS10_RxStatFragmentsHi_READ_RxStatFragmentsHi
// EMAC25G_EthMac25GS10_RxStatFragmentsLo_READ_RxStatFragmentsLo
// EMAC25G_EthMac25GS10_RxStatFrmOctsOkHi_READ_RxStatFrmOctsOkHi
// EMAC25G_EthMac25GS10_RxStatFrmOctsOkLo_READ_RxStatFrmOctsOkLo
// EMAC25G_EthMac25GS10_RxStatJabbersHi_READ_RxStatJabbersHi
// EMAC25G_EthMac25GS10_RxStatJabbersLo_READ_RxStatJabbersLo
// EMAC25G_EthMac25GS10_RxStatMcastCtrlErrLo_READ_RxStatMcastCtrlErrLo
// EMAC25G_EthMac25GS10_RxStatMcastCtrlHi_READ_RxStatMcastCtrlHi
// EMAC25G_EthMac25GS10_RxStatMcastCtrlOkHi_READ_RxStatMcastCtrlOkHi
// EMAC25G_EthMac25GS10_RxStatMcastCtrlOkLo_READ_RxStatMcastCtrlOkLo
// EMAC25G_EthMac25GS10_RxStatMcastDataErrHi_READ_RxStatMcastDataErrHi
// EMAC25G_EthMac25GS10_RxStatMcastDataErrLo_READ_RxStatMcastDataErrLo
// EMAC25G_EthMac25GS10_RxStatMcastDataOkHi_READ_RxStatMcastDataOkHi
// EMAC25G_EthMac25GS10_RxStatMcastDataOkLo_READ_RxStatMcastDataOkLo
// EMAC25G_EthMac25GS10_RxStatOversizeHi_READ_RxStatOversizeHi
// EMAC25G_EthMac25GS10_RxStatOversizeLo_READ_RxStatOversizeLo
// EMAC25G_EthMac25GS10_RxStatPauseErrHi_READ_RxStatPauseErrHi
// EMAC25G_EthMac25GS10_RxStatPauseErrLo_READ_RxStatPauseErrLo
// EMAC25G_EthMac25GS10_RxStatPauseHi_READ_RxStatPauseHi
// EMAC25G_EthMac25GS10_RxStatPauseLo_READ_RxStatPauseLo
// EMAC25G_EthMac25GS10_RxStatPaylOctsOkHi_READ_RxStatPaylOctsOkHi
// EMAC25G_EthMac25GS10_RxStatPaylOctsOkLo_READ_RxStatPaylOctsOkLo
// EMAC25G_EthMac25GS10_RxStatRuntHi_READ_RxStatRuntHi
// EMAC25G_EthMac25GS10_RxStatRuntLo_READ_RxStatRuntLo
// EMAC25G_EthMac25GS10_RxStatStatus_GET_ParityErr
// EMAC25G_EthMac25GS10_RxStatStatus_GET_Paused
// EMAC25G_EthMac25GS10_RxStatStatus_READ
// EMAC25G_EthMac25GS10_RxStatStatus_READ_ParityErr
// EMAC25G_EthMac25GS10_RxStatStatus_READ_Paused
// EMAC25G_EthMac25GS10_RxStatUCastDataErrHi_READ_RxStatUCastDataErrHi
// EMAC25G_EthMac25GS10_RxStatUcastCtrlErrHi_READ_RxStatUcastCtrlErrHi
// EMAC25G_EthMac25GS10_RxStatUcastCtrlErrLo_READ_RxStatUcastCtrlErrLo
// EMAC25G_EthMac25GS10_RxStatUcastCtrlOkHi_READ_RxStatUcastCtrlOkHi
// EMAC25G_EthMac25GS10_RxStatUcastCtrlOkLo_READ_RxStatUcastCtrlOkLo
// EMAC25G_EthMac25GS10_RxStatUcastDataErrLo_READ_RxStatUcastDataErrLo
// EMAC25G_EthMac25GS10_RxStatUcastDataOkHi_READ_RxStatUcastDataOkHi
// EMAC25G_EthMac25GS10_RxStatUcastDataOkLo_READ_RxStatUcastDataOkLo
// EMAC25G_EthMac25GS10_TxMacControl_GET_VlanDetDis
// EMAC25G_EthMac25GS10_TxMacControl_READ
// EMAC25G_EthMac25GS10_TxMacControl_SET_VlanDetDis
// EMAC25G_EthMac25GS10_TxMacControl_WRITE
// EMAC25G_EthMac25GS10_TxMacLinkFault_GET_ForceRemFault
// EMAC25G_EthMac25GS10_TxMacLinkFault_GET_LFRepEna
// EMAC25G_EthMac25GS10_TxMacLinkFault_GET_RemFaultDis
// EMAC25G_EthMac25GS10_TxMacLinkFault_GET_UnidirEna
// EMAC25G_EthMac25GS10_TxMacLinkFault_READ
// EMAC25G_EthMac25GS10_TxMacLinkFault_SET_ForceRemFault
// EMAC25G_EthMac25GS10_TxMacLinkFault_SET_LFRepEna
// EMAC25G_EthMac25GS10_TxMacLinkFault_SET_RemFaultDis
// EMAC25G_EthMac25GS10_TxMacLinkFault_SET_UnidirEna
// EMAC25G_EthMac25GS10_TxMacLinkFault_WRITE
// EMAC25G_EthMac25GS10_TxMacMaxTxSize_READ_TxMacMaxTxSize
// EMAC25G_EthMac25GS10_TxMacMaxTxSize_WRITE_TxMacMaxTxSize
// EMAC25G_EthMac25GS10_TxMacName0_READ_TxMacName0
// EMAC25G_EthMac25GS10_TxMacName1_READ_TxMacName1
// EMAC25G_EthMac25GS10_TxMacName2_READ_TxMacName2
// EMAC25G_EthMac25GS10_TxMacRevId_READ_TxMacRevId
// EMAC25G_EthMac25GS10_TxMacScratch_READ_TxMacScratch
// EMAC25G_EthMac25GS10_TxPtpAsymDelay_GET_AdjOper
// EMAC25G_EthMac25GS10_TxPtpAsymDelay_GET_AsymAdj
// EMAC25G_EthMac25GS10_TxPtpAsymDelay_GET_AsymEna
// EMAC25G_EthMac25GS10_TxPtpAsymDelay_READ
// EMAC25G_EthMac25GS10_TxPtpAsymDelay_SET_AdjOper
// EMAC25G_EthMac25GS10_TxPtpAsymDelay_SET_AsymAdj
// EMAC25G_EthMac25GS10_TxPtpAsymDelay_SET_AsymEna
// EMAC25G_EthMac25GS10_TxPtpAsymDelay_WRITE
// EMAC25G_EthMac25GS10_TxPtpClkPeriod_GET_Nano
// EMAC25G_EthMac25GS10_TxPtpClkPeriod_GET_NanoFrac
// EMAC25G_EthMac25GS10_TxPtpClkPeriod_READ
// EMAC25G_EthMac25GS10_TxPtpClkPeriod_SET_Nano
// EMAC25G_EthMac25GS10_TxPtpClkPeriod_SET_NanoFrac
// EMAC25G_EthMac25GS10_TxPtpClkPeriod_WRITE
// EMAC25G_EthMac25GS10_TxPtpName0_READ_TxPtpName0
// EMAC25G_EthMac25GS10_TxPtpName1_READ_TxPtpName1
// EMAC25G_EthMac25GS10_TxPtpName2_READ_TxPtpName2
// EMAC25G_EthMac25GS10_TxPtpPmaLatency_GET_Nano
// EMAC25G_EthMac25GS10_TxPtpPmaLatency_GET_NanoFrac
// EMAC25G_EthMac25GS10_TxPtpPmaLatency_READ
// EMAC25G_EthMac25GS10_TxPtpPmaLatency_SET_Nano
// EMAC25G_EthMac25GS10_TxPtpPmaLatency_SET_NanoFrac
// EMAC25G_EthMac25GS10_TxPtpPmaLatency_WRITE
// EMAC25G_EthMac25GS10_TxPtpRevId_READ_TxPtpRevId
// EMAC25G_EthMac25GS10_TxPtpScratch_READ_TxPtpScratch
// EMAC25G_EthMac25GS10_TxStat1024To1518Hi_READ_TxStat1024To1518Hi
// EMAC25G_EthMac25GS10_TxStat1024To1518Lo_READ_TxStat1024To1518Lo
// EMAC25G_EthMac25GS10_TxStat128To255Hi_READ_TxStat128To255Hi
// EMAC25G_EthMac25GS10_TxStat128To255Lo_READ_TxStat128To255Lo
// EMAC25G_EthMac25GS10_TxStat1519ToMaxHi_READ_TxStat1519ToMaxHi
// EMAC25G_EthMac25GS10_TxStat1519ToMaxLo_READ_TxStat1519ToMaxLo
// EMAC25G_EthMac25GS10_TxStat256To511Hi_READ_TxStat256To511Hi
// EMAC25G_EthMac25GS10_TxStat256To511Lo_READ_TxStat256To511Lo
// EMAC25G_EthMac25GS10_TxStat512To1023Hi_READ_TxStat512To1023Hi
// EMAC25G_EthMac25GS10_TxStat512To1023Lo_READ_TxStat512To1023Lo
// EMAC25G_EthMac25GS10_TxStat64bHi_READ_TxStat64bHi
// EMAC25G_EthMac25GS10_TxStat64bLo_READ_TxStat64bLo
// EMAC25G_EthMac25GS10_TxStat65To127Hi_READ_TxStat65To127Hi
// EMAC25G_EthMac25GS10_TxStat65To127Lo_READ_TxStat65To127Lo
// EMAC25G_EthMac25GS10_TxStatBcastCtrlErrHi_READ_TxStatBcastCtrlErrHi
// EMAC25G_EthMac25GS10_TxStatBcastCtrlErrLo_READ_TxStatBcastCtrlErrLo
// EMAC25G_EthMac25GS10_TxStatBcastCtrlOkHi_READ_TxStatBcastCtrlOkHi
// EMAC25G_EthMac25GS10_TxStatBcastCtrlOkLo_READ_TxStatBcastCtrlOkLo
// EMAC25G_EthMac25GS10_TxStatBcastDataErrHi_READ_TxStatBcastDataErrHi
// EMAC25G_EthMac25GS10_TxStatBcastDataErrLo_READ_TxStatBcastDataErrLo
// EMAC25G_EthMac25GS10_TxStatBcastDataOkHi_READ_TxStatBcastDataOkHi
// EMAC25G_EthMac25GS10_TxStatBcastDataOkLo_READ_TxStatBcastDataOkLo
// EMAC25G_EthMac25GS10_TxStatConfig_GET_ParityErrClr
// EMAC25G_EthMac25GS10_TxStatConfig_GET_ShadowReq
// EMAC25G_EthMac25GS10_TxStatConfig_GET_TxStatReset
// EMAC25G_EthMac25GS10_TxStatConfig_READ
// EMAC25G_EthMac25GS10_TxStatConfig_SET_ParityErrClr
// EMAC25G_EthMac25GS10_TxStatConfig_SET_ShadowReq
// EMAC25G_EthMac25GS10_TxStatConfig_SET_TxStatReset
// EMAC25G_EthMac25GS10_TxStatConfig_WRITE
// EMAC25G_EthMac25GS10_TxStatCrcErrHi_READ_TxStatCrcErrHi
// EMAC25G_EthMac25GS10_TxStatCrcErrLo_READ_TxStatCrcErrLo
// EMAC25G_EthMac25GS10_TxStatFcsHi_READ_TxStatFcsHi
// EMAC25G_EthMac25GS10_TxStatFcsLo_READ_TxStatFcsLo
// EMAC25G_EthMac25GS10_TxStatFragmentsHi_READ_TxStatFragmentsHi
// EMAC25G_EthMac25GS10_TxStatFragmentsLo_READ_TxStatFragmentsLo
// EMAC25G_EthMac25GS10_TxStatFrmOctsOkHi_READ_TxStatFrmOctsOkHi
// EMAC25G_EthMac25GS10_TxStatFrmOctsOkLo_READ_TxStatFrmOctsOkLo
// EMAC25G_EthMac25GS10_TxStatJabbersHi_READ_TxStatJabbersHi
// EMAC25G_EthMac25GS10_TxStatJabbersLo_READ_TxStatJabbersLo
// EMAC25G_EthMac25GS10_TxStatMcastCtrlErrHi_READ_TxStatMcastCtrlErrHi
// EMAC25G_EthMac25GS10_TxStatMcastCtrlErrLo_READ_TxStatMcastCtrlErrLo
// EMAC25G_EthMac25GS10_TxStatMcastCtrlOkHi_READ_TxStatMcastCtrlOkHi
// EMAC25G_EthMac25GS10_TxStatMcastCtrlOkLo_READ_TxStatMcastCtrlOkLo
// EMAC25G_EthMac25GS10_TxStatMcastDataErrHi_READ_TxStatMcastDataErrHi
// EMAC25G_EthMac25GS10_TxStatMcastDataErrLo_READ_TxStatMcastDataErrLo
// EMAC25G_EthMac25GS10_TxStatMcastDataOkHi_READ_TxStatMcastDataOkHi
// EMAC25G_EthMac25GS10_TxStatMcastDataOkLo_READ_TxStatMcastDataOkLo
// EMAC25G_EthMac25GS10_TxStatOversizeHi_READ_TxStatOversizeHi
// EMAC25G_EthMac25GS10_TxStatOversizeLo_READ_TxStatOversizeLo
// EMAC25G_EthMac25GS10_TxStatPauseErrHi_READ_TxStatPauseErrHi
// EMAC25G_EthMac25GS10_TxStatPauseErrLo_READ_TxStatPauseErrLo
// EMAC25G_EthMac25GS10_TxStatPauseHi_READ_TxStatPauseHi
// EMAC25G_EthMac25GS10_TxStatPauseLo_READ_TxStatPauseLo
// EMAC25G_EthMac25GS10_TxStatPaylOctsOkHi_READ_TxStatPaylOctsOkHi
// EMAC25G_EthMac25GS10_TxStatPaylOctsOkLo_READ_TxStatPaylOctsOkLo
// EMAC25G_EthMac25GS10_TxStatRuntHi_READ_TxStatRuntHi
// EMAC25G_EthMac25GS10_TxStatRuntLo_READ_TxStatRuntLo
// EMAC25G_EthMac25GS10_TxStatStatus_GET_ParityErr
// EMAC25G_EthMac25GS10_TxStatStatus_GET_Paused
// EMAC25G_EthMac25GS10_TxStatStatus_READ
// EMAC25G_EthMac25GS10_TxStatStatus_READ_ParityErr
// EMAC25G_EthMac25GS10_TxStatStatus_READ_Paused
// EMAC25G_EthMac25GS10_TxStatUCastDataErrHi_READ_TxStatUCastDataErrHi
// EMAC25G_EthMac25GS10_TxStatUcastCtrlErrHi_READ_TxStatUcastCtrlErrHi
// EMAC25G_EthMac25GS10_TxStatUcastCtrlErrLo_READ_TxStatUcastCtrlErrLo
// EMAC25G_EthMac25GS10_TxStatUcastCtrlOkHi_READ_TxStatUcastCtrlOkHi
// EMAC25G_EthMac25GS10_TxStatUcastCtrlOkLo_READ_TxStatUcastCtrlOkLo
// EMAC25G_EthMac25GS10_TxStatUcastDataErrLo_READ_TxStatUcastDataErrLo
// EMAC25G_EthMac25GS10_TxStatUcastDataOkHi_READ_TxStatUcastDataOkHi
// EMAC25G_EthMac25GS10_TxStatUcastDataOkLo_READ_TxStatUcastDataOkLo
// EMAC25G_EthTransc25GS10Shim_PhyReg106_GET_PmaTxBufDccFinestepEnin
// EMAC25G_EthTransc25GS10Shim_PhyReg106_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg106_SET_PmaTxBufDccFinestepEnin
// EMAC25G_EthTransc25GS10Shim_PhyReg106_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg108_GET_PmaTxBufTermSel
// EMAC25G_EthTransc25GS10Shim_PhyReg108_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg108_SET_PmaTxBufTermSel
// EMAC25G_EthTransc25GS10Shim_PhyReg108_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg111_GET_X1ClockSourceSelect
// EMAC25G_EthTransc25GS10Shim_PhyReg111_GET_XnClockSourceSelect
// EMAC25G_EthTransc25GS10Shim_PhyReg111_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg111_SET_X1ClockSourceSelect
// EMAC25G_EthTransc25GS10Shim_PhyReg111_SET_XnClockSourceSelect
// EMAC25G_EthTransc25GS10Shim_PhyReg111_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg117_GET_Scratch0X1ClockSrc
// EMAC25G_EthTransc25GS10Shim_PhyReg117_GET_Scratch1X1ClockSrc
// EMAC25G_EthTransc25GS10Shim_PhyReg117_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg117_READ_Scratch0X1ClockSrc
// EMAC25G_EthTransc25GS10Shim_PhyReg117_READ_Scratch1X1ClockSrc
// EMAC25G_EthTransc25GS10Shim_PhyReg11A_GET_PmaRxBufCtleAcGain
// EMAC25G_EthTransc25GS10Shim_PhyReg11A_GET_PmaRxBufVgaDcGainLow
// EMAC25G_EthTransc25GS10Shim_PhyReg11A_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg11A_SET_PmaRxBufCtleAcGain
// EMAC25G_EthTransc25GS10Shim_PhyReg11A_SET_PmaRxBufVgaDcGainLow
// EMAC25G_EthTransc25GS10Shim_PhyReg11A_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg11C_GET_PmaRxBufCtleEqGainLow
// EMAC25G_EthTransc25GS10Shim_PhyReg11C_GET_PmaRxBufTermSel
// EMAC25G_EthTransc25GS10Shim_PhyReg11C_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg11C_SET_PmaRxBufCtleEqGainLow
// EMAC25G_EthTransc25GS10Shim_PhyReg11C_SET_PmaRxBufTermSel
// EMAC25G_EthTransc25GS10Shim_PhyReg11C_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg11D_GET_LoopbackMode5
// EMAC25G_EthTransc25GS10Shim_PhyReg11D_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg11D_SET_LoopbackMode5
// EMAC25G_EthTransc25GS10Shim_PhyReg11D_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg11E_GET_PmaRxBufCtleEqGainHigh
// EMAC25G_EthTransc25GS10Shim_PhyReg11E_GET_PmaRxBufVgaHalfbwEn
// EMAC25G_EthTransc25GS10Shim_PhyReg11E_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg11E_SET_PmaRxBufCtleEqGainHigh
// EMAC25G_EthTransc25GS10Shim_PhyReg11E_SET_PmaRxBufVgaHalfbwEn
// EMAC25G_EthTransc25GS10Shim_PhyReg11E_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg11F_GET_PmaRxBufEqBwSel
// EMAC25G_EthTransc25GS10Shim_PhyReg11F_GET_PmaRxBufRxLfeqEnable
// EMAC25G_EthTransc25GS10Shim_PhyReg11F_GET_PmaRxBufVgaDcGainHigh
// EMAC25G_EthTransc25GS10Shim_PhyReg11F_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg11F_SET_PmaRxBufEqBwSel
// EMAC25G_EthTransc25GS10Shim_PhyReg11F_SET_PmaRxBufRxLfeqEnable
// EMAC25G_EthTransc25GS10Shim_PhyReg11F_SET_PmaRxBufVgaDcGainHigh
// EMAC25G_EthTransc25GS10Shim_PhyReg11F_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg121_GET_PmaRxBufConstGmEn
// EMAC25G_EthTransc25GS10Shim_PhyReg121_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg121_SET_PmaRxBufConstGmEn
// EMAC25G_EthTransc25GS10Shim_PhyReg121_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg12D_GET_PmaRxDfeLatchXcoupleDisable
// EMAC25G_EthTransc25GS10Shim_PhyReg12D_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg12D_SET_PmaRxDfeLatchXcoupleDisable
// EMAC25G_EthTransc25GS10Shim_PhyReg12D_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg12E_GET_PmaRxBufCtleTiaIsel
// EMAC25G_EthTransc25GS10Shim_PhyReg12E_GET_PmaRxBufEqSel
// EMAC25G_EthTransc25GS10Shim_PhyReg12E_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg12E_SET_PmaRxBufCtleTiaIsel
// EMAC25G_EthTransc25GS10Shim_PhyReg12E_SET_PmaRxBufEqSel
// EMAC25G_EthTransc25GS10Shim_PhyReg12E_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg130_GET_PmaRxDfeTapsumBwSel
// EMAC25G_EthTransc25GS10Shim_PhyReg130_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg130_SET_PmaRxDfeTapsumBwSel
// EMAC25G_EthTransc25GS10Shim_PhyReg130_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg132_GET_CdrPllSetCdrVcoSpeedFix1
// EMAC25G_EthTransc25GS10Shim_PhyReg132_GET_LoopbackMode43
// EMAC25G_EthTransc25GS10Shim_PhyReg132_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg132_SET_CdrPllSetCdrVcoSpeedFix1
// EMAC25G_EthTransc25GS10Shim_PhyReg132_SET_LoopbackMode43
// EMAC25G_EthTransc25GS10Shim_PhyReg132_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg135_GET_CdrPllLfResistorPfd
// EMAC25G_EthTransc25GS10Shim_PhyReg135_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg135_SET_CdrPllLfResistorPfd
// EMAC25G_EthTransc25GS10Shim_PhyReg135_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg136_GET_CdrPllSetCdrVcoSpeedFix2
// EMAC25G_EthTransc25GS10Shim_PhyReg136_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg136_SET_CdrPllSetCdrVcoSpeedFix2
// EMAC25G_EthTransc25GS10Shim_PhyReg136_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg137_GET_CdrPllSetCdrVcoSpeed
// EMAC25G_EthTransc25GS10Shim_PhyReg137_GET_LoopbackMode2
// EMAC25G_EthTransc25GS10Shim_PhyReg137_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg137_SET_CdrPllSetCdrVcoSpeed
// EMAC25G_EthTransc25GS10Shim_PhyReg137_SET_LoopbackMode2
// EMAC25G_EthTransc25GS10Shim_PhyReg137_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg139_GET_CdrPllChgpmpCurrentPfd
// EMAC25G_EthTransc25GS10Shim_PhyReg139_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg139_SET_CdrPllChgpmpCurrentPfd
// EMAC25G_EthTransc25GS10Shim_PhyReg139_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg13A_GET_CdrPllPdLCounter
// EMAC25G_EthTransc25GS10Shim_PhyReg13A_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg13A_SET_CdrPllPdLCounter
// EMAC25G_EthTransc25GS10Shim_PhyReg13A_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg13B_GET_CdrPllMcntDiv
// EMAC25G_EthTransc25GS10Shim_PhyReg13B_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg13B_SET_CdrPllMcntDiv
// EMAC25G_EthTransc25GS10Shim_PhyReg13B_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg142_GET_LoopbackMode0
// EMAC25G_EthTransc25GS10Shim_PhyReg142_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg142_SET_LoopbackMode0
// EMAC25G_EthTransc25GS10Shim_PhyReg142_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg144_GET_LoopbackMode1
// EMAC25G_EthTransc25GS10Shim_PhyReg144_GET_PmaRxOdiMonitorBwSel1
// EMAC25G_EthTransc25GS10Shim_PhyReg144_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg144_SET_LoopbackMode1
// EMAC25G_EthTransc25GS10Shim_PhyReg144_SET_PmaRxOdiMonitorBwSel1
// EMAC25G_EthTransc25GS10Shim_PhyReg144_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg145_GET_PmaRxOdiMonitorBwSel2
// EMAC25G_EthTransc25GS10Shim_PhyReg145_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg145_SET_PmaRxOdiMonitorBwSel2
// EMAC25G_EthTransc25GS10Shim_PhyReg145_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg151_GET_PmaRxBufEqCdgenSel
// EMAC25G_EthTransc25GS10Shim_PhyReg151_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg151_SET_PmaRxBufEqCdgenSel
// EMAC25G_EthTransc25GS10Shim_PhyReg151_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg154_GET_PmaRxOdiVregVoltageSel
// EMAC25G_EthTransc25GS10Shim_PhyReg154_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg154_SET_PmaRxOdiVregVoltageSel
// EMAC25G_EthTransc25GS10Shim_PhyReg154_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg160_GET_PmaAdaptAdpAcCtleInitialValue
// EMAC25G_EthTransc25GS10Shim_PhyReg160_GET_PmaAdaptAdpDcCtleInitialValue
// EMAC25G_EthTransc25GS10Shim_PhyReg160_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg160_SET_PmaAdaptAdpAcCtleInitialValue
// EMAC25G_EthTransc25GS10Shim_PhyReg160_SET_PmaAdaptAdpDcCtleInitialValue
// EMAC25G_EthTransc25GS10Shim_PhyReg160_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg162_GET_PmaAdaptAdpDfeTap1InitialValue
// EMAC25G_EthTransc25GS10Shim_PhyReg162_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg162_SET_PmaAdaptAdpDfeTap1InitialValue
// EMAC25G_EthTransc25GS10Shim_PhyReg162_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg165_GET_PmaAdaptAdpDcCtleMode2H2Limit
// EMAC25G_EthTransc25GS10Shim_PhyReg165_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg165_SET_PmaAdaptAdpDcCtleMode2H2Limit
// EMAC25G_EthTransc25GS10Shim_PhyReg165_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg167_GET_PmaAdaptAdpVgaInitialValue
// EMAC25G_EthTransc25GS10Shim_PhyReg167_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg167_SET_PmaAdaptAdpVgaInitialValue
// EMAC25G_EthTransc25GS10Shim_PhyReg167_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg22E_GET_HssiAibcrTxAibDllStrAlignDyCtlsel
// EMAC25G_EthTransc25GS10Shim_PhyReg22E_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg22E_SET_HssiAibcrTxAibDllStrAlignDyCtlsel
// EMAC25G_EthTransc25GS10Shim_PhyReg22E_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg230_GET_HssiAibcrRxAibRxDccByp
// EMAC25G_EthTransc25GS10Shim_PhyReg230_GET_HssiAibcrRxDccEn
// EMAC25G_EthTransc25GS10Shim_PhyReg230_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg230_SET_HssiAibcrRxAibRxDccByp
// EMAC25G_EthTransc25GS10Shim_PhyReg230_SET_HssiAibcrRxDccEn
// EMAC25G_EthTransc25GS10Shim_PhyReg230_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg32C_GET_HssiAibndRxAibDllstrAlignDyCtlsel
// EMAC25G_EthTransc25GS10Shim_PhyReg32C_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg32C_SET_HssiAibndRxAibDllstrAlignDyCtlsel
// EMAC25G_EthTransc25GS10Shim_PhyReg32C_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg32E_GET_HssiAibndTxAibTxDccByp
// EMAC25G_EthTransc25GS10Shim_PhyReg32E_GET_HssiAibndTxDccEn
// EMAC25G_EthTransc25GS10Shim_PhyReg32E_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg32E_SET_HssiAibndTxAibTxDccByp
// EMAC25G_EthTransc25GS10Shim_PhyReg32E_SET_HssiAibndTxDccEn
// EMAC25G_EthTransc25GS10Shim_PhyReg32E_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg480_GET_ChRxIsLockedToData
// EMAC25G_EthTransc25GS10Shim_PhyReg480_GET_ChRxIsLockedToRef
// EMAC25G_EthTransc25GS10Shim_PhyReg480_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg480_READ_ChRxIsLockedToData
// EMAC25G_EthTransc25GS10Shim_PhyReg480_READ_ChRxIsLockedToRef
// EMAC25G_EthTransc25GS10Shim_PhyReg481_GET_ChAvmmBusy
// EMAC25G_EthTransc25GS10Shim_PhyReg481_GET_ChRxCalBusy
// EMAC25G_EthTransc25GS10Shim_PhyReg481_GET_ChRxCalBusyEnable
// EMAC25G_EthTransc25GS10Shim_PhyReg481_GET_ChTxCalBusy
// EMAC25G_EthTransc25GS10Shim_PhyReg481_GET_ChTxCalBusyEnable
// EMAC25G_EthTransc25GS10Shim_PhyReg481_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg481_READ_ChAvmmBusy
// EMAC25G_EthTransc25GS10Shim_PhyReg481_READ_ChRxCalBusy
// EMAC25G_EthTransc25GS10Shim_PhyReg481_READ_ChTxCalBusy
// EMAC25G_EthTransc25GS10Shim_PhyReg481_SET_ChRxCalBusyEnable
// EMAC25G_EthTransc25GS10Shim_PhyReg481_SET_ChTxCalBusyEnable
// EMAC25G_EthTransc25GS10Shim_PhyReg481_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg4E0_GET_ChOverrideSetRxLocktodata
// EMAC25G_EthTransc25GS10Shim_PhyReg4E0_GET_ChOverrideSetRxLocktoref
// EMAC25G_EthTransc25GS10Shim_PhyReg4E0_GET_ChSetRxLockTodata
// EMAC25G_EthTransc25GS10Shim_PhyReg4E0_GET_ChSetRxLockToref
// EMAC25G_EthTransc25GS10Shim_PhyReg4E0_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg4E0_SET_ChOverrideSetRxLocktodata
// EMAC25G_EthTransc25GS10Shim_PhyReg4E0_SET_ChOverrideSetRxLocktoref
// EMAC25G_EthTransc25GS10Shim_PhyReg4E0_SET_ChSetRxLockTodata
// EMAC25G_EthTransc25GS10Shim_PhyReg4E0_SET_ChSetRxLockToref
// EMAC25G_EthTransc25GS10Shim_PhyReg4E0_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg4E1_GET_ChRxSerialLpbken
// EMAC25G_EthTransc25GS10Shim_PhyReg4E1_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg4E1_SET_ChRxSerialLpbken
// EMAC25G_EthTransc25GS10Shim_PhyReg4E1_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_GET_OverrideRxAnalogreset
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_GET_OverrideRxDigitalreset
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_GET_OverrideTxAnalogreset
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_GET_OverrideTxDigitalreset
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_GET_RxAnalogreset
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_GET_RxDigitalreset
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_GET_TxAnalogreset
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_GET_TxDigitalreset
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_SET_OverrideRxAnalogreset
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_SET_OverrideRxDigitalreset
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_SET_OverrideTxAnalogreset
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_SET_OverrideTxDigitalreset
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_SET_RxAnalogreset
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_SET_RxDigitalreset
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_SET_TxAnalogreset
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_SET_TxDigitalreset
// EMAC25G_EthTransc25GS10Shim_PhyReg4E2_WRITE
// EMAC25G_EthTransc25GS10Shim_PhyReg542_GET_EnableBackgroundCal
// EMAC25G_EthTransc25GS10Shim_PhyReg542_READ
// EMAC25G_EthTransc25GS10Shim_PhyReg542_SET_EnableBackgroundCal
// EMAC25G_EthTransc25GS10Shim_PhyReg542_WRITE
// EMAC25G_EthTransc25GS10Shim_PmaArbitrationControl_GET_PcsArbiterCtrl
// EMAC25G_EthTransc25GS10Shim_PmaArbitrationControl_GET_PcsCalDone
// EMAC25G_EthTransc25GS10Shim_PmaArbitrationControl_READ
// EMAC25G_EthTransc25GS10Shim_PmaArbitrationControl_SET_PcsArbiterCtrl
// EMAC25G_EthTransc25GS10Shim_PmaArbitrationControl_SET_PcsCalDone
// EMAC25G_EthTransc25GS10Shim_PmaArbitrationControl_WRITE
// EMAC25G_EthTransc25GS10Shim_PmaCalibrationControl_GET_PmCr2TxRxUcRxCal
// EMAC25G_EthTransc25GS10Shim_PmaCalibrationControl_GET_PreReconfig
// EMAC25G_EthTransc25GS10Shim_PmaCalibrationControl_GET_UxTxCal
// EMAC25G_EthTransc25GS10Shim_PmaCalibrationControl_READ
// EMAC25G_EthTransc25GS10Shim_PmaCalibrationControl_SET_PmCr2TxRxUcRxCal
// EMAC25G_EthTransc25GS10Shim_PmaCalibrationControl_SET_PreReconfig
// EMAC25G_EthTransc25GS10Shim_PmaCalibrationControl_SET_UxTxCal
// EMAC25G_EthTransc25GS10Shim_PmaCalibrationControl_WRITE
// EMAC25G_RxDelCnt_READ
// EMAC25G_SchedStatClr_READ
// EMAC25G_SchedStatClr_SET_ClrTooEarlyCnt
// EMAC25G_SchedStatClr_SET_ClrTooLateCnt
// EMAC25G_SchedStatClr_WRITE
// EMAC25G_SchedStat_GET_PacketSending
// EMAC25G_SchedStat_GET_PacketWaiting
// EMAC25G_SchedStat_GET_TooEarlyCnt
// EMAC25G_SchedStat_GET_TooLateCnt
// EMAC25G_SchedStat_READ
// EMAC25G_SchedStat_READ_PacketSending
// EMAC25G_SchedStat_READ_PacketWaiting
// EMAC25G_SchedStat_READ_TooEarlyCnt
// EMAC25G_SchedStat_READ_TooLateCnt
// EMAC25G_SchedulingOffset_WRITE
// EMAC25G_SfpGpio_GET_Absent
// EMAC25G_SfpGpio_GET_RxLos
// EMAC25G_SfpGpio_GET_TxFault
// EMAC25G_SfpGpio_READ
// EMAC25G_SfpGpio_READ_Absent
// EMAC25G_SfpGpio_READ_RxLos
// EMAC25G_SfpGpio_READ_TxFault
// EMAC25G_SfpGpio_SET_Disable
// EMAC25G_SfpGpio_SET_RS
// EMAC25G_SfpGpio_WRITE
// EMAC25G_Status_CLEAR_LinkStatChanged
// EMAC25G_Status_CLEAR_MacAccessTimedout
// EMAC25G_Status_CLEAR_RxOverflow
// EMAC25G_Status_CLEAR_SfpAbsentChanged
// EMAC25G_Status_CLEAR_TranscAccessTimedout
// EMAC25G_Status_GET_LinkStat
// EMAC25G_Status_GET_LinkStatChanged
// EMAC25G_Status_GET_MacAccessTimedout
// EMAC25G_Status_GET_RxOverflow
// EMAC25G_Status_GET_RxPcsReady
// EMAC25G_Status_GET_SfpAbsentChanged
// EMAC25G_Status_GET_TranscAccessTimedout
// EMAC25G_Status_GET_TxLanesStable
// EMAC25G_Status_READ
// EMAC25G_Status_READ_LinkStat
// EMAC25G_Status_READ_LinkStatChanged
// EMAC25G_Status_READ_MacAccessTimedout
// EMAC25G_Status_READ_RxOverflow
// EMAC25G_Status_READ_RxPcsReady
// EMAC25G_Status_READ_SfpAbsentChanged
// EMAC25G_Status_READ_TranscAccessTimedout
// EMAC25G_Status_READ_TxLanesStable

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'AdpAcInitialValue'
#define EMAC25G_ADPACVALUE_ADP_AC_VALUE_0             0x0   // radp_ac_ctle_initial_value_12
                                                            // - used for 25G
#define EMAC25G_ADPACVALUE_ADP_AC_VALUE_1             0x1   // radp_ac_ctle_initial_value_xx
                                                            // - not used
#define EMAC25G_ADPACVALUE_ADP_AC_VALUE_2             0x2   // radp_ac_ctle_initial_value_yy
                                                            // - not used
#define EMAC25G_ADPACVALUE_ADP_AC_VALUE_3             0x3   // radp_ac_ctle_initial_value_8
                                                            // - used for 10G

// Value map 'AdpDcInitialValue'
#define EMAC25G_ADPDCVALUE_ADP_DC_VALUE_0             0x0   // radp_dc_ctle_initial_value_xx
                                                            // - not used
#define EMAC25G_ADPDCVALUE_ADP_DC_VALUE_1             0x1   // radp_dc_ctle_initial_value_yy
                                                            // - not used
#define EMAC25G_ADPDCVALUE_ADP_DC_VALUE_2             0x2   // radp_dc_ctle_initial_value_16
                                                            // - used for 10G
#define EMAC25G_ADPDCVALUE_ADP_DC_VALUE_3             0x3   // radp_dc_ctle_initial_value_32
                                                            // - used for 25G

// Value map 'AdpDfeTap1InitialValue'
#define EMAC25G_ADPDFETAP1VALUE_ADP_DFE_TAP1_VALUE_0  0x0   // radp_dfe_tap1_initial_value_0
                                                            // - used for 10G
#define EMAC25G_ADPDFETAP1VALUE_ADP_DFE_TAP1_VALUE_1  0x1   // radp_dfe_tap1_initial_value_xx
                                                            // - not used
#define EMAC25G_ADPDFETAP1VALUE_ADP_DFE_TAP1_VALUE_2  0x2   // radp_dfe_tap1_initial_value_16
                                                            // - used for 25G
#define EMAC25G_ADPDFETAP1VALUE_ADP_DFE_TAP1_VALUE_3  0x3   // radp_dfe_tap1_initial_value_yy
                                                            // - not used

// Value map 'AdpVgaInitialValue'
#define EMAC25G_ADPVGAVALUE_ADP_VGA_VALUE_0           0x0   // radp_vga_initial_value_xx
                                                            // - not used
#define EMAC25G_ADPVGAVALUE_ADP_VGA_VALUE_1           0x1   // radp_vga_initial_value_4 -
                                                            // used for 10G
#define EMAC25G_ADPVGAVALUE_ADP_VGA_VALUE_2           0x2   // radp_vga_initial_value_yy
                                                            // - not used
#define EMAC25G_ADPVGAVALUE_ADP_VGA_VALUE_3           0x3   // radp_vga_initial_value_16
                                                            // - used for 25G

// Value map 'ArbOwner'
#define EMAC25G_ARBOWNER_USER                         0x0   // User has control of the
                                                            // internal configuration bus
#define EMAC25G_ARBOWNER_PRESICE                      0x1   // PreSICE is controlling the
                                                            // internal configuration bus

// Value map 'ArbitrationRequest'
#define EMAC25G_ARBREQ_USER                           0x0   // Request control of the
                                                            // internal configuration bus
#define EMAC25G_ARBREQ_PRESICE                        0x1   // Pass back control to the
                                                            // PreSICE configuration
                                                            // engine

// Value map 'BgCalEnable'
#define EMAC25G_BGCALENABLE_DISABLE                   0x0   // Disable background
                                                            // calibration
#define EMAC25G_BGCALENABLE_ENABLE                    0x1   // Enable background
                                                            // calibration

// Value map 'BlockEnable'
#define EMAC25G_BLKENA_DISABLED                       0x0   // Block is entirely disabled
#define EMAC25G_BLKENA_ENABLED                        0x1   // Block is enabled and
                                                            // processes data

// Value map 'CalBusyEnable'
#define EMAC25G_CALBUSYENABLE_DISABLE                 0x0   // Busy output and register
                                                            // field never asserted
#define EMAC25G_CALBUSYENABLE_ENABLE                  0x1   // Busy output and register
                                                            // field enabled

// Value map 'CalBusyState'
#define EMAC25G_CALBUSYSTATE_IDLE                     0x0   // Calibration is done
#define EMAC25G_CALBUSYSTATE_BUSY                     0x1   // Calibration is in progress

// Value map 'CalEn'
#define EMAC25G_CALEN_CAL_OFF                         0x0   // Calibration enable off
#define EMAC25G_CALEN_CAL_ON                          0x1   // Calibration enable on

// Value map 'CgmEn'
#define EMAC25G_CGMEN_CGM_EN_0                        0x0   // cgm_en_0 - not used
#define EMAC25G_CGMEN_CGM_EN_1                        0x1   // cgm_en 1 - not used
#define EMAC25G_CGMEN_CGM_EN_2                        0x2   // cgm_en_2 - used for 25G
#define EMAC25G_CGMEN_CGM_EN_3                        0x3   // cgm_en_3 - used for 10G

// Value map 'ChgpmpPfd'
#define EMAC25G_CHGPMPPFD_CP_CURRENT_PFD_0            0x0   // cp_current_pfd_setting0 -
                                                            // not used
#define EMAC25G_CHGPMPPFD_CP_CURRENT_PFD_1            0x1   // cp_current_pfd_setting1 -
                                                            // used for 25G
#define EMAC25G_CHGPMPPFD_CP_CURRENT_PFD_2            0x2   // cp_current_pfd_setting2 -
                                                            // used for 10G
#define EMAC25G_CHGPMPPFD_CP_CURRENT_PFD_3            0x3   // cp_current_pfd_setting3 -
                                                            // not used
#define EMAC25G_CHGPMPPFD_CP_CURRENT_PFD_4            0x4   // cp_current_pfd_setting4 -
                                                            // not used
#define EMAC25G_CHGPMPPFD_CP_CURRENT_PFD_5            0x5   // cp_current_pfd_setting5 -
                                                            // not used
#define EMAC25G_CHGPMPPFD_CP_CURRENT_PFD_6            0x6   // cp_current_pfd_setting6 -
                                                            // not used
#define EMAC25G_CHGPMPPFD_CP_CURRENT_PFD_7            0x7   // cp_current_pfd_setting7 -
                                                            // not used

// Value map 'CtleAcGain'
#define EMAC25G_CTLEGAIN_CTLE_GAIN_0                  0x0   // CTLE AC Gain setting 0
                                                            // (-2dB) - not used
#define EMAC25G_CTLEGAIN_CTLE_GAIN_1                  0x1   // CTLE AC Gain setting 1 -
                                                            // not used
#define EMAC25G_CTLEGAIN_CTLE_GAIN_2                  0x2   // CTLE AC Gain setting 2 -
                                                            // not used
#define EMAC25G_CTLEGAIN_CTLE_GAIN_3                  0x3   // CTLE AC Gain setting 3 -
                                                            // not used
#define EMAC25G_CTLEGAIN_CTLE_GAIN_4                  0x4   // CTLE AC Gain setting 4 -
                                                            // used for 10G
#define EMAC25G_CTLEGAIN_CTLE_GAIN_5                  0x5   // CTLE AC Gain setting 5 -
                                                            // not used
#define EMAC25G_CTLEGAIN_CTLE_GAIN_6                  0x6   // CTLE AC Gain setting 6 -
                                                            // not used
#define EMAC25G_CTLEGAIN_CTLE_GAIN_7                  0x7   // CTLE AC Gain setting 7 -
                                                            // not used
#define EMAC25G_CTLEGAIN_CTLE_GAIN_8                  0x8   // CTLE AC Gain setting 8 -
                                                            // not used
#define EMAC25G_CTLEGAIN_CTLE_GAIN_9                  0x9   // CTLE AC Gain setting 9 -
                                                            // not used
#define EMAC25G_CTLEGAIN_CTLE_GAIN_10                 0xA   // CTLE AC Gain setting 10 -
                                                            // not used
#define EMAC25G_CTLEGAIN_CTLE_GAIN_11                 0xB   // CTLE AC Gain setting 11 -
                                                            // not used
#define EMAC25G_CTLEGAIN_CTLE_GAIN_12                 0xC   // CTLE AC Gain setting 12 -
                                                            // used for 25G
#define EMAC25G_CTLEGAIN_CTLE_GAIN_13                 0xD   // CTLE AC Gain setting 13 -
                                                            // not used
#define EMAC25G_CTLEGAIN_CTLE_GAIN_14                 0xE   // CTLE AC Gain setting 14 -
                                                            // not used
#define EMAC25G_CTLEGAIN_CTLE_GAIN_15                 0xF   // CTLE AC Gain setting 15
                                                            // (+10dB) - not used

// Value map 'CtleEqGainHigh'
#define EMAC25G_CTLEEQGAINHIGH_CTLE_EQ_GAIN_H_0       0x0   // CTLE EQ Gain setting 0-31
                                                            // - used for 25G
#define EMAC25G_CTLEEQGAINHIGH_CTLE_EQ_GAIN_H_32      0x1   // CTLE EQ Gain setting 32-47
                                                            // - used for 10G

// Value map 'CtleEqGainLow'
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQ_GAIN_L_0_32     0x0   // CTLE EQ Gain setting 0
                                                            // (0dB) or 32 - 0 used for
                                                            // 10G, 32 used for 25G
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQ_GAIN_L_1_33     0x1   // CTLE EQ Gain setting 1 or
                                                            // 33 - not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQ_GAIN_L_2_34     0x2   // CTLE EQ Gain setting 2 or
                                                            // 34 - not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQ_GAIN_L_3_35     0x3   // CTLE EQ Gain setting 3 or
                                                            // 35 - not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQ_GAIN_L_4_36     0x4   // CTLE EQ Gain setting 4 or
                                                            // 36 - not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQ_GAIN_L_5_37     0x5   // CTLE EQ Gain setting 5 or
                                                            // 37 - not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQ_GAIN_L_6_38     0x6   // CTLE EQ Gain setting 6 or
                                                            // 38 - not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQ_GAIN_L_7_39     0x7   // CTLE EQ Gain setting 7 or
                                                            // 39 - not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQ_GAIN_L_8_40     0x8   // CTLE EQ Gain setting 8 or
                                                            // 40 - not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQ_GAIN_L_9_41     0x9   // CTLE EQ Gain setting 9 or
                                                            // 41 - not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_10_42     0xA   // CTLE EQ Gain setting 10 or
                                                            // 42 - not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_11_43     0xB   // CTLE EQ Gain setting 11 or
                                                            // 43 - not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_12_44     0xC   // CTLE EQ Gain setting 12 or
                                                            // 44 - not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_13_45     0xD   // CTLE EQ Gain setting 13 or
                                                            // 45 - not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_14_46     0xE   // CTLE EQ Gain setting 14 or
                                                            // 46 - not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_15_47     0xF   // CTLE EQ Gain setting 15 or
                                                            // 47 - not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_16        0x10  // CTLE EQ Gain setting 16 -
                                                            // not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_17        0x11  // CTLE EQ Gain setting 17 -
                                                            // not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_18        0x12  // CTLE EQ Gain setting 18 -
                                                            // not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_19        0x13  // CTLE EQ Gain setting 19 -
                                                            // not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_20        0x14  // CTLE EQ Gain setting 20 -
                                                            // not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_21        0x15  // CTLE EQ Gain setting 21 -
                                                            // not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_22        0x16  // CTLE EQ Gain setting 22 -
                                                            // not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_23        0x17  // CTLE EQ Gain setting 23 -
                                                            // not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_24        0x18  // CTLE EQ Gain setting 24 -
                                                            // not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_25        0x19  // CTLE EQ Gain setting 25 -
                                                            // not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_26        0x1A  // CTLE EQ Gain setting 26 -
                                                            // not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_27        0x1B  // CTLE EQ Gain setting 27 -
                                                            // not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_28        0x1C  // CTLE EQ Gain setting 28 -
                                                            // not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_29        0x1D  // CTLE EQ Gain setting 29 -
                                                            // not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_30        0x1E  // CTLE EQ Gain setting 30 -
                                                            // not used
#define EMAC25G_CTLEEQGAINLOW_CTLE_EQGAIN_L_31        0x1F  // CTLE EQ Gain setting 31 -
                                                            // not used

// Value map 'DccFinestepEn'
#define EMAC25G_DFS_DISABLE                           0x0   // disable - used for 10G
#define EMAC25G_DFS_ENABLE                            0x1   // enable - used for 25G

// Value map 'DllStrAlignCyCtlsel'
#define EMAC25G_DLLSTRALIGNCYCTLSEL_CTLSEL_0          0x0   // aib_dllstr_align_dy_ctlsel_setting0
                                                            // - used for 25G
#define EMAC25G_DLLSTRALIGNCYCTLSEL_CTLSEL_1          0x1   // aib_dllstr_align_dy_ctlsel_setting1
                                                            // - used for 10G

// Value map 'DllstrAlignDyCtlsel'
#define EMAC25G_DLLSTR_ALIGN_DY_CTLSEL_0              0x0   // aib_dllstr_align_dy_ctlsel_setting0
                                                            // - used for 25G
#define EMAC25G_DLLSTR_ALIGN_DY_CTLSEL_1              0x1   // aib_dllstr_align_dy_ctlsel_setting1
                                                            // - used for 10G

// Value map 'EqCdGenSel'
#define EMAC25G_EQCDGENSEL_EQ_CDGEN_0                 0x0   // eq_cdgen_0 - used for 25G
#define EMAC25G_EQCDGENSEL_EQ_CDGEN_2                 0x1   // eq_cdgen_2 - used for 10G

// Value map 'EqSel'
#define EMAC25G_EQSEL_EQ_SEL_0                        0x0   // eq_sel_0 - not used
#define EMAC25G_EQSEL_EQ_SEL_1                        0x1   // eq_sel_1 - used for 10G
#define EMAC25G_EQSEL_EQ_SEL_2                        0x2   // eq_sel_2 - not used
#define EMAC25G_EQSEL_EQ_SEL_3                        0x3   // eq_sel_3 - used for 25G

// Value map 'IbTiaBw'
#define EMAC25G_IBTIABW_IB_TIA_BW_0                   0x0   // ib_tia_bw0 - not used
#define EMAC25G_IBTIABW_IB_TIA_BW_1                   0x1   // ib_tia_bw1 - used for 10G
#define EMAC25G_IBTIABW_IB_TIA_BW_2                   0x2   // ib_tia_bw2 - not used
#define EMAC25G_IBTIABW_IB_TIA_BW_3                   0x3   // ib_tia_bw3 - used for 25G

// Value map 'LatchXcoupleDisable'
#define EMAC25G_LATCHXCDIS_ENABLE                     0x0   // latch_xcouple_enable -
                                                            // used for 10G
#define EMAC25G_LATCHXCDIS_DISABLE                    0x1   // latch_xcoupe_disable -
                                                            // used for 25G

// Value map 'LfEqEnable'
#define EMAC25G_LFEQENABLE_DISABLE                    0x0   // rx_lfeq_disable - used for
                                                            // 10G
#define EMAC25G_LFEQENABLE_ENABLE                     0x1   // rx_lfeq_enable - used for
                                                            // 25G

// Value map 'LfPfd'
#define EMAC25G_LFPFD_LF_PFD_0                        0x0   // lf_pfd_setting0 - not used
#define EMAC25G_LFPFD_LF_PFD_1                        0x1   // lf_pfd_setting1 - not used
#define EMAC25G_LFPFD_LF_PFD_2                        0x2   // lf_pfd_setting2 - used for
                                                            // 10G
#define EMAC25G_LFPFD_LF_PFD_3                        0x3   // lf_pfd_setting3 - used for
                                                            // 25G

// Value map 'LockState'
#define EMAC25G_LOCKSTATE_UNLOCKED                    0x0   // Lock has not been acquired
#define EMAC25G_LOCKSTATE_LOCKED                      0x1   // Lock has been acquired

// Value map 'Loopback0'
#define EMAC25G_LB0_DIS_OR_POST_CDR                   0x0   // Disabled or Post-CDR
                                                            // reverse serial loopback
#define EMAC25G_LB0_PRE_CDR                           0x1   // Pre-CDR reverse serial
                                                            // loopback

// Value map 'Loopback1'
#define EMAC25G_LB1_DIS_OR_PRE_CDR                    0x0   // Disabled or Pre-CDR
                                                            // reverse serial loopback
#define EMAC25G_LB1_POST_CDR                          0x1   // Post-CDR reverse serial
                                                            // loopback

// Value map 'Loopback2'
#define EMAC25G_LB2_DIS_OR_POST_CDR                   0x0   // Disabled or Post-CDR
                                                            // reverse serial loopback
#define EMAC25G_LB2_PRE_CDR                           0x1   // Pre-CDR reverse serial
                                                            // loopback

// Value map 'Loopback43'
#define EMAC25G_LB43_DIS_OR_PRE_CDR                   0x0   // Disabled or Pre-CDR
                                                            // reverse serial loopback
#define EMAC25G_LB43_POST_CDR                         0x1   // Post-CDR reverse serial
                                                            // loopback
#define EMAC25G_LB43_INVALID2                         0x2   // Invalid setting
#define EMAC25G_LB43_INVALID3                         0x3   // Invalid setting

// Value map 'Loopback5'
#define EMAC25G_LB5_DIS_OR_POST_CDR                   0x0   // Disabled or Post-CDR
                                                            // reverse serial loopback
#define EMAC25G_LB5_PRE_CDR                           0x1   // Pre-CDR reverse serial
                                                            // loopback

// Value map 'MacLinkSpeed'
#define EMAC25G_LINKSPEED_10G                         0x0   // Link speed set to 10Gbps
#define EMAC25G_LINKSPEED_25G                         0x1   // Link speed set to 25Gbps

// Value map 'MacLinkStat'
#define EMAC25G_LINKSTAT_DOWN                         0x0   // Link is down
#define EMAC25G_LINKSTAT_UP                           0x1   // Link is up

// Value map 'OdiMonBwSel'
#define EMAC25G_ODIMONBWSEL_BW_1                      0x0   // bw1 - used for 25G
#define EMAC25G_ODIMONBWSEL_BW_4                      0x1   // bw4 - used for 10G

// Value map 'OperationalMode'
#define EMAC25G_OPMODE_IDLE                           0x0   // Block is inactive
#define EMAC25G_OPMODE_STANDBY                        0x1   // Block is partially
                                                            // operational
#define EMAC25G_OPMODE_RUN                            0x2   // Block performs its normal
                                                            // function

// Value map 'PhyFlags'
#define EMAC25G_FLAG_TxFifoFull                       0x0   // Transmit FIFO full flag
#define EMAC25G_FLAG_TxFifoEmpty                      0x1   // Transmit FIFO empty flag
#define EMAC25G_FLAG_TxFifoPartF                      0x2   // Transmit FIFO partially
                                                            // full flag
#define EMAC25G_FLAG_TxFifoPartE                      0x3   // Transmit FIFO partially
                                                            // empty flag
#define EMAC25G_FLAG_RxFifoFull                       0x4   // Receive FIFO full flag
#define EMAC25G_FLAG_RxFifoEmpty                      0x5   // Receive FIFO empty flag
#define EMAC25G_FLAG_RxFifoPartF                      0x6   // Receive FIFO partially
                                                            // full flag
#define EMAC25G_FLAG_RxFifoPartE                      0x7   // Receive FIFO partially
                                                            // empty flag

// Value map 'PreReconfig'
#define EMAC25G_PREREC_USE_DEFAULT                    0x0   // PreSICE uses the default
                                                            // CDR charge pump bandwidth
                                                            // from the default memory
                                                            // space.
#define EMAC25G_PREREC_USE_SETTING                    0x1   // PreSICE uses the CDR
                                                            // charge pump bandwidth
                                                            // setting from the Avalon
                                                            // memory-mapped interface
                                                            // space register space.

// Value map 'Reset'
#define EMAC25G_RESET_DEASSERT                        0x0   // Deassert reset
#define EMAC25G_RESET_ASSERT                          0x1   // Assert reset

// Value map 'ResetOverrideEn'
#define EMAC25G_RESETOVERRIDEEN_NONE                  0x0   // Listen to transceiver
                                                            // reset port
#define EMAC25G_RESETOVERRIDEEN_OVERRIDE              0x1   // Listen to transceiver
                                                            // reset register field

// Value map 'RxDccByp'
#define EMAC25G_RXDCCBYP_ENABLE                       0x0   // aib_rx_dcc_byp_enable -
                                                            // used for 10G
#define EMAC25G_RXDCCBYP_DISABLE                      0x1   // aib_rx_dcc_byp_disable -
                                                            // used for 25G

// Value map 'RxDccEn'
#define EMAC25G_RXDCCEN_DISABLE                       0x0   // aib_rx_dcc_disable - used
                                                            // for 10G
#define EMAC25G_RXDCCEN_ENABLE                        0x1   // aib_rx_dcc_enable - used
                                                            // for 25G

// Value map 'RxEqualBandwidth'
#define EMAC25G_RXEQBW_BW_6_5G                        0x0   // datarate <= 6.5Gbps - not
                                                            // used
#define EMAC25G_RXEQBW_BW_12_5G                       0x1   // 6.5Gbps < datarate <=
                                                            //    12.5Gbps - used for 10G
#define EMAC25G_RXEQBW_BW_19_2G                       0x2   // 12.5Gbps < datarate <=
                                                            // 19.2Gbps - not used
#define EMAC25G_RXEQBW_BW_26_6G                       0x3   // 19.2Gbps < datarate - used
                                                            // for 25G

// Value map 'RxTermination'
#define EMAC25G_RXTERM_RX_TERM_85                     0x2   // 85 Ohm termination
#define EMAC25G_RXTERM_RX_TERM_100                    0x4   // 100 Ohm termination
#define EMAC25G_RXTERM_RX_TERM_EXT                    0x7   // External termination

// Value map 'SerialLoopbackEn'
#define EMAC25G_SERIALLOOPBACKEN_DISABLE              0x0   // Disable local serial
                                                            // loopback
#define EMAC25G_SERIALLOOPBACKEN_ENABLE               0x1   // Enable local serial
                                                            // loopback

// Value map 'SetLockTo'
#define EMAC25G_SETLOCKTO_NONE                        0x0   // Do not set the transceiver
                                                            // lockto register
#define EMAC25G_SETLOCKTO_SET_LOCK_TO                 0x1   // Sets the transceiver
                                                            // lockto register

// Value map 'SetLockToOverride'
#define EMAC25G_SETLOCKTOOVERRIDE_NONE                0x0   // Listen to set_lockto port
#define EMAC25G_SETLOCKTOOVERRIDE_OVERRIDE            0x1   // Listen to set_lockto
                                                            // register field

// Value map 'SfpAbsent'
#define EMAC25G_SFPABSENT_PRESENT                     0x0   // Module is present
#define EMAC25G_SFPABSENT_ABSENT                      0x1   // Module is absent

// Value map 'TapsumBw'
#define EMAC25G_TAPSUMBW_TAPSUM_BW0                   0x0   // tapsum_hibw - used for 25G
#define EMAC25G_TAPSUMBW_TAPSUM_BW1                   0x1   // tapsum_medbw - used for 10G
#define EMAC25G_TAPSUMBW_TAPSUM_BW2                   0x2   // not used
#define EMAC25G_TAPSUMBW_TAPSUM_BW3                   0x3   // not used

// Value map 'TxAibTxDccByp'
#define EMAC25G_TXAIBTXDCCBYP_ENABLE                  0x0   // aib_tx_dcc_byp_enable -
                                                            // used for 10G
#define EMAC25G_TXAIBTXDCCBYP_DISABLE                 0x1   // aib_tx_dcc_byp_disable -
                                                            // used for 25G

// Value map 'TxDccEn'
#define EMAC25G_TXDCCEN_DISABLE                       0x0   // aib_tx_dcc_disable - used
                                                            // for 10G
#define EMAC25G_TXDCCEN_ENABLE                        0x1   // aib_tx_dcc_enable - used
                                                            // for 25G

// Value map 'TxTermination'
#define EMAC25G_TXTERM_TX_TERM_85                     0x0   // 85 Ohm termination - used
                                                            // for 25G
#define EMAC25G_TXTERM_TX_TERM_100                    0x1   // 100 Ohm termination - used
                                                            // for 10G

// Value map 'VcoSpeed'
#define EMAC25G_VCOSPEED_VCO_SPEED_0                  0x0   // 0 - used for 25G
#define EMAC25G_VCOSPEED_VCO_SPEED_1                  0x1   // not used
#define EMAC25G_VCOSPEED_VCO_SPEED_2                  0x2   // 2 - used for 10G
#define EMAC25G_VCOSPEED_VCO_SPEED_3                  0x3   // not used
#define EMAC25G_VCOSPEED_VCO_SPEED_4                  0x4   // not used
#define EMAC25G_VCOSPEED_VCO_SPEED_5                  0x5   // not used
#define EMAC25G_VCOSPEED_VCO_SPEED_6                  0x6   // not used
#define EMAC25G_VCOSPEED_VCO_SPEED_7                  0x7   // not used
#define EMAC25G_VCOSPEED_VCO_SPEED_8                  0x8   // not used
#define EMAC25G_VCOSPEED_VCO_SPEED_9                  0x9   // not used
#define EMAC25G_VCOSPEED_VCO_SPEED_10                 0xA   // not used
#define EMAC25G_VCOSPEED_VCO_SPEED_11                 0xB   // not used
#define EMAC25G_VCOSPEED_VCO_SPEED_12                 0xC   // not used
#define EMAC25G_VCOSPEED_VCO_SPEED_13                 0xD   // not used
#define EMAC25G_VCOSPEED_VCO_SPEED_14                 0xE   // not used
#define EMAC25G_VCOSPEED_VCO_SPEED_15                 0xF   // not used

// Value map 'VcoSpeedFix1'
#define EMAC25G_VCOSPEEDFIX1_VCO_SPEED_FIX1_0         0x0   // not used
#define EMAC25G_VCOSPEEDFIX1_VCO_SPEED_FIX1_1         0x1   // not used
#define EMAC25G_VCOSPEEDFIX1_VCO_SPEED_FIX1_2         0x2   // not used
#define EMAC25G_VCOSPEEDFIX1_VCO_SPEED_FIX1_3         0x3   // not used
#define EMAC25G_VCOSPEEDFIX1_VCO_SPEED_FIX1_4         0x4   // not used
#define EMAC25G_VCOSPEEDFIX1_VCO_SPEED_FIX1_5         0x5   // 92 - used for 10G
#define EMAC25G_VCOSPEEDFIX1_VCO_SPEED_FIX1_6         0x6   // not used
#define EMAC25G_VCOSPEEDFIX1_VCO_SPEED_FIX1_7         0x7   // 120 - used for 25G
#define EMAC25G_VCOSPEEDFIX1_VCO_SPEED_FIX1_8         0x8   // not used
#define EMAC25G_VCOSPEEDFIX1_VCO_SPEED_FIX1_9         0x9   // not used
#define EMAC25G_VCOSPEEDFIX1_VCO_SPEED_FIX1_10        0xA   // not used
#define EMAC25G_VCOSPEEDFIX1_VCO_SPEED_FIX1_11        0xB   // not used
#define EMAC25G_VCOSPEEDFIX1_VCO_SPEED_FIX1_12        0xC   // not used
#define EMAC25G_VCOSPEEDFIX1_VCO_SPEED_FIX1_13        0xD   // not used
#define EMAC25G_VCOSPEEDFIX1_VCO_SPEED_FIX1_14        0xE   // not used
#define EMAC25G_VCOSPEEDFIX1_VCO_SPEED_FIX1_15        0xF   // not used

// Value map 'VcoSpeedFix2'
#define EMAC25G_VCOSPEEDFIX2_VCO_SPEED_FIX2_0         0x0   // not used
#define EMAC25G_VCOSPEEDFIX2_VCO_SPEED_FIX2_1         0x1   // not used
#define EMAC25G_VCOSPEEDFIX2_VCO_SPEED_FIX2_2         0x2   // not used
#define EMAC25G_VCOSPEEDFIX2_VCO_SPEED_FIX2_3         0x3   // not used
#define EMAC25G_VCOSPEEDFIX2_VCO_SPEED_FIX2_4         0x4   // not used
#define EMAC25G_VCOSPEEDFIX2_VCO_SPEED_FIX2_5         0x5   // not used
#define EMAC25G_VCOSPEEDFIX2_VCO_SPEED_FIX2_6         0x6   // not used
#define EMAC25G_VCOSPEEDFIX2_VCO_SPEED_FIX2_7         0x7   // not used
#define EMAC25G_VCOSPEEDFIX2_VCO_SPEED_FIX2_8         0x8   // 120 - used for 25G
#define EMAC25G_VCOSPEEDFIX2_VCO_SPEED_FIX2_9         0x9   // not used
#define EMAC25G_VCOSPEEDFIX2_VCO_SPEED_FIX2_10        0xA   // not used
#define EMAC25G_VCOSPEEDFIX2_VCO_SPEED_FIX2_11        0xB   // not used
#define EMAC25G_VCOSPEEDFIX2_VCO_SPEED_FIX2_12        0xC   // 92 - used for 10G
#define EMAC25G_VCOSPEEDFIX2_VCO_SPEED_FIX2_13        0xD   // not used
#define EMAC25G_VCOSPEEDFIX2_VCO_SPEED_FIX2_14        0xE   // not used
#define EMAC25G_VCOSPEEDFIX2_VCO_SPEED_FIX2_15        0xF   // not used

// Value map 'VgaDcGainHigh'
#define EMAC25G_VGAGAINH_VGA_GAIN_H_0                 0x0   // VGA DC Gain setting 0-15 -
                                                            // used for 10G
#define EMAC25G_VGAGAINH_VGA_GAIN_H_16                0x1   // VGA DC Gain setting 16-31
                                                            // - used for 25G

// Value map 'VgaDcGainLow'
#define EMAC25G_VGAGAINL_VGA_GAIN_L_0_16              0x0   // VGA DC Gain setting 0
                                                            // (-5dB) or 16 - 16 used for
                                                            // 25G
#define EMAC25G_VGAGAINL_VGA_GAIN_L_1_17              0x1   // VGA DC Gain setting 1 or
                                                            // 17 - not used
#define EMAC25G_VGAGAINL_VGA_GAIN_L_2_18              0x2   // VGA DC Gain setting 2 or
                                                            // 18 - not used
#define EMAC25G_VGAGAINL_VGA_GAIN_L_3_19              0x3   // VGA DC Gain setting 3 or
                                                            // 19 - not used
#define EMAC25G_VGAGAINL_VGA_GAIN_L_4_20              0x4   // VGA DC Gain setting 4 or
                                                            // 20 - 4 used for 10G
#define EMAC25G_VGAGAINL_VGA_GAIN_L_5_21              0x5   // VGA DC Gain setting 5 or
                                                            // 21 - not used
#define EMAC25G_VGAGAINL_VGA_GAIN_L_6_22              0x6   // VGA DC Gain setting 6 or
                                                            // 22 - not used
#define EMAC25G_VGAGAINL_VGA_GAIN_L_7_23              0x7   // VGA DC Gain setting 7 or
                                                            // 23 - not used
#define EMAC25G_VGAGAINL_VGA_GAIN_L_8_24              0x8   // VGA DC Gain setting 8 or
                                                            // 24 - not used
#define EMAC25G_VGAGAINL_VGA_GAIN_L_9_25              0x9   // VGA DC Gain setting 9 or
                                                            // 25 - not used
#define EMAC25G_VGAGAINL_VGA_GAIN_L_10_26             0xA   // VGA DC Gain setting 10 or
                                                            // 26 - not used
#define EMAC25G_VGAGAINL_VGA_GAIN_L_11_27             0xB   // VGA DC Gain setting 11 or
                                                            // 27 - not used
#define EMAC25G_VGAGAINL_VGA_GAIN_L_12_28             0xC   // VGA DC Gain setting 12 or
                                                            // 28 - used for 25G
#define EMAC25G_VGAGAINL_VGA_GAIN_L_13_29             0xD   // VGA DC Gain setting 13 or
                                                            // 29 - not used
#define EMAC25G_VGAGAINL_VGA_GAIN_L_14_30             0xE   // VGA DC Gain setting 14 or
                                                            // 30 - not used
#define EMAC25G_VGAGAINL_VGA_GAIN_L_15_31             0xF   // VGA DC Gain setting 15 or
                                                            // 31 (+7dB) - not used

// Value map 'VgaHalfBwEn'
#define EMAC25G_VGAHALFBWEN_DISABLE                   0x0   // vga_half_bw_disabled -
                                                            // used for 10G
#define EMAC25G_VGAHALFBWEN_ENABLE                    0x1   // vga_half_bw_enabled - used
                                                            // for 25G

// Value map 'VregVoltageSel'
#define EMAC25G_VREGVOLTSEL_VREG_0                    0x0   // vreg0 - used for 10G
#define EMAC25G_VREGVOLTSEL_VREG_1                    0x1   // vreg1 - used for 25G
#define EMAC25G_VREGVOLTSEL_VREG_2                    0x2   // vreg2 - not used
#define EMAC25G_VREGVOLTSEL_VREG_3                    0x3   // vreg3 - not used

// Value map 'XcvrReset'
#define EMAC25G_XCVRRESET_DEASSERT                    0x0   // Do not reset the
                                                            // transceiver
#define EMAC25G_XCVRRESET_ASSERT                      0x1   // Reset the transceiver

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// +=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Configuration' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_Configuration_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x8);
}

// Field GET function.
static __inline UInt32 EMAC25G_Configuration_GET_JumboSupport(UInt32 Configuration)
{
    return Configuration & 0x1;
}

// Field READ function.
static __inline UInt32 EMAC25G_Configuration_READ_JumboSupport(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x8) & 0x1;
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC25G_Control_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0xC);
}

// Field SET functions.
static __inline UInt32 EMAC25G_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32 EMAC25G_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32 EMAC25G_Control_SET_PromiscuousMode(UInt32 Control, UInt32 PromiscuousMode)
{
    DT_ASSERT((PromiscuousMode & ~0x1) == 0);
    return (Control & ~0x8) | (PromiscuousMode << 3);
}
static __inline UInt32 EMAC25G_Control_SET_FlushFifos(UInt32 Control, UInt32 FlushFifos)
{
    DT_ASSERT((FlushFifos & ~0x1) == 0);
    return (Control & ~0x10) | (FlushFifos << 4);
}
static __inline UInt32 EMAC25G_Control_SET_SpeedSel(UInt32 Control, UInt32 SpeedSel)
{
    DT_ASSERT((SpeedSel & ~0x1) == 0);
    return (Control & ~0x20) | (SpeedSel << 5);
}
static __inline UInt32 EMAC25G_Control_SET_CsrRst(UInt32 Control, UInt32 CsrRst)
{
    DT_ASSERT((CsrRst & ~0x1) == 0);
    return (Control & ~0x40) | (CsrRst << 6);
}
static __inline UInt32 EMAC25G_Control_SET_TxRst(UInt32 Control, UInt32 TxRst)
{
    DT_ASSERT((TxRst & ~0x1) == 0);
    return (Control & ~0x80) | (TxRst << 7);
}
static __inline UInt32 EMAC25G_Control_SET_RxRst(UInt32 Control, UInt32 RxRst)
{
    DT_ASSERT((RxRst & ~0x1) == 0);
    return (Control & ~0x100) | (RxRst << 8);
}
static __inline UInt32 EMAC25G_Control_SET_ChannelReset(UInt32 Control, UInt32 ChannelReset)
{
    DT_ASSERT((ChannelReset & ~0x1) == 0);
    return (Control & ~0x200) | (ChannelReset << 9);
}
static __inline UInt32 EMAC25G_Control_SET_ClrRxDelCnt(UInt32 Control, UInt32 ClrRxDelCnt)
{
    DT_ASSERT((ClrRxDelCnt & ~0x1) == 0);
    return (Control & ~0x400) | (ClrRxDelCnt << 10);
}
static __inline UInt32 EMAC25G_Control_SET_MaxDelay(UInt32 Control, UInt32 MaxDelay)
{
    DT_ASSERT((MaxDelay & ~0xFFFF) == 0);
    return (Control & ~0xFFFF0000) | (MaxDelay << 16);
}

// Register WRITE function.
static __inline void EMAC25G_Control_WRITE(DtBcEMAC25G* Bc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)Bc, 0xC, Control);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC25G_Status_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10);
}

// Field GET functions.
static __inline UInt32 EMAC25G_Status_GET_MacAccessTimedout(UInt32 Status)
{
    return (Status & 0x2) >> 1;
}
static __inline UInt32 EMAC25G_Status_GET_TranscAccessTimedout(UInt32 Status)
{
    return (Status & 0x4) >> 2;
}
static __inline UInt32 EMAC25G_Status_GET_LinkStat(UInt32 Status)
{
    return (Status & 0x100) >> 8;
}
static __inline UInt32 EMAC25G_Status_GET_LinkStatChanged(UInt32 Status)
{
    return (Status & 0x800) >> 11;
}
static __inline UInt32 EMAC25G_Status_GET_SfpAbsentChanged(UInt32 Status)
{
    return (Status & 0x1000) >> 12;
}
static __inline UInt32 EMAC25G_Status_GET_RxOverflow(UInt32 Status)
{
    return (Status & 0x10000) >> 16;
}
static __inline UInt32 EMAC25G_Status_GET_RxPcsReady(UInt32 Status)
{
    return (Status & 0x20000) >> 17;
}
static __inline UInt32 EMAC25G_Status_GET_TxLanesStable(UInt32 Status)
{
    return (Status & 0x40000) >> 18;
}

// Field READ functions.
static __inline UInt32 EMAC25G_Status_READ_MacAccessTimedout(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x10) & 0x2) >> 1;
}
static __inline UInt32 EMAC25G_Status_READ_TranscAccessTimedout(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x10) & 0x4) >> 2;
}
static __inline UInt32 EMAC25G_Status_READ_LinkStat(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x10) & 0x100) >> 8;
}
static __inline UInt32 EMAC25G_Status_READ_LinkStatChanged(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x10) & 0x800) >> 11;
}
static __inline UInt32 EMAC25G_Status_READ_SfpAbsentChanged(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x10) & 0x1000) >> 12;
}
static __inline UInt32 EMAC25G_Status_READ_RxOverflow(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x10) & 0x10000) >> 16;
}
static __inline UInt32 EMAC25G_Status_READ_RxPcsReady(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x10) & 0x20000) >> 17;
}
static __inline UInt32 EMAC25G_Status_READ_TxLanesStable(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x10) & 0x40000) >> 18;
}

// Field CLEAR functions.
static __inline void EMAC25G_Status_CLEAR_MacAccessTimedout(DtBcEMAC25G* Bc)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10, 0x2);
}
static __inline void EMAC25G_Status_CLEAR_TranscAccessTimedout(DtBcEMAC25G* Bc)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10, 0x4);
}
static __inline void EMAC25G_Status_CLEAR_LinkStatChanged(DtBcEMAC25G* Bc)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10, 0x800);
}
static __inline void EMAC25G_Status_CLEAR_SfpAbsentChanged(DtBcEMAC25G* Bc)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10, 0x1000);
}
static __inline void EMAC25G_Status_CLEAR_RxOverflow(DtBcEMAC25G* Bc)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10, 0x10000);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SchedulingOffset' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function.
static __inline void EMAC25G_SchedulingOffset_WRITE(DtBcEMAC25G* Bc, UInt32 SchedulingOffset)
{
    DT_ASSERT((SchedulingOffset & ~0x3FF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x14, SchedulingOffset);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxDelCnt' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_RxDelCnt_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x18);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SchedStat' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_SchedStat_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1C);
}

// Field GET functions.
static __inline UInt32 EMAC25G_SchedStat_GET_TooEarlyCnt(UInt32 SchedStat)
{
    return SchedStat & 0xFF;
}
static __inline UInt32 EMAC25G_SchedStat_GET_TooLateCnt(UInt32 SchedStat)
{
    return (SchedStat & 0xFF00) >> 8;
}
static __inline UInt32 EMAC25G_SchedStat_GET_PacketWaiting(UInt32 SchedStat)
{
    return (SchedStat & 0x10000) >> 16;
}
static __inline UInt32 EMAC25G_SchedStat_GET_PacketSending(UInt32 SchedStat)
{
    return (SchedStat & 0x40000) >> 18;
}

// Field READ functions.
static __inline UInt32 EMAC25G_SchedStat_READ_TooEarlyCnt(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1C) & 0xFF;
}
static __inline UInt32 EMAC25G_SchedStat_READ_TooLateCnt(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x1C) & 0xFF00) >> 8;
}
static __inline UInt32 EMAC25G_SchedStat_READ_PacketWaiting(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x1C) & 0x10000) >> 16;
}
static __inline UInt32 EMAC25G_SchedStat_READ_PacketSending(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x1C) & 0x40000) >> 18;
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SchedStatClr' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_SchedStatClr_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x20);
}

// Field SET functions.
static __inline UInt32 EMAC25G_SchedStatClr_SET_ClrTooEarlyCnt(UInt32 SchedStatClr, UInt32 ClrTooEarlyCnt)
{
    DT_ASSERT((ClrTooEarlyCnt & ~0x1) == 0);
    return (SchedStatClr & ~0x1) | ClrTooEarlyCnt;
}
static __inline UInt32 EMAC25G_SchedStatClr_SET_ClrTooLateCnt(UInt32 SchedStatClr, UInt32 ClrTooLateCnt)
{
    DT_ASSERT((ClrTooLateCnt & ~0x1) == 0);
    return (SchedStatClr & ~0x100) | (ClrTooLateCnt << 8);
}

// Register WRITE function.
static __inline void EMAC25G_SchedStatClr_WRITE(DtBcEMAC25G* Bc, UInt32 SchedStatClr)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x20, SchedStatClr);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SfpGpio' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC25G_SfpGpio_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x24);
}

// Field GET functions.
static __inline UInt32 EMAC25G_SfpGpio_GET_TxFault(UInt32 SfpGpio)
{
    return (SfpGpio & 0x100) >> 8;
}
static __inline UInt32 EMAC25G_SfpGpio_GET_RxLos(UInt32 SfpGpio)
{
    return (SfpGpio & 0x200) >> 9;
}
static __inline UInt32 EMAC25G_SfpGpio_GET_Absent(UInt32 SfpGpio)
{
    return (SfpGpio & 0x400) >> 10;
}

// Field READ functions.
static __inline UInt32 EMAC25G_SfpGpio_READ_TxFault(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x24) & 0x100) >> 8;
}
static __inline UInt32 EMAC25G_SfpGpio_READ_RxLos(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x24) & 0x200) >> 9;
}
static __inline UInt32 EMAC25G_SfpGpio_READ_Absent(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x24) & 0x400) >> 10;
}

// Field SET functions.
static __inline UInt32 EMAC25G_SfpGpio_SET_Disable(UInt32 SfpGpio, UInt32 Disable)
{
    DT_ASSERT((Disable & ~0x1) == 0);
    return (SfpGpio & ~0x1) | Disable;
}
static __inline UInt32 EMAC25G_SfpGpio_SET_RS(UInt32 SfpGpio, UInt32 RS)
{
    DT_ASSERT((RS & ~0x3) == 0);
    return (SfpGpio & ~0x6) | (RS << 1);
}

// Register WRITE function.
static __inline void EMAC25G_SfpGpio_WRITE(DtBcEMAC25G* Bc, UInt32 SfpGpio)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x24, SfpGpio);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyRevId' -.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyRevId_READ_PhyRevId(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x400);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyScratch' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyScratch_READ_PhyScratch(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x404);
}

// Field WRITE function.
static __inline void EMAC25G_EthMac25GS10_PhyScratch_WRITE_PhyScratch(DtBcEMAC25G* Bc, UInt32 PhyScratch)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x404, PhyScratch);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyName0' -.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyName0_READ_PhyName0(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x408);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyName1' -.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyName1_READ_PhyName1(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x40C);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyName2' -.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyName2_READ_PhyName2(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x410);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyConfig' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyConfig_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x414);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyConfig_GET_EioSysRst(UInt32 EthMac25GS10_PhyConfig)
{
    return EthMac25GS10_PhyConfig & 0x1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_PhyConfig_GET_SoftTxpRst(UInt32 EthMac25GS10_PhyConfig)
{
    return (EthMac25GS10_PhyConfig & 0x2) >> 1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_PhyConfig_GET_SoftRxpRst(UInt32 EthMac25GS10_PhyConfig)
{
    return (EthMac25GS10_PhyConfig & 0x4) >> 2;
}
static __inline UInt32 EMAC25G_EthMac25GS10_PhyConfig_GET_SetRefLock(UInt32 EthMac25GS10_PhyConfig)
{
    return (EthMac25GS10_PhyConfig & 0x10) >> 4;
}
static __inline UInt32 EMAC25G_EthMac25GS10_PhyConfig_GET_SetDataLock(UInt32 EthMac25GS10_PhyConfig)
{
    return (EthMac25GS10_PhyConfig & 0x20) >> 5;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyConfig_SET_EioSysRst(UInt32 EthMac25GS10_PhyConfig, UInt32 EioSysRst)
{
    DT_ASSERT((EioSysRst & ~0x1) == 0);
    return (EthMac25GS10_PhyConfig & ~0x1) | EioSysRst;
}
static __inline UInt32 EMAC25G_EthMac25GS10_PhyConfig_SET_SoftTxpRst(UInt32 EthMac25GS10_PhyConfig, UInt32 SoftTxpRst)
{
    DT_ASSERT((SoftTxpRst & ~0x1) == 0);
    return (EthMac25GS10_PhyConfig & ~0x2) | (SoftTxpRst << 1);
}
static __inline UInt32 EMAC25G_EthMac25GS10_PhyConfig_SET_SoftRxpRst(UInt32 EthMac25GS10_PhyConfig, UInt32 SoftRxpRst)
{
    DT_ASSERT((SoftRxpRst & ~0x1) == 0);
    return (EthMac25GS10_PhyConfig & ~0x4) | (SoftRxpRst << 2);
}
static __inline UInt32 EMAC25G_EthMac25GS10_PhyConfig_SET_SetRefLock(UInt32 EthMac25GS10_PhyConfig, UInt32 SetRefLock)
{
    DT_ASSERT((SetRefLock & ~0x1) == 0);
    return (EthMac25GS10_PhyConfig & ~0x10) | (SetRefLock << 4);
}
static __inline UInt32 EMAC25G_EthMac25GS10_PhyConfig_SET_SetDataLock(UInt32 EthMac25GS10_PhyConfig, UInt32 SetDataLock)
{
    DT_ASSERT((SetDataLock & ~0x1) == 0);
    return (EthMac25GS10_PhyConfig & ~0x20) | (SetDataLock << 5);
}

// Register WRITE function.
static __inline void EMAC25G_EthMac25GS10_PhyConfig_WRITE(DtBcEMAC25G* Bc, UInt32 EthMac25GS10_PhyConfig)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x414, EthMac25GS10_PhyConfig);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyWordLock' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyWordLock_READ_PhyWordLock(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x418) & 0x1;
}

// Field WRITE function.
static __inline void EMAC25G_EthMac25GS10_PhyWordLock_WRITE_PhyWordLock(DtBcEMAC25G* Bc, UInt32 PhyWordLock)
{
    DT_ASSERT((PhyWordLock & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x418, PhyWordLock);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyEioSloop' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyEioSloop_READ_PhyEioSloop(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x41C) & 0x1;
}

// Field WRITE function.
static __inline void EMAC25G_EthMac25GS10_PhyEioSloop_WRITE_PhyEioSloop(DtBcEMAC25G* Bc, UInt32 PhyEioSloop)
{
    DT_ASSERT((PhyEioSloop & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x41C, PhyEioSloop);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyEioFlagSel' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyEioFlagSel_READ_PhyEioFlagSel(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x420) & 0x7;
}

// Field WRITE function.
static __inline void EMAC25G_EthMac25GS10_PhyEioFlagSel_WRITE_PhyEioFlagSel(DtBcEMAC25G* Bc, UInt32 PhyEioFlagSel)
{
    DT_ASSERT((PhyEioFlagSel & ~0x7) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x420, PhyEioFlagSel);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyEioFlags' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyEioFlags_READ_PhyEioFlags(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x424) & 0x1;
}

// Field WRITE function.
static __inline void EMAC25G_EthMac25GS10_PhyEioFlags_WRITE_PhyEioFlags(DtBcEMAC25G* Bc, UInt32 PhyEioFlags)
{
    DT_ASSERT((PhyEioFlags & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x424, PhyEioFlags);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyEioFreqLock' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyEioFreqLock_READ_PhyEioFreqLock(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x428) & 0x1;
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyClk' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyClk_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x42C);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyClk_GET_TxPcsReady(UInt32 EthMac25GS10_PhyClk)
{
    return EthMac25GS10_PhyClk & 0x1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_PhyClk_GET_TxMacPllLocked(UInt32 EthMac25GS10_PhyClk)
{
    return (EthMac25GS10_PhyClk & 0x2) >> 1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_PhyClk_GET_RxCdrPllLocked(UInt32 EthMac25GS10_PhyClk)
{
    return (EthMac25GS10_PhyClk & 0x4) >> 2;
}

// Field READ functions.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyClk_READ_TxPcsReady(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x42C) & 0x1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_PhyClk_READ_TxMacPllLocked(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x42C) & 0x2) >> 1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_PhyClk_READ_RxCdrPllLocked(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x42C) & 0x4) >> 2;
}

// .-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyFrmErr' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyFrmErr_READ_PhyFrmErr(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x430) & 0x1;
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhySclrFrmErr' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhySclrFrmErr_READ_PhySclrFrmErr(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x434) & 0x1;
}

// Field WRITE function.
static __inline void EMAC25G_EthMac25GS10_PhySclrFrmErr_WRITE_PhySclrFrmErr(DtBcEMAC25G* Bc, UInt32 PhySclrFrmErr)
{
    DT_ASSERT((PhySclrFrmErr & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x434, PhySclrFrmErr);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyRxPcsAligned' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyRxPcsAligned_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x43C);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyRxPcsAligned_GET_RxPcsAligned(UInt32 EthMac25GS10_PhyRxPcsAligned)
{
    return EthMac25GS10_PhyRxPcsAligned & 0x1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_PhyRxPcsAligned_GET_RxErrRate(UInt32 EthMac25GS10_PhyRxPcsAligned)
{
    return (EthMac25GS10_PhyRxPcsAligned & 0x2) >> 1;
}

// Field READ functions.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyRxPcsAligned_READ_RxPcsAligned(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x43C) & 0x1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_PhyRxPcsAligned_READ_RxErrRate(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x43C) & 0x2) >> 1;
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyLaneDeskewed' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyLaneDeskewed_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x440);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyLaneDeskewed_GET_Deskewed(UInt32 EthMac25GS10_PhyLaneDeskewed)
{
    return EthMac25GS10_PhyLaneDeskewed & 0x1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_PhyLaneDeskewed_GET_DeskChanged(UInt32 EthMac25GS10_PhyLaneDeskewed)
{
    return (EthMac25GS10_PhyLaneDeskewed & 0x2) >> 1;
}

// Field READ functions.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyLaneDeskewed_READ_Deskewed(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x440) & 0x1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_PhyLaneDeskewed_READ_DeskChanged(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x440) & 0x2) >> 1;
}

// .-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyKhzRx' -.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyKhzRx_READ_PhyKhzRx(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x448);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyKhzTx' -.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyKhzTx_READ_PhyKhzTx(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x44C);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_PhyTlkitAccess' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_PhyTlkitAccess_READ_PhyTlkitAccess(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x450) & 0x1;
}

// Field WRITE function.
static __inline void EMAC25G_EthMac25GS10_PhyTlkitAccess_WRITE_PhyTlkitAccess(DtBcEMAC25G* Bc, UInt32 PhyTlkitAccess)
{
    DT_ASSERT((PhyTlkitAccess & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x450, PhyTlkitAccess);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxMacRevId' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacRevId_READ_TxMacRevId(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x460);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxMacScratch' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacScratch_READ_TxMacScratch(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x464);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxMacName0' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacName0_READ_TxMacName0(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x468);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxMacName1' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacName1_READ_TxMacName1(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x46C);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxMacName2' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacName2_READ_TxMacName2(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x470);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxMacLinkFault' -.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacLinkFault_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x474);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacLinkFault_GET_LFRepEna(UInt32 EthMac25GS10_TxMacLinkFault)
{
    return EthMac25GS10_TxMacLinkFault & 0x1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacLinkFault_GET_UnidirEna(UInt32 EthMac25GS10_TxMacLinkFault)
{
    return (EthMac25GS10_TxMacLinkFault & 0x2) >> 1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacLinkFault_GET_RemFaultDis(UInt32 EthMac25GS10_TxMacLinkFault)
{
    return (EthMac25GS10_TxMacLinkFault & 0x4) >> 2;
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacLinkFault_GET_ForceRemFault(UInt32 EthMac25GS10_TxMacLinkFault)
{
    return (EthMac25GS10_TxMacLinkFault & 0x8) >> 3;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacLinkFault_SET_LFRepEna(UInt32 EthMac25GS10_TxMacLinkFault, UInt32 LFRepEna)
{
    DT_ASSERT((LFRepEna & ~0x1) == 0);
    return (EthMac25GS10_TxMacLinkFault & ~0x1) | LFRepEna;
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacLinkFault_SET_UnidirEna(UInt32 EthMac25GS10_TxMacLinkFault, UInt32 UnidirEna)
{
    DT_ASSERT((UnidirEna & ~0x1) == 0);
    return (EthMac25GS10_TxMacLinkFault & ~0x2) | (UnidirEna << 1);
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacLinkFault_SET_RemFaultDis(UInt32 EthMac25GS10_TxMacLinkFault, UInt32 RemFaultDis)
{
    DT_ASSERT((RemFaultDis & ~0x1) == 0);
    return (EthMac25GS10_TxMacLinkFault & ~0x4) | (RemFaultDis << 2);
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacLinkFault_SET_ForceRemFault(UInt32 EthMac25GS10_TxMacLinkFault, UInt32 ForceRemFault)
{
    DT_ASSERT((ForceRemFault & ~0x1) == 0);
    return (EthMac25GS10_TxMacLinkFault & ~0x8) | (ForceRemFault << 3);
}

// Register WRITE function.
static __inline void EMAC25G_EthMac25GS10_TxMacLinkFault_WRITE(DtBcEMAC25G* Bc, UInt32 EthMac25GS10_TxMacLinkFault)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x474, EthMac25GS10_TxMacLinkFault);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxMacMaxTxSize' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacMaxTxSize_READ_TxMacMaxTxSize(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x478) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC25G_EthMac25GS10_TxMacMaxTxSize_WRITE_TxMacMaxTxSize(DtBcEMAC25G* Bc, UInt32 TxMacMaxTxSize)
{
    DT_ASSERT((TxMacMaxTxSize & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x478, TxMacMaxTxSize);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxMacControl' -.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacControl_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x47C);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacControl_GET_VlanDetDis(UInt32 EthMac25GS10_TxMacControl)
{
    return (EthMac25GS10_TxMacControl & 0x2) >> 1;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxMacControl_SET_VlanDetDis(UInt32 EthMac25GS10_TxMacControl, UInt32 VlanDetDis)
{
    DT_ASSERT((VlanDetDis & ~0x1) == 0);
    return (EthMac25GS10_TxMacControl & ~0x2) | (VlanDetDis << 1);
}

// Register WRITE function.
static __inline void EMAC25G_EthMac25GS10_TxMacControl_WRITE(DtBcEMAC25G* Bc, UInt32 EthMac25GS10_TxMacControl)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x47C, EthMac25GS10_TxMacControl);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxMacRevId' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacRevId_READ_RxMacRevId(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x480);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxMacScratch' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacScratch_READ_RxMacScratch(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x484);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxMacName0' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacName0_READ_RxMacName0(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x488);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxMacName1' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacName1_READ_RxMacName1(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x48C);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxMacName2' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacName2_READ_RxMacName2(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x490);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxMacMaxRxSize' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacMaxRxSize_READ_RxMacMaxRxSize(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x494) & 0xFFFF;
}

// Field WRITE function.
static __inline void EMAC25G_EthMac25GS10_RxMacMaxRxSize_WRITE_RxMacMaxRxSize(DtBcEMAC25G* Bc, UInt32 RxMacMaxRxSize)
{
    DT_ASSERT((RxMacMaxRxSize & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x494, RxMacMaxRxSize);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxMacCrcConfig' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacCrcConfig_READ_RxMacCrcConfig(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x498) & 0x1;
}

// Field WRITE function.
static __inline void EMAC25G_EthMac25GS10_RxMacCrcConfig_WRITE_RxMacCrcConfig(DtBcEMAC25G* Bc, UInt32 RxMacCrcConfig)
{
    DT_ASSERT((RxMacCrcConfig & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0x498, RxMacCrcConfig);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxMacLinkFault' -.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacLinkFault_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x49C);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacLinkFault_GET_LocalFault(UInt32 EthMac25GS10_RxMacLinkFault)
{
    return EthMac25GS10_RxMacLinkFault & 0x1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacLinkFault_GET_RemoteFault(UInt32 EthMac25GS10_RxMacLinkFault)
{
    return (EthMac25GS10_RxMacLinkFault & 0x2) >> 1;
}

// Field READ functions.
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacLinkFault_READ_LocalFault(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x49C) & 0x1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacLinkFault_READ_RemoteFault(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x49C) & 0x2) >> 1;
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxMacControl' -.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacControl_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4A0);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacControl_GET_VlanDetDis(UInt32 EthMac25GS10_RxMacControl)
{
    return (EthMac25GS10_RxMacControl & 0x2) >> 1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacControl_GET_PreChkEna(UInt32 EthMac25GS10_RxMacControl)
{
    return (EthMac25GS10_RxMacControl & 0x10) >> 4;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacControl_SET_VlanDetDis(UInt32 EthMac25GS10_RxMacControl, UInt32 VlanDetDis)
{
    DT_ASSERT((VlanDetDis & ~0x1) == 0);
    return (EthMac25GS10_RxMacControl & ~0x2) | (VlanDetDis << 1);
}
static __inline UInt32 EMAC25G_EthMac25GS10_RxMacControl_SET_PreChkEna(UInt32 EthMac25GS10_RxMacControl, UInt32 PreChkEna)
{
    DT_ASSERT((PreChkEna & ~0x1) == 0);
    return (EthMac25GS10_RxMacControl & ~0x10) | (PreChkEna << 4);
}

// Register WRITE function.
static __inline void EMAC25G_EthMac25GS10_RxMacControl_WRITE(DtBcEMAC25G* Bc, UInt32 EthMac25GS10_RxMacControl)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x4A0, EthMac25GS10_RxMacControl);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxPtpRevId' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpRevId_READ_TxPtpRevId(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4B0);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxPtpScratch' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpScratch_READ_TxPtpScratch(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4B4);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxPtpName0' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpName0_READ_TxPtpName0(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4B8);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxPtpName1' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpName1_READ_TxPtpName1(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4BC);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxPtpName2' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpName2_READ_TxPtpName2(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4C0);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxPtpClkPeriod' -.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpClkPeriod_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4C4);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpClkPeriod_GET_NanoFrac(UInt32 EthMac25GS10_TxPtpClkPeriod)
{
    return EthMac25GS10_TxPtpClkPeriod & 0xFFFF;
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpClkPeriod_GET_Nano(UInt32 EthMac25GS10_TxPtpClkPeriod)
{
    return (EthMac25GS10_TxPtpClkPeriod & 0xF0000) >> 16;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpClkPeriod_SET_NanoFrac(UInt32 EthMac25GS10_TxPtpClkPeriod, UInt32 NanoFrac)
{
    DT_ASSERT((NanoFrac & ~0xFFFF) == 0);
    return (EthMac25GS10_TxPtpClkPeriod & ~0xFFFF) | NanoFrac;
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpClkPeriod_SET_Nano(UInt32 EthMac25GS10_TxPtpClkPeriod, UInt32 Nano)
{
    DT_ASSERT((Nano & ~0xF) == 0);
    return (EthMac25GS10_TxPtpClkPeriod & ~0xF0000) | (Nano << 16);
}

// Register WRITE function.
static __inline void EMAC25G_EthMac25GS10_TxPtpClkPeriod_WRITE(DtBcEMAC25G* Bc, UInt32 EthMac25GS10_TxPtpClkPeriod)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x4C4, EthMac25GS10_TxPtpClkPeriod);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxPtpAsymDelay' -.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpAsymDelay_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4DC);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpAsymDelay_GET_AsymAdj(UInt32 EthMac25GS10_TxPtpAsymDelay)
{
    return EthMac25GS10_TxPtpAsymDelay & 0x1FFFF;
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpAsymDelay_GET_AdjOper(UInt32 EthMac25GS10_TxPtpAsymDelay)
{
    return (EthMac25GS10_TxPtpAsymDelay & 0x20000) >> 17;
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpAsymDelay_GET_AsymEna(UInt32 EthMac25GS10_TxPtpAsymDelay)
{
    return (EthMac25GS10_TxPtpAsymDelay & 0x40000) >> 18;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpAsymDelay_SET_AsymAdj(UInt32 EthMac25GS10_TxPtpAsymDelay, UInt32 AsymAdj)
{
    DT_ASSERT((AsymAdj & ~0x1FFFF) == 0);
    return (EthMac25GS10_TxPtpAsymDelay & ~0x1FFFF) | AsymAdj;
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpAsymDelay_SET_AdjOper(UInt32 EthMac25GS10_TxPtpAsymDelay, UInt32 AdjOper)
{
    DT_ASSERT((AdjOper & ~0x1) == 0);
    return (EthMac25GS10_TxPtpAsymDelay & ~0x20000) | (AdjOper << 17);
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpAsymDelay_SET_AsymEna(UInt32 EthMac25GS10_TxPtpAsymDelay, UInt32 AsymEna)
{
    DT_ASSERT((AsymEna & ~0x1) == 0);
    return (EthMac25GS10_TxPtpAsymDelay & ~0x40000) | (AsymEna << 18);
}

// Register WRITE function.
static __inline void EMAC25G_EthMac25GS10_TxPtpAsymDelay_WRITE(DtBcEMAC25G* Bc, UInt32 EthMac25GS10_TxPtpAsymDelay)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x4DC, EthMac25GS10_TxPtpAsymDelay);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxPtpPmaLatency' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpPmaLatency_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4E0);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpPmaLatency_GET_NanoFrac(UInt32 EthMac25GS10_TxPtpPmaLatency)
{
    return EthMac25GS10_TxPtpPmaLatency & 0xFFFF;
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpPmaLatency_GET_Nano(UInt32 EthMac25GS10_TxPtpPmaLatency)
{
    return (EthMac25GS10_TxPtpPmaLatency & 0xF0000) >> 16;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpPmaLatency_SET_NanoFrac(UInt32 EthMac25GS10_TxPtpPmaLatency, UInt32 NanoFrac)
{
    DT_ASSERT((NanoFrac & ~0xFFFF) == 0);
    return (EthMac25GS10_TxPtpPmaLatency & ~0xFFFF) | NanoFrac;
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxPtpPmaLatency_SET_Nano(UInt32 EthMac25GS10_TxPtpPmaLatency, UInt32 Nano)
{
    DT_ASSERT((Nano & ~0xF) == 0);
    return (EthMac25GS10_TxPtpPmaLatency & ~0xF0000) | (Nano << 16);
}

// Register WRITE function.
static __inline void EMAC25G_EthMac25GS10_TxPtpPmaLatency_WRITE(DtBcEMAC25G* Bc, UInt32 EthMac25GS10_TxPtpPmaLatency)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x4E0, EthMac25GS10_TxPtpPmaLatency);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxPtpRevId' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxPtpRevId_READ_RxPtpRevId(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4F0);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxPtpScratch' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxPtpScratch_READ_RxPtpScratch(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4F4);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxPtpName0' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxPtpName0_READ_RxPtpName0(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4F8);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxPtpName1' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxPtpName1_READ_RxPtpName1(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4FC);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxPtpName2' -.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxPtpName2_READ_RxPtpName2(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x500);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxPtpClkPeriod' -.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxPtpClkPeriod_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x504);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_RxPtpClkPeriod_GET_NanoFrac(UInt32 EthMac25GS10_RxPtpClkPeriod)
{
    return EthMac25GS10_RxPtpClkPeriod & 0xFFFF;
}
static __inline UInt32 EMAC25G_EthMac25GS10_RxPtpClkPeriod_GET_Nano(UInt32 EthMac25GS10_RxPtpClkPeriod)
{
    return (EthMac25GS10_RxPtpClkPeriod & 0xF0000) >> 16;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_RxPtpClkPeriod_SET_NanoFrac(UInt32 EthMac25GS10_RxPtpClkPeriod, UInt32 NanoFrac)
{
    DT_ASSERT((NanoFrac & ~0xFFFF) == 0);
    return (EthMac25GS10_RxPtpClkPeriod & ~0xFFFF) | NanoFrac;
}
static __inline UInt32 EMAC25G_EthMac25GS10_RxPtpClkPeriod_SET_Nano(UInt32 EthMac25GS10_RxPtpClkPeriod, UInt32 Nano)
{
    DT_ASSERT((Nano & ~0xF) == 0);
    return (EthMac25GS10_RxPtpClkPeriod & ~0xF0000) | (Nano << 16);
}

// Register WRITE function.
static __inline void EMAC25G_EthMac25GS10_RxPtpClkPeriod_WRITE(DtBcEMAC25G* Bc, UInt32 EthMac25GS10_RxPtpClkPeriod)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x504, EthMac25GS10_RxPtpClkPeriod);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxPtpPmaLatency' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxPtpPmaLatency_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x508);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_RxPtpPmaLatency_GET_NanoFrac(UInt32 EthMac25GS10_RxPtpPmaLatency)
{
    return EthMac25GS10_RxPtpPmaLatency & 0xFFFF;
}
static __inline UInt32 EMAC25G_EthMac25GS10_RxPtpPmaLatency_GET_Nano(UInt32 EthMac25GS10_RxPtpPmaLatency)
{
    return (EthMac25GS10_RxPtpPmaLatency & 0xF0000) >> 16;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_RxPtpPmaLatency_SET_NanoFrac(UInt32 EthMac25GS10_RxPtpPmaLatency, UInt32 NanoFrac)
{
    DT_ASSERT((NanoFrac & ~0xFFFF) == 0);
    return (EthMac25GS10_RxPtpPmaLatency & ~0xFFFF) | NanoFrac;
}
static __inline UInt32 EMAC25G_EthMac25GS10_RxPtpPmaLatency_SET_Nano(UInt32 EthMac25GS10_RxPtpPmaLatency, UInt32 Nano)
{
    DT_ASSERT((Nano & ~0xF) == 0);
    return (EthMac25GS10_RxPtpPmaLatency & ~0xF0000) | (Nano << 16);
}

// Register WRITE function.
static __inline void EMAC25G_EthMac25GS10_RxPtpPmaLatency_WRITE(DtBcEMAC25G* Bc, UInt32 EthMac25GS10_RxPtpPmaLatency)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x508, EthMac25GS10_RxPtpPmaLatency);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatFragmentsLo' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatFragmentsLo_READ_TxStatFragmentsLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x600);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatFragmentsHi' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatFragmentsHi_READ_TxStatFragmentsHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x604);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatJabbersLo' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatJabbersLo_READ_TxStatJabbersLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x608);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatJabbersHi' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatJabbersHi_READ_TxStatJabbersHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x60C);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatFcsLo' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatFcsLo_READ_TxStatFcsLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x610);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatFcsHi' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatFcsHi_READ_TxStatFcsHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x614);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatCrcErrLo' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatCrcErrLo_READ_TxStatCrcErrLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x618);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatCrcErrHi' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatCrcErrHi_READ_TxStatCrcErrHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x61C);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatMcastDataErrLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatMcastDataErrLo_READ_TxStatMcastDataErrLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x620);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatMcastDataErrHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatMcastDataErrHi_READ_TxStatMcastDataErrHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x624);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatBcastDataErrLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatBcastDataErrLo_READ_TxStatBcastDataErrLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x628);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatBcastDataErrHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatBcastDataErrHi_READ_TxStatBcastDataErrHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x62C);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatUcastDataErrLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatUcastDataErrLo_READ_TxStatUcastDataErrLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x630);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatUCastDataErrHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatUCastDataErrHi_READ_TxStatUCastDataErrHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x634);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatMcastCtrlErrLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatMcastCtrlErrLo_READ_TxStatMcastCtrlErrLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x638);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatMcastCtrlErrHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatMcastCtrlErrHi_READ_TxStatMcastCtrlErrHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x63C);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatBcastCtrlErrLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatBcastCtrlErrLo_READ_TxStatBcastCtrlErrLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x640);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatBcastCtrlErrHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatBcastCtrlErrHi_READ_TxStatBcastCtrlErrHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x644);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatUcastCtrlErrLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatUcastCtrlErrLo_READ_TxStatUcastCtrlErrLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x648);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatUcastCtrlErrHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatUcastCtrlErrHi_READ_TxStatUcastCtrlErrHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x64C);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatPauseErrLo' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatPauseErrLo_READ_TxStatPauseErrLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x650);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatPauseErrHi' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatPauseErrHi_READ_TxStatPauseErrHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x654);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStat64bLo' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStat64bLo_READ_TxStat64bLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x658);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStat64bHi' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStat64bHi_READ_TxStat64bHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x65C);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStat65To127Lo' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStat65To127Lo_READ_TxStat65To127Lo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x660);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStat65To127Hi' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStat65To127Hi_READ_TxStat65To127Hi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x664);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStat128To255Lo' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStat128To255Lo_READ_TxStat128To255Lo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x668);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStat128To255Hi' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStat128To255Hi_READ_TxStat128To255Hi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x66C);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStat256To511Lo' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStat256To511Lo_READ_TxStat256To511Lo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x670);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStat256To511Hi' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStat256To511Hi_READ_TxStat256To511Hi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x674);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStat512To1023Lo' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStat512To1023Lo_READ_TxStat512To1023Lo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x678);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStat512To1023Hi' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStat512To1023Hi_READ_TxStat512To1023Hi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x67C);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStat1024To1518Lo' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStat1024To1518Lo_READ_TxStat1024To1518Lo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x680);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStat1024To1518Hi' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStat1024To1518Hi_READ_TxStat1024To1518Hi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x684);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStat1519ToMaxLo' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStat1519ToMaxLo_READ_TxStat1519ToMaxLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x688);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStat1519ToMaxHi' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStat1519ToMaxHi_READ_TxStat1519ToMaxHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x68C);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatOversizeLo' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatOversizeLo_READ_TxStatOversizeLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x690);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatOversizeHi' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatOversizeHi_READ_TxStatOversizeHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x694);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatMcastDataOkLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatMcastDataOkLo_READ_TxStatMcastDataOkLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x698);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatMcastDataOkHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatMcastDataOkHi_READ_TxStatMcastDataOkHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x69C);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatBcastDataOkLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatBcastDataOkLo_READ_TxStatBcastDataOkLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6A0);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatBcastDataOkHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatBcastDataOkHi_READ_TxStatBcastDataOkHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6A4);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatUcastDataOkLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatUcastDataOkLo_READ_TxStatUcastDataOkLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6A8);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatUcastDataOkHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatUcastDataOkHi_READ_TxStatUcastDataOkHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6AC);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatMcastCtrlOkLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatMcastCtrlOkLo_READ_TxStatMcastCtrlOkLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6B0);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatMcastCtrlOkHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatMcastCtrlOkHi_READ_TxStatMcastCtrlOkHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6B4);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatBcastCtrlOkLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatBcastCtrlOkLo_READ_TxStatBcastCtrlOkLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6B8);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatBcastCtrlOkHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatBcastCtrlOkHi_READ_TxStatBcastCtrlOkHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6BC);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatUcastCtrlOkLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatUcastCtrlOkLo_READ_TxStatUcastCtrlOkLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6C0);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatUcastCtrlOkHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatUcastCtrlOkHi_READ_TxStatUcastCtrlOkHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6C4);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatPauseLo' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatPauseLo_READ_TxStatPauseLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6C8);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatPauseHi' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatPauseHi_READ_TxStatPauseHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6CC);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatRuntLo' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatRuntLo_READ_TxStatRuntLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6D0);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatRuntHi' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatRuntHi_READ_TxStatRuntHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6D4);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatPaylOctsOkLo' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatPaylOctsOkLo_READ_TxStatPaylOctsOkLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6D8);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatPaylOctsOkHi' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatPaylOctsOkHi_READ_TxStatPaylOctsOkHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6DC);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatFrmOctsOkLo' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatFrmOctsOkLo_READ_TxStatFrmOctsOkLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6E0);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatFrmOctsOkHi' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatFrmOctsOkHi_READ_TxStatFrmOctsOkHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6E4);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatConfig' -.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatConfig_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6F0);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatConfig_GET_TxStatReset(UInt32 EthMac25GS10_TxStatConfig)
{
    return EthMac25GS10_TxStatConfig & 0x1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatConfig_GET_ParityErrClr(UInt32 EthMac25GS10_TxStatConfig)
{
    return (EthMac25GS10_TxStatConfig & 0x2) >> 1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatConfig_GET_ShadowReq(UInt32 EthMac25GS10_TxStatConfig)
{
    return (EthMac25GS10_TxStatConfig & 0x4) >> 2;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatConfig_SET_TxStatReset(UInt32 EthMac25GS10_TxStatConfig, UInt32 TxStatReset)
{
    DT_ASSERT((TxStatReset & ~0x1) == 0);
    return (EthMac25GS10_TxStatConfig & ~0x1) | TxStatReset;
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatConfig_SET_ParityErrClr(UInt32 EthMac25GS10_TxStatConfig, UInt32 ParityErrClr)
{
    DT_ASSERT((ParityErrClr & ~0x1) == 0);
    return (EthMac25GS10_TxStatConfig & ~0x2) | (ParityErrClr << 1);
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatConfig_SET_ShadowReq(UInt32 EthMac25GS10_TxStatConfig, UInt32 ShadowReq)
{
    DT_ASSERT((ShadowReq & ~0x1) == 0);
    return (EthMac25GS10_TxStatConfig & ~0x4) | (ShadowReq << 2);
}

// Register WRITE function.
static __inline void EMAC25G_EthMac25GS10_TxStatConfig_WRITE(DtBcEMAC25G* Bc, UInt32 EthMac25GS10_TxStatConfig)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x6F0, EthMac25GS10_TxStatConfig);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_TxStatStatus' -.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatStatus_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6F4);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatStatus_GET_ParityErr(UInt32 EthMac25GS10_TxStatStatus)
{
    return EthMac25GS10_TxStatStatus & 0x1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatStatus_GET_Paused(UInt32 EthMac25GS10_TxStatStatus)
{
    return (EthMac25GS10_TxStatStatus & 0x2) >> 1;
}

// Field READ functions.
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatStatus_READ_ParityErr(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6F4) & 0x1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_TxStatStatus_READ_Paused(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x6F4) & 0x2) >> 1;
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatFragmentsLo' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatFragmentsLo_READ_RxStatFragmentsLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x700);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatFragmentsHi' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatFragmentsHi_READ_RxStatFragmentsHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x704);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatJabbersLo' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatJabbersLo_READ_RxStatJabbersLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x708);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatJabbersHi' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatJabbersHi_READ_RxStatJabbersHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x70C);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatFcsLo' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatFcsLo_READ_RxStatFcsLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x710);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatFcsHi' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatFcsHi_READ_RxStatFcsHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x714);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatCrcErrLo' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatCrcErrLo_READ_RxStatCrcErrLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x718);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatCrcErrHi' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatCrcErrHi_READ_RxStatCrcErrHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x71C);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatMcastDataErrLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatMcastDataErrLo_READ_RxStatMcastDataErrLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x720);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatMcastDataErrHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatMcastDataErrHi_READ_RxStatMcastDataErrHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x724);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatBcastDataErrLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatBcastDataErrLo_READ_RxStatBcastDataErrLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x728);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatBcastDataErrHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatBcastDataErrHi_READ_RxStatBcastDataErrHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x72C);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatUcastDataErrLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatUcastDataErrLo_READ_RxStatUcastDataErrLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x730);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatUCastDataErrHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatUCastDataErrHi_READ_RxStatUCastDataErrHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x734);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatMcastCtrlErrLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatMcastCtrlErrLo_READ_RxStatMcastCtrlErrLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x738);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatMcastCtrlHi' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatMcastCtrlHi_READ_RxStatMcastCtrlHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x73C);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatBcastCtrlErrLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatBcastCtrlErrLo_READ_RxStatBcastCtrlErrLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x740);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatBcastCtrlErrHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatBcastCtrlErrHi_READ_RxStatBcastCtrlErrHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x744);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatUcastCtrlErrLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatUcastCtrlErrLo_READ_RxStatUcastCtrlErrLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x748);
}

// .-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatUcastCtrlErrHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatUcastCtrlErrHi_READ_RxStatUcastCtrlErrHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x74C);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatPauseErrLo' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatPauseErrLo_READ_RxStatPauseErrLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x750);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatPauseErrHi' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatPauseErrHi_READ_RxStatPauseErrHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x754);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStat64bLo' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStat64bLo_READ_RxStat64bLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x758);
}

// -.-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStat64bHi' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStat64bHi_READ_RxStat64bHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x75C);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStat65To127Lo' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStat65To127Lo_READ_RxStat65To127Lo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x760);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStat65To127Hi' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStat65To127Hi_READ_RxStat65To127Hi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x764);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStat128To255Lo' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStat128To255Lo_READ_RxStat128To255Lo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x768);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStat128To255Hi' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStat128To255Hi_READ_RxStat128To255Hi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x76C);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStat256To511Lo' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStat256To511Lo_READ_RxStat256To511Lo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x770);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStat256To511Hi' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStat256To511Hi_READ_RxStat256To511Hi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x774);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStat512To1023Lo' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStat512To1023Lo_READ_RxStat512To1023Lo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x778);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStat512To1023Hi' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStat512To1023Hi_READ_RxStat512To1023Hi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x77C);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStat1024To1518Lo' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStat1024To1518Lo_READ_RxStat1024To1518Lo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x780);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStat1024To1518Hi' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStat1024To1518Hi_READ_RxStat1024To1518Hi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x784);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStat1519ToMaxLo' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStat1519ToMaxLo_READ_RxStat1519ToMaxLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x788);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStat1519ToMaxHi' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStat1519ToMaxHi_READ_RxStat1519ToMaxHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x78C);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatOversizeLo' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatOversizeLo_READ_RxStatOversizeLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x790);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatOversizeHi' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatOversizeHi_READ_RxStatOversizeHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x794);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatMcastDataOkLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatMcastDataOkLo_READ_RxStatMcastDataOkLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x798);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatMcastDataOkHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatMcastDataOkHi_READ_RxStatMcastDataOkHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x79C);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatBcastDataOkLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatBcastDataOkLo_READ_RxStatBcastDataOkLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7A0);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatBcastDataOkHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatBcastDataOkHi_READ_RxStatBcastDataOkHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7A4);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatUcastDataOkLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatUcastDataOkLo_READ_RxStatUcastDataOkLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7A8);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatUcastDataOkHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatUcastDataOkHi_READ_RxStatUcastDataOkHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7AC);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatMcastCtrlOkLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatMcastCtrlOkLo_READ_RxStatMcastCtrlOkLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7B0);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatMcastCtrlOkHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatMcastCtrlOkHi_READ_RxStatMcastCtrlOkHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7B4);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatBcastCtrlOkLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatBcastCtrlOkLo_READ_RxStatBcastCtrlOkLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7B8);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatBcastCtrlOkHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatBcastCtrlOkHi_READ_RxStatBcastCtrlOkHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7BC);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatUcastCtrlOkLo' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatUcastCtrlOkLo_READ_RxStatUcastCtrlOkLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7C0);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatUcastCtrlOkHi' -.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatUcastCtrlOkHi_READ_RxStatUcastCtrlOkHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7C4);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatPauseLo' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatPauseLo_READ_RxStatPauseLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7C8);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatPauseHi' -.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatPauseHi_READ_RxStatPauseHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7CC);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatRuntLo' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatRuntLo_READ_RxStatRuntLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7D0);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatRuntHi' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatRuntHi_READ_RxStatRuntHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7D4);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatPaylOctsOkLo' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatPaylOctsOkLo_READ_RxStatPaylOctsOkLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7D8);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatPaylOctsOkHi' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatPaylOctsOkHi_READ_RxStatPaylOctsOkHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7DC);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatFrmOctsOkLo' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatFrmOctsOkLo_READ_RxStatFrmOctsOkLo(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7E0);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatFrmOctsOkHi' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatFrmOctsOkHi_READ_RxStatFrmOctsOkHi(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7E4);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatConfig' -.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatConfig_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7F0);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatConfig_GET_RxStatReset(UInt32 EthMac25GS10_RxStatConfig)
{
    return EthMac25GS10_RxStatConfig & 0x1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatConfig_GET_ParityErrClr(UInt32 EthMac25GS10_RxStatConfig)
{
    return (EthMac25GS10_RxStatConfig & 0x2) >> 1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatConfig_GET_ShadowReq(UInt32 EthMac25GS10_RxStatConfig)
{
    return (EthMac25GS10_RxStatConfig & 0x4) >> 2;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatConfig_SET_RxStatReset(UInt32 EthMac25GS10_RxStatConfig, UInt32 RxStatReset)
{
    DT_ASSERT((RxStatReset & ~0x1) == 0);
    return (EthMac25GS10_RxStatConfig & ~0x1) | RxStatReset;
}
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatConfig_SET_ParityErrClr(UInt32 EthMac25GS10_RxStatConfig, UInt32 ParityErrClr)
{
    DT_ASSERT((ParityErrClr & ~0x1) == 0);
    return (EthMac25GS10_RxStatConfig & ~0x2) | (ParityErrClr << 1);
}
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatConfig_SET_ShadowReq(UInt32 EthMac25GS10_RxStatConfig, UInt32 ShadowReq)
{
    DT_ASSERT((ShadowReq & ~0x1) == 0);
    return (EthMac25GS10_RxStatConfig & ~0x4) | (ShadowReq << 2);
}

// Register WRITE function.
static __inline void EMAC25G_EthMac25GS10_RxStatConfig_WRITE(DtBcEMAC25G* Bc, UInt32 EthMac25GS10_RxStatConfig)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x7F0, EthMac25GS10_RxStatConfig);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'EthMac25GS10_RxStatStatus' -.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatStatus_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7F4);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatStatus_GET_ParityErr(UInt32 EthMac25GS10_RxStatStatus)
{
    return EthMac25GS10_RxStatStatus & 0x1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatStatus_GET_Paused(UInt32 EthMac25GS10_RxStatStatus)
{
    return (EthMac25GS10_RxStatStatus & 0x2) >> 1;
}

// Field READ functions.
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatStatus_READ_ParityErr(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x7F4) & 0x1;
}
static __inline UInt32 EMAC25G_EthMac25GS10_RxStatStatus_READ_Paused(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x7F4) & 0x2) >> 1;
}

// .-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PmaArbitrationControl' -.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PmaArbitrationControl_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x800);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PmaArbitrationControl_GET_PcsArbiterCtrl(UInt32 EthTransc25GS10Shim_PmaArbitrationControl)
{
    return EthTransc25GS10Shim_PmaArbitrationControl & 0x1;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PmaArbitrationControl_GET_PcsCalDone(UInt32 EthTransc25GS10Shim_PmaArbitrationControl)
{
    return (EthTransc25GS10Shim_PmaArbitrationControl & 0x2) >> 1;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PmaArbitrationControl_SET_PcsArbiterCtrl(UInt32 EthTransc25GS10Shim_PmaArbitrationControl, UInt32 PcsArbiterCtrl)
{
    DT_ASSERT((PcsArbiterCtrl & ~0x1) == 0);
    return (EthTransc25GS10Shim_PmaArbitrationControl & ~0x1) | PcsArbiterCtrl;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PmaArbitrationControl_SET_PcsCalDone(UInt32 EthTransc25GS10Shim_PmaArbitrationControl, UInt32 PcsCalDone)
{
    DT_ASSERT((PcsCalDone & ~0x1) == 0);
    return (EthTransc25GS10Shim_PmaArbitrationControl & ~0x2) | (PcsCalDone << 1);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PmaArbitrationControl_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PmaArbitrationControl)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x800, EthTransc25GS10Shim_PmaArbitrationControl);
}

// .-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PmaCalibrationControl' -.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PmaCalibrationControl_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x804);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PmaCalibrationControl_GET_PmCr2TxRxUcRxCal(UInt32 EthTransc25GS10Shim_PmaCalibrationControl)
{
    return EthTransc25GS10Shim_PmaCalibrationControl & 0x1;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PmaCalibrationControl_GET_UxTxCal(UInt32 EthTransc25GS10Shim_PmaCalibrationControl)
{
    return (EthTransc25GS10Shim_PmaCalibrationControl & 0x2) >> 1;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PmaCalibrationControl_GET_PreReconfig(UInt32 EthTransc25GS10Shim_PmaCalibrationControl)
{
    return (EthTransc25GS10Shim_PmaCalibrationControl & 0x4) >> 2;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PmaCalibrationControl_SET_PmCr2TxRxUcRxCal(UInt32 EthTransc25GS10Shim_PmaCalibrationControl, UInt32 PmCr2TxRxUcRxCal)
{
    DT_ASSERT((PmCr2TxRxUcRxCal & ~0x1) == 0);
    return (EthTransc25GS10Shim_PmaCalibrationControl & ~0x1) | PmCr2TxRxUcRxCal;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PmaCalibrationControl_SET_UxTxCal(UInt32 EthTransc25GS10Shim_PmaCalibrationControl, UInt32 UxTxCal)
{
    DT_ASSERT((UxTxCal & ~0x1) == 0);
    return (EthTransc25GS10Shim_PmaCalibrationControl & ~0x2) | (UxTxCal << 1);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PmaCalibrationControl_SET_PreReconfig(UInt32 EthTransc25GS10Shim_PmaCalibrationControl, UInt32 PreReconfig)
{
    DT_ASSERT((PreReconfig & ~0x1) == 0);
    return (EthTransc25GS10Shim_PmaCalibrationControl & ~0x4) | (PreReconfig << 2);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PmaCalibrationControl_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PmaCalibrationControl)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x804, EthTransc25GS10Shim_PmaCalibrationControl);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg106' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg106_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x808);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg106_GET_PmaTxBufDccFinestepEnin(UInt32 EthTransc25GS10Shim_PhyReg106)
{
    return (EthTransc25GS10Shim_PhyReg106 & 0x8) >> 3;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg106_SET_PmaTxBufDccFinestepEnin(UInt32 EthTransc25GS10Shim_PhyReg106, UInt32 PmaTxBufDccFinestepEnin)
{
    DT_ASSERT((PmaTxBufDccFinestepEnin & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg106 & ~0x8) | (PmaTxBufDccFinestepEnin << 3);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg106_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg106)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x808, EthTransc25GS10Shim_PhyReg106);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg108' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg108_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x80C);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg108_GET_PmaTxBufTermSel(UInt32 EthTransc25GS10Shim_PhyReg108)
{
    return (EthTransc25GS10Shim_PhyReg108 & 0x20) >> 5;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg108_SET_PmaTxBufTermSel(UInt32 EthTransc25GS10Shim_PhyReg108, UInt32 PmaTxBufTermSel)
{
    DT_ASSERT((PmaTxBufTermSel & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg108 & ~0x20) | (PmaTxBufTermSel << 5);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg108_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg108)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x80C, EthTransc25GS10Shim_PhyReg108);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg111' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg111_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x810);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg111_GET_X1ClockSourceSelect(UInt32 EthTransc25GS10Shim_PhyReg111)
{
    return EthTransc25GS10Shim_PhyReg111 & 0x1F;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg111_GET_XnClockSourceSelect(UInt32 EthTransc25GS10Shim_PhyReg111)
{
    return (EthTransc25GS10Shim_PhyReg111 & 0xE0) >> 5;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg111_SET_X1ClockSourceSelect(UInt32 EthTransc25GS10Shim_PhyReg111, UInt32 X1ClockSourceSelect)
{
    DT_ASSERT((X1ClockSourceSelect & ~0x1F) == 0);
    return (EthTransc25GS10Shim_PhyReg111 & ~0x1F) | X1ClockSourceSelect;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg111_SET_XnClockSourceSelect(UInt32 EthTransc25GS10Shim_PhyReg111, UInt32 XnClockSourceSelect)
{
    DT_ASSERT((XnClockSourceSelect & ~0x7) == 0);
    return (EthTransc25GS10Shim_PhyReg111 & ~0xE0) | (XnClockSourceSelect << 5);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg111_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg111)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x810, EthTransc25GS10Shim_PhyReg111);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg117' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg117_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x814);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg117_GET_Scratch0X1ClockSrc(UInt32 EthTransc25GS10Shim_PhyReg117)
{
    return EthTransc25GS10Shim_PhyReg117 & 0xF;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg117_GET_Scratch1X1ClockSrc(UInt32 EthTransc25GS10Shim_PhyReg117)
{
    return (EthTransc25GS10Shim_PhyReg117 & 0xF0) >> 4;
}

// Field READ functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg117_READ_Scratch0X1ClockSrc(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x814) & 0xF;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg117_READ_Scratch1X1ClockSrc(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x814) & 0xF0) >> 4;
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg11A' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11A_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x818);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11A_GET_PmaRxBufVgaDcGainLow(UInt32 EthTransc25GS10Shim_PhyReg11A)
{
    return EthTransc25GS10Shim_PhyReg11A & 0xF;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11A_GET_PmaRxBufCtleAcGain(UInt32 EthTransc25GS10Shim_PhyReg11A)
{
    return (EthTransc25GS10Shim_PhyReg11A & 0xF0) >> 4;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11A_SET_PmaRxBufVgaDcGainLow(UInt32 EthTransc25GS10Shim_PhyReg11A, UInt32 PmaRxBufVgaDcGainLow)
{
    DT_ASSERT((PmaRxBufVgaDcGainLow & ~0xF) == 0);
    return (EthTransc25GS10Shim_PhyReg11A & ~0xF) | PmaRxBufVgaDcGainLow;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11A_SET_PmaRxBufCtleAcGain(UInt32 EthTransc25GS10Shim_PhyReg11A, UInt32 PmaRxBufCtleAcGain)
{
    DT_ASSERT((PmaRxBufCtleAcGain & ~0xF) == 0);
    return (EthTransc25GS10Shim_PhyReg11A & ~0xF0) | (PmaRxBufCtleAcGain << 4);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg11A_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg11A)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x818, EthTransc25GS10Shim_PhyReg11A);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg11C' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11C_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x81C);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11C_GET_PmaRxBufCtleEqGainLow(UInt32 EthTransc25GS10Shim_PhyReg11C)
{
    return EthTransc25GS10Shim_PhyReg11C & 0x1F;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11C_GET_PmaRxBufTermSel(UInt32 EthTransc25GS10Shim_PhyReg11C)
{
    return (EthTransc25GS10Shim_PhyReg11C & 0xE0) >> 5;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11C_SET_PmaRxBufCtleEqGainLow(UInt32 EthTransc25GS10Shim_PhyReg11C, UInt32 PmaRxBufCtleEqGainLow)
{
    DT_ASSERT((PmaRxBufCtleEqGainLow & ~0x1F) == 0);
    return (EthTransc25GS10Shim_PhyReg11C & ~0x1F) | PmaRxBufCtleEqGainLow;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11C_SET_PmaRxBufTermSel(UInt32 EthTransc25GS10Shim_PhyReg11C, UInt32 PmaRxBufTermSel)
{
    DT_ASSERT((PmaRxBufTermSel & ~0x7) == 0);
    return (EthTransc25GS10Shim_PhyReg11C & ~0xE0) | (PmaRxBufTermSel << 5);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg11C_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg11C)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x81C, EthTransc25GS10Shim_PhyReg11C);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg11D' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11D_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x820);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11D_GET_LoopbackMode5(UInt32 EthTransc25GS10Shim_PhyReg11D)
{
    return EthTransc25GS10Shim_PhyReg11D & 0x1;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11D_SET_LoopbackMode5(UInt32 EthTransc25GS10Shim_PhyReg11D, UInt32 LoopbackMode5)
{
    DT_ASSERT((LoopbackMode5 & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg11D & ~0x1) | LoopbackMode5;
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg11D_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg11D)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x820, EthTransc25GS10Shim_PhyReg11D);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg11E' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11E_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x824);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11E_GET_PmaRxBufVgaHalfbwEn(UInt32 EthTransc25GS10Shim_PhyReg11E)
{
    return (EthTransc25GS10Shim_PhyReg11E & 0x20) >> 5;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11E_GET_PmaRxBufCtleEqGainHigh(UInt32 EthTransc25GS10Shim_PhyReg11E)
{
    return (EthTransc25GS10Shim_PhyReg11E & 0x80) >> 7;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11E_SET_PmaRxBufVgaHalfbwEn(UInt32 EthTransc25GS10Shim_PhyReg11E, UInt32 PmaRxBufVgaHalfbwEn)
{
    DT_ASSERT((PmaRxBufVgaHalfbwEn & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg11E & ~0x20) | (PmaRxBufVgaHalfbwEn << 5);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11E_SET_PmaRxBufCtleEqGainHigh(UInt32 EthTransc25GS10Shim_PhyReg11E, UInt32 PmaRxBufCtleEqGainHigh)
{
    DT_ASSERT((PmaRxBufCtleEqGainHigh & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg11E & ~0x80) | (PmaRxBufCtleEqGainHigh << 7);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg11E_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg11E)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x824, EthTransc25GS10Shim_PhyReg11E);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg11F' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11F_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x828);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11F_GET_PmaRxBufVgaDcGainHigh(UInt32 EthTransc25GS10Shim_PhyReg11F)
{
    return EthTransc25GS10Shim_PhyReg11F & 0x1;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11F_GET_PmaRxBufEqBwSel(UInt32 EthTransc25GS10Shim_PhyReg11F)
{
    return (EthTransc25GS10Shim_PhyReg11F & 0x30) >> 4;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11F_GET_PmaRxBufRxLfeqEnable(UInt32 EthTransc25GS10Shim_PhyReg11F)
{
    return (EthTransc25GS10Shim_PhyReg11F & 0x40) >> 6;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11F_SET_PmaRxBufVgaDcGainHigh(UInt32 EthTransc25GS10Shim_PhyReg11F, UInt32 PmaRxBufVgaDcGainHigh)
{
    DT_ASSERT((PmaRxBufVgaDcGainHigh & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg11F & ~0x1) | PmaRxBufVgaDcGainHigh;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11F_SET_PmaRxBufEqBwSel(UInt32 EthTransc25GS10Shim_PhyReg11F, UInt32 PmaRxBufEqBwSel)
{
    DT_ASSERT((PmaRxBufEqBwSel & ~0x3) == 0);
    return (EthTransc25GS10Shim_PhyReg11F & ~0x30) | (PmaRxBufEqBwSel << 4);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg11F_SET_PmaRxBufRxLfeqEnable(UInt32 EthTransc25GS10Shim_PhyReg11F, UInt32 PmaRxBufRxLfeqEnable)
{
    DT_ASSERT((PmaRxBufRxLfeqEnable & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg11F & ~0x40) | (PmaRxBufRxLfeqEnable << 6);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg11F_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg11F)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x828, EthTransc25GS10Shim_PhyReg11F);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg121' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg121_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x82C);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg121_GET_PmaRxBufConstGmEn(UInt32 EthTransc25GS10Shim_PhyReg121)
{
    return (EthTransc25GS10Shim_PhyReg121 & 0x30) >> 4;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg121_SET_PmaRxBufConstGmEn(UInt32 EthTransc25GS10Shim_PhyReg121, UInt32 PmaRxBufConstGmEn)
{
    DT_ASSERT((PmaRxBufConstGmEn & ~0x3) == 0);
    return (EthTransc25GS10Shim_PhyReg121 & ~0x30) | (PmaRxBufConstGmEn << 4);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg121_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg121)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x82C, EthTransc25GS10Shim_PhyReg121);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg12D' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg12D_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x830);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg12D_GET_PmaRxDfeLatchXcoupleDisable(UInt32 EthTransc25GS10Shim_PhyReg12D)
{
    return (EthTransc25GS10Shim_PhyReg12D & 0x20) >> 5;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg12D_SET_PmaRxDfeLatchXcoupleDisable(UInt32 EthTransc25GS10Shim_PhyReg12D, UInt32 PmaRxDfeLatchXcoupleDisable)
{
    DT_ASSERT((PmaRxDfeLatchXcoupleDisable & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg12D & ~0x20) | (PmaRxDfeLatchXcoupleDisable << 5);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg12D_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg12D)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x830, EthTransc25GS10Shim_PhyReg12D);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg12E' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg12E_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x834);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg12E_GET_PmaRxBufCtleTiaIsel(UInt32 EthTransc25GS10Shim_PhyReg12E)
{
    return (EthTransc25GS10Shim_PhyReg12E & 0x30) >> 4;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg12E_GET_PmaRxBufEqSel(UInt32 EthTransc25GS10Shim_PhyReg12E)
{
    return (EthTransc25GS10Shim_PhyReg12E & 0xC0) >> 6;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg12E_SET_PmaRxBufCtleTiaIsel(UInt32 EthTransc25GS10Shim_PhyReg12E, UInt32 PmaRxBufCtleTiaIsel)
{
    DT_ASSERT((PmaRxBufCtleTiaIsel & ~0x3) == 0);
    return (EthTransc25GS10Shim_PhyReg12E & ~0x30) | (PmaRxBufCtleTiaIsel << 4);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg12E_SET_PmaRxBufEqSel(UInt32 EthTransc25GS10Shim_PhyReg12E, UInt32 PmaRxBufEqSel)
{
    DT_ASSERT((PmaRxBufEqSel & ~0x3) == 0);
    return (EthTransc25GS10Shim_PhyReg12E & ~0xC0) | (PmaRxBufEqSel << 6);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg12E_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg12E)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x834, EthTransc25GS10Shim_PhyReg12E);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg130' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg130_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x838);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg130_GET_PmaRxDfeTapsumBwSel(UInt32 EthTransc25GS10Shim_PhyReg130)
{
    return (EthTransc25GS10Shim_PhyReg130 & 0xC0) >> 6;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg130_SET_PmaRxDfeTapsumBwSel(UInt32 EthTransc25GS10Shim_PhyReg130, UInt32 PmaRxDfeTapsumBwSel)
{
    DT_ASSERT((PmaRxDfeTapsumBwSel & ~0x3) == 0);
    return (EthTransc25GS10Shim_PhyReg130 & ~0xC0) | (PmaRxDfeTapsumBwSel << 6);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg130_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg130)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x838, EthTransc25GS10Shim_PhyReg130);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg132' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg132_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x83C);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg132_GET_CdrPllSetCdrVcoSpeedFix1(UInt32 EthTransc25GS10Shim_PhyReg132)
{
    return EthTransc25GS10Shim_PhyReg132 & 0xF;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg132_GET_LoopbackMode43(UInt32 EthTransc25GS10Shim_PhyReg132)
{
    return (EthTransc25GS10Shim_PhyReg132 & 0x30) >> 4;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg132_SET_CdrPllSetCdrVcoSpeedFix1(UInt32 EthTransc25GS10Shim_PhyReg132, UInt32 CdrPllSetCdrVcoSpeedFix1)
{
    DT_ASSERT((CdrPllSetCdrVcoSpeedFix1 & ~0xF) == 0);
    return (EthTransc25GS10Shim_PhyReg132 & ~0xF) | CdrPllSetCdrVcoSpeedFix1;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg132_SET_LoopbackMode43(UInt32 EthTransc25GS10Shim_PhyReg132, UInt32 LoopbackMode43)
{
    DT_ASSERT((LoopbackMode43 & ~0x3) == 0);
    return (EthTransc25GS10Shim_PhyReg132 & ~0x30) | (LoopbackMode43 << 4);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg132_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg132)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x83C, EthTransc25GS10Shim_PhyReg132);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg135' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg135_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x840);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg135_GET_CdrPllLfResistorPfd(UInt32 EthTransc25GS10Shim_PhyReg135)
{
    return EthTransc25GS10Shim_PhyReg135 & 0x3;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg135_SET_CdrPllLfResistorPfd(UInt32 EthTransc25GS10Shim_PhyReg135, UInt32 CdrPllLfResistorPfd)
{
    DT_ASSERT((CdrPllLfResistorPfd & ~0x3) == 0);
    return (EthTransc25GS10Shim_PhyReg135 & ~0x3) | CdrPllLfResistorPfd;
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg135_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg135)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x840, EthTransc25GS10Shim_PhyReg135);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg136' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg136_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x844);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg136_GET_CdrPllSetCdrVcoSpeedFix2(UInt32 EthTransc25GS10Shim_PhyReg136)
{
    return EthTransc25GS10Shim_PhyReg136 & 0xF;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg136_SET_CdrPllSetCdrVcoSpeedFix2(UInt32 EthTransc25GS10Shim_PhyReg136, UInt32 CdrPllSetCdrVcoSpeedFix2)
{
    DT_ASSERT((CdrPllSetCdrVcoSpeedFix2 & ~0xF) == 0);
    return (EthTransc25GS10Shim_PhyReg136 & ~0xF) | CdrPllSetCdrVcoSpeedFix2;
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg136_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg136)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x844, EthTransc25GS10Shim_PhyReg136);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg137' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg137_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x848);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg137_GET_CdrPllSetCdrVcoSpeed(UInt32 EthTransc25GS10Shim_PhyReg137)
{
    return (EthTransc25GS10Shim_PhyReg137 & 0x3C) >> 2;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg137_GET_LoopbackMode2(UInt32 EthTransc25GS10Shim_PhyReg137)
{
    return (EthTransc25GS10Shim_PhyReg137 & 0x80) >> 7;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg137_SET_CdrPllSetCdrVcoSpeed(UInt32 EthTransc25GS10Shim_PhyReg137, UInt32 CdrPllSetCdrVcoSpeed)
{
    DT_ASSERT((CdrPllSetCdrVcoSpeed & ~0xF) == 0);
    return (EthTransc25GS10Shim_PhyReg137 & ~0x3C) | (CdrPllSetCdrVcoSpeed << 2);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg137_SET_LoopbackMode2(UInt32 EthTransc25GS10Shim_PhyReg137, UInt32 LoopbackMode2)
{
    DT_ASSERT((LoopbackMode2 & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg137 & ~0x80) | (LoopbackMode2 << 7);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg137_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg137)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x848, EthTransc25GS10Shim_PhyReg137);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg139' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg139_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x84C);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg139_GET_CdrPllChgpmpCurrentPfd(UInt32 EthTransc25GS10Shim_PhyReg139)
{
    return EthTransc25GS10Shim_PhyReg139 & 0x7;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg139_SET_CdrPllChgpmpCurrentPfd(UInt32 EthTransc25GS10Shim_PhyReg139, UInt32 CdrPllChgpmpCurrentPfd)
{
    DT_ASSERT((CdrPllChgpmpCurrentPfd & ~0x7) == 0);
    return (EthTransc25GS10Shim_PhyReg139 & ~0x7) | CdrPllChgpmpCurrentPfd;
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg139_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg139)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x84C, EthTransc25GS10Shim_PhyReg139);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg13A' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg13A_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x850);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg13A_GET_CdrPllPdLCounter(UInt32 EthTransc25GS10Shim_PhyReg13A)
{
    return (EthTransc25GS10Shim_PhyReg13A & 0x38) >> 3;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg13A_SET_CdrPllPdLCounter(UInt32 EthTransc25GS10Shim_PhyReg13A, UInt32 CdrPllPdLCounter)
{
    DT_ASSERT((CdrPllPdLCounter & ~0x7) == 0);
    return (EthTransc25GS10Shim_PhyReg13A & ~0x38) | (CdrPllPdLCounter << 3);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg13A_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg13A)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x850, EthTransc25GS10Shim_PhyReg13A);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg13B' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg13B_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x854);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg13B_GET_CdrPllMcntDiv(UInt32 EthTransc25GS10Shim_PhyReg13B)
{
    return EthTransc25GS10Shim_PhyReg13B & 0xFF;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg13B_SET_CdrPllMcntDiv(UInt32 EthTransc25GS10Shim_PhyReg13B, UInt32 CdrPllMcntDiv)
{
    DT_ASSERT((CdrPllMcntDiv & ~0xFF) == 0);
    return (EthTransc25GS10Shim_PhyReg13B & ~0xFF) | CdrPllMcntDiv;
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg13B_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg13B)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x854, EthTransc25GS10Shim_PhyReg13B);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg142' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg142_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x858);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg142_GET_LoopbackMode0(UInt32 EthTransc25GS10Shim_PhyReg142)
{
    return (EthTransc25GS10Shim_PhyReg142 & 0x10) >> 4;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg142_SET_LoopbackMode0(UInt32 EthTransc25GS10Shim_PhyReg142, UInt32 LoopbackMode0)
{
    DT_ASSERT((LoopbackMode0 & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg142 & ~0x10) | (LoopbackMode0 << 4);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg142_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg142)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x858, EthTransc25GS10Shim_PhyReg142);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg144' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg144_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x85C);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg144_GET_LoopbackMode1(UInt32 EthTransc25GS10Shim_PhyReg144)
{
    return (EthTransc25GS10Shim_PhyReg144 & 0x2) >> 1;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg144_GET_PmaRxOdiMonitorBwSel1(UInt32 EthTransc25GS10Shim_PhyReg144)
{
    return (EthTransc25GS10Shim_PhyReg144 & 0x80) >> 7;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg144_SET_LoopbackMode1(UInt32 EthTransc25GS10Shim_PhyReg144, UInt32 LoopbackMode1)
{
    DT_ASSERT((LoopbackMode1 & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg144 & ~0x2) | (LoopbackMode1 << 1);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg144_SET_PmaRxOdiMonitorBwSel1(UInt32 EthTransc25GS10Shim_PhyReg144, UInt32 PmaRxOdiMonitorBwSel1)
{
    DT_ASSERT((PmaRxOdiMonitorBwSel1 & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg144 & ~0x80) | (PmaRxOdiMonitorBwSel1 << 7);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg144_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg144)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x85C, EthTransc25GS10Shim_PhyReg144);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg145' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg145_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x860);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg145_GET_PmaRxOdiMonitorBwSel2(UInt32 EthTransc25GS10Shim_PhyReg145)
{
    return (EthTransc25GS10Shim_PhyReg145 & 0x80) >> 7;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg145_SET_PmaRxOdiMonitorBwSel2(UInt32 EthTransc25GS10Shim_PhyReg145, UInt32 PmaRxOdiMonitorBwSel2)
{
    DT_ASSERT((PmaRxOdiMonitorBwSel2 & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg145 & ~0x80) | (PmaRxOdiMonitorBwSel2 << 7);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg145_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg145)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x860, EthTransc25GS10Shim_PhyReg145);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg151' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg151_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x864);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg151_GET_PmaRxBufEqCdgenSel(UInt32 EthTransc25GS10Shim_PhyReg151)
{
    return (EthTransc25GS10Shim_PhyReg151 & 0x80) >> 7;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg151_SET_PmaRxBufEqCdgenSel(UInt32 EthTransc25GS10Shim_PhyReg151, UInt32 PmaRxBufEqCdgenSel)
{
    DT_ASSERT((PmaRxBufEqCdgenSel & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg151 & ~0x80) | (PmaRxBufEqCdgenSel << 7);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg151_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg151)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x864, EthTransc25GS10Shim_PhyReg151);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg154' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg154_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x868);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg154_GET_PmaRxOdiVregVoltageSel(UInt32 EthTransc25GS10Shim_PhyReg154)
{
    return (EthTransc25GS10Shim_PhyReg154 & 0xC0) >> 6;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg154_SET_PmaRxOdiVregVoltageSel(UInt32 EthTransc25GS10Shim_PhyReg154, UInt32 PmaRxOdiVregVoltageSel)
{
    DT_ASSERT((PmaRxOdiVregVoltageSel & ~0x3) == 0);
    return (EthTransc25GS10Shim_PhyReg154 & ~0xC0) | (PmaRxOdiVregVoltageSel << 6);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg154_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg154)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x868, EthTransc25GS10Shim_PhyReg154);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg160' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg160_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x86C);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg160_GET_PmaAdaptAdpAcCtleInitialValue(UInt32 EthTransc25GS10Shim_PhyReg160)
{
    return EthTransc25GS10Shim_PhyReg160 & 0x3;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg160_GET_PmaAdaptAdpDcCtleInitialValue(UInt32 EthTransc25GS10Shim_PhyReg160)
{
    return (EthTransc25GS10Shim_PhyReg160 & 0xC) >> 2;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg160_SET_PmaAdaptAdpAcCtleInitialValue(UInt32 EthTransc25GS10Shim_PhyReg160, UInt32 PmaAdaptAdpAcCtleInitialValue)
{
    DT_ASSERT((PmaAdaptAdpAcCtleInitialValue & ~0x3) == 0);
    return (EthTransc25GS10Shim_PhyReg160 & ~0x3) | PmaAdaptAdpAcCtleInitialValue;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg160_SET_PmaAdaptAdpDcCtleInitialValue(UInt32 EthTransc25GS10Shim_PhyReg160, UInt32 PmaAdaptAdpDcCtleInitialValue)
{
    DT_ASSERT((PmaAdaptAdpDcCtleInitialValue & ~0x3) == 0);
    return (EthTransc25GS10Shim_PhyReg160 & ~0xC) | (PmaAdaptAdpDcCtleInitialValue << 2);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg160_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg160)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x86C, EthTransc25GS10Shim_PhyReg160);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg162' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg162_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x870);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg162_GET_PmaAdaptAdpDfeTap1InitialValue(UInt32 EthTransc25GS10Shim_PhyReg162)
{
    return (EthTransc25GS10Shim_PhyReg162 & 0x30) >> 4;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg162_SET_PmaAdaptAdpDfeTap1InitialValue(UInt32 EthTransc25GS10Shim_PhyReg162, UInt32 PmaAdaptAdpDfeTap1InitialValue)
{
    DT_ASSERT((PmaAdaptAdpDfeTap1InitialValue & ~0x3) == 0);
    return (EthTransc25GS10Shim_PhyReg162 & ~0x30) | (PmaAdaptAdpDfeTap1InitialValue << 4);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg162_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg162)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x870, EthTransc25GS10Shim_PhyReg162);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg165' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg165_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x874);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg165_GET_PmaAdaptAdpDcCtleMode2H2Limit(UInt32 EthTransc25GS10Shim_PhyReg165)
{
    return (EthTransc25GS10Shim_PhyReg165 & 0x1E) >> 1;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg165_SET_PmaAdaptAdpDcCtleMode2H2Limit(UInt32 EthTransc25GS10Shim_PhyReg165, UInt32 PmaAdaptAdpDcCtleMode2H2Limit)
{
    DT_ASSERT((PmaAdaptAdpDcCtleMode2H2Limit & ~0xF) == 0);
    return (EthTransc25GS10Shim_PhyReg165 & ~0x1E) | (PmaAdaptAdpDcCtleMode2H2Limit << 1);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg165_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg165)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x874, EthTransc25GS10Shim_PhyReg165);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg167' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg167_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x878);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg167_GET_PmaAdaptAdpVgaInitialValue(UInt32 EthTransc25GS10Shim_PhyReg167)
{
    return EthTransc25GS10Shim_PhyReg167 & 0x3;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg167_SET_PmaAdaptAdpVgaInitialValue(UInt32 EthTransc25GS10Shim_PhyReg167, UInt32 PmaAdaptAdpVgaInitialValue)
{
    DT_ASSERT((PmaAdaptAdpVgaInitialValue & ~0x3) == 0);
    return (EthTransc25GS10Shim_PhyReg167 & ~0x3) | PmaAdaptAdpVgaInitialValue;
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg167_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg167)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x878, EthTransc25GS10Shim_PhyReg167);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg22E' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg22E_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x87C);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg22E_GET_HssiAibcrTxAibDllStrAlignDyCtlsel(UInt32 EthTransc25GS10Shim_PhyReg22E)
{
    return (EthTransc25GS10Shim_PhyReg22E & 0x4) >> 2;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg22E_SET_HssiAibcrTxAibDllStrAlignDyCtlsel(UInt32 EthTransc25GS10Shim_PhyReg22E, UInt32 HssiAibcrTxAibDllStrAlignDyCtlsel)
{
    DT_ASSERT((HssiAibcrTxAibDllStrAlignDyCtlsel & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg22E & ~0x4) | (HssiAibcrTxAibDllStrAlignDyCtlsel << 2);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg22E_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg22E)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x87C, EthTransc25GS10Shim_PhyReg22E);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg230' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg230_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x880);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg230_GET_HssiAibcrRxAibRxDccByp(UInt32 EthTransc25GS10Shim_PhyReg230)
{
    return (EthTransc25GS10Shim_PhyReg230 & 0x8) >> 3;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg230_GET_HssiAibcrRxDccEn(UInt32 EthTransc25GS10Shim_PhyReg230)
{
    return (EthTransc25GS10Shim_PhyReg230 & 0x10) >> 4;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg230_SET_HssiAibcrRxAibRxDccByp(UInt32 EthTransc25GS10Shim_PhyReg230, UInt32 HssiAibcrRxAibRxDccByp)
{
    DT_ASSERT((HssiAibcrRxAibRxDccByp & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg230 & ~0x8) | (HssiAibcrRxAibRxDccByp << 3);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg230_SET_HssiAibcrRxDccEn(UInt32 EthTransc25GS10Shim_PhyReg230, UInt32 HssiAibcrRxDccEn)
{
    DT_ASSERT((HssiAibcrRxDccEn & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg230 & ~0x10) | (HssiAibcrRxDccEn << 4);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg230_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg230)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x880, EthTransc25GS10Shim_PhyReg230);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg32C' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg32C_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x884);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg32C_GET_HssiAibndRxAibDllstrAlignDyCtlsel(UInt32 EthTransc25GS10Shim_PhyReg32C)
{
    return (EthTransc25GS10Shim_PhyReg32C & 0x4) >> 2;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg32C_SET_HssiAibndRxAibDllstrAlignDyCtlsel(UInt32 EthTransc25GS10Shim_PhyReg32C, UInt32 HssiAibndRxAibDllstrAlignDyCtlsel)
{
    DT_ASSERT((HssiAibndRxAibDllstrAlignDyCtlsel & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg32C & ~0x4) | (HssiAibndRxAibDllstrAlignDyCtlsel << 2);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg32C_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg32C)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x884, EthTransc25GS10Shim_PhyReg32C);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg32E' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg32E_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x888);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg32E_GET_HssiAibndTxAibTxDccByp(UInt32 EthTransc25GS10Shim_PhyReg32E)
{
    return (EthTransc25GS10Shim_PhyReg32E & 0x8) >> 3;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg32E_GET_HssiAibndTxDccEn(UInt32 EthTransc25GS10Shim_PhyReg32E)
{
    return (EthTransc25GS10Shim_PhyReg32E & 0x10) >> 4;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg32E_SET_HssiAibndTxAibTxDccByp(UInt32 EthTransc25GS10Shim_PhyReg32E, UInt32 HssiAibndTxAibTxDccByp)
{
    DT_ASSERT((HssiAibndTxAibTxDccByp & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg32E & ~0x8) | (HssiAibndTxAibTxDccByp << 3);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg32E_SET_HssiAibndTxDccEn(UInt32 EthTransc25GS10Shim_PhyReg32E, UInt32 HssiAibndTxDccEn)
{
    DT_ASSERT((HssiAibndTxDccEn & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg32E & ~0x10) | (HssiAibndTxDccEn << 4);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg32E_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg32E)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x888, EthTransc25GS10Shim_PhyReg32E);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg480' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg480_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x88C);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg480_GET_ChRxIsLockedToData(UInt32 EthTransc25GS10Shim_PhyReg480)
{
    return EthTransc25GS10Shim_PhyReg480 & 0x1;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg480_GET_ChRxIsLockedToRef(UInt32 EthTransc25GS10Shim_PhyReg480)
{
    return (EthTransc25GS10Shim_PhyReg480 & 0x2) >> 1;
}

// Field READ functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg480_READ_ChRxIsLockedToData(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x88C) & 0x1;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg480_READ_ChRxIsLockedToRef(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x88C) & 0x2) >> 1;
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg481' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg481_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x890);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg481_GET_ChTxCalBusy(UInt32 EthTransc25GS10Shim_PhyReg481)
{
    return EthTransc25GS10Shim_PhyReg481 & 0x1;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg481_GET_ChRxCalBusy(UInt32 EthTransc25GS10Shim_PhyReg481)
{
    return (EthTransc25GS10Shim_PhyReg481 & 0x2) >> 1;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg481_GET_ChAvmmBusy(UInt32 EthTransc25GS10Shim_PhyReg481)
{
    return (EthTransc25GS10Shim_PhyReg481 & 0x4) >> 2;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg481_GET_ChTxCalBusyEnable(UInt32 EthTransc25GS10Shim_PhyReg481)
{
    return (EthTransc25GS10Shim_PhyReg481 & 0x10) >> 4;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg481_GET_ChRxCalBusyEnable(UInt32 EthTransc25GS10Shim_PhyReg481)
{
    return (EthTransc25GS10Shim_PhyReg481 & 0x20) >> 5;
}

// Field READ functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg481_READ_ChTxCalBusy(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x890) & 0x1;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg481_READ_ChRxCalBusy(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x890) & 0x2) >> 1;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg481_READ_ChAvmmBusy(DtBcEMAC25G* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x890) & 0x4) >> 2;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg481_SET_ChTxCalBusyEnable(UInt32 EthTransc25GS10Shim_PhyReg481, UInt32 ChTxCalBusyEnable)
{
    DT_ASSERT((ChTxCalBusyEnable & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg481 & ~0x10) | (ChTxCalBusyEnable << 4);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg481_SET_ChRxCalBusyEnable(UInt32 EthTransc25GS10Shim_PhyReg481, UInt32 ChRxCalBusyEnable)
{
    DT_ASSERT((ChRxCalBusyEnable & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg481 & ~0x20) | (ChRxCalBusyEnable << 5);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg481_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg481)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x890, EthTransc25GS10Shim_PhyReg481);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg4E0' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E0_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x894);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E0_GET_ChSetRxLockTodata(UInt32 EthTransc25GS10Shim_PhyReg4E0)
{
    return EthTransc25GS10Shim_PhyReg4E0 & 0x1;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E0_GET_ChSetRxLockToref(UInt32 EthTransc25GS10Shim_PhyReg4E0)
{
    return (EthTransc25GS10Shim_PhyReg4E0 & 0x2) >> 1;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E0_GET_ChOverrideSetRxLocktodata(UInt32 EthTransc25GS10Shim_PhyReg4E0)
{
    return (EthTransc25GS10Shim_PhyReg4E0 & 0x4) >> 2;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E0_GET_ChOverrideSetRxLocktoref(UInt32 EthTransc25GS10Shim_PhyReg4E0)
{
    return (EthTransc25GS10Shim_PhyReg4E0 & 0x8) >> 3;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E0_SET_ChSetRxLockTodata(UInt32 EthTransc25GS10Shim_PhyReg4E0, UInt32 ChSetRxLockTodata)
{
    DT_ASSERT((ChSetRxLockTodata & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg4E0 & ~0x1) | ChSetRxLockTodata;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E0_SET_ChSetRxLockToref(UInt32 EthTransc25GS10Shim_PhyReg4E0, UInt32 ChSetRxLockToref)
{
    DT_ASSERT((ChSetRxLockToref & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg4E0 & ~0x2) | (ChSetRxLockToref << 1);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E0_SET_ChOverrideSetRxLocktodata(UInt32 EthTransc25GS10Shim_PhyReg4E0, UInt32 ChOverrideSetRxLocktodata)
{
    DT_ASSERT((ChOverrideSetRxLocktodata & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg4E0 & ~0x4) | (ChOverrideSetRxLocktodata << 2);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E0_SET_ChOverrideSetRxLocktoref(UInt32 EthTransc25GS10Shim_PhyReg4E0, UInt32 ChOverrideSetRxLocktoref)
{
    DT_ASSERT((ChOverrideSetRxLocktoref & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg4E0 & ~0x8) | (ChOverrideSetRxLocktoref << 3);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg4E0_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg4E0)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x894, EthTransc25GS10Shim_PhyReg4E0);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg4E1' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E1_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x898);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E1_GET_ChRxSerialLpbken(UInt32 EthTransc25GS10Shim_PhyReg4E1)
{
    return EthTransc25GS10Shim_PhyReg4E1 & 0x1;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E1_SET_ChRxSerialLpbken(UInt32 EthTransc25GS10Shim_PhyReg4E1, UInt32 ChRxSerialLpbken)
{
    DT_ASSERT((ChRxSerialLpbken & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg4E1 & ~0x1) | ChRxSerialLpbken;
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg4E1_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg4E1)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x898, EthTransc25GS10Shim_PhyReg4E1);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg4E2' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x89C);
}

// Field GET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_GET_RxAnalogreset(UInt32 EthTransc25GS10Shim_PhyReg4E2)
{
    return EthTransc25GS10Shim_PhyReg4E2 & 0x1;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_GET_RxDigitalreset(UInt32 EthTransc25GS10Shim_PhyReg4E2)
{
    return (EthTransc25GS10Shim_PhyReg4E2 & 0x2) >> 1;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_GET_TxAnalogreset(UInt32 EthTransc25GS10Shim_PhyReg4E2)
{
    return (EthTransc25GS10Shim_PhyReg4E2 & 0x4) >> 2;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_GET_TxDigitalreset(UInt32 EthTransc25GS10Shim_PhyReg4E2)
{
    return (EthTransc25GS10Shim_PhyReg4E2 & 0x8) >> 3;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_GET_OverrideRxAnalogreset(UInt32 EthTransc25GS10Shim_PhyReg4E2)
{
    return (EthTransc25GS10Shim_PhyReg4E2 & 0x10) >> 4;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_GET_OverrideRxDigitalreset(UInt32 EthTransc25GS10Shim_PhyReg4E2)
{
    return (EthTransc25GS10Shim_PhyReg4E2 & 0x20) >> 5;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_GET_OverrideTxAnalogreset(UInt32 EthTransc25GS10Shim_PhyReg4E2)
{
    return (EthTransc25GS10Shim_PhyReg4E2 & 0x40) >> 6;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_GET_OverrideTxDigitalreset(UInt32 EthTransc25GS10Shim_PhyReg4E2)
{
    return (EthTransc25GS10Shim_PhyReg4E2 & 0x80) >> 7;
}

// Field SET functions.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_SET_RxAnalogreset(UInt32 EthTransc25GS10Shim_PhyReg4E2, UInt32 RxAnalogreset)
{
    DT_ASSERT((RxAnalogreset & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg4E2 & ~0x1) | RxAnalogreset;
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_SET_RxDigitalreset(UInt32 EthTransc25GS10Shim_PhyReg4E2, UInt32 RxDigitalreset)
{
    DT_ASSERT((RxDigitalreset & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg4E2 & ~0x2) | (RxDigitalreset << 1);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_SET_TxAnalogreset(UInt32 EthTransc25GS10Shim_PhyReg4E2, UInt32 TxAnalogreset)
{
    DT_ASSERT((TxAnalogreset & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg4E2 & ~0x4) | (TxAnalogreset << 2);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_SET_TxDigitalreset(UInt32 EthTransc25GS10Shim_PhyReg4E2, UInt32 TxDigitalreset)
{
    DT_ASSERT((TxDigitalreset & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg4E2 & ~0x8) | (TxDigitalreset << 3);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_SET_OverrideRxAnalogreset(UInt32 EthTransc25GS10Shim_PhyReg4E2, UInt32 OverrideRxAnalogreset)
{
    DT_ASSERT((OverrideRxAnalogreset & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg4E2 & ~0x10) | (OverrideRxAnalogreset << 4);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_SET_OverrideRxDigitalreset(UInt32 EthTransc25GS10Shim_PhyReg4E2, UInt32 OverrideRxDigitalreset)
{
    DT_ASSERT((OverrideRxDigitalreset & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg4E2 & ~0x20) | (OverrideRxDigitalreset << 5);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_SET_OverrideTxAnalogreset(UInt32 EthTransc25GS10Shim_PhyReg4E2, UInt32 OverrideTxAnalogreset)
{
    DT_ASSERT((OverrideTxAnalogreset & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg4E2 & ~0x40) | (OverrideTxAnalogreset << 6);
}
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg4E2_SET_OverrideTxDigitalreset(UInt32 EthTransc25GS10Shim_PhyReg4E2, UInt32 OverrideTxDigitalreset)
{
    DT_ASSERT((OverrideTxDigitalreset & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg4E2 & ~0x80) | (OverrideTxDigitalreset << 7);
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg4E2_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg4E2)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x89C, EthTransc25GS10Shim_PhyReg4E2);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'EthTransc25GS10Shim_PhyReg542' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg542_READ(DtBcEMAC25G* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x8A0);
}

// Field GET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg542_GET_EnableBackgroundCal(UInt32 EthTransc25GS10Shim_PhyReg542)
{
    return EthTransc25GS10Shim_PhyReg542 & 0x1;
}

// Field SET function.
static __inline UInt32 EMAC25G_EthTransc25GS10Shim_PhyReg542_SET_EnableBackgroundCal(UInt32 EthTransc25GS10Shim_PhyReg542, UInt32 EnableBackgroundCal)
{
    DT_ASSERT((EnableBackgroundCal & ~0x1) == 0);
    return (EthTransc25GS10Shim_PhyReg542 & ~0x1) | EnableBackgroundCal;
}

// Register WRITE function.
static __inline void EMAC25G_EthTransc25GS10Shim_PhyReg542_WRITE(DtBcEMAC25G* Bc, UInt32 EthTransc25GS10Shim_PhyReg542)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x8A0, EthTransc25GS10Shim_PhyReg542);
}

