//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcDISEQC_RegAccess.h *#*#*#*#*#*#*#*# (C) 2020 DekTec
//
// Device driver - Lnbh25DiSeqC v0 (DISEQC) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block Lnbh25DiSeqC.
// These functions should solely be used by the block controller for Lnbh25DiSeqC.
//
// 2020.12.09 15:52 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2020 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'TxFifoSize' and 'RxFifoSize' from register 'Config':
//      UInt32  Reg_Config, TxFifoSize, RxFifoSize;
//      Reg_Config = DISEQC_Config_READ(pBc);
//      TxFifoSize = DISEQC_Config_GET_TxFifoSize(Reg_Config);
//      RxFifoSize = DISEQC_Config_GET_RxFifoSize(Reg_Config);
//
// 2. Single-function shorthand for reading field 'ParityErrorCounter' from register
//    'RxStatus':
//      UInt32  ParityErrorCounter = DISEQC_RxStatus_READ_ParityErrorCounter(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// DISEQC_Config_GET_RxFifoSize
// DISEQC_Config_GET_TxFifoSize
// DISEQC_Config_READ
// DISEQC_Config_READ_RxFifoSize
// DISEQC_Config_READ_TxFifoSize
// DISEQC_FaultControl_READ
// DISEQC_FaultControl_SET_Reset
// DISEQC_FaultControl_WRITE
// DISEQC_RxControl_READ
// DISEQC_RxControl_SET_RxEnable
// DISEQC_RxControl_SET_RxFifoClear
// DISEQC_RxControl_WRITE
// DISEQC_RxData_READ
// DISEQC_RxStatus_GET_FifoLoad
// DISEQC_RxStatus_GET_ParityErrorCounter
// DISEQC_RxStatus_READ
// DISEQC_RxStatus_READ_FifoLoad
// DISEQC_RxStatus_READ_ParityErrorCounter
// DISEQC_TxControl_READ
// DISEQC_TxControl_SET_Command
// DISEQC_TxControl_SET_Reset
// DISEQC_TxControl_WRITE
// DISEQC_TxData_WRITE
// DISEQC_TxStatus_GET_FifoLoad
// DISEQC_TxStatus_READ
// DISEQC_TxStatus_READ_FifoLoad

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'Clear'
#define DISEQC_CMD_NOP               0x0  // No operation
#define DISEQC_CMD_CLEAR             0x1  // Clear

// Value map 'Reset'
#define DISEQC_CMD_NOP               0x0  // No operation
#define DISEQC_CMD_RESET             0x1  // Reset transmit DiSEqC and clear the transmit
                                          // FIFO

// Value map 'RxEnable'
#define DISEQC_CMD_DISABLED          0x0  // Not receiving
#define DISEQC_CMD_ENABLED           0x1  // Receiving

// Value map 'TxControl'
#define DISEQC_CMD_NOP               0x0  // No operation
#define DISEQC_CMD_SEND_TX_FIFO      0x1  // Start transmitting DiSEqC FIFO
#define DISEQC_CMD_SEND_TONEBURST_A  0x2  // Start transmitting unmodulated tone burst
#define DISEQC_CMD_SEND_TONEBURST_B  0x3  // Start transmitting modulated tone burst
#define DISEQC_CMD_GENERATE_22KHZ    0x4  // Start transmitting continuous 22kHz tone
#define DISEQC_CMD_STOP_22KHZ        0x5  // Stop transmitting continuous 22kHz tone

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 DISEQC_Config_READ(DtBcDISEQC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10);
}

// Field GET functions
static __inline UInt32 DISEQC_Config_GET_TxFifoSize(UInt32 Config)
{
    return Config & 0x1F;
}
static __inline UInt32 DISEQC_Config_GET_RxFifoSize(UInt32 Config)
{
    return (Config & 0x3E0) >> 5;
}

// Field READ functions
static __inline UInt32 DISEQC_Config_READ_TxFifoSize(DtBcDISEQC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10) & 0x1F;
}
static __inline UInt32 DISEQC_Config_READ_RxFifoSize(DtBcDISEQC* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x10) & 0x3E0) >> 5;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TxControl' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 DISEQC_TxControl_READ(DtBcDISEQC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x14);
}

// Field SET functions
static __inline UInt32 DISEQC_TxControl_SET_Command(UInt32 TxControl, UInt32 Command)
{
    DT_ASSERT((Command & ~0x7) == 0);
    return (TxControl & ~0x7) | Command;
}
static __inline UInt32 DISEQC_TxControl_SET_Reset(UInt32 TxControl, UInt32 Reset)
{
    DT_ASSERT((Reset & ~0x1) == 0);
    return (TxControl & ~0x8) | (Reset << 3);
}

// Register WRITE function
static __inline void DISEQC_TxControl_WRITE(DtBcDISEQC* pBc, UInt32 TxControl)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x14, TxControl);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TxStatus' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 DISEQC_TxStatus_READ(DtBcDISEQC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x18);
}

// Field GET function
static __inline UInt32 DISEQC_TxStatus_GET_FifoLoad(UInt32 TxStatus)
{
    return TxStatus & 0x1F;
}

// Field READ function
static __inline UInt32 DISEQC_TxStatus_READ_FifoLoad(DtBcDISEQC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x18) & 0x1F;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TxData' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void DISEQC_TxData_WRITE(DtBcDISEQC* pBc, UInt32 TxData)
{
    DT_ASSERT((TxData & ~0xFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x1C, TxData);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxControl' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 DISEQC_RxControl_READ(DtBcDISEQC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x20);
}

// Field SET functions
static __inline UInt32 DISEQC_RxControl_SET_RxEnable(UInt32 RxControl, UInt32 RxEnable)
{
    DT_ASSERT((RxEnable & ~0x1) == 0);
    return (RxControl & ~0x1) | RxEnable;
}
static __inline UInt32 DISEQC_RxControl_SET_RxFifoClear(UInt32 RxControl, UInt32 RxFifoClear)
{
    DT_ASSERT((RxFifoClear & ~0x1) == 0);
    return (RxControl & ~0x2) | (RxFifoClear << 1);
}

// Register WRITE function
static __inline void DISEQC_RxControl_WRITE(DtBcDISEQC* pBc, UInt32 RxControl)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x20, RxControl);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxStatus' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 DISEQC_RxStatus_READ(DtBcDISEQC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x24);
}

// Field GET functions
static __inline UInt32 DISEQC_RxStatus_GET_FifoLoad(UInt32 RxStatus)
{
    return RxStatus & 0x1F;
}
static __inline UInt32 DISEQC_RxStatus_GET_ParityErrorCounter(UInt32 RxStatus)
{
    return (RxStatus & 0x1FFE0) >> 5;
}

// Field READ functions
static __inline UInt32 DISEQC_RxStatus_READ_FifoLoad(DtBcDISEQC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x24) & 0x1F;
}
static __inline UInt32 DISEQC_RxStatus_READ_ParityErrorCounter(DtBcDISEQC* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x24) & 0x1FFE0) >> 5;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RxData' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32 DISEQC_RxData_READ(DtBcDISEQC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x28) & 0x1FF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FaultControl' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32 DISEQC_FaultControl_READ(DtBcDISEQC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x2C);
}

// Field SET function
static __inline UInt32 DISEQC_FaultControl_SET_Reset(UInt32 FaultControl, UInt32 Reset)
{
    DT_ASSERT((Reset & ~0x1) == 0);
    return (FaultControl & ~0x1) | Reset;
}

// Register WRITE function
static __inline void DISEQC_FaultControl_WRITE(DtBcDISEQC* pBc, UInt32 FaultControl)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x2C, FaultControl);
}

